<%
/*
	File			:	ecChangeSummaryComponentType.jsp
	Purpose			:	Display component type wise changes
	Creation Date	:	25-01-2009
	Author			:	Krishnamurthi
	UI Design		:	Jaiwin
*/
%>

<%@ include file = "EcTracker.jsp"%>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "java.net.URLEncoder"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "egurkha.config.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	private TreeMap getTreeMap(ArrayList al_components)
	{
		TreeMap tmap = null;
		if (al_components != null && !al_components.isEmpty())
		{
			tmap = new TreeMap();
			for(int i=0;i<al_components.size();i++)
			{
				String s_component = (String)al_components.get(i);
				String component_type = s_component.substring(s_component.lastIndexOf(":")+1);
				String component_name;

				if (component_type.equals("Oracle_server"))
				{
					StringTokenizer strTokens = new StringTokenizer(s_component,":");
					component_name = strTokens.nextToken() + ":" + strTokens.nextToken();
					component_type = strTokens.nextToken() + ":" + strTokens.nextToken();
				}
				else
					component_name = s_component.substring(0,s_component.lastIndexOf(":"));

				if (tmap.containsKey(component_type))
				{
					ArrayList al_temp = (ArrayList)tmap.get(component_type);
					al_temp.add(component_name);
				}
				else
				{
					ArrayList al_temp = new ArrayList();
					al_temp.add(component_name);
					tmap.put(component_type,al_temp);
				}
			}
		}
		return tmap;
	}

	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgUserRole userRole = user.getUserRole();
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDateInfo egDateInfo = new EgDateInfo();
	EcProcessChangeData processChangeData = new EcProcessChangeData();
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}

	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	boolean hasAllComponentAccess = userRole.hasAllComponentAccess();
	String configSkin = user.getConfigSkin();

	String defaultHours = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","ChangeSummary");
	String hourSelection = request.getParameter("NHour");
	StringTokenizer strTokens = new StringTokenizer(defaultHours,",");
	if (hourSelection == null)
	{
		Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.DASHBOARD_SETTING);
		String hourSetting = (String)dashboardSetting.get(EgConfigConstants.TYPE_CHANGE_DURATION);
		if (hourSetting == null)
		{
			hourSelection = strTokens.nextToken();
		}
		else
		{
			hourSelection = hourSetting;
		}
	}

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConvertertemp = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConvertertemp.getDateTime();
	/* Added by Prakash.K Ends */

	String tempStartDate = "";
	String startHour = "";
	String startMinute = "";
	String tempEndDate = "";
	String endHour = "";
	String endMinute = "";

	String str_ec_timeline = request.getParameter("ec_timeline");
	String str_ec_prevtimeline = request.getParameter("ec_prevtimeline");
	String strRequestFrom = request.getParameter("request_from");
	String submitOrNot = (String) request.getAttribute("isSubmit");
	String startDateInSch = "";
	String endDateInSch = "";
	String currTimeInSch = "";
	String startHourInSch = "";
	String endHourInSch = "";
	String startMinInSch = "";
	String endMinInSch = "";
	String startDateSchRef = "";
	String endDateSchRef = "";
	Map ScheduleDetails = null;

	if (str_ec_timeline != null)
	{
		Map map = request.getParameterMap();
		TimeLineBean timeLineBean = null;
		if (strRequestFrom != null && strRequestFrom.equalsIgnoreCase("saveSchedule"))
		{
			ScheduleDetails = (Map) request.getAttribute("ScheduleDetails");
			if (ScheduleDetails != null)
			{
				timeLineBean = new TimeLineBean(ScheduleDetails);
				startDateInSch = (String) ScheduleDetails.get("ec_stdate");
				endDateInSch = (String) ScheduleDetails.get("ec_enddate");
				currTimeInSch = (String) ScheduleDetails.get("currTime");
				startHourInSch = (String) ScheduleDetails.get("ec_sthr");
				endHourInSch = (String) ScheduleDetails.get("ec_endhr");
				startMinInSch = (String) ScheduleDetails.get("ec_startmin");
				endMinInSch = (String) ScheduleDetails.get("ec_endmin");
			}
			else
			{
				timeLineBean = new TimeLineBean(map);
			}
			submitOrNot = "false";
		}
		else
		{
			timeLineBean = new TimeLineBean(map);
		}

		String strStartDate = timeLineBean.getStartDate();
		startDateSchRef = strStartDate;
		String strEndDate = timeLineBean.getEndDate();
		endDateSchRef = strEndDate;
		startHour = timeLineBean.getStartHour();
		endHour = timeLineBean.getEndHour();
		startMinute = timeLineBean.getStartMinute();
		endMinute = timeLineBean.getEndMinute();

		if (!str_ec_timeline.equalsIgnoreCase("Any"))
		{
			if (strStartDate != null && strEndDate != null)
			{
				tempStartDate = DateUtil.changeDateFormat(strStartDate,"MM/dd/yyyy",currentDateFormat);
				tempEndDate = DateUtil.changeDateFormat(strEndDate,"MM/dd/yyyy",currentDateFormat);
			}
		}
		else
		{
			String ec_st_date = "";
			String ec_st_hr = "";
			String ec_start_min = "";
			String ec_end_date = "";
			String ec_end_hr = "";
			String ec_end_min = "";
			if (ScheduleDetails != null)
			{
				ec_st_date = startDateInSch;
				ec_end_date = endDateInSch;
				ec_st_hr = startHourInSch;
				ec_end_hr = endHourInSch;
				ec_start_min = startMinInSch;
				ec_end_min = endMinInSch;
			}
			else
			{
				ec_st_date = request.getParameter("ec_stdate_h");
				ec_st_hr = request.getParameter("ec_sthr_h");
				ec_start_min = request.getParameter("ec_startmin_h");
				ec_end_date = request.getParameter("ec_enddate_h");
				ec_end_hr = request.getParameter("ec_endhr_h");
				ec_end_min = request.getParameter("ec_endmin_h");
				if (ec_st_hr == null)
				{
					ec_st_hr = startHour;
				}
				if (ec_start_min == null)
				{
					ec_start_min = startMinute;
				}
				if (ec_end_hr == null)
				{
					ec_end_hr = endHour;
				}
				if (ec_end_min == null)
				{
					ec_end_min = endMinute;
				}
			}
			tempStartDate = new String(ec_st_date);
			tempEndDate = new String(ec_end_date);
			startHour = new String(ec_st_hr);
			endHour = new String(ec_end_hr);
			startMinute = new String(ec_start_min);
			endMinute = new String(ec_end_min);
		}
	}
	else
	{
		str_ec_timeline = "Any";

		//UI Date Process - Start
		Date tempDate = new Date(egDateInfo.egetUTCDate());
		Calendar tempCalendar = new GregorianCalendar();
		tempCalendar.setTime(tempDate);
		Date tempDate2 = tempCalendar.getTime();
		long tempTime = tempDate2.getTime();

		String edate = egDateInfo.egetDate(tempTime);

		int start_time = Integer.parseInt(hourSelection);
		long msecsPerHour = (long) 1000 * 60 * 60;
		String sdate = egDateInfo.egetDate(tempTime - (long)(start_time * msecsPerHour));

		sdate = sdate.substring(0,sdate.lastIndexOf(":")+1) + "00";
		edate = edate.substring(0,edate.lastIndexOf(":")+1) + "00";

		String startDate = sdate.substring(0,sdate.indexOf(' '));
		String endDate = edate.substring(0,edate.indexOf(' '));
		startDate = startDate.substring(startDate.indexOf('/')+1,startDate.lastIndexOf('/'))+"/"+startDate.substring(0,startDate.indexOf('/'))+"/"+startDate.substring(startDate.lastIndexOf('/')+1);
		endDate = endDate.substring(endDate.indexOf('/')+1,endDate.lastIndexOf('/'))+"/"+endDate.substring(0,endDate.indexOf('/'))+"/"+endDate.substring(endDate.lastIndexOf('/')+1);

		String SHours = sdate.substring(sdate.indexOf(' ')+1);
		String EHours = edate.substring(edate.indexOf(' ')+1);
		StringTokenizer startTimeToken = new StringTokenizer(SHours,":");
		StringTokenizer endTimeToken = new StringTokenizer(EHours,":");

		startHour = startTimeToken.nextToken();
		startMinute = startTimeToken.nextToken();
		endHour = endTimeToken.nextToken();
		endMinute = endTimeToken.nextToken();

		tempStartDate = DateUtil.changeDateFormat(startDate,"MM/dd/yyyy",currentDateFormat);
		tempEndDate = DateUtil.changeDateFormat(endDate,"MM/dd/yyyy",currentDateFormat);
		//UI Date Process - End
	}

	boolean goBack = false;

	String strRequestStart = request.getParameter("request_start");
	if (strRequestStart == null)
	{
		strRequestStart = request.getParameter("request_from");
	}

	String strChangeType = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","ShowChanges");

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	TreeMap tmap_changeConfigDetails = null;
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	if (strRequestFrom == null || !strRequestFrom.equalsIgnoreCase("Timeline"))
	{
		//Parameters - Start
		String option1[] = new String[]{"All Components"};
		String timeline[] = new String[]{"Any"};
		String prevtimeline[] = new String[]{"Any"};

		String ec_stdate[] = new String[]{tempStartDate};
		String ec_sthr[] =  new String[]{startHour};
		String ec_startmin[] =  new String[]{startMinute};
		String ec_enddate[] =  new String[]{tempEndDate};
		String ec_endhr[] =  new String[]{endHour};
		String ec_endmin[] =  new String[]{endMinute};

		if (strChangeType == null || strChangeType.length() == 0)
		{
			strChangeType = "All";
		}
		if (strChangeType.equalsIgnoreCase("Recent"))
		{
			strChangeType = "Latest";
		}
		else
		{
			strChangeType = "All";
		}

		String changeType[] = new String[]{strChangeType};
		String viewChange[] = new String[]{"byInformation"};

		Map params = new HashMap();
		params.put("ec_option1",option1);
		params.put("ec_timeline",timeline);
		params.put("ec_prevtimeline",prevtimeline);
		params.put("ec_stdate_h",ec_stdate);
		params.put("ec_sthr_h",ec_sthr);
		params.put("ec_startmin_h",ec_startmin);
		params.put("ec_enddate_h",ec_enddate);
		params.put("ec_endhr_h",ec_endhr);
		params.put("ec_endmin_h",ec_endmin);
		params.put("ec_changetype",changeType);
		params.put("ec_viewchange",viewChange);
		params.put("user_language",new String[]{userLanguage});
		//Parameters - End

		ArrayList al_components = new ArrayList();
		for(int i=0;i<aListAssociatedComponents.size();i++)
		{
			String s_component = (String)aListAssociatedComponents.get(i);
			String component_type = s_component.substring(0,s_component.indexOf(":"));
			boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
			if(!isConfigTestEnabled)
				continue;
			String component_name = s_component.substring(s_component.indexOf(":")+1);
			al_components.add(component_name+":"+component_type);
		}
		TreeMap tmap_components = getTreeMap(al_components);

		Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");

		EcChangeConfigurationBean ccbean = new EcChangeConfigurationBean(params,hasAllComponentAccess);
		ccbean.setTreeMap(tmap_components);
		ccbean.setHostAgentsMapping(hostAgentsMapping);
		tmap_changeConfigDetails = ccbean.getChangeConfigurationData();
	}

	if (strRequestFrom == null)
	{
		strRequestFrom = request.getParameter("request_start");
	}

	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
	}

	if (strRequestStart != null && strRequestStart.equalsIgnoreCase("saveSchedule"))
	{
		submitOrNot = "false";
	}

	if (ScheduleDetails != null && strRequestFrom != null && strRequestFrom.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String) ScheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String) ScheduleDetails.get("ec_criteriaPrevious");

		vecUserOptions = (Vector) ScheduleDetails.get("vecUserOptions");
		ec_userOption = (String) ScheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String) ScheduleDetails.get("ec_userOptionPrevious");
	}

	String id = request.getParameter("id");

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	String userName = (String)session.getAttribute("sess_auserid");
%>

<html>
<head>
<title></title>
<meta name="Author" content="Krishnamurthi">
<egui:skin ui="config"/>
<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2" src="../config/scripts/ec_date.js"></script>
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script language="javascript1.2">

var $j = jQuery.noConflict();

function divWidthHeight()
{
	var winWidth = $j(window).width();
	var winHeight = $j(window).height();

	var topTableTd1Obj = $j(".topTableTd1").height();
	var topTableTd2Obj = $j(".topTableTd2").height();

	$j(".bottomDiv").height((winHeight-(topTableTd1Obj+topTableTd2Obj))-90);
}

$j(document).ready(function(){
	divWidthHeight();
});

$j(window).resize(function(){
	divWidthHeight();
});

function showDetails()
{
	var thisForm = document.forms[0];

	var tempCriteria = "";
	var tempUserOption = "";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}

	if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
	{
		if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
		{
			if (tempCriteria == "Zone")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
				return false;
			}
			else if (tempCriteria == "Service")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
				return false;
			}
			else if (tempCriteria == "Segment")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
				return false;
			}
		}
	}

	var timeStart = thisForm.ec_stdate_h;
	var timeEnd = thisForm.ec_enddate_h;

	if (timeStart != "" && timeEnd != "")
	{
		var startHr = thisForm.ec_sthr.options[thisForm.ec_sthr.selectedIndex];
		var startMin = thisForm.ec_startmin.options[thisForm.ec_startmin.selectedIndex];

		var startHr_h = thisForm.ec_sthr_h.value;
		var startMin_h = thisForm.ec_startmin_h.value;

		var endHr = thisForm.ec_endhr.options[thisForm.ec_endhr.selectedIndex];
		var endMin = thisForm.ec_endmin.options[thisForm.ec_endmin.selectedIndex];

		var endHr_h = thisForm.ec_endhr_h.value;
		var endMin_h = thisForm.ec_endmin_h.value;

		//Convert to original format(i.e., to MM/dd/yyyy)
		var startDate = formatDate(new Date(getDateFromFormat(timeStart.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
		var endDate = formatDate(new Date(getDateFromFormat(timeEnd.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");

		if(!validateDateTime(startDate,endDate,startHr_h,endHr_h,startMin_h,endMin_h))
		{
			alert('<egui:intnl text="configmgmt.changes.detailed.Start date should be less than the End date" />');
			return false;
		}
	}

	thisForm.secsubmt.value = '<egui:intnl text="configmgmt.common.Loading" />'+'...';
	thisForm.secsubmt.disabled = true;
	thisForm.action = "../servlet/com.eg.EcConfigurationServlet?cmd=ChangeSummary&request_start=<%=strRequestStart%>";
	thisForm.submit();
}

function componentSearch()
{
	var thisForm = document.forms[0];

	var tempCriteria = "";
	var tempUserOption = "";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}

	if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
	{
		if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
		{
			if (tempCriteria == "Zone")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
				return false;
			}
			else if (tempCriteria == "Service")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
				return false;
			}
			else if (tempCriteria == "Segment")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
				return false;
			}
		}
	}

	var timeStart = thisForm.ec_stdate_h;
	var timeEnd = thisForm.ec_enddate_h;

	if (timeStart != "" && timeEnd != "")
	{
		var startHr = thisForm.ec_sthr.options[thisForm.ec_sthr.selectedIndex];
		var startMin = thisForm.ec_startmin.options[thisForm.ec_startmin.selectedIndex];

		var startHr_h = thisForm.ec_sthr_h.value;
		var startMin_h = thisForm.ec_startmin_h.value;

		var endHr = thisForm.ec_endhr.options[thisForm.ec_endhr.selectedIndex];
		var endMin = thisForm.ec_endmin.options[thisForm.ec_endmin.selectedIndex];

		var endHr_h = thisForm.ec_endhr_h.value;
		var endMin_h = thisForm.ec_endmin_h.value;
		
		//Convert to original format(i.e., to MM/dd/yyyy)
		var startDate = formatDate(new Date(getDateFromFormat(timeStart.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
		var endDate = formatDate(new Date(getDateFromFormat(timeEnd.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");

		if(!validateDateTime(startDate,endDate,startHr_h,endHr_h,startMin_h,endMin_h))
		{
			alert('<egui:intnl text="configmgmt.changes.detailed.Start date should be less than the End date" />');
			return false;
		}
	}
}

function printData()
{
<%
	if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
	{
%>
	alert('<egui:intnl text="configmgmt.common.No data available" />');
	return;
<%
	}

	StringBuffer printQS = new StringBuffer();
	printQS.append("&ec_type=ChangeSummaryForComponentType");
	printQS.append("&ec_trgttype=REPORT");
	printQS.append("&printData=yes");
	printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
	printQS.append("&user_language="+userLanguage);
	printQS.append("&ec_criteria="+ec_criteria);
	printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
	var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
	print(s_qryString);
}

function savePdf()
{
<%
	if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
	{
%>
	alert('<egui:intnl text="configmgmt.common.No data available" />');
	return;
<%
	}
	session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
	session.setAttribute("REPORT_NAME","ChangeSummaryForComponentType");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");
	session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
	session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
	getPdf('<%=configSkin%>');
}

function mail()
{
<%
	if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
	{
%>
	alert('<egui:intnl text="configmgmt.common.No data available" />');
	return;
<%
	}
%>
	sendMail();
}

function goTo(type)
{
	switch (type)
	{
		case "jsp":
			document.forms[0].action = '../config/ecChangeSummaryComponentType.jsp?request_from=Time_line&request_start=<%=strRequestStart%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=ec_userOption%>&id=<%=id%>';
			document.forms[0].submit();
	}
}

var screenname='';
var ev='';
var def='';
var def_h='';
var datefv='';
function checkwindow1(datef,datef_h,event,sname,frmField)
{
	event=event?event:window.event;
	document.forms[0].fromField.value = frmField;
	try
	{
		datefv = formatDate(new Date(getDateFromFormat(datef_h.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
	}
	catch(e)
	{
		datefv = formatDate(new Date(getDateFromFormat(datef_h.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
	}
	screenname=sname;
	ev=event;
	def=datef;
	def_h=datef_h;
	try
	{
		setTimeout("callcalendar4(def,def_h,datefv,ev,screenname)",0);
	}
	catch(e)
	{
		alert(e);
	}
}

function getDetails()
{
	thisForm = document.componenttypechanges;
	var str_ec_timeline = thisForm.ec_timeline.value;
	var tempCriteria = "";
	var tempUserOption = "";
	var tempCriteriaPrevious = "";
	var tempUserOptionPrevious = "";

	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}
	if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
	{
		tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
	}
	if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
	{
		tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
	}

	if (tempCriteria != "" && tempCriteriaPrevious != "")
	{
		if (tempCriteria == tempCriteriaPrevious)
		{
			if (tempUserOption != tempUserOptionPrevious)
			{
				str_ec_timeline = "1 day";
			}
		}
		else
		{
			str_ec_timeline = "1 day";
		}
	}

	thisForm.action = "../servlet/com.eg.EcConfigurationServlet?cmd=ChangeSummary&ec_timeline="+str_ec_timeline+"&request_start=<%=strRequestStart%>"+"&ec_stdate=<%=startDateInSch%>&ec_enddate=<%=endDateInSch%>&currTime=<%=currTimeInSch%>&id=<%=id%>";
	thisForm.submit();
}

function csv()
{
<%
	if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}
%>
	thisForm = document.forms[0];
	thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
	thisForm.submit();
}

function schedule(op)
{
	var checkFlag = componentSearch();
	if(checkFlag == false) return;
	var thisForm = document.componenttypechanges;
<%
	if (aListAssociatedComponents == null || aListAssociatedComponents.isEmpty())
	{
%>
		alert('<egui:intnl text="configmgmt.common.No components have been managed" />');
		return;
<%
	}
%>
	if (op == "schedule")
	{
<%
		if (strRequestFrom != null && strRequestFrom.equalsIgnoreCase("saveSchedule") || strRequestStart != null && strRequestStart.equalsIgnoreCase("saveSchedule"))
		{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
		}
		else
		{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=ChangesByComponentType";
<%
		}
%>
	}
	else if (op =="favorite")
		thisForm.action = "/final/config/EcSaveFavorite.jsp";
	else
	{
		alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
		return;
	}
	thisForm.submit();
}

function goBackToSaveSchedule()
{
	var thisForm = document.forms[0];
	thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=strRequestFrom%>&id=<%=id%>";
	thisForm.submit();
}

</script>
</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="overflow:hidden" bgcolor="#FFFFFF">
<form name="componenttypechanges" method="post" style="margin:0px">
<input type="hidden" name="ec_rtype" value="ChangesByComponentType">
<input type="hidden" name="ec_trgttype" value="Configuration_Report">
<input type="hidden" name="fromField" id="fromField" value="from">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" height="100%">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="padding5">
				<tr>
					<td align="left" id="main_head_top" width="95%" nowrap>
						&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.CONFIGURATION CHANGE" /> : <egui:intnl text="configmgmt.changes.summary.SUMMARY BY COMPONENT TYPE" /></b>
					</td>
					<td>
<%
	if ((strRequestFrom != null && strRequestFrom.equalsIgnoreCase("saveSchedule")) || (strRequestStart != null && strRequestStart.equalsIgnoreCase("saveSchedule")))
	{
%>
						<a id='mousehand' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
			<!-- new tab start here -->
				<tr>
					<td id="padding6" style="padding-bottom:0px" class="topTableTd1">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getDetails()'>
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				selected = "selected";
			}
%>
			<option value="<%=strCriteria%>" <%=selected%>>
				<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
			</option>
<%
		}
	}
	else
	{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Not Applicable" />
		</option>
<%
	}
%>
									</select>
								</td>
<%
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
%>
								<td align="right" nowrap>
<%
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getDetails()'>
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					selected = "selected";
				}
%>
				<option value="<%=strUserOption%>" <%=selected%>>
					<%=strUserOption%>
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
									</select>
								</td>
<%
	}
	else
	{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->
				<tr>
					<td id="padding6" class="topTableTd2">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable" >
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed" id="text_bold"> <col width="300">
										<col width="100"><col width="10"><col width="100"><col width="300">
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr>
											<td colspan="5">
												<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="text_bold">
													<tr>
														<td colspan="2" align="right" width="35%" valign="top" style="padding-top:4px"><b><egui:intnl text="configmgmt.changes.detailed.Timeline" />&nbsp;:&nbsp;</b></td>
														<td align="left" colspan="3" valign="top" width="65%"><%@ include file="EcTimeLineLiteNew.jsp"%></td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="5" height="10" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center">&nbsp;</td>
<%
	if ((strRequestFrom != null && strRequestFrom.equalsIgnoreCase("saveSchedule")) || (strRequestStart != null && strRequestStart.equalsIgnoreCase("saveSchedule")))
	{
%>
											<td align="center" colspan="3" valign="middle" height="20"> 
											<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">
											</td>
<%
	}
	else
	{
%>
											<td align="center" colspan="3" valign="middle" height="20"> <input type="button" value='<egui:intnl text="configmgmt.common.SUBMIT" />' name="secsubmt"  id="darkbutton"style="width: 75px; height: 20px;"  onClick="javascript:showDetails()"></td>
<%
	}
%>
											<td align="right"  colspan="1" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" ><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>
														<td width="2" align="center" id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="2" > </td>
														<td align="center" id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()"> </td>
														<td width="13" align="center" id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13" > </td>
														<td width="13" align="center" id="leftcurvebg" > <img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>
														<td width="13" align="center" id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>
														<td width="13" align="center" id="leftcurvebg" > <img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>
														<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>
														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> 
														</td>
														<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>

													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="4" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td id="padding6" height="100%" width="100%" valign="top" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
<%
	if (tmap_changeConfigDetails != null && !tmap_changeConfigDetails.isEmpty() && submitOrNot.equalsIgnoreCase("true"))
	{
		TreeMap tmapAllComponentChanges = processChangeData.getAllComponentSummary(tmap_changeConfigDetails,null,null);
		Iterator changeCountKeys = tmapAllComponentChanges.keySet().iterator();
		int totalCount = 0;

		ArrayList aList = new ArrayList();
		while (changeCountKeys.hasNext())
		{
			Integer changeCount = (Integer)changeCountKeys.next();
			if (changeCount.intValue() == -1) continue;
			aList.add(changeCount);
		}
		Collections.reverse(aList);

		ArrayList aListChangedComponentTypes = new ArrayList();
		ArrayList aListChangeCount = new ArrayList();
		for (int a=0; a<aList.size(); a++)
		{
			Integer changeCount = (Integer)aList.get(a);
			int countValue = changeCount.intValue();

			ArrayList aListTemp = (ArrayList)tmapAllComponentChanges.get(changeCount);
			aListChangedComponentTypes.addAll(aListTemp);

			for (int i=0; i<aListTemp.size(); i++)
			{
				aListChangeCount.add(changeCount);
				totalCount = totalCount + countValue;
			}
		}

		TreeMap tmapFinal = new TreeMap();
		TreeMap tmapChangedComponentsUnderType = (TreeMap)tmapAllComponentChanges.get(new Integer("-1"));
		for (int j=0;j<aListChangedComponentTypes.size();j++)
		{
			String componentType = (String)aListChangedComponentTypes.get(j);
			ArrayList aListChangedComponents = (ArrayList)tmapChangedComponentsUnderType.get(componentType);

			TreeMap tmapChangeCount = new TreeMap();
			for (int i=0;i<aListChangedComponents.size();i++)
			{
				String component = (String)aListChangedComponents.get(i);
				String strCount = component.substring(component.indexOf("@")+1);
				Integer intObject = new Integer(strCount);
				ArrayList aListTemp = (ArrayList)tmapChangeCount.get(intObject);
				if (aListTemp == null)
				{
					aListTemp = new ArrayList();
					aListTemp.add(component);
					tmapChangeCount.put(intObject,aListTemp);
				}
				else
				{
					aListTemp.add(component);
				}
			}

			ArrayList aListComponents = new ArrayList();
			Iterator iter_changeCountKeys = tmapChangeCount.keySet().iterator();
			while (iter_changeCountKeys.hasNext())
			{
				Integer changeCount = (Integer)iter_changeCountKeys.next();
				ArrayList aListTemp = (ArrayList)tmapChangeCount.get(changeCount);
				for (int x=0;x<aListTemp.size();x++)
				{
					aListComponents.add((String)aListTemp.get(x));
				}
			}

			tmapFinal.put(componentType,aListComponents);
		}

		//For print - Start
		session.setAttribute("TOTAL_CHANGES",totalCount+"");
		session.setAttribute("CHANGED_COMPONENT_TYPES",aListChangedComponentTypes);
		session.setAttribute("CHANGED_COMPONENT_TYPES_CHANGE_COUNT",aListChangeCount);
		session.setAttribute("CHANGED_COMPONENTS_UNDER_EACH_COMPONENT_TYPE",tmapFinal);
		session.setAttribute("START_DATETIME",tempStartDate + " " + startHour+":"+startMinute);
		session.setAttribute("END_DATETIME",tempEndDate + " " + endHour+":"+endMinute);
		//For print - End

		//For PDF - Start
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.SUMMARY REPORT BY COMPONENT TYPE") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.SUMMARY REPORT BY COMPONENT TYPE") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		/* Added by Prakash.K starts */
		EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(tempStartDate + " " + startHour + ":" + startMinute,user);
		String startDateTime = timeZoneConverter.getDateTime();
		timeZoneConverter = new EgTimeZoneConverter(tempEndDate + " " + endHour + ":" + endMinute,user);
		String endDateTime = timeZoneConverter.getDateTime();
		/* Added by Prakash.K ends */

		String subTitle = mappingInfo.getTextDescription("configmgmt.changes.summary.Between") + " " + startDateTime + " " + mappingInfo.getTextDescription("configmgmt.common.and") + " " + endDateTime;
		reportAttributes.setSubTitle(subTitle);

		reportAttributes.setReportName("ComponentTypeChangeSummary");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);

		pdfData.setAttributes(reportAttributes);

		EgTableAttributes egTableAttributes = new EgTableAttributes();
		egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes") + " : " + totalCount);

		ArrayList aListColumnNames = new ArrayList();
		ArrayList aListData = new ArrayList();
		ArrayList userColumnNames = new ArrayList();

		aListColumnNames.add("C0");
		aListColumnNames.add("C1");
		aListColumnNames.add("C2");

		userColumnNames.add("C0");
		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.summary.Changed components"));
		userColumnNames.add("");
		//For PDF - End
%>
							<tr>
								<td align="center" valign="top">
									<table width="100%" class="body_text" cellspacing="0" cellpadding="0" border="0" >
										<tr>
											<td height="20" class="tdbackcolortop" id="white_content" align="center">
												&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.Total Changes" />&nbsp;:&nbsp;<%=totalCount+""%></b>
											</td>
										</tr>
									</table>
								</td>
							</tr>

							<tr>
								<td height="3" id="blank">&nbsp;</td>
							</tr>

							<tr>
								<td align="center" valign="top" height="100%">
									<div id="div_scroll" class="bottomDiv" style="width:99%;height:200px;border:0px solid #ff0000">
									<table width="100%" class="body_text" cellspacing="0" cellpadding="0" border="0" align="center" id="bottomtable">
										<tr>
											<td width="18%" height="20" id="bgdarkimg"><b><egui:intnl text="configmgmt.changes.detailed.Component Type" /></b></td>
											<td width="7%" height="20" id="bgdarkimg" align="center"><b><egui:intnl text="configmgmt.changes.summary.Changes" /></b></td>
											<td width="75%" height="20" id="bgdarkimg" align="center"><b><egui:intnl text="configmgmt.changes.summary.Changed components" /></b></td>
										</tr>
<%
		for (int g=0; g<aListChangedComponentTypes.size(); g++)
		{
			String componentType = (String)aListChangedComponentTypes.get(g);
			Integer changes = (Integer)aListChangeCount.get(g);
%>
										<tr>
											<td colspan="3" valign="top">
												<table cellspacing="0" cellpadding="0" align="center" border="0" width="100%" id="body_text">
													<tr>
														<td nowrap width="18%" id="cell_bg1" style="padding-top:0px" valign="top" height="20">&nbsp;<a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=CS&ec_rtype=Change&ec_option1=Component Type&ec_timeline=<%=str_ec_timeline%>&ec_prevtimeline=<%=str_ec_timeline%>&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_stdate_h=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate_h=<%=URLEncoder.encode(tempEndDate)%>&ec_option2=<%=EgURLEncoder.encode(componentType,"UTF-8")%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&ec_viewchange=byInformation&NHourCS=<%=hourSelection%>&request_start=CS&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="" class="eg_monlink"><egui:intnl type="<%=componentType%>" /></a></td>
														<td width="7%" align="center" class="cell_border" valign="top" height="20"><a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=CS&ec_rtype=Change&ec_option1=Component Type&ec_timeline=<%=str_ec_timeline%>&ec_prevtimeline=<%=str_ec_timeline%>&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_stdate_h=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate_h=<%=URLEncoder.encode(tempEndDate)%>&ec_option2=<%=EgURLEncoder.encode(componentType,"UTF-8")%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&ec_viewchange=byInformation&NHourCS=<%=hourSelection%>&request_start=CS&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="" class="eg_monlink"><%=changes%></a></td>
														<td width="75%" align="left"> 
															<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
			ArrayList aListChangedComponents = (ArrayList)tmapFinal.get(componentType);
			int size = aListChangedComponents.size();
			for (int d=size-1; d>=0; d=d-2)
			{
				aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type") + " : " + mappingInfo.getComponentTypeDescription(componentType) + " (" + mappingInfo.getTextDescription("configmgmt.changes.summary.Changes") + " : " + changes + ")"); //For PDF
%>
																<tr>
<%
				for (int e=d; e>d-2; e--)
				{
					if (e >= 0)
					{
						String component = (String)aListChangedComponents.get(e);
						String componentName = component.substring(0,component.lastIndexOf(":"));
						String strCount = component.substring(component.indexOf("@")+1);
						component = component.substring(0,component.indexOf("@"));
						if (componentName.endsWith(":NULL"))
						{
							componentName= componentName.substring(0,componentName.lastIndexOf(':'));
						}
						aListData.add(componentName+" ["+strCount+"]"); //For PDF

						String tmpStr = componentName;
						int displayLength = 20;
						String strCName = StringUtils.egSubString(tmpStr,displayLength);
%>
																	<td id="cell_bg1" width="33%" valign="top" style="padding-top:0px" height="20"><a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=CS&ec_rtype=Change&ec_option1=Component Name&ec_timeline=<%=str_ec_timeline%>&ec_prevtimeline=<%=str_ec_timeline%>&ec_sthr_h=<%=startHour%>&ec_endhr_h=<%=endHour%>&ec_stdate_h=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate_h=<%=URLEncoder.encode(tempEndDate)%>&ec_option2=<%=EgURLEncoder.encode(component,"UTF-8")%>&ec_startmin_h=<%=startMinute%>&ec_endmin_h=<%=endMinute%>&ec_changetype=<%=strChangeType%>&ec_viewchange=byInformation&NHourCS=<%=hourSelection%>&request_start=CS&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="" class="eg_monlink" title="<%=componentName%>"><%=strCName%>&nbsp;[<%=strCount%>]</a></td>
<%
					}
					else
					{
						aListData.add(" "); //For PDF
%>
																	<td id="cell_bg1" width="50%" valign="top" style="padding-top:0px" height="20">&nbsp;</td>
<%
					}
				}
%>
																</tr>
<%
			}
%>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
		}

		//For PDF - Start
		EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);

		egTableAttributes.setColumnNames(userColumnNames);
		egTableAttributes.setDataGrouping(true);
		egTableAttributes.setDataGroupingField(0);

		EgTable egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);

		aListPdfData.add(egTable);

		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
		//For PDF - End
%>
									</table>
									</div>
								</td>
							</tr>
							<tr>
								<td height="3" id="blank">&nbsp;</td>
							</tr>
<%
	}
	else if (aListAssociatedComponents != null && !aListAssociatedComponents.isEmpty() && submitOrNot.equalsIgnoreCase("true"))
	{
%>
							<tr>
								<td align="center">
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center"> <img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'> </td>
													</tr>
													<tr>
														<td align="center"> <b><egui:intnl text="configmgmt.changes.detailed.There were no configuration changes in the selected timeline" /></b> </td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
	else
	{
%>
							<tr>
								<td align="center">
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												&nbsp;
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>

</table>

</form>
</body>
</html>



