<%
/*
	File				:	configServicesSetting.jsp
	Purpose				:	Allows per user service settings for the selected operating system
	Creation Date		:	02-01-2007
	Author				:	Balasigamani
	UI Design			:	Krishnamurthi
	UI Design Changes	:	Jaiwin
*/
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import ="egurkha.config.EcServicesDetails"%>
<%@ page import ="com.egurkha.User"%>
<%@ page import ="com.egurkha.UserRegistry"%>
<%@ page import ="egurkha.config.EcUtils"%>
<%@ page import ="com.eg.EgConfigTestsInfo"%>
<%@ page import ="egurkha.config.ConfigDbSetting"%>
<%@ page import ="com.eg.EgConfigConstants"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());

	//Bean Instance
	EcServicesDetails servicesDetails=new EcServicesDetails();
	EgConfigTestsInfo configTestsInfo=new EgConfigTestsInfo("manager");
	EcUtils ecUtils = new EcUtils();

	String requestName=request.getParameter("osName");
	Vector osName=new Vector();
	Hashtable finalData=new Hashtable();
	Map servicesData=new TreeMap();

	servicesDetails.setUserObject(user);
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	servicesDetails.setAssociatedComponents(aListAssociatedComponents);
	Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");
	servicesDetails.setHostAgentsMapping(hostAgentsMapping);

	Map resultData=(TreeMap)servicesDetails.getOSDetails();
	Iterator os=resultData.keySet().iterator();
	while(os.hasNext())
	{
		String oName=(String)os.next();
		if (oName.equalsIgnoreCase("HP-UX") || 
			oName.equalsIgnoreCase("AIX") || 
			oName.equalsIgnoreCase("SunOs") || 
			oName.equalsIgnoreCase("Unknown"))
		{
			continue;
		}
		osName.add(oName);
	}

	if(requestName==null && osName!=null && osName.size()>0)
	{
		Map userCommonSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
		String osNameSetting = (String)userCommonSetting.get(EgConfigConstants.SERVICE_STATUS_OS_NAME);
		if (osNameSetting == null || !osName.contains(osNameSetting))
		{
			requestName = (String)osName.get(0);
		}
		else
		{
			requestName = osNameSetting;
		}
	}

	if(requestName!=null)
	{
		servicesData=(TreeMap)servicesDetails.getUserServices(requestName,"Setting");
	}

	ArrayList userServices = (ArrayList)ConfigDbSetting.getUserServicesName(user.getLoginID(),requestName);
	if (userServices != null && userServices.size() >0)
	{
		Collections.sort(userServices,String.CASE_INSENSITIVE_ORDER);
	}
	else
	{
		if (userServices == null)
		{
			userServices = new ArrayList();
		}
		String defaultCount = configTestsInfo.getDisplayCountForServiceStatus();
		defaultCount = (defaultCount!=null && defaultCount.length()>0)?defaultCount:"5";
		int dispCount = Integer.parseInt(defaultCount);
		ArrayList li = new ArrayList(servicesData.keySet());
		if (li != null && li.size() > 0)
		{
			if (li.size() < dispCount)
			{
				dispCount = li.size();
			}
			for (int i=dispCount-1; i >= 0 ; i--)
			{
				userServices.add(li.remove(i));
			}
		}
		Collections.sort(userServices,String.CASE_INSENSITIVE_ORDER);
	}
%>

<html>
<head>
<title>
	<egui:intnl text="configmgmt.settings.dashboard.eG Configuration" /> : <egui:intnl text="configmgmt.settings.dashboard.User Services Setting" />
</title>
<egui:skin ui="config"/>
<script language="JavaScript1.2">
	function showDetails()
	{
		var thisForm = document.servicesConfig;
		var osname = thisForm.osSelect.value;
		if(osname== -1)
		{
			alert('<egui:intnl text="configmgmt.settings.dashboard.Please select an operating system" />');
			return;
		}
		else
		{
			window.location.href="../config/configServicesSetting.jsp?osName="+osname;
		}
	}

	function isNetscape() 
	{
		// get browser info. 
		appName= navigator.appName;
		appLongVer = navigator.appVersion;
		appVer = appLongVer.substring(0, 1); 

		// check for Navigator ver 4+. 
		if ((appName == "Netscape") && (appVer >= 4)) return true;
		return false;
	}

	function isIE() 
	{
		// get browser info. 
		appName= navigator.appName;
		appLongVer = navigator.appVersion;
		appVer = appLongVer.substring(0, 1); 

		// check for IE ver 4+. 
		if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
		return false;
	}

	function addToDissociate()
	{
		var thisForm = document.servicesConfig;
		var serverselected = "false";
		manunmanage = true;

		//getting list size
		var j = thisForm.dissociate.options.length;

		//gettin list vars
		var list = thisForm.associate;
		var mlist = thisForm.dissociate;
		for(var i = 0 ; i < list.options.length ; i++)
		{
			//browsing through to find selected items
			if(list.options[i].selected == true)
			{
				serverselected = "true";
				var txt=list.options[i].text;
				var val=list.options[i].value;
				var flag = 0;
				//to check if it already exists
				for(k = 0; k < mlist.options.length; k++)
				{
					if(val == mlist.options[k].value)
					{
						flag = 1;
					}
				}
				//addin the new name
				if(flag == 0)
				{
					mlist.options[j++] = new Option (txt,val) ;
				}
			}
		}

		for(var i = thisForm.associate.options.length; i > 0 ; i--)
		{
			if(thisForm.associate.options[i-1].selected == true )
			thisForm.associate.options[i-1] = null;
		}

		if(serverselected == "true")
		{
			alert('<egui:intnl text="configmgmt.settings.dashboard.All the user associated services will be lost if you disassociate" />'+'. '+'<egui:intnl text="configmgmt.settings.dashboard.Please click update to disassociate services" />');
		}
		else if(serverselected == "false")
		{
			alert('<egui:intnl text="configmgmt.settings.dashboard.No associated services has been selected" />');
		}
	}

	function addToAssociate()
	{
		var thisForm = document.servicesConfig;
		var serverselected = "false";
		manunmanage = true;

		//getting list size
		var j = thisForm.associate.options.length;

		//gettin list vars
		var list = thisForm.dissociate;
		var mlist = thisForm.associate;
		for(var i = 0 ; i < list.options.length ; i++)
		{
			//browsing through to find selected items
			if(list.options[i].selected == true)
			{
				serverselected = "true";
				var txt = list.options[i].text;
				var val = list.options[i].value;
				var flag = 0;
				//to check if it already exists
				for(k = 0; k<mlist.options.length; k++)
				{
					if(val == mlist.options[k].value)
					{
						flag = 1;
					}
				}
				//addin the new name
				if(flag == 0)
				{
					mlist.options[j++] = new Option (txt,val) ;
				}
			}
		}
	
		for(var i = thisForm.dissociate.options.length; i > 0 ; i--)
		{
			if(thisForm.dissociate.options[i-1].selected == true )
				thisForm.dissociate.options[i-1] = null;
		}

		if(serverselected == "false")
		{
			alert('<egui:intnl text="configmgmt.settings.dashboard.No disassociated services has been selected" />');
		}
	}

	function populate()
	{
		var funmng = new Array();
		var fmng = new Array();
		var funmngwithcomptype = new Array();
		var fmngwithcomptype = new Array();
		var thisForm = document.servicesConfig;
		var unmnglen = thisForm.dissociate.options.length;
		var mnglen = thisForm.associate.options.length;
		var funmglst = thisForm.dissociate;
		var fmglst = thisForm.associate;

		for(var z = 0 ; z < unmnglen ; z++)
		{
			if(funmglst.options[z].value == null)
			{
				continue;
			}
			else
			{
				funmng[z] = funmglst.options[z].value;
			}
		}
		for(var y = 0 ; y < mnglen ; y++)
		{
			if(fmglst.options[y].value == null)
			{
				continue;
			}
			else
			{
				fmng[y] = fmglst.options[y].value;
			}
		}

		thisForm.serviceAssociate.value = fmng;
		thisForm.serviceDissociate.value = funmng;
		if(fmng != "" || funmng != "")
		{
			if (isNetscape()) targetObj = document.servicesConfig.update;
			if (isIE()) targetObj = document.servicesConfig.update;
			targetObj.disabled = true;
			thisForm.update.value='<egui:intnl text="configmgmt.common.Updating" />'+'...';
			thisForm.submit();
		}
	}
</script>

<!-- Screen width script starts here -->
<SCRIPT LANGUAGE="JavaScript">
documentView = {
	getObject: function()
	{
		if(typeof( window.innerWidth) == 'number')
		{//Firefox
			this.height = window.innerHeight;
			this.width = window.innerWidth-10;
			this.fireFox = true;
		}
		else if( document.documentElement && ( document.documentElement.clientWidth
			|| document.documentElement.clientHeight ))
		{//IE 6 + in 'standards compliant mode'
			this.height = document.documentElement.clientHeight;
			this.width = document.documentElement.clientWidth;
			this.ie = true;
		}
		else if(document.body && document.body.clientHeight)
		{ //IE 4 compatible
			this.height = document.body.clientHeight;
			this.width = document.body.clientWidth;
			this.ie = true;
		}

		this.screenHeight=window.screen.availHeight;
		this.screenWidth=window.screen.availWidth;
		return this;
	},
	getScreenHeight: function()
	{
		return this.getObject().screenHeight;
	},
	getScreenWidth: function()
	{
		return this.getObject().screenWidth;
	},
	getHeight: function()
	{
		return this.getObject().height;
	},
	getWidth: function()
	{
		return this.getObject().width;
	},
	isIE: function()
	{
		return this.getObject().ie;
	},
	isFireFox: function()
	{
		return this.getObject().fireFox;
	}
};

var old_width=0;

function bigScreenPage()
{
	if(old_width==0)
	{
		old_width=980;
	}

	var selectWidth1Obj = document.getElementById('selectWidth1');
	var selectWidth2Obj = document.getElementById('selectWidth2');

	if(selectWidth1Obj!=null && selectWidth1Obj!=undefined)
	{
		var selectWidth = selectWidth1Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth1Obj.style.width=(newSelectWidth)+"px";
		}
	}

	if(selectWidth2Obj!=null && selectWidth2Obj!=undefined)
	{
		var selectWidth = selectWidth2Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth2Obj.style.width=(newSelectWidth)+"px";
		}
	}

	old_width=documentView.getWidth();
}

window.onresize = bigScreenPage;
</SCRIPT>

</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" onLoad="bigScreenPage();">
<form name="servicesConfig" method="POST" action="../servlet/com.eg.EcConfigurationServlet?cmd=ServiceSetting" style="margin:0px">
<input type="hidden" name="serviceAssociate" value="">
<input type="hidden" name="serviceDissociate" value="">
<input type="hidden" name="catagory" value="SERVICES">
<input type="hidden" name="osName" value="<%=requestName%>">
<input type="hidden" name="userName" value="<%=user.getLoginID()%>">

<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" height="100%">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="padding5">
				<tr>
					<td align="left" id="main_head_top" width="97%" nowrap>
						&nbsp;<b><egui:intnl text="configmgmt.settings.dashboard.DASHBOARD SETTINGS" /> : <egui:intnl text="configmgmt.settings.dashboard.SERVICE ASSOCIATION" /></b>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	
	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%" class="padding6"  >
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable" >
				<tr>
					<td align="center">
						<table width="100%" border="0" height="26" cellpadding="0" cellspacing="0" class="body_text" id="bgmorelight">
							<tr>
								<td align="center">
									<b><egui:intnl text="configmgmt.settings.dashboard.Select services to be shown in Dashboard under 'Service Status'" /></b>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0"   class="body_text" height="50">
							<tr>
								<td align="center"><b><egui:intnl text="configmgmt.settings.dashboard.Operating System" /></b>&nbsp;:&nbsp;<select name="osSelect" onChange="javascript:showDetails()"> <%=ecUtils.fillSelectBox(osName,"",requestName)%> </select></td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td height="100%" valign="top">
						<table align="center" cellspacing="0" cellpadding="0" border="0" height="100%">
							<tr>
								<td align="center" valign="top" height="100%">
									<table width="90%" border="0" align="center" cellpadding="0" cellspacing="0" class="body_text">
										<tr>
											<td colspan="3" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center" id="bgmedium" height="20">
												<b><egui:intnl text="configmgmt.settings.dashboard.ASSOCIATED SERVICES" /></b></td>
											<td width="10%" height="20">&nbsp;</td>
											<td align="center" id="bgmedium" height="20">
												<b><egui:intnl text="configmgmt.settings.dashboard.DISASSOCIATED SERVICES" /></b>
											</td>
										</tr>
										<tr>
											<td align="center">
												<select name="associate" id="selectWidth1" style="width:400px" size="27" multiple>
<%
	if(userServices!=null && userServices.size()>0)
	{
		for(int n=0;n<userServices.size();n++)
		{
			String serName=(String)userServices.get(n);
%>
			<option value="<%=serName%>"><%=serName%></option>
<%
		}
	}
%>
												</select>
											</td>
											<td style="width:150px" id="padding6">
												<table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" class="body_text">
													<tr>
														<td align="center"> <input type="button" id="lightbutton" value='<egui:intnl text="configmgmt.settings.dashboard.Disassociate" /> &rsaquo;&rsaquo;' style="width: 100px; height: 20px;" onClick="javascript:addToDissociate();"> </td>
													</tr>
													<tr>
														<td  height="10" id="blank">&nbsp;</td>
													</tr>
													<tr>
														<td align="center"> <input type="button" id="lightbutton" value='&lsaquo;&lsaquo; <egui:intnl text="configmgmt.settings.dashboard.Associate" />' style="width: 100px; height: 20px;" onClick="javascript:addToAssociate();"> </td>
													</tr>
												</table>
											</td>
											<td align="center">
												<select name="dissociate" id="selectWidth2" style="width:400px" size="27" multiple>
<%
	Iterator service=servicesData.keySet().iterator();
	while(service.hasNext())
	{
		String serviceName=(String)service.next();
		if (userServices!=null && userServices.contains(serviceName)) continue;
%>
		<option value="<%=serviceName%>"><%=serviceName%></option>
<%
	}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td colspan="3" height="20" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center" valign="top" colspan="3">
												<table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" class="body_text">
													<tr>
														<td align="center" class="cell_layout"> <input type="button" id="darkbutton" name="update" value='<egui:intnl text="configmgmt.common.UPDATE" />' style="width: 90px; height: 20px;" onClick="javascript:populate();"></td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="3" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</form>
</body>



