<!DOCTYPE html>
<%
/**************************************************************************************************
* File name			: EcSftwrHtfxFilterByPrint.jsp
* Purpose			: For Software/Hotfix dashboard  Filter By
* Last Modified 	:
* Author			: 
**************************************************************************************************/
%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.text.*"%>

<%@ page import = "com.eg.*"%>

<%@ page import = "com.egurkha.*"%>

<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.ini.IniUI"%>

<%@ page import = "egurkha.config.*"%>

<%@ include file = "EcTracker.jsp" %>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	private User getCurrentUser(HttpSession session)
	{
		UserRegistry registry = UserRegistry.getInstance();
		User user = registry.getUser(session.getId());
		return user;
	}
	private String getUserLanguage(User user)
	{
		IniUI iniUI = IniUI.getInstance();
		String userLanguage = iniUI.getDefaultLanguage();
		if (user != null)
		{
			userLanguage = user.getLanguage();
		}
		return userLanguage;
	}
	private String getCurrentDateFormat(User user)
	{
		String uiFile = "eg_ui.ini";
		String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
		
		String currentDateFormat = null;
		
		String mgrDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String userDateFormat = user.getUserDateFormat();
		
		if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
		{
			userDateFormat = mgrDateFormat;
		}
		
		if (userDateFormat != null)
		{
			currentDateFormat = userDateFormat;
		}
		else
		{
			currentDateFormat = mgrDateFormat;
		}
		
		return currentDateFormat;
	}
%>


<%
	User curUser = getCurrentUser(session);

	if(curUser != null)
	{
		String labelSftwrHotfix = null;
		String labelGridHeading = null;
		
		String userLanguage = getUserLanguage(curUser);
		String currentDateFormat = getCurrentDateFormat(curUser);
		
		SimpleDateFormat dateTimeFormat = new SimpleDateFormat(currentDateFormat+" "+"HH:mm");
		
		EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
		
		String labelNotApplicable = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Not applicable");
		String labelNotAvailable = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Unknown");
		
		String ec_forPDF = request.getParameter("ec_forPDF"); 
		
		//Read data from session 
		Map sftwrHotfixFilterByInfo = (Map)session.getAttribute("SftwrHotfixFilterByInfo");
		
		//View By ,SoftwareOrHotfix, Timeline Details
		String viewBy = (String)sftwrHotfixFilterByInfo.get("viewBy");
		String softwareOrHotfix = (String)sftwrHotfixFilterByInfo.get("softwareOrHotfix");
		Calendar fromDate = (Calendar)sftwrHotfixFilterByInfo.get("fromDate");
		Calendar toDate = (Calendar)sftwrHotfixFilterByInfo.get("toDate");
		String timeline = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.timeline."+(String)sftwrHotfixFilterByInfo.get("timeline"));
		String ec_userOption = (String)sftwrHotfixFilterByInfo.get("ec_userOption");
		String filterBy = (String)sftwrHotfixFilterByInfo.get("filterBy");
		String osName = (String)sftwrHotfixFilterByInfo.get("osName");
		String cmpntType = (String)sftwrHotfixFilterByInfo.get("cmpntType");
		String cmpntName = (String)sftwrHotfixFilterByInfo.get("cmpntName");
		String info  = (String)sftwrHotfixFilterByInfo.get("info");
		String showBackButton  = (String)sftwrHotfixFilterByInfo.get("showBackButton");
		String labelFltrCndtn = (String)sftwrHotfixFilterByInfo.get("labelFltrCndtn");
		List filterByDtls = ((List)sftwrHotfixFilterByInfo.get("filterByDtlsForPrint")) == null ? ((List)sftwrHotfixFilterByInfo.get("filterByDtls")) : ((List)sftwrHotfixFilterByInfo.get("filterByDtlsForPrint"));
		String gvnTblClmnFltrCndtnsAsStrForPrint = (String)sftwrHotfixFilterByInfo.get("gvnTblClmnFltrCndtnsAsStrForPrint");
		
		Map avlblCmpntNmType = (Map)sftwrHotfixFilterByInfo.get("avlblCmpntNmType");
		
		//Lables Details of lang Entry
		String gridSftwrHtfxLblName = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.grid."+softwareOrHotfix+" name");
		if(EcSoftwareHotfixHandler.CONST_SOFTWARE.equalsIgnoreCase(softwareOrHotfix))
		{
			labelSftwrHotfix = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Software");
			
		}
		else if(EcSoftwareHotfixHandler.CONST_HOTFIX.equalsIgnoreCase(softwareOrHotfix))
		{
			labelSftwrHotfix = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Hotfix");
		}
		if( filterBy != null && filterBy.equalsIgnoreCase("Available Components")  )						
		{
			labelGridHeading = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Available components details");
		}
		else if( filterBy != null && filterBy.equalsIgnoreCase("Unavailable Components") )						
		{
			labelGridHeading = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Unavailable components details");
		}
		else if( filterBy != null && filterBy.equalsIgnoreCase("DashboardReq") )						
		{
			labelGridHeading = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Components details");
		}
		else
		{
			labelGridHeading = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix."+filterBy);
		}				
		
		
%>

	<!Doctype html>
		<head>
			<title> <egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Filter By"/> <%=" "+labelSftwrHotfix +" " %> <egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Results"/> </title>
			<meta name="Author" content="">
			<meta  charset="UTF-8">
			<egui:skin ui = "configcompliancecheck"/>
			<link rel="stylesheet" type="text/css" href="/final/styles/componentsLight.css" />
			<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
			<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
			<style type="text/css" media="print">
				@page {size : portrait; margin : 0in }
				@page :footer {content: none, "Macro Home" decimal(pageno), none;}
			</style>
		</head>
		<body style="padding:10px;background-color:#ffffff">
			<%  
				if(ec_forPDF != null && "No".equalsIgnoreCase(ec_forPDF))
				{
			%>
					<div class="printHeaderBoxLogo"><img src="/final/images/eGLogo.png" border="0"></div>
					<div class="printHeaderBox">
						<div class="printHeaderBoxTitle" style="float:left;"><%=labelSftwrHotfix +" " %><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Results" /></div>
						<div class="printHeaderBoxPrintIcon" style="float:left;">
							<img class="mouse iconPrinter" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:print()" alt='<%=(String)mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.PRINT")%>' title='<%=(String)mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.PRINT")%>'/>
						</div>
					</div>
			<%		
				}				
				else if(ec_forPDF != null && "Yes".equalsIgnoreCase(ec_forPDF))
				{
			%>
					<div class="printHeaderBoxLogo" style="top:0px"><img src="/final/images/eGLogo.png" border="0"></div>
					<div class="printHeaderBox" style="padding-top:20px;padding-bottom:10px">
						<div class="printHeaderBoxTitle" style="float:left;"><%=labelSftwrHotfix +" " %><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Results" /></div>
						
					</div>
			<%		
				}
			%>
			
			<div class="printOuterBox" style="background:#ffffff;margin-top:10px;display:inline-block">
						<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.View By :" /><span class="bold">&nbsp;<%=viewBy%></span></div>
				<%
					if(!("Component".equalsIgnoreCase(viewBy)))
					{
				%>
						<div class="printSelectionFields"><%=viewBy%><span class="bold">&nbsp;<%=ec_userOption%></span></div>
				<%
					}
				%>
						<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Software/Hotfix :" /><span class="bold">&nbsp;<%=softwareOrHotfix%></span></div>
						
						<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Operating system :" /><span class="bold">&nbsp;<%=osName%></span></div>
				<%
				
					if( filterBy != null && ( filterBy.equalsIgnoreCase("Available Components") || filterBy.equalsIgnoreCase("Unavailable Components") || filterBy.equalsIgnoreCase("DashboardReq") ) )						
					{
						if((!"All".equalsIgnoreCase(info)))
						{
							if(softwareOrHotfix.equalsIgnoreCase("Software"))
							{
				%>
							<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Software name :" /><span class="bold">&nbsp;<%=info%></span></div>
				<%
							}
							else if(softwareOrHotfix.equalsIgnoreCase("Hotfix"))
							{
				%>
								<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Hotfix name :" /><span class="bold">&nbsp;<%=info%></span></div>
				<%			}
							
						}
					}
					else
					{
				%>
						<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Component type :" /><span class="bold">&nbsp;<%=cmpntType%></span></div>
					
				<%
					if((!"All".equalsIgnoreCase(info)))
					{
						if(softwareOrHotfix.equalsIgnoreCase("Software"))
						{
				%>
							<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Software name :" /><span class="bold">&nbsp;<%=info%></span></div>
				<%
						}
						else if(softwareOrHotfix.equalsIgnoreCase("Hotfix"))
						{
				%>
								<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Hotfix name :" /><span class="bold">&nbsp;<%=info%></span></div>
				<%		
						}
					}
				%>	
				
						<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.From Date :" /><span class="bold">&nbsp;<%=dateTimeFormat.format(fromDate.getTime())%></span></div>

						<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.To Date :" /><span class="bold">&nbsp;<%=dateTimeFormat.format(toDate.getTime())%></span></div>

						<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Filter By :" /><span class="bold">&nbsp;<%=filterBy%></span></div>
				<%
					if((EcSoftwareHotfixHandler.CONST_CmpntsHvngSftwrs.equalsIgnoreCase(filterBy)) || (EcSoftwareHotfixHandler.CONST_CmpntsNtHvngSftwrs.equalsIgnoreCase(filterBy)) || (EcSoftwareHotfixHandler.CONST_SftwrsNtAvlblCmpnts.equalsIgnoreCase(filterBy)) || (EcSoftwareHotfixHandler.CONST_SftwrsAvlblCmpnts.equalsIgnoreCase(filterBy)))
					{
				%>
						<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Filter condition :" /><span class="bold">&nbsp;<%=labelFltrCndtn%></span></div>
				<%	
					}
					
					else if((EcSoftwareHotfixHandler.CONST_CmpntsHvngHtfxs.equalsIgnoreCase(filterBy)) || (EcSoftwareHotfixHandler.CONST_CmpntsNtHvngHtfxs.equalsIgnoreCase(filterBy)) || (EcSoftwareHotfixHandler.CONST_HtfxsAvlblCmpnts.equalsIgnoreCase(filterBy)) || (EcSoftwareHotfixHandler.CONST_HtfxsNtAvlblCmpnts.equalsIgnoreCase(filterBy)))
					{
				%>
						<div class="printSelectionFields"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Filter condition :" /><span class="bold">&nbsp;<%=labelFltrCndtn%></span></div>
				<%	
					}
					}
				%>
					<div class="printSelectionFields">
						<%
							if(gvnTblClmnFltrCndtnsAsStrForPrint != null)
							{
								%>
									<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Filter conditions" />&nbsp;:&nbsp;<span>&nbsp;<%=gvnTblClmnFltrCndtnsAsStrForPrint%></span>
								<%
							}
						%>
					</div>
			</div>
			<div class="printOuterBox" style="margin-top:10px;page-break-inside:avoid"> 
				<div class="printHeaderBoxTitle" style="float:none;margin-bottom:10px;"><%=labelGridHeading%></div>
				<div class="newTable">
					<table align="center" style="table-layout:fixed;width:100%;" cellpadding="0" cellspacing="0" >
						<thead>
							<tr>
								<th style="width:15%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.Component type" /></th>
								<th style="width:20%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.Component name" /></th>
								<th style="width:15%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.Operating system" /></th>
								<th style="width:20%;white-space: normal;"  align="left"><%=gridSftwrHtfxLblName%></th>
								<%
									if((EcSoftwareHotfixHandler.CONST_SOFTWARE.equalsIgnoreCase(softwareOrHotfix)) && !(EcSoftwareHotfixHandler.CONST_CurUnInslldSftwrs.equalsIgnoreCase(filterBy)) && !(EcSoftwareHotfixHandler.CONST_AllUnInslldSftwrs.equalsIgnoreCase(filterBy)))
									{	
								%>
										<th style="width:10%;white-space: normal;" align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.Version" /></th>
								<%
									}
								%>
								<%
									if((EcSoftwareHotfixHandler.CONST_CurUnInslldSftwrs.equalsIgnoreCase(filterBy)) || (EcSoftwareHotfixHandler.CONST_AllUnInslldSftwrs.equalsIgnoreCase(filterBy)) ||(EcSoftwareHotfixHandler.CONST_CurUnInstldHtfxs.equalsIgnoreCase(filterBy)) || (EcSoftwareHotfixHandler.CONST_AllUnInstldHtfxs.equalsIgnoreCase(filterBy)))
									{
								%>
										<th style="width:10%;white-space: normal;" align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.Uninstalled date" />
								<%
									}
									else
									{
								%>
										<th style="width:15%;white-space: normal;" align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.Installed date" />
								<%	
									}
								%>
								
								<th style="width:15%;white-space: normal;" align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.When reported?" />
								</th>
							</tr>
						</thead>
						<tbody>
							<%
								if(filterByDtls != null && filterByDtls.size()>0)
								{	
									for(int incr=0; incr<filterByDtls.size(); incr++)
									{
										List currentRow = (List)filterByDtls.get(incr);
							%>
										<tr>
											<td align="left"  style="word-break:break-all"><%= mappingInfo.getComponentTypeDescription((String)avlblCmpntNmType.get((String)currentRow.get(0)))%></td>
											<td align="left" style="word-break:break-all"><%=(String)currentRow.get(0)%></td>
											<%
												String curOsName = (String)currentRow.get(1);
												if(curOsName != null && !EcSoftwareHotfixHandler.Not_Available.equalsIgnoreCase(curOsName))
												{
											%>
													<td align="left" style="word-break:break-all"><%=curOsName%></td>
											<%
												}
												else
												{
											%>
													<td align="left" style="word-break:break-all"><%=labelNotAvailable%></td>
											<%
												}
											%>
													<td align="left" style="word-break:break-all"><%=(String)currentRow.get(2)%></td>
											
											<%
												if((EcSoftwareHotfixHandler.CONST_SOFTWARE.equalsIgnoreCase(softwareOrHotfix)) && !(EcSoftwareHotfixHandler.CONST_CurUnInslldSftwrs.equalsIgnoreCase(filterBy)) && !(EcSoftwareHotfixHandler.CONST_AllUnInslldSftwrs.equalsIgnoreCase(filterBy)))
												{	
											
													String curVData = (String)currentRow.get(5);
													if(curVData != null)
													{
											%>
														<td align="left" style="word-break:break-all"><%=curVData%></td>
											<%
													}
													else
													{
											%>
														<td align="left" style="word-break:break-all"><%=labelNotApplicable%></td>
											<%
													}
												}
											
												Date instlDt  = (Date)currentRow.get(3);
												if(instlDt != null )
												{
											%>
													<td align="left" style="word-break:break-all"><%=new SimpleDateFormat(currentDateFormat).format((Date)currentRow.get(3))%></td>	
											<%
												}
												else
												{
											%>
													<td align="left" style="word-break:break-all"><%=labelNotApplicable%></td>	
											<%	
												}
												if(currentRow.size() == 4)
												{
													Date curDate = (Date)currentRow.get(3);
													if(curDate != null )
													{
											%>
														<td align="left" style="word-break:break-all"><%=new SimpleDateFormat(currentDateFormat+" HH:mm:ss").format(curDate)%></td>
											<%		
													}
													else 
													{
											%>
														<td align="left" style="word-break:break-all"><%=labelNotApplicable%></td>
											<%		
													}
												}
												else
												{
													Date curDate1 = (Date)currentRow.get(4);
													if(curDate1 != null)
													{
											%>
														<td align="left" style="word-break:break-all"><%=new SimpleDateFormat(currentDateFormat+" HH:mm:ss").format(curDate1)%></td>
											<%		
													}
													else
													{
											%>
														<td align="left" style="word-break:break-all"><%=labelNotApplicable%></td>
											<%
													}
												}
											%>
											
										</tr>
							<%
									}
								}								
							%>
						</tbody>
					</table>		
				</div>
			</div>
		</body>
	</html>
<%	
		session.setAttribute("configLastAccessedURL","/final/config/EcSftwrHtfxFilterByIndex.jsp?cmd=FilterBySftwrHtfx");	
	}
%>


