<!DOCTYPE html>

<%@ include file = "EcTracker.jsp"%>
<%@ page errorPage="EcProbs.jsp"%>

<%@ page import = "java.util.*"%>
<%@ page import = "java.text.*"%>

<%@ page import = "com.eg.*"%>

<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "com.egurkha.ini.IniUI"%>

<%@ page import = "egurkha.config.*"%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	String dashboardIniFileName = EcSoftwareHotfixHandler.iniFileName; //"eg_cnfg_SftwrHotfixDashboard.ini";
	
	public static String prepareEnocodedQueryString(Map params)
	{
		if (params == null || params.size() == 0) return "";
		String queryStr = "";
		try
		{
			Iterator itr = params.keySet().iterator();
			while (itr.hasNext())
			{
				String key = (String)itr.next();
				if (key.trim().length() == 0) continue;
				Object value= params.get(key);

				if (value instanceof String[])
				{
					String val[] =(String[])value;
					for(int i=0;i<val.length;i++)
						//queryStr += key + "=" + EgURLEncoder.encode(val[i],"UTF-8") + "&";
						queryStr += key + "=" + val[i] + "&";
				}
				else
				{
					if (value == null) value = "";
					//queryStr += key + "=" + EgURLEncoder.encode((String)value,"UTF-8") + "&";
					queryStr += key + "=" + (String)value + "&";
				}
			}
			if (queryStr.length() > 0) queryStr = queryStr.substring(0,queryStr.length()-1);
		}
		catch(Exception e)
		{
			queryStr = "";
		}
		return queryStr;
	}
	
	private User getCurrentUser(HttpSession session)
	{
		UserRegistry registry = UserRegistry.getInstance();
		User user = registry.getUser(session.getId());
		return user;
	}
	
	private String getUserLanguage(User user)
	{
		IniUI iniUI = IniUI.getInstance();
		String userLanguage = iniUI.getDefaultLanguage();
		if (user != null)
		{
			userLanguage = user.getLanguage();
		}
		return userLanguage;
	}
	
	private String getCurrentDateFormat(User user)
	{
		String uiFile = "eg_ui.ini";
		String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
		
		String currentDateFormat = null;
		
		String mgrDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String userDateFormat = user.getUserDateFormat();
		
		if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
		{
			userDateFormat = mgrDateFormat;
		}
		
		if (userDateFormat != null)
		{
			currentDateFormat = userDateFormat;
		}
		else
		{
			currentDateFormat = mgrDateFormat;
		}
		
		return currentDateFormat;
	}
	
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	
	String queryString = prepareEnocodedQueryString(request.getParameterMap());
	
	String redirectFilterByUri =null;
	String configLastAccessedURL = null;
	
	if(!("".equals((String)request.getAttribute("redirectFilterByUri"))) && !("null".equalsIgnoreCase((String)request.getAttribute("redirectFilterByUri"))))
	{
		redirectFilterByUri = (String)request.getAttribute("redirectFilterByUri");
	}
	
	if(!("".equals((String)request.getAttribute("configLastAccessedURL"))) && !("null".equalsIgnoreCase((String)request.getAttribute("configLastAccessedURL"))))
	{
		configLastAccessedURL = (String)request.getAttribute("configLastAccessedURL");
	}
	if(!("".equals(configLastAccessedURL)) && configLastAccessedURL != null)
	{
		if(configLastAccessedURL.indexOf("?")!= -1)
		{
			configLastAccessedURL =configLastAccessedURL.substring(configLastAccessedURL.indexOf("?")+1);
		}
		if(configLastAccessedURL.indexOf("needData")!= -1)
		{
			configLastAccessedURL =configLastAccessedURL.replaceAll("&needData=yes", "");
		}
	}
	User user = getCurrentUser(session);
	String userLanguage = getUserLanguage(user);
	String currentDateFormat = getCurrentDateFormat(user);
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	IniFile dashboardIni = new IniFile(EgConfigInfo.egMgrConfigDir +dashboardIniFileName );

	String reqFrom = request.getParameter("reqFrom");
	String viewBy = request.getParameter("viewBy");
	String softwareOrHotfix = request.getParameter("softwareOrHotfix");
	String timeline = request.getParameter("ec_timeline");
	String ec_userOption = request.getParameter("ec_userOption");
	String formItemsValidatinErrorMsg= "";
	String theCnfgrd = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.The configured"); 
	String name = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.name"); 
	String name_is_Nt_Cnfgrd = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.name is not configured");
	String please_Cnfgr_in= mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Please configure in eg_cnfg_SftwrHotfixDashboard ini file");
	String please_Cnfgr_properly= mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Please configure properly in eg_cnfg_SftwrHotfixDashboard ini file");
	String name_is_Nt_Avlbl = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.is not available");
	
	if (reqFrom == null)
	{
		reqFrom = "FilterBySftwrHtfx";
	}
	
	if (viewBy == null)
	{
		viewBy = dashboardIni.getValue("DEFAULT_VALUES", "ViewBy");  
	}
	
	if(viewBy != null && !"Component".equalsIgnoreCase(viewBy) )
	{
		if("Zone".equalsIgnoreCase(viewBy))
		{
			String zoneName = dashboardIni.getValue("DEFAULT_VALUES", "ZoneName"); 
			if("".equals(zoneName))
			{
				formItemsValidatinErrorMsg = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.Zone")+" "+name_is_Nt_Cnfgrd+". "+please_Cnfgr_in;	
			}
			else if(zoneName != null )
			{
				formItemsValidatinErrorMsg = theCnfgrd+" "+ mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.Zone")+" "+name +" '"+zoneName+"' "+name_is_Nt_Avlbl+". "+please_Cnfgr_properly;
			}
		}
		else if("Service".equalsIgnoreCase(viewBy))
		{
			String serviceName = dashboardIni.getValue("DEFAULT_VALUES", "ServiceName");  
			if("".equals(serviceName))
			{
				formItemsValidatinErrorMsg = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.Service")+" "+name_is_Nt_Cnfgrd+". "+please_Cnfgr_in;
			}
			else if(serviceName != null )
			{
				formItemsValidatinErrorMsg = theCnfgrd+" "+ mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.Service")+" "+name +" '"+serviceName+"' "+name_is_Nt_Avlbl+". "+please_Cnfgr_properly;
			}
		}
		else if("Segment".equalsIgnoreCase(viewBy))
		{	
			String segmentName = dashboardIni.getValue("DEFAULT_VALUES", "SegmentName");
			if("".equals(segmentName))
			{
				formItemsValidatinErrorMsg = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.Segment")+" "+name_is_Nt_Cnfgrd+". "+please_Cnfgr_in;
			}
			else if(segmentName != null )
			{
				formItemsValidatinErrorMsg = theCnfgrd+" "+ mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.Segment")+" "+name +" '"+segmentName+"' "+name_is_Nt_Avlbl+". "+please_Cnfgr_properly;
			}
		}		
	}

	if (softwareOrHotfix == null)
	{
		softwareOrHotfix = dashboardIni.getValue("DEFAULT_VALUES", "SoftwareHotfix");
	}
	
	if (timeline == null)
	{
		timeline = dashboardIni.getValue("DEFAULT_VALUES", "TimeLine");
	}
	
	String configServletURL = "../servlet/com.eg.EcConfigurationServletNew";
	String servletURL = configServletURL;
	
	if (queryString == null)
	{	
		queryString = "cmd=FilterBySftwrHtfx&viewBy="+viewBy+"&softwareOrHotfix="+softwareOrHotfix+"&ec_timeline="+timeline+"ec_prevtimeline=";
	}
	
%>
<html>
<head>
	<meta charset="utf-8">
	
	<egui:skin ui = "newConfigStyles"/>	
	<script type="text/javascript" src="../extjs/ext-all.js"></script>
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/Highcharts/js/highstock.js"></script>
	
	<script language="Javascript1.2" src="/final/config/utilities/Common.js"></script> 
	
	<script  src="/final/monitor/eg_scripts/EgCitrixDashboardHighChart.js"></script>
	<script language="JavaScript1.2" src="/final/scripts/eg_DateUtil.js"></script>
	<script language="Javascript1.2" src="/final/config/scripts/ec_date.js"></script>
	<script language="Javascript1.2" src="/final/config/scripts/ec_validate.js"></script>
	
	<script src="/final/scripts/utilities/EncodeDecodeParams.js"></script>  
	
    <script src="../config/InventorySftwrHtfxFilterBy/app/app.js"></script>
	
	<script language="JavaScript1.2">
		var publicJSON = "";
		var csrfToken = '<%=strCsrfToken%>';
		var currentDateFormat = getExtjsDateFormat('<%=currentDateFormat%>');
		var probsErrorMessage = '<egui:intnl text="config.error.Problem encountered while loading the user interface"/>';
		var errorTitle = '<egui:intnl text="config.user.Error"/>';
		var config = 
		{
			labels : 
			{
				viewBy : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.View By" />',
				softwareHotfix : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Software/Hotfix" />',
				frm : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.From" />',
				to : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.To" />',
				hr : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Hr" />',
				mins : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Mins" />',
				timeline : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Timeline" />',
				fromDate : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.From Date" />',
				toDate : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.To Date" />',
				title : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Configuration > Inventory > Software/Hotfix > Filter By" />',
				filterBy : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Filter By" />',
				filterCondition : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Filter condition" />',
				entrSftwrNm : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Enter software name" />',
				entrPtchNm :  '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Enter patch name" />',
				entrTrgtHst : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Enter Trgt host" />',
				chooseOne : '<egui:intnl text="configmgmt.SoftwareHotfix.Choose one" />',
				filter : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Filter" />',
				clearFilterData : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Clear Filter Data" />',
				submit : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Submit" />',
				operatingSys : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Operating system" />',
				cmpntName : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Component name" />',
				cmpntType : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Component type" />',
				softwareName : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Software name" />',
				hotfixName : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Hotfix name" />',
				avlblCmpntsDtls : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Available components details" />',
				unavlblCmpntsDtls : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Unavailable components details" />',
				CmpntsDtls : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Components details" />',
				notAvailable: '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Unknown" />',
				fltrCndtns: '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Filter conditions" />',
				
				
			},
			msg : 
			{
				loading : '<egui:intnl text="monitor.common.Loading..." />',
				noDataAvlbl : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.No data available!" />',
				enterFltrCndtn : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Please enter the filter condition" />',
			},
			title : 
			{
				printPreview : 'SoftwareHotfix Print Info',
			},
			defaultValues : 
			{
				timeline : "<%=timeline %>",
				viewBy : "<%=viewBy %>",
			},
			errors : 
			{
				smtngWntWring :'<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.something went wrong" />',
				errorInUpdtingDtls :'<egui:intnl text="configmgmt.SoftwareHotfix.Error in updating details" />',
				plsChoseFltyByCndtn :'<egui:intnl text="configmgmt.SoftwareHotfix.filterby.Please choose filterby condition" />',
				plsPrvdVldDtRng :'<egui:intnl text="configmgmt.SoftwareHotfix.Please provide valid date range" />',
				plsDntPrvdSplChrctrs :'<egui:intnl text="configmgmt.SoftwareHotfix.filterby.The special characters  &#91; &#93;  &#40;   &#41;   &#37;  &#38; &#61;  &#39; &#59; are not allowed&#46; Please provide again&#46;" />',
				noOfDaysAllwdInDtRng :'<egui:intnl text="configmgmt.SoftwareHotfix.The number of days allowed in the date range is" />',
				days :'<egui:intnl text="configmgmt.SoftwareHotfix.days" />',
				formItemsValidatinErrorMsg :  "<%=formItemsValidatinErrorMsg %>",
				pleaseSelect : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Please select a" />',
			},
			urls : 
			{
				configServletURL : "<%=configServletURL%>",
				redirectFilterByUri : "<%=redirectFilterByUri%>",
				configLastAccessedURL : "<%=configLastAccessedURL%>",
			}
	
	};
	</script>

	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			
			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>
</head>

<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</body>
</html>


