<%
/*
 *	File				:	EcDashboard.jsp
 *	Purpose				:	Configuration Home Page
 *	Creation Date		:	24/07/2006
 *	Author				:	Balasigamani
 *	Design				:	Jaiwin
 */
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp"%>
<%@ page errorPage= "EcProbs.jsp"%>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="java.util.*" %>
<%@ page import="egurkha.config.ConfigDbSetting"%>
<%@ page import="egurkha.config.EcProcessData"%>
<%@ page import="egurkha.config.EcUtils"%>
<%@ page import="com.eg.EgConfigConstants"%>
<%@ page import="com.eg.*" %>
<%@ page import="com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());

	String viewBy = "";
	Map data = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.DASHBOARD_SETTING);
	if (data != null && !data.isEmpty())
	{
		viewBy = (String)data.get(EgConfigConstants.VIEW_BY);
	}

	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	String strViewBy = configTestsInfo.getServerDisplayValue("MISC_ARGS","ViewBy");

	String ec_criteria = request.getParameter("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	if (viewBy == null || viewBy.length() == 0)
	{
		if (strViewBy == null || strViewBy.length() == 0)
		{
			ec_criteria = "Component";
		}
		else if (ec_criteria == null)
		{
			ec_criteria = strViewBy; //INI value
		}
	}
	else
	{
		if (ec_criteria == null)
		{
			ec_criteria = viewBy; //DB value
		}
	}

	String ec_userOption = request.getParameter("ec_userOption");
	if (ec_criteria != null && 
		ec_criteriaPrevious != null && 
		!ec_criteriaPrevious.equals(ec_criteria))
	{
		ec_userOption = null;
	}

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserAssociatedComponents = new Vector(user.getServers(false));

	Vector vecUserOptions = null;
	ArrayList aListAssociatedComponents = new ArrayList();
	if (ec_criteria != null)
	{
		EgGroupInfo egGroupInfo = new EgGroupInfo();
		EgTopoInfo egTopoInfo = egGroupInfo.getTopoInfoObject();

		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
			ArrayList aListComponentsFromZone = new ArrayList();
			List zoneList = user.getZones();
			if (zoneList != null && !zoneList.isEmpty())
			{
				vecUserOptions = new Vector(zoneList);
				Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);

				//To fetch all components from user associated zones
				for (int i=0;i<vecUserOptions.size();i++)
				{
					String strZone = (String)vecUserOptions.get(i);
					aListComponentsFromZone.addAll(egGroupInfo.getAllComponentsUnderZone(strZone,true));
				}
			}

			if (aListComponentsFromZone != null && !aListComponentsFromZone.isEmpty())
			{
				boolean defaultZoneExists = false;
				for (int i=0;i<vecUserAssociatedComponents.size();i++)
				{
					String component = (String)vecUserAssociatedComponents.get(i);
					if (!aListComponentsFromZone.contains(component))
					{
						defaultZoneExists = true;
						break;
					}
				}
				if (defaultZoneExists)
				{
					vecUserOptions.add(0,"--Default--");
				}
			}
			else
			{
				if (vecUserAssociatedComponents != null && !vecUserAssociatedComponents.isEmpty())
				{
					vecUserOptions = new Vector();
					vecUserOptions.add("--Default--");
				}
			}

			if (ec_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				ec_userOption = (String)vecUserOptions.get(0);
			}

			if (ec_userOption != null)
			{
				if (!ec_userOption.equalsIgnoreCase("--Default--"))
				{
					aListAssociatedComponents = egGroupInfo.getAllComponentsUnderZone(ec_userOption,true);
				}
				else
				{
					aListAssociatedComponents = new ArrayList();
					for (int i=0;i<vecUserAssociatedComponents.size();i++)
					{
						String userComponent = (String)vecUserAssociatedComponents.get(i);
						int index = aListComponentsFromZone.indexOf(userComponent);
						if (index == -1)
						{
							aListAssociatedComponents.add(userComponent);
						}
					}
				}
			}
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
			List serviceList = new ArrayList();
			serviceList.addAll(user.getServices());
			ArrayList aListSites = new ArrayList();
			aListSites.addAll(user.getSites());
			aListSites.removeAll(serviceList);
			serviceList.addAll(aListSites);
			if (serviceList != null && !serviceList.isEmpty())
			{
				vecUserOptions = new Vector(serviceList);
				Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);
			}

			if (ec_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				ec_userOption = (String)vecUserOptions.get(0);
			}

			if (ec_userOption != null)
			{
				Vector vecServiceComponents = egTopoInfo.getAssociatesForSite(ec_userOption);
				if (vecServiceComponents != null)
				{
					aListAssociatedComponents = new ArrayList(vecServiceComponents);
				}
			}
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[2]))
		{
			List segmentList = user.getSegments();

			if (segmentList != null && !segmentList.isEmpty())
			{
				vecUserOptions = new Vector(segmentList);
				Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);

			}

			if (ec_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				ec_userOption = (String)vecUserOptions.get(0);
			}

			if (ec_userOption != null)
			{
//				Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(ec_userOption,2,true);
				Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(ec_userOption,2);
				if (vecSegmentComponents != null)
				{
					aListAssociatedComponents = new ArrayList(vecSegmentComponents);
				}
			}
		}
		else
		{
			aListAssociatedComponents = new ArrayList(vecUserAssociatedComponents);
		}
	}

	EcUtils ecUtils = new EcUtils();
	EcProcessData processData = new EcProcessData();
	processData.setUserObject(user);
	processData.setAssociatedComponents(aListAssociatedComponents);
	processData.getOSDetails();
	Vector osListTmp = processData.getAllOsName();
	Vector osList = new Vector();
	for(int n=0;n<osListTmp.size();n++)
	{
		String os=(String)osListTmp.get(n);
		if (os.equalsIgnoreCase("HP-UX") || 
			os.equalsIgnoreCase("AIX") || 
			os.equalsIgnoreCase("SunOs") || 
			os.equalsIgnoreCase("Unknown"))
		{
			continue;
		}
		osList.add(os);
	}

	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
	String osNameSetting = (String)dashboardSetting.get(EgConfigConstants.SERVICE_STATUS_OS_NAME);
	String osName = "";
	if (osNameSetting != null && osNameSetting.length() > 0)
	{
		osName = osNameSetting;
	}
	else
	{
		if (osList.size() > 0)
		{
			osName = (String)osList.get(0);
		}
	}
%>

<html>
<head>
<title>
	<egui:intnl text="configmgmt.dashboard.eG Configuration" /> : <egui:intnl text="configmgmt.dashboard.Dashboard"/>
</title>
<egui:skin ui="config"/>
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script language="JavaScript1.2" type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<script language="JavaScript1.2" src="/../final/scripts/screen_display.js"></script>
</head>

<script language="javascript1.2">
	var $j = jQuery.noConflict();
	//ajax -- added by ahamed
	function createRequestObject()
	{
		var request_o; //declare the variable to hold the object.
		var browser = navigator.appName; //find the browser name
		if(browser == "Microsoft Internet Explorer")
		{
			/* Create the object using MSIE's method */
			request_o = new ActiveXObject("Microsoft.XMLHTTP");
			
		}
		else
		{
			/* Create the object using other browser's method */
			request_o = new XMLHttpRequest();
		}
		return request_o; //return the object
	}

	//var http = createRequestObject(); 
	var http1;
	var http2;
	var http3;
	var http4;
	var http5;
	var http6;
	var divId1;
	var divId2;
	var divId3;
	var divId4;
	var divId5;
	var divId6;

	/*****************first*******************/
	function sendURL1(url,id)
	{
		//var httpObj = createRequestObject(); 
		//http1 = httpObj;
		divId1 = id;
		document.getElementById(divId1).innerHTML = "<tr><td align='center'><table width='100%' height='170'><tr><td id='ajax_load' align='center'> <img src='/final/monitor/eg_images/Loading.gif'></td></tr></table></td></tr>";
		//http1.open("GET", url,true);
		//http1.onreadystatechange =handleReq1; 
		//http1.send(null);
		$j.ajax({
			method: "GET",
			url: url,
			cache: false,
			dataType: "html",
			success: function(strHTML, textStatus, jqXHR)
			{
				$j("#"+id).html( strHTML );
			},
			error: function(jqXHR, textStatus, errorThrown) 
			{
				$j("#"+id).html( jqXHR.responseText );
			}
		});
	}

	function handleReq1()
	{
		if(http1.readyState == 4){ //Finished loading the response
			var response = http1.responseText;
			document.getElementById(divId1).innerHTML = response;
		}
	}
	/**************End of first***********************/

	/*****************Second*******************/
	function sendURL2(url,id)
	{
		var httpObj = createRequestObject(); 
		http2 = httpObj;

		divId2 = id;
		document.getElementById(divId2).innerHTML = "<tr><td align='center'><table width='100%' height='170'><tr><td id='ajax_load' align='center'> <img src='/final/monitor/eg_images/Loading.gif'></td></tr></table></td></tr>";
		http2.open("GET", url,true);
		http2.onreadystatechange =handleReq2; 
		http2.send(null);
	}

	// function to get output
	function handleReq2()
	{
		if(http2.readyState == 4)
		{ //Finished loading the response
			var response = http2.responseText;
			try
			{
				document.getElementById(divId2).innerHTML = response;
			}
			catch (error)
			{
				var newDiv = document.createElement('div');
				newDiv.innerHTML = response;
				var myDiv = document.getElementById(divId2);
				if (myDiv.firstChild)
				{
					myDiv.removeChild(myDiv.firstChild);
				}
				myDiv.appendChild(newDiv);
			}
		}
	}
	/*****************End of second*******************/

	/*****************Third*******************/
	function sendURL3(url,id)
	{
		var httpObj = createRequestObject(); 
		http3 = httpObj;

		divId3 = id;
		document.getElementById(divId3).innerHTML = "<tr><td align='center'><table width='100%' height='160'><tr><td id='ajax_load' align='center'> <img src='/final/monitor/eg_images/Loading.gif'></td></tr></table></td></tr>";
		http3.open("GET", url,true);
		http3.onreadystatechange =handleReq3; 
		http3.send(null);
	}

	// function to get output
	function handleReq3()
	{
		if(http3.readyState == 4)
		{ //Finished loading the response
			var response = http3.responseText;
			document.getElementById(divId3).innerHTML = response;
		}
	}
	/*****************End of Third*******************/

	/*****************Fourth*******************/
	function sendURL4(url,id)
	{
		var httpObj = createRequestObject(); 
		http4 = httpObj;

		divId4 = id;
		document.getElementById(divId4).innerHTML = "<tr><td align='center'><table width='100%' height='160'><tr><td id='ajax_load' align='center'> <img src='/final/monitor/eg_images/Loading.gif'></td></tr></table></td></tr>";
		http4.open("GET", url,true);
		http4.onreadystatechange =handleReq4; 
		http4.send(null);
	}

	// function to get output
	function handleReq4()
	{
		if(http4.readyState == 4)
		{ //Finished loading the response
			var response = http4.responseText;
			try
			{
				document.getElementById(divId4).innerHTML = response;
			}
			catch (error)
			{
				var newDiv = document.createElement('div');
				newDiv.innerHTML = response;
				var myDiv = document.getElementById(divId4);
				if (myDiv.firstChild)
				{
					myDiv.removeChild(myDiv.firstChild);
				}
				myDiv.appendChild(newDiv);
			}
		}
	}
	/*****************End of Fourth*******************/

	/*****************Fifth*******************/
	function sendURL5(url,id)
	{
		var httpObj = createRequestObject(); 
		http5 = httpObj;

		divId5 = id;
		document.getElementById(divId5).innerHTML = "<tr><td align='center' width='470'><table width='470' height='140' border='0' align='center'><tr><td id='ajax_load' align='center'> <img src='/final/monitor/eg_images/Loading.gif'></td></tr></table></td></tr>";
		http5.open("GET", url,true);
		http5.onreadystatechange =handleReq5; 
		http5.send(null);
	}

	// function to get output
	function handleReq5()
	{
		if(http5.readyState == 4)
		{ //Finished loading the response
			var response = http5.responseText;
			document.getElementById(divId5).innerHTML = response;
		}
	}
	/*****************End of Fifth*******************/

	/*****************Sixth*******************/
	function sendURL6(url,id)
	{
		//var httpObj = createRequestObject(); 
		//http6 = httpObj;

		divId6 = id;
		document.getElementById(divId6).innerHTML = "<tr><td align='center'><table width='100%' height='140'><tr><td id='ajax_load' align='center'> <img src='/final/monitor/eg_images/Loading.gif'></td></tr></table></td></tr>";
		//http6.open("GET", url,true);
		//http6.onreadystatechange =handleReq6; 
		//http6.send(null);
		$j.ajax({
			method: "GET",
			url: url,
			cache: false,
			dataType: "html",
			success: function(strHTML, textStatus, jqXHR)
			{
				try
				{
					//document.getElementById(divId6).innerHTML = response;
					$j("#"+id).html( strHTML );
				}
				catch (error)
				{
					//var newDiv = document.createElement('div');
					//newDiv.innerHTML = strHTML;
					//var myDiv = document.getElementById(divId6);
					//if (myDiv.firstChild)
					//{
					//	myDiv.removeChild(myDiv.firstChild);
					//}
					//myDiv.appendChild(newDiv);
				}
			},
			error: function(jqXHR, textStatus, errorThrown) 
			{
				$j("#"+id).html( jqXHR.responseText );
			}
		});
	}

	// function to get output
	function handleReq6()
	{
		if(http6.readyState == 4)
		{ //Finished loading the response
			var response = http6.responseText;
			try
			{
				document.getElementById(divId6).innerHTML = response;
			}
			catch (error)
			{
				var newDiv = document.createElement('div');
				newDiv.innerHTML = response;
				var myDiv = document.getElementById(divId6);
				if (myDiv.firstChild)
				{
					myDiv.removeChild(myDiv.firstChild);
				}
				myDiv.appendChild(newDiv);
			}
		}
	}
	/*****************End of Sixth*******************/
	//end ajax

	function isNetscape()
	{
		// get browser info.
		appName= navigator.appName;
		appLongVer = navigator.appVersion;
		appVer = appLongVer.substring(0,1);

		// check for Navigator ver 4+.
		if ((appName == "Netscape") && (appVer >= 4)) return true;

		return false;
	}

	function isIE()
	{
		// get browser info.
		appName= navigator.appName;
		appLongVer = navigator.appVersion;
		appVer = appLongVer.substring(0,1);

		// check for IE ver 4+.
		if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;

		return false;
	}

	// global variables
	var arr = new Array();

	function show(step)
	{
		var layername = "layer"+step;
		if (isNetscape())
		{
			document.getElementById(layername).style.visibility = 'visible';
			document.getElementById(layername).style.display = 'table-row';
		}
		else if (isIE())
		{
			document.getElementById(layername).style.visibility = 'visible';
			document.getElementById(layername).style.display = 'block';
		}
	}

	function hide(step)
	{
		var layername = "layer"+step;
		document.getElementById(layername).style.display = 'none';
	}

	function onRefresh()
	{
		getOSwiseMachineStatus(); //1,1
		//getTopNInstalls(); //2,1
		//getServiceStatus(); //3,1
		getTopNSoftwareInstalls(); //2,1
		getTopNHotfixInstalls(); //3,1

		goToChangeSummary(); //1,2
		goToChangesAtAGlance(); //2,2
		goToDaywiseChangeDistribution(); //3,2
	}

	function execute()
	{
		var thisForm = document.forms[0];
		var view = thisForm.ec_criteria.options[thisForm.ec_criteria.options.selectedIndex].value;
		var option = "";
		if (view != "Component")
		{
			option = thisForm.ec_userOption.options[thisForm.ec_userOption.options.selectedIndex].value;
		}
		sendURL1("/final/servlet/com.eg.EcConfigurationServlet?cmd=OswiseComponentStatus&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"CompStatusOswise");
		sendURL2("/final/servlet/com.eg.EcConfigurationServlet?cmd=DashboardChangeSummary&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"CompTypeChanges");
		sendURL3("/final/servlet/com.eg.EcConfigurationServlet?cmd=TopNAvailability&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&testName=SoftwareList_cf&"+Math.random(),"TopNAvail");
		sendURL4("/final/servlet/com.eg.EcConfigurationServlet?cmd=DashboardChangesAtAGlance&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"CompChanges");
		//sendURL5("/final/servlet/com.eg.EcConfigurationServlet?cmd=ServiceDisplay&flagValue=Dashboard&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"ServiceDisplay");
		sendURL5("/final/servlet/com.eg.EcConfigurationServlet?cmd=TopNAvailability&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&testName=HotFix_cf&"+Math.random(),"TopNAvailHotfix");
		sendURL6("/final/servlet/com.eg.EcConfigurationServlet?cmd=DashboardDaywiseChangeDistribution&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"WeekChanges");
		doResize();
	}

<%
	if (aListAssociatedComponents != null && !aListAssociatedComponents.isEmpty())
	{
%>
		setInterval("onRefresh()",120000);
<%
	}
%>

	function doResize()
	{
		var borwserWidth=screen.width;
		var borwserHeight=screen.height;

		if(typeof(window.innerWidth) == 'number')
		{
			//Non-IE
			borwserWidth = window.innerWidth;
			borwserHeight = window.innerHeight;
		}
		else if(document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight ))
		{
			//IE 6+ in 'standards compliant mode'
			borwserWidth = document.documentElement.clientWidth;
			borwserHeight = document.documentElement.clientHeight;
		}
		else if(document.body && ( document.body.clientWidth || document.body.clientHeight ))
		{
			//IE 4 compatible
			borwserWidth = document.body.clientWidth;
			borwserHeight = document.body.clientHeight;
		}

		var servieDiv = document.getElementById("ServiceDisplay");
		var weekDiv = document.getElementById("WeekChanges");

		if (servieDiv != null && weekDiv != null)
		{
			servieDiv.style.height = (borwserHeight - 460)+"px";
			weekDiv.style.height = (borwserHeight - 420)+"px";
			if (isIE())
			{
				//servieDiv.style.position = "absolute";
				servieDiv.style.position = "relative";
			}
		}
		bigScreen();
	}
	window.onresize = doResize;

	function goToChangeSummary()
	{
		var thisForm = document.forms[0];
		var HourChange= thisForm.NHour.options[thisForm.NHour.options.selectedIndex].value;
		var view = thisForm.ec_criteria.options[thisForm.ec_criteria.options.selectedIndex].value;
		var option = "";
		if (view != "Component")
		{
			option = thisForm.ec_userOption.options[thisForm.ec_userOption.options.selectedIndex].value;
		}
		sendURL2("/final/servlet/com.eg.EcConfigurationServlet?cmd=DashboardChangeSummary&NHour="+HourChange+"&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"CompTypeChanges");
	}

	function goToChangesAtAGlance()
	{
		var thisForm = document.forms[0];
		var HourChange= thisForm.Hour.options[thisForm.Hour.options.selectedIndex].value;
		var view = thisForm.ec_criteria.options[thisForm.ec_criteria.options.selectedIndex].value;
		var option = "";
		if (view != "Component")
		{
			option = thisForm.ec_userOption.options[thisForm.ec_userOption.options.selectedIndex].value;
		}
		sendURL4("/final/servlet/com.eg.EcConfigurationServlet?cmd=DashboardChangesAtAGlance&NHour="+HourChange+"&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"CompChanges");
	}

	function goToDaywiseChangeDistribution()
	{
		var thisForm = document.forms[0];
		var selectedComponentType = thisForm.componentType.options[thisForm.componentType.options.selectedIndex].value;
		var selectedDuration = thisForm.duration.options[thisForm.duration.options.selectedIndex].value;
		var view = thisForm.ec_criteria.options[thisForm.ec_criteria.options.selectedIndex].value;
		var option = "";
		if (view != "Component")
		{
			option = thisForm.ec_userOption.options[thisForm.ec_userOption.options.selectedIndex].value;
		}
		sendURL6("/final/servlet/com.eg.EcConfigurationServlet?cmd=DashboardDaywiseChangeDistribution&componentType="+selectedComponentType+"&duration="+selectedDuration+"&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"WeekChanges");
	}

	function getOSwiseMachineStatus()
	{
		var thisForm = document.forms[0];
		if (thisForm.ec_osOption != null)
		{
			var view = thisForm.ec_criteria.options[thisForm.ec_criteria.options.selectedIndex].value;
			var option = "";
			if (view != "Component")
			{
				option = thisForm.ec_userOption.options[thisForm.ec_userOption.options.selectedIndex].value;
			}

			var osOption= thisForm.ec_osOption.options[thisForm.ec_osOption.options.selectedIndex].value;
			if (osOption == "OS")
			{
				sendURL1("/final/servlet/com.eg.EcConfigurationServlet?cmd=OswiseComponentStatus&version=No"+"&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"CompStatusOswise");
			}
			else if(osOption == "OSVersion")
			{
				sendURL1("/final/servlet/com.eg.EcConfigurationServlet?cmd=OswiseComponentStatus&version=Yes"+"&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"CompStatusOswise");
			}
			else if(osOption == "NetworkDevices")
			{
				sendURL1("/final/servlet/com.eg.EcConfigurationServlet?cmd=OswiseComponentStatus&machines=NetworkDevices"+"&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"CompStatusOswise");
			}
			else if(osOption == "Virutualization")
			{
				sendURL1("/final/servlet/com.eg.EcConfigurationServlet?cmd=OswiseComponentStatus&machines=Virutualization"+"&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"CompStatusOswise");
			}
		}
	}

	function getTopNSoftwareInstalls()
	{
		var thisForm = document.forms[0];
		//var testName = thisForm.ec_choice_sw.value;
		var osname = thisForm.ec_os_sw.value;
		var view = thisForm.ec_criteria.options[thisForm.ec_criteria.options.selectedIndex].value;
		var option = null;
		if (view != "Component")
		{
			option = thisForm.ec_userOption.options[thisForm.ec_userOption.options.selectedIndex].value;
		}
		sendURL3("/final/servlet/com.eg.EcConfigurationServlet?cmd=TopNAvailability&osName="+osname+"&testName=SoftwareList_cf&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"TopNAvail");
	}

	function getTopNHotfixInstalls()
	{
		var thisForm = document.forms[0];
		//var testName = thisForm.ec_choice_hf.value;
		var osname = thisForm.ec_os_hf.value;
		var view = thisForm.ec_criteria.options[thisForm.ec_criteria.options.selectedIndex].value;
		var option = null;
		if (view != "Component")
		{
			option = thisForm.ec_userOption.options[thisForm.ec_userOption.options.selectedIndex].value;
		}
		sendURL5("/final/servlet/com.eg.EcConfigurationServlet?cmd=TopNAvailability&osName="+osname+"&testName=HotFix_cf&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"TopNAvailHotfix");
	}

	function getServiceStatus()
	{
		var thisForm = document.forms[0];
		var osname = thisForm.ec_os1.value;
		var view = thisForm.ec_criteria.options[thisForm.ec_criteria.options.selectedIndex].value;
		var option = null;
		if (view != "Component")
		{
			option = thisForm.ec_userOption.options[thisForm.ec_userOption.options.selectedIndex].value;
		}
		sendURL5("/final/servlet/com.eg.EcConfigurationServlet?cmd=ServiceDisplay&flagValue=Dashboard&osName="+osname+"&ec_criteria="+view+"&ec_userOption="+encodeURIComponent(option)+"&"+Math.random(),"ServiceDisplay");
	}

	function showServiceStatus()
	{
		var thisForm = document.forms[0];
		var osname = thisForm.ec_os1.value;
		window.location.href = '/final/servlet/com.eg.EcConfigurationServlet?cmd=ServiceDisplay&flagValue=MenuServices&request_from=HomePage&osName='+osname+'&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=(ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""%>';
	}

	function goTo(op)
	{
		var thisForm = document.forms[0];
		thisForm.action = "/final/config/EcDashboard.jsp";
		thisForm.submit();
	}

	// Added For Fusionchart Legend Links--Rekha
	function legendData(legendLabel) //os
	{
		var tempLink = '/final/servlet/com.eg.EcConfigurationServlet?cmd=OSInventory&request_from=OS&osName='+encodeURIComponent(legendLabel)+'&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=(ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""%>';
		if (legendLabel != null && legendLabel == "Others")
		{
			tempLink = '/final/servlet/com.eg.EcConfigurationServlet?cmd=OSInventory&request_from=OS&osName=All&category=Others&&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=(ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""%>';
		}
		window.location.href  = tempLink;
	}

	function legendCompData(type,legendLabel) //network and virtual
	{
		var tempLink = '/final/servlet/com.eg.EcConfigurationServlet?cmd=ComponentsView&requestFrom=Devices&clickOn=legend&requestFrom=Homepage&selectedType='+type+'&componentType='+encodeURIComponent(legendLabel)+'&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=(ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""%>';
		window.location.href = tempLink;
	}
	// Ends

</script>

<%
	if (aListAssociatedComponents == null || aListAssociatedComponents.isEmpty())
	{
%>
<body leftmargin="0" topmargin="0" marginheight="0" marginwidth="0" style="overflow:hidden" onLoad="bigScreen();">
<%
	}
	else
	{
%>
<body leftmargin="0" topmargin="0" marginheight="0" marginwidth="0" onload="javascript:execute();bigScreen();" style="overflow:hidden">
<%
	}
%>

<form name="Dashboard" style="margin:0px;height:100%;width:100%">
<table cellspacing="0" cellpadding="0" border="0" width="100%" height="100%" align="center">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">

	<tr>
		<td valign="top" width="100%" class="table_header_dash" style="padding:2px" height="24px">
			<table align="left" cellspacing="0" cellpadding="0" border="0" id="text_bold">
				<tr>
					<td align="right" nowrap style="height:20px"><egui:intnl text="configmgmt.common.View By" /></td>
					<td align="center">&nbsp;:&nbsp;</td>
					<td valign="middle">
						<select name="ec_criteria" style="width:170px;" onChange="javascript:goTo('jspc')">
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				selected = "selected";
			}
%>
			<option value="<%=strCriteria%>" <%=selected%>>
				<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
			</option>
<%
		}
	}
	else
	{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Not Applicable" />
		</option>
<%
	}
%>
						</select>
					</td>
<%
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
%>
					<td align="right" nowrap>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<%
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
					</td>
					<td align="center">&nbsp;:&nbsp;</td>
					<td>
						<select name="ec_userOption" style="width: 250px;" onChange="javascript:goTo('jspc')">
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					selected = "selected";
				}
%>
				<option value="<%=strUserOption%>" <%=selected%>>
					<%=strUserOption%>
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
						</select>
					</td>
<%
	}
	else
	{
%>
					<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
				</tr>
			</table>
		</td>
	</tr>

<%
	if (aListAssociatedComponents == null || aListAssociatedComponents.isEmpty())
	{
%>
	<tr>
		<td>
			<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" style="table-layout:fixed" id="innertable">
				<tr height="100%">
					<td align="center" width="50%">
						<table id="insidetable" cellpadding="0" cellspacing="0" width="100%" height="100%" border="0">
<%
		if (ec_criteria.equalsIgnoreCase("Zone"))
		{
%>
							<tr>
								<td width="100%" valign="top" align="center" id="body_text">
									<table border="0" cellspacing="0" cellpadding="0" height="100%">
										<tr>
											<td align="center" colspan="2" height="160" valign="middle">
												<table border="0" cellspacing="0" cellpadding="0" class="body_text" height="100%">
													<tr>
														<td align="center" height="90" valign="bottom">
															<img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />' >
														</td>
													</tr>
													<tr>
														<td align="center" valign="top" height="70">
															<egui:intnl text="configmgmt.dashboard.No zones have been configured" />
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
		else if (ec_criteria.equalsIgnoreCase("Service"))
		{
%>
							<tr>
								<td width="100%" valign="top" align="center" id="body_text">
									<table border="0" cellspacing="0" cellpadding="0" height="100%">
										<tr>
											<td align="center" colspan="2" height="160" valign="middle">
												<table border="0" cellspacing="0" cellpadding="0" class="body_text" height="100%">
													<tr>
														<td align="center" height="90" valign="bottom">
															<img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />' >
														</td>
													</tr>
													<tr>
														<td align="center" valign="top" height="70">
															<egui:intnl text="configmgmt.dashboard.No services have been configured" />
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
		else if (ec_criteria.equalsIgnoreCase("Segment"))
		{
%>
							<tr>
								<td width="100%" valign="top" align="center" id="body_text">
									<table border="0" cellspacing="0" cellpadding="0" height="100%">
										<tr>
											<td align="center" colspan="2" height="160" valign="middle">
												<table border="0" cellspacing="0" cellpadding="0" class="body_text" height="100%">
													<tr>
														<td align="center" height="90" valign="bottom">
															<img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />' >
														</td>
													</tr>
													<tr>
														<td align="center" valign="top" height="70">
															<egui:intnl text="configmgmt.dashboard.No segments have been configured" />
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
		else
		{
%>
							<tr>
								<td width="100%" valign="top" align="center" id="body_text">
									<table border="0" cellspacing="0" cellpadding="0" height="100%">
										<tr>
											<td align="center" colspan="2" height="160" valign="middle">
												<table border="0" cellspacing="0" cellpadding="0" class="body_text" height="100%">
													<tr>
														<td align="center" height="90" valign="bottom">
															<img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />' >
														</td>
													</tr>
													<tr>
														<td align="center" valign="top" height="70">
															<egui:intnl text="configmgmt.dashboard.No components have been managed" />
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
%>
						</table>
					</td>
				</tr>
			<table>
		</td>
	</tr>
<%
	}
	else
	{
%>
	<tr>
		<td width="100%" valign="top" style="padding:0px">
			<table cellpadding="0" style="padding-right:0px;padding-left:0px" cellspacing="6" border="0" width="100%" height="100%"><col width="50%"><col width="50%">
				<!-- ROW ONE STARTS HERE-->
				<tr height="170px">
					<td align="center" width="50%" height="170px">
						<table id="insidetable" cellpadding="0" cellspacing="0" width="100%" height="100%" border="0">
							<tr>
								<td align="center" id="white" valign="top">
									<div id="CompStatusOswise" border="0" scrolling="no" marginwidth="0" marginheight="0" style="overflow:auto;display:block;">
									</div>
									<!-- <div id="myiframehidden" border="0" scrolling="no" marginwidth="0" marginheight="0" style="visibility:hidden;display:none;overflow:auto;height:170px">
										<table width='100%' height='100%'><tr><td id='ajax_load' align='center' valign="middle"> <img src='/final/monitor/eg_images/Loading.gif'></td></tr></table>
									</div> -->
								</td>
							</tr>
						</table>
					</td>

					<td align="center" width="50%" height="170px">
						<table id="insidetable" cellpadding="0" cellspacing="0" width="100%" border="0" height="100%">
							<tr>
								<td align="center" id="white" valign="top">
									<div id="CompTypeChanges" border="0" scrolling="no" marginwidth="0" marginheight="0"  width="100%">
									</div>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<!-- ROW ONE ENDS HERE-->

				<!-- ROW TWO STARTS HERE-->
				<tr height="160px">
					<td align="center" width="50%" height="160px" valign="top">
						<table id="insidetable" cellpadding="0" cellspacing="0" width="100%" height="100%" border="0">
							<tr>
								<td align="center" id="white" valign="top">
									<div id="TopNAvail" scrolling="no" style="border:0px solid #ff0000" width="100%">
									</div>
								</td>
							</tr>
						</table>
					</td>

					<td align="center" width="50%" height="160px" valign="top">
						<table id="insidetable" cellpadding="0" cellspacing="0" width="100%" height="100%" border="0">
							<tr>
								<td  align="center" id="white" valign="top">
									<div id="CompChanges" border="0" style="border:0px solid #ff00cc" scrolling="no" width="100%">
									</div>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<!-- ROW TWO ENDS HERE-->

				<!-- ROW THREE STARTS HERE-->
				<tr>
					<!-- <td align="center" width="50%" height="100%" valign="top">
						<table id="insidetable" cellpadding="0" cellspacing="0" width="100%" height="100%" border="0">
							<tr>
								<td align="center" id="white" valign="top">
									<table cellspacing="0" cellpadding="0" border="0" width="100%">
										<tr>
											<td class="tdbackcolortop pLeft4"><span align="left"><a href="javascript:showServiceStatus()" class="eg_headlink_white"><b><egui:intnl text="configmgmt.dashboard.Service Status"/></b></a></span></td>
											<td class="tdbackcolortop" align="right" nowrap><select color="#F3FEE9" name="ec_os1" onChange="javascript:getServiceStatus()" style="width:265px"><%//=ecUtils.fillSelectBox(osList,"config","",osName)%></select></td>
										</tr>
										<tr>
											<td width="100%" height="100px" colspan="2" align="left" valign="top">
												  
												<div id="ServiceDisplay" class="div_scroll" style="height:100px;width:100%;border:0px solid #ff0000;overflow-y:auto;"> </div> -->
												<!-- //IE10 code
												<div id="ServiceDisplay" class="div_scroll" style="height:100px;width:493px;border:0px solid #ff0000;overflow:auto;overflow-y:auto;">
												</div> -->
											<!-- </td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td> -->

					<td align="center" width="50%" height="100%" valign="top">
						<table id="insidetable" cellpadding="0" cellspacing="0" width="100%" height="100%" border="0">
							<tr>
								<td align="center" id="white" valign="top">
									<div id="TopNAvailHotfix" scrolling="no" style="height:100%;width:100%;border:0px solid #ff0000;">
									</div>
								</td>
							</tr>
						</table>
					</td>

					<td align="center" width="50%" height="100%" valign="top">
						<table id="insidetable" cellpadding="0" cellspacing="0" width="100%" height="100%" border="0">
							<tr>
								<td align="center" id="white" valign="top">
									<div id="WeekChanges" class="div_scroll" style="height:100%;width:100%;border:0px solid #ff0000;">
									</div>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<!-- ROW THREE ENDS HERE-->
			</table>
		</td>
	</tr>
<%
	}
%>

</table>
</form>
</body>
</html>



