<%@ include file = "../../EcTrackerJson.jsp" %>
<%@ page import = "net.sf.json.*"%>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import = "egurkha.config.EcUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgDbInfo" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};

	private String getUserAppData(String key)
	{
		String data = null;
		IniFile configIniFilePtr = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_configtests.ini");
		String val = configIniFilePtr.getValue("USER_APPLICATIONS_REPORT",key);

		if (val != null && val.length() > 0)
		{
			return val;
		}

		return data;
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String queryString = EcUtils.prepareQueryString(request.getParameterMap());
	JSONObject rootJson = new JSONObject();
	JSONObject hiddenFields = new JSONObject();
	rootJson.put("success","true");

	UserRegistry registry = UserRegistry.getInstance();
	User userObj = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (userObj != null)
	{
		userLanguage = userObj.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	String configSkin = userObj.getConfigSkin();
	String heading = request.getParameter("heading");
	if (heading == null)
	{
		heading = "";
	}
	String componentName = null;
	String componentType = null;
	String farmName = null;
	String serverName = null;
	TreeMap tmapCitrixApplicationsAndUsers = null;
	TreeMap tmapCitrixUsersAndApplications = null;
	String subTitle = ""; //For PDF
	ArrayList serverList = new ArrayList();

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,userObj);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */


	String ec_comptype = request.getParameter("ec_comptype");
	String ec_component = request.getParameter("ec_component");
	String o_comptype = request.getParameter("old_comptype");

	String strThinClients = configTestsInfo.getServerDisplayValue("MISC_ARGS","ThinClients");
	ArrayList aListThinClients = new ArrayList();
	StringTokenizer stringTokens = new StringTokenizer(strThinClients,",");
	while (stringTokens.hasMoreTokens())
	{
		String token = stringTokens.nextToken();
		aListThinClients.add(token);
	}

	Vector vec_componentTypes = new Vector();
	Vector vec_components = new Vector();
	Vector allcomps = new Vector();

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	allcomps.addAll(aListAssociatedComponents);
	//allcomps.addAll(userObj.getServers(false));

	String request_from = request.getParameter("request_from");
	String submitOrNot = (String) request.getAttribute("isSubmit");
	Map scheduleDetails = (Map) request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
		submitOrNot = "false";
	}

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		ec_comptype = (String) scheduleDetails.get("ec_comptype");
		ec_component = (String) scheduleDetails.get("ec_component");
		o_comptype = (String) scheduleDetails.get("old_comptype");
		ec_userOption = (String) scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String) scheduleDetails.get("ec_userOptionPrevious");
		heading = (String) scheduleDetails.get("heading");
	}

	String selectedCompType = "";
	if(ec_comptype != null && ec_comptype.trim().length() > 0 && ec_comptype.equalsIgnoreCase("-1") && !ec_comptype.equalsIgnoreCase("null"))
	{
		if(ec_component != null && ec_component.trim().length() > 0 && !ec_component.equalsIgnoreCase("null"))
		{
			selectedCompType = ec_component.substring(ec_component.lastIndexOf(":")+1);
		}
	}
	else if(ec_comptype != null && ec_comptype.trim().length() > 0 && !ec_comptype.equalsIgnoreCase("null"))
	{
		selectedCompType = ec_comptype;
	}

	if (ec_component != null && ec_component.trim().length() > 0 && !ec_component.equalsIgnoreCase("-1"))
	{
		String displayCompType = "";
		String tempCompNameStr = "";
		Vector tempV = new Vector();
		tempV.add(selectedCompType);
		ArrayList tempAList = sorter.getSortedCompTypeList(tempV);
		for (int i=0;i<tempAList.size();i++)
		{
			EgName nameObj = (EgName)tempAList.get(i);
			String localName = nameObj.getLocalName();
			displayCompType = localName;

			tempCompNameStr = ec_component.substring(0,ec_component.lastIndexOf(":"));
			if (tempCompNameStr.endsWith(":NULL"))
				tempCompNameStr = tempCompNameStr.substring(0,tempCompNameStr.indexOf(":"));
		}
		rootJson.put("displayCompName",tempCompNameStr+" ["+displayCompType+"]");
	}

	String testWithMeasureName = getUserAppData(selectedCompType+":"+heading);
	String measure = "";
	String testName = "";
	if (testWithMeasureName != null && testWithMeasureName.trim().length() > 0)
	{
		int colonIdx = testWithMeasureName.indexOf(":");
		testName = testWithMeasureName.substring(0,colonIdx);
		measure = testWithMeasureName.substring(colonIdx+1);
	}

	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
	}

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		submitOrNot = "false";
	}

	if (!allcomps.isEmpty())
	{
		for (int i=0;i<allcomps.size();i++)
		{
			String str = (String) allcomps.get(i);
			String component_type = str.substring(0,str.indexOf(":"));

			if (!aListThinClients.contains(component_type)) continue;

			boolean isTestEnabled = specsInfo.isConfigTestEnabled(component_type);
			if (!isTestEnabled) continue;

			if (!vec_componentTypes.contains(component_type))
				vec_componentTypes.add(component_type);

			String component_name = str.substring(str.indexOf(":")+1);
			vec_components.add(component_name+":"+component_type);
		}
		Collections.sort(vec_componentTypes);
	}

	if (ec_component != null && !ec_component.equals("-1"))
	{
		componentName = ec_component.substring(0,ec_component.lastIndexOf(":"));
		componentType = ec_component.substring(ec_component.lastIndexOf(":")+1);
		componentType = mappingInfo.getComponentTypeDescription(componentType);
	}

	if (ec_comptype != null)
	{
		if (ec_comptype.equals("Citrix_server"))
		{
			heading = "Server Application Users";
		}
	}

	//if (selectedCompType != null && selectedCompType.trim().length() > 0)
	//{
		//heading = selectedCompType;
	//}

	Vector v_comp = null;
	if (ec_comptype == null || ec_comptype.equals("-1"))
	{
		v_comp = vec_components;
		Collections.sort(v_comp);
		ec_comptype = "-1";
	}
	else
	{
		v_comp = new Vector();
		for (int i=0;i<vec_components.size();i++)
		{
			String s_comp = (String)vec_components.get(i);
			if (ec_comptype != null && s_comp.endsWith(ec_comptype))
			{
				v_comp.add(s_comp);
			}
		}
		Collections.sort(v_comp);
		if (!ec_comptype.equalsIgnoreCase(o_comptype))
			ec_component = "";
	}

	ArrayList aListCitrixAppUsers = (ArrayList)request.getAttribute("Citrix Application Users");
	if (aListCitrixAppUsers != null && !aListCitrixAppUsers.isEmpty())
	{
		ArrayList aListCitrixFarmDetails = (ArrayList)aListCitrixAppUsers.get(1);
		if (aListCitrixFarmDetails != null)
		{
			tmapCitrixApplicationsAndUsers = (TreeMap)aListCitrixFarmDetails.get(3);
		}
	}

	if (tmapCitrixApplicationsAndUsers != null)
	{
		int colNo = 0;
		tmapCitrixUsersAndApplications = new TreeMap();
		if (measure != null && measure.trim().length() > 0)
		{
			EgDbInfo dbInfo = new EgDbInfo("manager");
			String columnName = dbInfo.getColumnForMeasure(testName,measure);
			colNo = Integer.parseInt(columnName);
		}
		Iterator applicationAsKeys = tmapCitrixApplicationsAndUsers.keySet().iterator();
		while (applicationAsKeys.hasNext())
		{
			String key_application = (String)applicationAsKeys.next();
			ArrayList aListApplicationValues = (ArrayList)tmapCitrixApplicationsAndUsers.get(key_application);

			StringTokenizer strTokens = new StringTokenizer((String)aListApplicationValues.get(colNo),",");

			while (strTokens.hasMoreTokens())
			{
				String token = strTokens.nextToken();
				if (token.equals("-")) continue;
				ArrayList aListApplications = (ArrayList)tmapCitrixUsersAndApplications.get(token);

				if (aListApplications == null)
				{
					aListApplications = new ArrayList();
					aListApplications.add(key_application);
					tmapCitrixUsersAndApplications.put(token,aListApplications);
				}
				else
				{
					aListApplications.add(key_application);
				}
			}
		}
	}


	String userName = (String)request.getAttribute("userName");
	ArrayList aListCitrixUserApplications = null;
	if (userName != null && !(userName.equalsIgnoreCase("All") || userName.equals("-1")) && tmapCitrixUsersAndApplications != null && !tmapCitrixUsersAndApplications.isEmpty())
	{
		aListCitrixUserApplications = (ArrayList)tmapCitrixUsersAndApplications.get(userName);
	}

	session.setAttribute("ec_component",ec_component);
	session.setAttribute("heading",heading);
	session.setAttribute("farmName",farmName);
	session.setAttribute("serverName",serverName);
	session.setAttribute("userName",userName);
	session.setAttribute("CitrixUserApplications",tmapCitrixUsersAndApplications);

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	String s_userName = (String)session.getAttribute("sess_auserid");

	String id = request.getParameter("id");

	String strBackRequest = request.getParameter("back_request");
	String strsubmitClicked = request.getParameter("submitClicked");
	if (strsubmitClicked == null)
	{
		strsubmitClicked = "false";
	}
	if (strBackRequest != null && strBackRequest.equalsIgnoreCase("ScheduleConfig") && strsubmitClicked != null && strsubmitClicked.equalsIgnoreCase("false"))
	{
		submitOrNot = "false";
	}

	hiddenFields.put("ec_rtype","CitrixApplicationsAndUsers");
	hiddenFields.put("heading",heading);
	hiddenFields.put("userOption","User Applications");
	hiddenFields.put("requestFrom","CurrentPage");
	hiddenFields.put("old_comptype",ec_comptype);
	hiddenFields.put("ec_criteriaPrevious",ec_criteria);
	if (request_from != null && request_from.equalsIgnoreCase("currentConfig"))
	{
		hiddenFields.put("isReqFromCurConfig","yes");
	}
	else
	{
		hiddenFields.put("isReqFromCurConfig","no");
	}
	if(ec_userOption == null)
	{
		hiddenFields.put("ec_userOptionPrevious","");
	}
	else
	{
		hiddenFields.put("ec_userOptionPrevious",ec_userOption);
	}

	rootJson.put("hiddenFields",hiddenFields);

	JSONObject backOperation = new JSONObject();
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		backOperation.put("schedule",new Boolean(true));
	}

	if (request_from != null && request_from.equalsIgnoreCase("currentConfig"))
	{
		String compName = request.getParameter("ec_component");
		String compType = compName.substring(compName.lastIndexOf(":")+1);
		String tests[] = request.getParameterValues("ec_test");
		backOperation.put("goToCurrentConfig",new Boolean(true));
		backOperation.put("compName",compName);
		backOperation.put("compType",compType);
		backOperation.put("ec_criteria",ec_criteria);
		backOperation.put("selectedTest",tests);
	}
	rootJson.put("backOperation",backOperation);


	JSONObject viewByObj = new JSONObject();
	JSONArray viewByArr = new JSONArray();
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				rootJson.put("selectedEcOpt",ec_criteria);
			}
			viewByObj.put("displayField",_mapping.getTextDescription("configmgmt.common."+strCriteria));
			viewByObj.put("valueField",strCriteria);
			viewByArr.add(viewByObj);
		}
	}
	else
	{
		rootJson.put("selectedEcOpt","-1");
		viewByObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
		viewByObj.put("valueField","-1");
		viewByArr.add(viewByObj);
	}
	rootJson.put("viewByList",viewByArr);


	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
			rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[0]));
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
			rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[1]));
		}
		else
		{
			rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[2]));
		}

		JSONObject specviewByObj = new JSONObject();
		JSONArray specviewByArr = new JSONArray();

		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					rootJson.put("selectedUserOption",ec_userOption);
				}
				specviewByObj.put("displayField",strUserOption);
				specviewByObj.put("valueField",strUserOption);
				specviewByArr.add(specviewByObj);
			}
		}
		else
		{
			rootJson.put("selectedUserOption","-1");
			specviewByObj.put("displayField",_mapping.getTextDescription("configmgmt.inventory.system.Not Applicable"));
			specviewByObj.put("valueField","-1");
			specviewByArr.add(specviewByObj);
		}
		rootJson.put("specViewByList",specviewByArr);
	}
	else
	{
	}



	JSONObject compTypeObj = new JSONObject();
	JSONArray compTypeArr = new JSONArray();
	if (vec_componentTypes != null && !vec_componentTypes.isEmpty())
	{
		rootJson.put("selectedCompType","-1");
		compTypeObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Select a component type"));
		compTypeObj.put("valueField","-1");
		compTypeArr.add(compTypeObj);

		if (ec_comptype == null || ec_comptype.equals("-1"))
		{
			serverList = sorter.getSortedCompTypeList(vec_componentTypes);
			for (int i=0;i<serverList.size();i++)
			{
				EgName nameObj = (EgName)serverList.get(i);
				String actualName = nameObj.getActualName();
				String localName = nameObj.getLocalName();

				compTypeObj.put("displayField",localName);
				compTypeObj.put("valueField",actualName);
				compTypeArr.add(compTypeObj);
			}
		}
		else
		{
			serverList = sorter.getSortedCompTypeList(vec_componentTypes);
			for (int i=0;i<serverList.size();i++)
			{
				EgName nameObj = (EgName)serverList.get(i);
				String actualName = nameObj.getActualName();
				String localName = nameObj.getLocalName();
				String selected = "";
				if (actualName != null && actualName.equals(ec_comptype))
				{
					rootJson.put("selectedCompType",actualName);
				}
				compTypeObj.put("displayField",localName);
				compTypeObj.put("valueField",actualName);
				compTypeArr.add(compTypeObj);
			}
		}
	}
	else
	{
		rootJson.put("selectedCompType","-1");
		compTypeObj.put("displayField",_mapping.getTextDescription("configmgmt.inventory.system.Not Applicable"));
		compTypeObj.put("valueField","-1");
		compTypeArr.add(compTypeObj);
	}
	rootJson.put("compTypeList",compTypeArr);


	JSONObject compNameObj = new JSONObject();
	JSONArray compNameArr = new JSONArray();
	if (v_comp != null && !v_comp.isEmpty())
	{
		rootJson.put("selectedCompName","-1");
		compNameObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Select a component"));
		compNameObj.put("valueField","-1");
		compNameArr.add(compNameObj);

		for (int i=0;i<v_comp.size();i++)
		{
			String componentTemp = (String)v_comp.get(i);
			String tempCompName = "";
			String tempCompType = "";
			String selected = "";
			if (componentTemp != null)
			{
				tempCompName = componentTemp.substring(0,componentTemp.lastIndexOf(":"));
				if (tempCompName.endsWith(":NULL"))
					tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
				tempCompType = componentTemp.substring(componentTemp.lastIndexOf(":")+1);
				//getting component type mapping name
				tempCompType = mappingInfo.getComponentTypeDescription(tempCompType);
				if (componentTemp.equals(ec_component))
				{
					rootJson.put("selectedCompName",componentTemp);
				}
			}

			String strDisplay = tempCompName + ":"+tempCompType;
			compNameObj.put("displayField",strDisplay);
			compNameObj.put("valueField",componentTemp);
			compNameArr.add(compNameObj);
		}
	}
	else
	{
		rootJson.put("selectedCompName","-1");
		compNameObj.put("displayField",_mapping.getTextDescription("configmgmt.inventory.system.Not Applicable"));
		compNameObj.put("valueField","-1");
		compNameArr.add(compNameObj);
	}
	rootJson.put("compNameList",compNameArr);


	subTitle = mappingInfo.getTextDescription("configmgmt.common.Component") + " : " + componentName + ":" + componentType;
	if (heading.equalsIgnoreCase("List of Applications/Desktops/Contents With Users"))
	{
		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.configuration.Farm name") + " : " + farmName;

		rootJson.put("LabelName",mappingInfo.getTextDescription("configmgmt.configuration.Farm Name"));

		if (farmName == null)
		{
			rootJson.put("serverName",mappingInfo.getTextDescription("configmgmt.common.Not Applicable"));
		}
		else
		{
			rootJson.put("serverName",farmName);
		}
	}
	else
	{
		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.configuration.Server name") + " : " + serverName;

		rootJson.put("LabelName",mappingInfo.getTextDescription("configmgmt.configuration.Server Name"));

		if (serverName == null)
		{
			rootJson.put("serverName",mappingInfo.getTextDescription("configmgmt.common.Not Applicable"));
		}
		else
		{
			rootJson.put("serverName",serverName);
		}
	}

	JSONObject usersObj = new JSONObject();
	JSONArray userArr = new JSONArray();

	if (tmapCitrixUsersAndApplications != null && tmapCitrixUsersAndApplications.size()>0)
	{
		rootJson.put("selectedUser","-1");
		usersObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Select a user"));
		usersObj.put("valueField","-1");
		userArr.add(usersObj);

		if (tmapCitrixUsersAndApplications.size() > 1)
		{
			if ("All".equalsIgnoreCase(userName))
			{
				rootJson.put("selectedUser",userName);
			}
			usersObj.put("displayField",_mapping.getTextDescription("configmgmt.common.All"));
			usersObj.put("valueField","All");
			userArr.add(usersObj);
		}

		Iterator userAsKeys = tmapCitrixUsersAndApplications.keySet().iterator();
		while (userAsKeys.hasNext())
		{
			String userKey = (String)userAsKeys.next();

			if (userKey.equalsIgnoreCase(userName))
			{
				rootJson.put("selectedUser",userKey);
			}

			usersObj.put("displayField",userKey);
			usersObj.put("valueField",userKey);
			userArr.add(usersObj);
		}
	}
	else
	{
		rootJson.put("selectedUser","-1");
		usersObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
		usersObj.put("valueField","-1");
		userArr.add(usersObj);
	}

	rootJson.put("usersList",userArr);

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
	}
	else
	{
	}


	if (aListCitrixUserApplications != null && submitOrNot.equals("true"))
	{
		rootJson.put("hasConfigDetails",true);
		int applicationSize = aListCitrixUserApplications.size();

		//For New Pdf Framework - Krishnamurthi
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
	
		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.THIN CLIENT USERS REPORT") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.THIN CLIENT USERS REPORT") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		reportAttributes.setReportName("ThinClientUsers");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);

		EgTableAttributes egTableAttributes = new EgTableAttributes();
		String user = userName;
		/*
		if (userName.indexOf("\\") != -1)
		{
			StringBuffer strBuffer = new StringBuffer(userName);
			strBuffer.insert(userName.indexOf("\\")+1,"\\");
			user = strBuffer.toString();
		}
		*/
		egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.configuration.Total applications for")+" "+user+" : "+applicationSize);

		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.configuration.User") + " : " + user;
		reportAttributes.setSubTitle(subTitle);

		ArrayList aListColumnNames = new ArrayList();
		ArrayList aListData = new ArrayList();
		ArrayList userColumnNames = new ArrayList();

		for (int x=0; x<4; x++)
			aListColumnNames.add("C"+x);

		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.List of applications"));
		userColumnNames.add("");
		userColumnNames.add("");
		userColumnNames.add("");

		rootJson.put("gridSubTitle",mappingInfo.getTextDescription("configmgmt.configuration.List of applications"));
		rootJson.put("gridMainTitle",mappingInfo.getTextDescription("configmgmt.configuration.Total applications for")+" "+user+" : "+applicationSize);

		JSONArray appArr = new JSONArray();
		JSONObject appObj = new JSONObject();
		int columnCount = 1;

		appObj.put("user",user+" (Count: "+applicationSize+")");

		for (int d=0; d<applicationSize; d=d+4)
		{
			for (int e=d; e<d+4; e++)
			{
				if (e<applicationSize)
				{
					String hidden_href = "";
					aListData.add((String)aListCitrixUserApplications.get(e));

					if(farmName != null && farmName != "")
					{
						hidden_href = "../servlet/com.eg.EcConfigurationServletNew?ec_rtype=CitrixApplicationsAndUsers&applicationName="+aListCitrixUserApplications.get(e)+"&ec_component="+ec_component+"&ec_comptype="+ec_comptype+"&ec_criteria="+ec_criteria+"&ec_criteriaPrevious="+ec_criteriaPrevious+"&ec_userOptionPrevious="+ec_userOptionPrevious+"&heading="+heading+"&old_comptype="+ec_comptype+"&requestFrom=CitrixUserAppsPage"+"&submitClicked="+strsubmitClicked+"&userName="+userName+"&userOption=Application Users&user_language="+userLanguage+"&fsctrl="+farmName;
					}
					else if(serverName != null && serverName != "")
					{
						hidden_href = "../servlet/com.eg.EcConfigurationServletNew?ec_rtype=CitrixApplicationsAndUsers&applicationName="+aListCitrixUserApplications.get(e)+"&ec_component="+ec_component+"&ec_comptype="+ec_comptype+"&ec_criteria="+ec_criteria+"&ec_criteriaPrevious="+ec_criteriaPrevious+"&ec_userOptionPrevious="+ec_userOptionPrevious+"&heading="+heading+"&old_comptype="+ec_comptype+"&requestFrom=CitrixUserAppsPage"+"&submitClicked="+strsubmitClicked+"&userName="+userName+"&userOption=Application Users&user_language="+userLanguage+"&fsctrl="+serverName;
					}

					String appWithURL = (String)aListCitrixUserApplications.get(e) +"#$#"+ hidden_href;
					appObj.put("column_"+columnCount,appWithURL);
				}
				else
				{
					aListData.add(" ");
					appObj.put("column_"+columnCount,"");
				}
				if(columnCount == 4)
				{
					columnCount = 1;
				}
				else
				{
					columnCount++;
				}
			}
			appArr.add(appObj);
		}
		rootJson.put("ListOfApplications",appArr);

		//For Pdf
		EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
		egTableAttributes.setColumnNames(userColumnNames);

		EgTable egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);

		aListPdfData.add(egTable);

		pdfData.setAttributes(reportAttributes);
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else if (userName != null && userName.equalsIgnoreCase("All") && submitOrNot.equals("true"))
	{
		rootJson.put("hasConfigDetails",true);

		//For PDF
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();

		EgReportAttributes reportAttributes = new EgReportAttributes();
		if (request_from != null && request_from.equalsIgnoreCase("currentConfig"))
			reportAttributes.setMainTitle(mappingInfo.getTextDescription("configmgmt.configuration.USERS AND THEIR ASSOCIATED APPLICATIONS REPORT"));
		else
			reportAttributes.setMainTitle(mappingInfo.getTextDescription("configmgmt.configuration.THIN CLIENT USERS"));

		if (request_from != null && request_from.equalsIgnoreCase("currentConfig"))
			reportAttributes.setReportName("UsersAndTheirAssociatedApplications");
		else
			reportAttributes.setReportName("ThinClientUsers");

		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);

		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.configuration.List of users with their associated applications");
		reportAttributes.setSubTitle(subTitle);

		ArrayList aListData = new ArrayList();

		ArrayList aListColumnNames = new ArrayList();
		aListColumnNames.add("User");
		aListColumnNames.add("Application1");
		aListColumnNames.add("Application2");
		aListColumnNames.add("Application3");

		ArrayList userColumnNames = new ArrayList();
		userColumnNames.add("");
		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Applications"));
		userColumnNames.add("");
		userColumnNames.add("");

		EgTableAttributes egTableAttributes = new EgTableAttributes();
		egTableAttributes.setColumnNames(userColumnNames);
		egTableAttributes.setStartX(0);
		egTableAttributes.setDataGrouping(true);
		egTableAttributes.setDataGroupingField(0);

		rootJson.put("AllUsersGridTitle",mappingInfo.getTextDescription("configmgmt.configuration.List of users with their associated applications"));

		JSONArray allAppArr = new JSONArray();
		JSONObject allAppObj = new JSONObject();

		int colCount = 1;

		Iterator userAsKeys = tmapCitrixUsersAndApplications.keySet().iterator();
		while (userAsKeys.hasNext())
		{
			String userKey = (String)userAsKeys.next();
			ArrayList aListApplications = (ArrayList)tmapCitrixUsersAndApplications.get(userKey);

			String userWithAppCount = userKey + "#$#" +mappingInfo.getTextDescription("configmgmt.configuration.Count")+ " : " + aListApplications.size();

			allAppObj.put("user",userWithAppCount);

			for (int d=0; d<aListApplications.size(); d=d+3)
			{
				aListData.add(mappingInfo.getTextDescription("configmgmt.configuration.User")+" : "+userKey);
				for (int e=d; e<d+3; e++)
				{
					if (e<aListApplications.size())
					{
						String hidden_href = "";
						String applicationKey = (String)aListApplications.get(e);
						aListData.add(applicationKey);


						if(farmName != null && farmName != "")
						{
							hidden_href = "../servlet/com.eg.EcConfigurationServletNew?ec_rtype=CitrixApplicationsAndUsers&applicationName="+aListApplications.get(e)+"&ec_component="+ec_component+"&ec_comptype="+ec_comptype+"&ec_criteria="+ec_criteria+"&ec_criteriaPrevious="+ec_criteriaPrevious+"&ec_userOptionPrevious="+ec_userOptionPrevious+"&heading="+heading+"&old_comptype="+ec_comptype+"&requestFrom=CitrixUserAppsPage"+"&submitClicked="+strsubmitClicked+"&userName="+userName+"&userOption=Application Users&user_language="+userLanguage+"&fsctrl="+farmName;
						}
						else if(serverName != null && serverName != "")
						{
							hidden_href = "../servlet/com.eg.EcConfigurationServletNew?ec_rtype=CitrixApplicationsAndUsers&applicationName="+aListApplications.get(e)+"&ec_component="+ec_component+"&ec_comptype="+ec_comptype+"&ec_criteria="+ec_criteria+"&ec_criteriaPrevious="+ec_criteriaPrevious+"&ec_userOptionPrevious="+ec_userOptionPrevious+"&heading="+heading+"&old_comptype="+ec_comptype+"&requestFrom=CitrixUserAppsPage"+"&submitClicked="+strsubmitClicked+"&userName="+userName+"&userOption=Application Users&user_language="+userLanguage+"&fsctrl="+serverName;
						}
						String applicationKeyWithURL = applicationKey + "#$#" + hidden_href;

						allAppObj.put("column_"+colCount,applicationKeyWithURL);
					}
					else
					{
						aListData.add("");
						allAppObj.put("column_"+colCount,"");
					}
					if (colCount == 3)
					{
						colCount = 1;
					}
					else
					{
						colCount++;
					}
				}
				allAppArr.add(allAppObj);
			}
		}
		rootJson.put("AllApplicationsGridValues",allAppArr);
		//For PDF
		EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
		EgTable egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);
		aListPdfData.add(egTable);

		pdfData.setAttributes(reportAttributes);
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else
	{
		rootJson.put("hasConfigDetails",false);
		rootJson.put("errorText","No data found for the current selection.");
	}

	StringBuffer printQS = new StringBuffer();
	printQS.append("ec_type=User_Applications");
	printQS.append("&requestFrom=currentConfigThinClient");
	printQS.append("&ec_trgttype=REPORT");
	printQS.append("&printData=yes");
	printQS.append("&userName="+EgURLEncoder.encode(s_userName,"UTF-8"));
	printQS.append("&user_language="+userLanguage);
	printQS.append("&ec_criteria="+ec_criteria);
	printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
	String s_qryString = "../servlet/com.eg.EcRepoLiteC?"+printQS.toString()+"&ec_forPDF=No";
	rootJson.put("printQueryStr",s_qryString);

	session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
	if (request_from != null && request_from.equalsIgnoreCase("currentConfig"))
		session.setAttribute("REPORT_NAME","UsersAndTheirAssociatedApplications");
	else
		session.setAttribute("REPORT_NAME","ThinClientUsersWithApplications");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");
	session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
	session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
	out.println(rootJson);

%>



