<%
/*******************************************************************************
*       Name            :       aggAddServerp.jsp
*       Purpose         :		Process page for adding an aggregate component
*       Version         :       5.2
*       CreationDate    :       08/02/2011
*       Author          :       James Thomas P.
*********************************************************************************
*/
%>

<%@ include file = "EgTrackerA.jsp"%>
<%@ page errorPage = "EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "com.eg.UpdateAndTransmitICInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import="java.util.*" %>
<%@ page import="egurkha.*" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
	String server = request.getParameter("server");
	server = server.trim();

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	auditLogThread.setValue("Activity","Component Type");
	/* code for auditlog starts */

	if(EgInstallInfo.isAggregationSupported())
	{
		if(!server.startsWith("Agg_"))
		{
			Vector errors = new Vector();
			errors.addElement(_mapping.getTextDescription("admin.error.Add Component type"));
			errors.addElement("aggAddComponent.jsp");
			errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
			errors.addElement(_mapping.getTextDescription("admin.error.You are trying to add a Aggregate Component type which does not start with Agg_")+".");
			errors.addElement(_mapping.getTextDescription("admin.error.Please enter a unique component type starting with Agg_")+".");
			session.putValue("vec_Errors", errors);
%>
			<jsp:forward page="EgErrors.jsp" />
<%
		}
	}
	ServerBean serverBean = new ServerBean(true);
	if(serverBean.doesServerExist(server))
	{
		Vector errors = new Vector();
		errors.addElement(_mapping.getTextDescription("admin.error.Add Component type"));
		errors.addElement("aggAddComponent.jsp");
		errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
		errors.addElement(_mapping.getTextDescription("admin.error.You are trying to add a Aggregate Component type which is already existing")+".");
		errors.addElement(_mapping.getTextDescription("admin.error.Please enter a unique component type")+".");
		session.putValue("vec_Errors", errors);

		/* code for auditlog starts */
		auditLogThread.setValue("Description",server + " component type can not be added as it already exists");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */
%>
		<jsp:forward page="EgErrors.jsp" />
<%
	}
	else
	{
		//IniFile agglang = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_aggregate_lang_en_US.ini",true);
		IniFile agglang = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_aggregate_lang_en_US.ini");
		String compDispName = request.getParameter("comp_type_display_name");
		boolean found = false;
		if(!StringUtils.isNull(compDispName))
		{
			compDispName = compDispName.trim();
			Vector v = agglang.getAllValues("TYPE_NAME_MAPPING");
			if(v != null && v.size()>0)
			{
				for(int i=0;i<v.size();i++)
				{
					if(v.get(i).toString().trim().toLowerCase().equals(compDispName.trim().toLowerCase()))
					{
						found = true;
						break;
					}
				}
			}
		}
		if(found)
		{
			agglang.saveFile();
			EgConfigFilesSync.releaseInstance(agglang);
			Vector errors = new Vector();
			errors.addElement(_mapping.getTextDescription("admin.error.Add Component type"));
			errors.addElement("aggAddComponent.jsp");
			errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
			errors.addElement(_mapping.getTextDescription("admin.error.You are trying to add a aggregate component display name which is already existing")+".");
			errors.addElement(_mapping.getTextDescription("admin.error.Please enter a unique aggregate component display name")+".");
			session.putValue("vec_Errors", errors);
%>
			<jsp:forward page="EgErrors.jsp" />
<%
		}
		agglang.setValue("TYPE_NAME_MAPPING",server,compDispName);
		agglang.setValue("AGG_TEXT_NAME_MAPPING","admin.aggregate."+server,compDispName);
		agglang.saveFile();
		EgConfigFilesSync.releaseInstance(agglang);

		String port = "NULL";
		String display=request.getParameter("display");
		String siteSupport = request.getParameter("sitesupport");
		boolean siteSupported = (!StringUtils.isNull(siteSupport) && siteSupport.equals("Yes"))?true:false;
		String associatedServerTypes = request.getParameter("associatedServerTypes");
		ArrayList associatedServerTypeList = new ArrayList(java.util.Arrays.asList(StringUtils.getTokens(associatedServerTypes,",")));

		session.setAttribute("server",server);
		session.setAttribute("port",port);
		session.setAttribute("sitesupport",siteSupport);

		ArrayList siteServers = new EgDiscInfo("manager").getSiteServers();
		if(siteServers != null && siteServers.size()>0 && siteSupported)
		{
			siteSupported = false;
			for(int i=0;i<associatedServerTypeList.size();i++)
			{
				if(siteServers.contains(associatedServerTypeList.get(i)))
				{
					siteSupported = true;
					break;
				}
			}
		}
		serverBean.addServer(server, port, siteSupported);
		try
		{
			UpdateAndTransmitICInfo updateICInfo = new UpdateAndTransmitICInfo();
			updateICInfo.createImage(server,display);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		/* code for auditlog starts */
		auditLogThread.setCurrentValue("01~~Component type",server);
		auditLogThread.setCurrentValue("02~~Image display name",display);
		auditLogThread.setCurrentValue("03~~Port",port);
		auditLogThread.setCurrentValue("04~~Site support",siteSupport);
		/* code for auditlog ends */
		
		if(EgInstallInfo.isAggregationSupported())
		{
			String array[] = StringUtils.getTokens(associatedServerTypes,",");
			if(associatedServerTypeList != null && associatedServerTypeList.size()>0)
			{
				for(int i=0;i<associatedServerTypeList.size();i++)
				{
					String server_type = (String)associatedServerTypeList.get(i);
					if(!server_type.endsWith("_ex"))
						server_type = "$ctype$:"+ server_type;
					auditLogThread.setCurrentValue("05~~Server types associaited",server_type);
				}
			}
			IniFile aggregateInfo = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_aggregate.ini");
			aggregateInfo.setValue("AGGREGATE_TYPES",server,"true");
			aggregateInfo.setValue("COMPONENT_TYPE_MAPPING",server,associatedServerTypes);
			aggregateInfo.setValue("COMP_DISPLAY_NICK",server,display);
			
			if(!StringUtils.isNull(request.getParameter("isAggGenType")))
			{
				aggregateInfo.setValue("AGGREGATE_GENERIC_TYPES",server,"yes");
			}
			aggregateInfo.saveFile();
			EgConfigFilesSync.releaseInstance(aggregateInfo);
			//IniFile egInfra = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_infrastructure.ini",true);
			IniFile egInfra = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_infrastructure.ini");
			egInfra.setValue("AGGREGATES",server,request.getParameter("comp_type_display_name"));
			egInfra.saveFile();
			EgConfigFilesSync.releaseInstance(egInfra);
		}

		/* code for auditlog starts */
		auditLogThread.setValue("Description",server + " component type has been created");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */

		Vector sess_vec = new Vector();
		sess_vec.addElement(_mapping.getTextDescription("admin.aggregate.Layer configuration page"));
		sess_vec.addElement("aggConfigLayersForServer.jsp?from_jsp=aggCreateComponent&server="+server);
		sess_vec.addElement(_mapping.getTextDescription("admin.aggregate.Add Aggregate Component ")+".");
		sess_vec.addElement(_mapping.getTextDescription("admin.aggregate.Aggregate component type has been added successfully")+"...");
		session.setAttribute("vec_Results",sess_vec);
%>
		<jsp:forward page="EgResults.jsp"/>
<%
	}
%>
