<%
/******************************************************************************
*	Name			:	aggAddComponent.jsp
*	Purpose			:	creating aggregate component type
*	Version			:	5.2
*	Creation Date	:	14th February 2011
*	Author			:	James Thomas P
******************************************************************************/
%>
<%@ include file = "EgTrackerA.jsp" %>
<%@ page errorPage = "EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgAggregateInfo"%>
<%@ page import="com.eg.EgThresholdInfo"%>
<%@ page import="com.eg.EgDbAdapterTypeUI"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.admin.EgTestSpecification"%>
<%@ page import="com.eg.EgRoleInfo"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgDiscInfo"%>
<%@ page import="egurkha.TestBean"%>
<%@ page import="egurkha.EgDbAdapterUI"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	if(!EgInstallInfo.isAggregationSupported())
	{
		Vector errors = new Vector();
		errors.addElement(_mapping.getTextDescription("admin.error.Admin Home"));
		errors.addElement("EgAdminOperations.jsp");
		errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
		errors.addElement(_mapping.getTextDescription("admin.error.Your license does not allow you to use this feature")+".");
		errors.addElement(_mapping.getTextDescription("admin.error.Please contact") + " <a href='mailTo:license@eginnovations.com' target='_parent' class='dash_link'><b>license@eginnovations.com</b></a> " + _mapping.getTextDescription("admin.error.for more details")+".");
		session.putValue("vec_Errors", errors);
%>
	<jsp:forward page="EgErrors.jsp" />
<%
	}
	boolean browser = false;
	String ua = request.getHeader("user-agent");
	browser = (!StringUtils.isNull(ua) && ua.indexOf("MSIE") > -1)?true:false;
	int managedCount = 0;
	int unmanagedCount = 0;
	String aggComponentType = null;
	String startBorder = "form_spacing";
	String showBackButton = "true";
	String component_type = request.getParameter("s_component_type");
	String s_agg_component_type = request.getParameter("s_agg_component_type");
	String link = request.getParameter("reqfrom");
	String operation = request.getParameter("operation");
	String componentfor = request.getParameter("componentfor");
	String imageDisplayName="";
	String[] measures = null;
	boolean showLink = false;
	Vector associatedTypes = new Vector();
	componentfor = StringUtils.isNull(componentfor) ? "managedComponents":componentfor.trim();
	if(!StringUtils.isNull(link) && link.equals("navlink")) showBackButton = "false";
	operation = StringUtils.isNull(operation)? "add":operation.trim();

	ArrayList componentTypes = new ArrayList();
	Vector includedMeasures = new Vector();
	Vector excludedMeasures = new Vector();
	EgTablesInfo tableConfig = new EgTablesInfo("manager");
	EgThresholdInfo threshConfig = new EgThresholdInfo("manager");
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	ArrayList siteServers = new ArrayList();
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	siteServers = discInfo.getSiteServers();
	if(componentfor.equals("managedComponents"))
	{
		EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
		EgTestSpecification egTestSpecification = null;
		List managedComponents = ri.getAllServers();
		if(managedComponents != null && managedComponents.size()>0)
		{
			for(int i=0;i<managedComponents.size();i++)
			{
				String mComponent = (String)managedComponents.get(i);
				String mcType = mComponent.substring(0,mComponent.indexOf(":"));
				if(!mcType.startsWith("Agg_") && !componentTypes.contains(mcType))
				{
					componentTypes.add(mcType);
				}
			}
		}
	}
	if(componentfor.equals("allComponents"))
	{
		componentfor="allComponents";
		String [] cTypes = discInfo.getServerTypes();
		for(int i=0;i<cTypes.length;i++)
		{
			String cType = cTypes[i];
			if(!cType.startsWith("Agg_") && !componentTypes.contains(cType))
			{
				componentTypes.add(cType);
			}
		}
	}
	if(operation.equalsIgnoreCase("modify"))
	{
		component_type = aggregateInfo.getValue("COMPONENT_TYPE_MAPPING",s_agg_component_type);
		if(!StringUtils.isNull(component_type))
		{
			String array[] = StringUtils.getTokens(component_type,",");
			if(array != null && array.length>0)
			{
				component_type = "Generic_server";
				associatedTypes = new Vector(Arrays.asList(array));
			}
		}

	}
	String displayDescription = null;
	if(!StringUtils.isNull(component_type) && !component_type.equals("-1"))
	{
		startBorder = "form_border";
		if(operation.equalsIgnoreCase("modify"))
		{
			aggComponentType = s_agg_component_type;
			displayDescription = _mapping.getComponentTypeDescription(aggComponentType);
			imageDisplayName = aggregateInfo.getValue("COMP_DISPLAY_NICK",s_agg_component_type);
		}
		else
		{
			if(component_type.length()>22)
				aggComponentType = "Agg_"+component_type.substring(0,22)+"_ExAgg";
			else
				aggComponentType = "Agg_"+component_type+"_ExAgg";
			displayDescription = _mapping.getComponentTypeDescription(component_type);
			if(displayDescription.length()>21)
				displayDescription=displayDescription.substring(0,21) + " Aggregate";
			else
				displayDescription=displayDescription + " Aggregate";
		}
	}
	else
	{
		component_type = "-1";
		aggComponentType="-1";
	}
	String url = "listSearch.jsp?title=Create Aggregate Component&leftString=&subtitle=false&searchBox=false&backButton="+showBackButton;
	boolean siteServer=siteServers.contains(component_type);
	String siteBorder=siteServer?"form_border":"form_spacing";
	String[] strServerTypes = new EgDiscInfo("manager").getServerTypes();
%>
<html>
<head>
	<egui:skin ui = "admin"/>
	<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
	<script language="javascript">
	function showTests(a)
	{
		if(a!='<%=componentfor%>')
		{
			window.location.href = "aggAddComponent.jsp?s_component_type=-1&componentfor="+a;
		}
	}
	function reloadPage(a)
	{
		var thisForm = document.list;
		var s_component_type = thisForm.component_type.options[thisForm.component_type.selectedIndex].value;
		if(s_component_type == -1)
			window.location.href = "aggAddComponent.jsp?s_component_type=-1&componentfor="+selectedComponentFor();
		else
			window.location.href = "aggAddComponent.jsp?s_component_type="+encodeURI(a)+"&componentfor="+selectedComponentFor();
	}
	function selectedComponentFor()
	{
		var thisForm = document.list;
		if(thisForm.componentfor[0].checked)
			return "managedComponents";
		else
			return "allComponents";
	}
	function valform()
	{
		var thisForm = document.list;
		var flag = true;
		var cmpName=true;
		var imageDispName=true;
		var compDispName=true;
		if('<%=EgDbInfo.doubleByteEnabled%>'=="false")
		{
			cmpName = validateSingleByte(thisForm.aggComponentName.value);
			imageDispName = validateSingleByte(thisForm.imageDispName.value);
			compDispName = validateSingleByte(thisForm.compDispName.value);
		}
		if(!checkblank(thisForm.aggComponentName))
		{
			alert("<egui:intnl text='admin.ic.Aggregate component type field can not be empty'/>");
			thisForm.aggComponentName.focus();
			flag = false;
		}
		else if(!checkspace(thisForm.aggComponentName))
		{
			thisForm.aggComponentName.focus();
			flag = false;
		}
		else if(!checkspecialnomess(thisForm.aggComponentName,"`~!@#$%^&*()-+={}[]|\\:;\"\'<>,.?\/"))
		{
			alert("<egui:intnl text='admin.ic.Please enter a valid component type'/>");
			thisForm.aggComponentName.focus();
			flag = false;
		}
		else if(!checkForAggregate(thisForm.aggComponentName.value))
		{
			thisForm.aggComponentName.focus();
			flag = false;
		}
		else if(!cmpName)
		{
			alert('<egui:intnl text="admin.ic.Aggregate Component type is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
			thisForm.aggComponentName.focus();
			flag = false;
			return;
		}
		else if(!checkblank(thisForm.compDispName))
		{
			alert("<egui:intnl text='admin.ic.Please enter Aggregate component type display name'/>");
			thisForm.compDispName.focus();
			flag=false;
			return;
		}
		else if(!checkblank(thisForm.imageDispName))
		{
			alert("<egui:intnl text='admin.ic.Please enter image display name'/>");
			thisForm.imageDispName.focus();
			flag=false;
			return;
		}
		else if(!compDispName)
		{
			alert('<egui:intnl text="admin.ic.Component display name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
			thisForm.compDispName.focus();
			flag = false;
			return;
		}
		else if(!imageDispName)
		{
			alert('<egui:intnl text="admin.ic.Image display name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
			thisForm.imageDispName.focus();
			flag = false;
			return;
		}
		if(flag)
		{
			if (isNetscape()) targetObj = thisForm.add;
			if (isIE()) targetObj = thisForm.add;
			targetObj.disabled = true;

			var thisForm = document.list;
			var builtURL = "aggAddComponentp.jsp?operation=<%=operation%>";

			builtURL+="&server="+encodeURI(thisForm.aggComponentName.value);
			builtURL+="&display="+thisForm.imageDispName.value;
			builtURL+="&comp_type_display_name="+thisForm.compDispName.value;

			if('<%=component_type%>'=='Generic_server')
			{
				with(document.list)
				{
					associated_normalComponentTypes="";
					for(var cnt=0;cnt<associated.options.length;cnt++)
					{
						if(associated_normalComponentTypes.length==0)
							associated_normalComponentTypes = associated.options[cnt].value;
						else
							associated_normalComponentTypes += "," + associated.options[cnt].value;
					}
					if(associated_normalComponentTypes =="" || associated_normalComponentTypes.length==0)
					{
						alert("<egui:intnl text='admin.ic.No component types associated'/>");
						targetObj.disabled = false;
						return;
					}
					builtURL+="&associatedServerTypes="+associated_normalComponentTypes+'&isAggGenType=true';
				}
			}
			else
			{
				builtURL+="&associatedServerTypes=<%=component_type%>";
			}
			if(document.getElementById("siteSupport"))
			{
				if(thisForm.siteSupport[0].checked)
				{
					builtURL+="&sitesupport=yes";
				}
				else
				{
					builtURL+="&sitesupport=no";
				}
			}
			window.location.href=builtURL;
		}
	}
	function checkForAggregate(str)
	{
		startingWord = str.substring(0,4);
		endingWord = str.substring(str.length-6);
		if(str=="Agg_ExAgg")
		{
			alert("Agg_ExAgg " + "<egui:intnl text='admin.ic.is not valid aggregate component type'/>");
			return false;
		}
		else if(startingWord!="Agg_")
		{
			alert("<egui:intnl text='admin.ic.Aggregate component type should start with'/> Agg_");
			return false;
		}
		else if(endingWord!="_ExAgg")
		{
			alert("<egui:intnl text='admin.ic.Aggregate component type should end with'/> _ExAgg");
			return false;
		}
		else if(str.indexOf("__")>-1)
		{
			alert("<egui:intnl text='admin.ic.Aggregate component type should not contain'/> _ (underscore) in consecutive locations");
			return false;
		}
		else
		{
			return true;
		}
	}
	function isNetscape()
	{
		appName= navigator.appName;
		appLongVer = navigator.appVersion;
		appVer = appLongVer.substring(0, 1);
		if((appName == "Netscape") && (appVer >= 4)) return true;
		return false;
	}
	function isIE()
	{
		appName= navigator.appName;
		appLongVer = navigator.appVersion;
		appVer = appLongVer.substring(0, 1);
		if((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
		return false;
	}
	function addToAssociated()
	{
		var thisForm = document.list;
		var layersSelected = "false";
		var count=0;
		var optcount=thisForm.dissociated.options.length;
		if(optcount==0)
		{
			alert('<egui:intnl text="admin.server.No Dissociated components selected"/>');
			return;
		}
		for(j=0;j<thisForm.dissociated.options.length;j++)
		{
			if(thisForm.elements['dissociated'].options[j].selected==true)
			{
				count++;
			}
		}
		if(count==0)
		{
			alert('<egui:intnl text="admin.server.No Dissociated components selected"/>');
			return;
		}
		for (i=0; ;i++)
		{
			if(thisForm.elements['dissociated'].options[i] == null)
				return;
			if(thisForm.elements['dissociated'].options[i].selected)
			{
				elem = document.createElement("option");
				elem.text = thisForm.elements['dissociated'].options[i].text;
				elem.value = thisForm.elements['dissociated'].options[i].value;
				j = 0;
				while (j < thisForm.elements['associated'].options.length &&
				elem.value > thisForm.elements['associated'].options[j].value)
					j++;
				thisForm.elements['associated'].options.add(elem,j);
				thisForm.elements['dissociated'].options[i] = null;
				i--;
			}
		}
	}
	function addToDissociated()
	{
		var thisForm = document.list;
		var layersSelected = "false";
		var count=0;
		var optcount=thisForm.associated.options.length;
		if(optcount==0)
		{
			alert('<egui:intnl text="admin.server.No Associated components selected"/>');
			return;
		}
		for(j=0;j<thisForm.associated.options.length;j++)
		{
			if(thisForm.elements['associated'].options[j].selected==true)
			{
				count++;
			}
		}
		if(count==0)
		{
			alert('<egui:intnl text="admin.server.No Associated components selected"/>');
			return;
		}
		for(i=0;;i++)
		{
			if(thisForm.elements['associated'].options[i] == null)
				return;
			if(thisForm.elements['associated'].options[i].selected)
			{
				elem = document.createElement("option");
				elem.text = thisForm.elements['associated'].options[i].text;
				elem.value = thisForm.elements['associated'].options[i].value;
				j = 0;
				while (j < thisForm.elements['dissociated'].options.length &&
				elem.value > thisForm.elements['dissociated'].options[j].value)
					j++;
				thisForm.elements['dissociated'].options.add(elem,j);
				thisForm.elements['associated'].options[i]=null;
				i--;
			}
		}
	}
	</script>
</head>
<body style="overflow:auto" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
	<form name="list" method="post" action="javascript:update();" style="margin:0px">
	<jsp:include page="<%=url%>"/>
		<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
			<tr>
				<td width="100%" id="eg_whitebg" align="center" height="100%" valign="middle">
					<table align="center" cellspacing="0" cellpadding="0" width="75%" border="0" style="table-layout:auto">
						<tr>
							<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							<td height="6" id="eg_subcontentbg" width="100%" colspan="6"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
							<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
						</tr>
						<tr>
							<td class="eg_subcontentbg" id="form_border">&nbsp;</td>
							<td align="left" width="250" class="eg_subcontentbg" nowrap height="20" id="form_border"><egui:intnl text="admin.threshold.Aggregate"/></td>
							<td width="5" class="eg_subcontentbg" id="form_border">:</td>
							<td class="eg_subcontentbg" id="form_border" style="padding-left:10px;">
								<table width="90%" cellspacing="0" cellpadding="0" border="0">
									<tr>
										<td id="eg_subcontentbg" class="eg_subcontent" width="20">
											<input type="radio" class="eg_input" name="componentfor" value="managedComponents" <%=componentfor.equalsIgnoreCase("managedComponents") ? "checked":""%> onclick="showTests('managedComponents')">
										</td>
										<td><egui:intnl text="admin.common.Managed components"/></td>
										<td id="eg_subcontentbg" class="eg_subcontent" width="20">
											<input type="radio"class="eg_input" name="componentfor" value="allComponents" <%=componentfor.equalsIgnoreCase("allComponents") ? "checked":""%> onclick="showTests('allComponents')">
										</td>
										<td><egui:intnl text="admin.common.All components"/></td>
									</tr>
								</table>
							</td>
							<td colspan="4" class="eg_subcontentbg" id="form_border">&nbsp;</td>
						</tr>
						<tr>
							<td class="eg_subcontentbg" id="<%=startBorder%>">&nbsp;</td>
							<td align="left" width="250" class="eg_subcontentbg" nowrap height="20" id="<%=startBorder%>"><egui:intnl text="admin.threshold.Component type to be aggregated"/></td>
							<td width="5" class="eg_subcontentbg" id="<%=startBorder%>">:</td>
							<td class="eg_subcontentbg" id="<%=startBorder%>" style="padding-left:10px;" width="73%">
								<select name="component_type" style='width:<%=browser?"285":"298"%>px;' onchange="javascript:reloadPage(this.value);">
									<option value="-1" selected="true"><egui:intnl text="admin.ic.Please select a component type"/></option>
<%
								for(int i=0;i<componentTypes.size();i++)
								{
									String cType = (String)componentTypes.get(i);
%>
									<option value='<%=cType%>' <%=(cType.equalsIgnoreCase(component_type))?"selected":""%>><%=_mapping.getComponentTypeDescription(cType)%></option>
<%
								}
%>
								</select>
							</td>
							<td colspan="4" class="eg_subcontentbg" id="<%=startBorder%>">&nbsp;</td>
						</tr>
<%
				if(!StringUtils.isNull(component_type) && !component_type.equals("-1"))
				{
%>
						<tr>
							<td class="eg_subcontentbg" id="form_border">&nbsp;</td>
							<td align="left" width="250" class="eg_subcontentbg" nowrap height="20" id="form_border"><egui:intnl text="admin.threshold.Aggregate component type"/></td>
							<td width="5" class="eg_subcontentbg" id="form_border">:</td>
							<td class="eg_subcontentbg" id="form_border" style="padding-left:10px;"><input type='text' maxlength="32" size="47" id="aggComponentName" name='aggComponentName' value='<%=aggComponentType%>' onkeydown="if (event.keyCode == 13) update();"></td>
							<td colspan="4" class="eg_subcontentbg" id="form_border">&nbsp;</td>
						</tr>
						<tr>
							<td class="eg_subcontentbg" id="form_border">&nbsp;</td>
							<td align="left" width="250" class="eg_subcontentbg" nowrap height="20" id="form_border"><egui:intnl text="admin.threshold.Aggregate component type display name"/></td>
							<td width="5" class="eg_subcontentbg" id="form_border">:</td>
							<td class="eg_subcontentbg" id="form_border" style="padding-left:10px;"><input type='text' maxlength="32" size="47" id="compDispName" name='compDispName' value="<%=displayDescription%>" onkeydown="if (event.keyCode == 13) update();"></td>
							<td colspan="4" class="eg_subcontentbg" id="form_border">&nbsp;</td>
						</tr>
						<tr>
							<td class="eg_subcontentbg" id="<%=siteBorder%>">&nbsp;</td>
							<td align="left" width="250" class="eg_subcontentbg" nowrap height="20" id="<%=siteBorder%>"><egui:intnl text="admin.threshold.Image display name"/>&nbsp;[Only 6 characters allowed]</td>
							<td width="5" class="eg_subcontentbg" id="<%=siteBorder%>">:</td>
							<td class="eg_subcontentbg" id="<%=siteBorder%>" style="padding-left:10px;"><input type='text' maxlength="6" size="47" id="imageDispName" name='imageDispName' value='<%=imageDisplayName%>' onkeydown="if (event.keyCode == 13) update();"></td>
							<td colspan="4" class="eg_subcontentbg" id="<%=siteBorder%>">&nbsp;</td>
						</tr>
<%
					if(component_type != null && component_type.equals("Generic_server"))
					{
%>
						<tr>
							<td class="eg_subcontentbg" id="<%=siteBorder%>" colspan="4">
								<table border="0" width="100%" cellspacing="0" cellpadding="0">
									<tr>
										<td width="45%">
											<table align="center" cellspacing="0" cellpadding="0" border="0" id="table_outer_border" style="padding:0px">
												<tr>
													<th id="eg_subheadbg" class="head_padding4" style="border-top-width:0px"><egui:intnl text="admin.server.Associated component types"/></th>
												</tr>
												<tr>
													<td id="eg_subcontentbg" align="center" valign="middle">
													<select name="associated" size="12" multiple width="300" style="width:300px;">
<%
														for(int cnt=0;cnt<associatedTypes.size();cnt++)
														{
															String currentServerType = (String)associatedTypes.get(cnt);
%>
															<option value="<%=currentServerType%>"><%=_mapping.getComponentTypeDescription(currentServerType)%></option>
<%
														}
%>
													</select>
													</td>
												</tr>
											</table>
										</td>
										<td id="eg_subcontentbg" width="10%">
											<table align="center" cellspacing="0" border="0" cellpadding="4">
												<tr>
													<td align="center" valign="middle" >
													<input type="button" value='<egui:intnl text="admin.server.Disassociate"/>&rsaquo;&rsaquo;' class="eg_lightbutton" onClick="javascript:addToDissociated();" name="unman" style="letter-spacing: 0px;width:100px">
													<br><br>
													<input type="button" value='&lsaquo;&lsaquo;<egui:intnl text="amin.server.Associate"/>' class="eg_lightbutton" onClick="javascript:addToAssociated();" name="man" style="letter-spacing: 0px;width:100px">
													</td>
												</tr>
											</table>
										</td>
										<td width="45%" id="eg_subcontentbg">
											<table align="center" cellspacing="0" border="0" id="table_outer_border" style="padding:0px">
												<tr>
													<th id="eg_subheadbg" class="head_padding4" style="border-top-width:0px"><egui:intnl text="admin.server.Disassociated component types"/></th>
												</tr>
												<tr>
													<td id="eg_subcontentbg" align="center" valign="middle">
													<select name="dissociated" size="12" multiple width="300" style="width:300px;">
<%
														for(int cnt=0;cnt<strServerTypes.length;cnt++)
														{
															String currentServerType = strServerTypes[cnt];
															if(currentServerType.startsWith("Agg_") || associatedTypes.contains(currentServerType))
																continue;
%>
															<option value="<%=currentServerType%>"><%=_mapping.getComponentTypeDescription(currentServerType)%></option>
<%
														}
%>
													</select>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
							<td colspan="4" class="eg_subcontentbg" id="form_border">&nbsp;</td>
						</tr>
<%
					}
					if(siteServer)
					{
%>
						<tr>
							<td class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
							<td align="left" width="250" class="eg_subcontentbg" nowrap height="20" id="form_spacing"><egui:intnl text="admin.threshold.Site support"/></td>
							<td width="5" class="eg_subcontentbg" id="form_spacing">:</td>
							<td class="eg_subcontentbg" id="form_spacing" style="padding-left:10px;">
								<table width="60%" cellspacing="0" cellpadding="0" border="0">
									<tr>
										<td id="eg_subcontentbg" class="eg_subcontent" width="20">
											<input type="radio" class="eg_input" id="siteSupport" name="siteSupport" value="true">
										</td>
										<td><egui:intnl text="admin.common.Yes"/></td>
										<td id="eg_subcontentbg" class="eg_subcontent" width="20">
											<input type="radio"class="eg_input" id="siteSupport" name="siteSupport" value="false">
										</td>
										<td><egui:intnl text="admin.common.No"/></td>
									</tr>
								</table>
							</td>
							<td colspan="4" class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
						</tr>
<%
					}
				}
%>
						<tr>
							<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
							<td id="eg_subcontentbg" width="100%" colspan="6" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
							<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td id="eg_blankspace" height="10">&nbsp;</td>
			</tr>
<%
		if(!StringUtils.isNull(component_type) && !component_type.equals("-1"))
		{
%>
			<tr>
				<td align="center"><input type="button" name="add" value='<egui:intnl text="admin.common.Add"/>' style="width:80px" class="eg_darkbutton" onClick="javascript:valform();"></td>
			</tr>
<%
		}
%>

		</table>
	</form>
</body>
</html>
<%
	session.setAttribute("adminLastAccessedURL","/final/admin/aggAddComponent.jsp?"+request.getQueryString());
%>
