<%
/**********************************************************************************
*	Name			:	EgDispZones.jsp
*	Purpose			:	Display Zones
*	Design Changes	:	Jaiwin
*	Last Modified	:	July-23-2007		N.Gokulanand	For zone map changes.
***********************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgGroupInfoAdmin" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="net.sf.json.*"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "java.sql.*"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	 JSONObject rootJson = new JSONObject();
	 JSONObject screenLabels = new JSONObject();
	 JSONObject zoneObj = new JSONObject();
	 JSONArray zoneArr = new JSONArray();

	//http://dev.sencha.com/deploy/ext-4.0.0/examples/window/gmap.html
	//http://technet.microsoft.com/en-us/library/ff686791(v=office.14).aspx
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String fromWizard = request.getParameter("fromWizard");
	if(com.egurkha.util.StringUtils.isNull(fromWizard))
	{
		fromWizard = "";
	}

	//user specific work - start
	String sql_query = "";
	ResultSet rs = null;
	String con_status = "";
	EgDbAdapterUI egDb;
	String session_userId = (String)session.getAttribute("sess_userid");

	EgUserRole userRole = _user.getUserRole();
	boolean hasAllComponentAccess = userRole.hasAllComponentAccess();
	ArrayList userSpecZoneList = new ArrayList();
	if(!hasAllComponentAccess)
	{
		egDb = EgDbAdapterTypeUI.getObject();
		con_status = egDb.setConnection();
		try
		{
			if(con_status.equals("CONNECTED"))
			{
				sql_query = "SELECT ZONE_NAME FROM USER_ZONE WHERE USER_ID='" + session_userId + "' ";
				rs = egDb.SelectExec(sql_query);
				while(rs.next())
				{
					String zone_Name = rs.getString("ZONE_NAME");
					userSpecZoneList.add(zone_Name);
				}
			}
		}
		catch(Exception e1)
		{
			out.println(e1.getMessage());
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		egDb.releaseConnection(false);
		EgDbAdapterTypeUI.releaseObject(egDb);
	}
	//user specific work - end

	EgGroupInfoAdmin groupinfo = new EgGroupInfoAdmin();
	String strVarArr[] = groupinfo.getZoneNames();
	if (strVarArr==null)
		strVarArr=new String[0];
	session.setAttribute("existing_names",strVarArr);
	
	String reqfrom = request.getParameter("reqfrom");
	reqfrom = (reqfrom == null ?"":reqfrom);

	IniFile topoIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");

	if(strVarArr.length > 0)
	{
		String thisZone="";
		
		List zoneList = new ArrayList();
		for(int i=0;i<strVarArr.length;i++)
		{
			thisZone = strVarArr[i];

			//user specific work - start
			if(!hasAllComponentAccess)
			{
				if(!userSpecZoneList.contains(thisZone))
				{
					continue;
				}
			}
			//user specific work - end
			zoneList.add(thisZone);
		}
		Collections.sort(zoneList,String.CASE_INSENSITIVE_ORDER);

		Hashtable masterZoneMap = groupinfo.getMasterZoneMap();
		int zoneListSize = zoneList.size();
		for(int i=0;i<zoneListSize;i++)
		{
			boolean border = (i+1)<zoneListSize;
			boolean spacing = (i+1)<zoneListSize;
			thisZone = (String)zoneList.get(i);
			String mainZone = (String)masterZoneMap.get(thisZone);
			boolean isDisabled = (!(mainZone==null) && !(mainZone.equals("")));
			String disabledStr = isDisabled?"DISABLED":"";
			String thisTdClass=border?"form_border":"padding4";
			zoneObj.put("Zonename",thisZone);

			// Get display image for this zone
			String imageValue = topoIni.getValue("ZONE_DISPLAY_IMAGE",thisZone);
			zoneObj.put("ImageName",imageValue);
			
			screenLabels.put("deleteConfirmMessage1",_mapping.getTextDescription("admin.zone.Are you sure you want to delete '"));
			screenLabels.put("deleteConfirmMessage2",_mapping.getTextDescription("admin.zone.' zone?"));
			String tmpStr = "<table class= \"tableWrap\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\" align=\"center\">";
			if(!isDisabled)
			{
				tmpStr=tmpStr+"<tr><td width='70' style='font-size:8pt;font-weight:normal;vertical-align:middle'>&nbsp;&nbsp;-&nbsp;</td></tr>";
			}
			if (isDisabled)
			{
				zoneObj.put("isDisabled","true");
				if(mainZone!=null&&!mainZone.equals(""))
				{
					if(mainZone.endsWith(","))
						mainZone = mainZone.substring(0,mainZone.length()-1);
				}
				StringTokenizer stz= new StringTokenizer(mainZone,",");
				int tokCount = stz.countTokens();
				tmpStr = tmpStr + "<tr><td class='f12-bold' style='vertical-align:top'>";
				int cc=0;
				
				while(stz.hasMoreTokens())
				{
					String zToken = stz.nextToken();

					if(!hasAllComponentAccess && !userSpecZoneList.contains(zToken))
					{
						tmpStr=tmpStr+"&nbsp;"+zToken;
					}
					else
					{
						tmpStr=tmpStr+"<a class='mouse' href=\"/final/admin/EgComponentZones.jsp?qctr=0&zone="+EgURLEncoder.encode(zToken,"UTF-8")+"&fromWizard="+fromWizard+"&mode=modify&returnToMain=true&mainUrl=EgComponentZones.jsp\"  style='text-decoration:none;vertical-align:middle'>&nbsp;"+zToken+"</a>";
					}
					if(cc!=(tokCount-1))
					{
						tmpStr = tmpStr +",";
					}
					cc++;
				}
			}
			else
			{
				zoneObj.put("isDisabled","false");
			}
			tmpStr = tmpStr + "</td></tr></table>";
			zoneObj.put("associations",tmpStr);
			zoneArr.add(zoneObj);
		}

		rootJson.put("NoExtFound","false");
	}
	else
	{
		screenLabels.put("noZone",_mapping.getTextDescription("admin.group.There are no zones available currently"));	
		rootJson.put("NoExtFound","true");
	}
	session.removeAttribute("zoneMessage");
%>

<%
	screenLabels.put("deleteforSelectedMessage",_mapping.getTextDescription("admin.group.Are you sure you want to delete the selected zone(s)?"));
	screenLabels.put("no zone selected",_mapping.getTextDescription("admin.group.No zone(s) have been selected"));
	
	// Rename labels
	screenLabels.put("sameName",_mapping.getTextDescription("admin.zone.Zone names are identical")+". "+_mapping.getTextDescription("admin.zone.Please use different name for the zone"));
	screenLabels.put("admin.common.space not allowed",_mapping.getTextDescription("admin.common.Space is not allowed in Zone name "));
	screenLabels.put("admin.common.special characters not allowed",_mapping.getTextDescription("admin.common.Special characters are not allowed"));
	screenLabels.put("admin.common.field value cannot be blank",_mapping.getTextDescription("admin.common.Field value cannot be blank."));
	screenLabels.put("admin.common.DBL not allowed",_mapping.getTextDescription("admin.common.Zone name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte."));

	rootJson.put("screenLabels",screenLabels);
	rootJson.put("gridValues",zoneArr);
	rootJson.put("isDouble",EgDbInfo.doubleByteEnabled);
	out.println(rootJson.toString());
%>



