<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String from = request.getParameter("from");
	String unlimited = "Unlimited";

	IniFile egMgrMisc = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
	String defaultLicenseVar [] = egMgrMisc.getVariables("DEFAULT_LICENSING_POLICY");
	ArrayList defaultLicenseVarList = defaultLicenseVar==null?new ArrayList():new ArrayList(Arrays.asList(defaultLicenseVar));

	String isMgrUsedBased = "false";
	boolean isMgrConcUserBased = EgInstallInfo.isconcurrentUserLicense;
	boolean isMgrNamedUserBased = EgInstallInfo.isnamedUserLicense;
	boolean isEndPointNames = EgInstallInfo.isEUCEndPointsLicense;
	boolean isO365Lic =  EgInstallInfo.isO365UsersLicense;
	if (isMgrConcUserBased || isMgrNamedUserBased)
	{
		isMgrUsedBased = "true";
	}
	
	String enableOneLinerCommand = egMgrMisc.getValue("MISC_ARGS","enableOneLinerCommand");
	if (StringUtils.isNull(enableOneLinerCommand))
	{
		enableOneLinerCommand = "true";
	}
	
	rootJson.put("enableOneLinerCmd",enableOneLinerCommand);
	rootJson.put("isMgrUsedBased",isMgrUsedBased);
	rootJson.put("isMgrConcUserBased",isMgrConcUserBased);
	rootJson.put("isMgrNamedUserBased",isMgrNamedUserBased);
	rootJson.put("isEndPointNames",isEndPointNames);
	rootJson.put("isO365Lic",isO365Lic);

	if (from != null && from.equalsIgnoreCase("getDefaultLicense"))
	{
		if (defaultLicenseVar != null && defaultLicenseVar.length > 0)
		{
			for (int i=0;i<defaultLicenseVar.length;i++)
			{
				String licenceStr = defaultLicenseVar[i];
				if (licenceStr.equals("DALPD"))
				{
					continue;
				}
				String licenseCount = egMgrMisc.getValue("DEFAULT_LICENSING_POLICY",licenceStr);
				licenseCount = licenseCount.equals("-1") ? unlimited : licenseCount;
				rootJson.put(licenceStr,licenseCount);
			}
		}

		IniFile eglsIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ls_portal.ini");
		String selfRegistration = "true";
		String hideRegistrationTab = eglsIniFile.getValue("LS_TRIAL_SETTINGS","hideRegistrationTab");
		if (hideRegistrationTab != null && (hideRegistrationTab.equalsIgnoreCase("true") || hideRegistrationTab.equalsIgnoreCase("yes")))
		{
			selfRegistration = "false";
		}
		rootJson.put("selfRegistration",selfRegistration);
		String eGCloudUserSubscriptionPeriod = eglsIniFile.getValue("LS_TRIAL_SETTINGS","eGCloudUserSubscriptionPeriod");
		if (eGCloudUserSubscriptionPeriod != null && eGCloudUserSubscriptionPeriod.trim().length() > 0)
		{
			rootJson.put("eGCloudUserSubscriptionPeriod",eGCloudUserSubscriptionPeriod);
		}
	}
	else if (from != null && from.equalsIgnoreCase("updateDefaultLicense"))
	{
		/* code for auditlog starts */
		AuditLogThread auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","User License Management");
		auditLogThread.setValue("Activity","Default License");
		/* code for auditlog ends */
		boolean isAuditChange = false;

		IniFile egMgrMiscWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_mgrmisc.ini");

		String TotalMonitors = request.getParameter("TotalMonitors");
		String BasicMonitors = request.getParameter("BasicMonitors");
		String NetworkDevices = request.getParameter("NetworkDevices");
		String MonitorUsers = request.getParameter("MonitorUsers");
		
		if(TotalMonitors.equalsIgnoreCase("unlimited"))
		{
			TotalMonitors = "-1";
		}
		if(BasicMonitors.equalsIgnoreCase("unlimited"))
		{
			BasicMonitors = "-1";
		}
		if(NetworkDevices.equalsIgnoreCase("unlimited"))
		{
			NetworkDevices = "-1";
		}
		if(MonitorUsers.equalsIgnoreCase("unlimited"))
		{
			MonitorUsers = "-1";
		}
		String preTotalMonitors = egMgrMiscWr.getValue("DEFAULT_LICENSING_POLICY","TotalMonitors");
		String preBasicMonitors = egMgrMiscWr.getValue("DEFAULT_LICENSING_POLICY","BasicMonitors");
		String preNetworkDevices = egMgrMiscWr.getValue("DEFAULT_LICENSING_POLICY","NetworkDevices");
		String preMonitorUsers = egMgrMiscWr.getValue("DEFAULT_LICENSING_POLICY","MonitorUsers");
		preTotalMonitors = preTotalMonitors !=null ? preTotalMonitors :"-1";
		preBasicMonitors = preBasicMonitors !=null ? preBasicMonitors :"-1";
		preNetworkDevices = preNetworkDevices !=null ? preNetworkDevices :"-1";
		preMonitorUsers = preMonitorUsers !=null ? preMonitorUsers :"-1";

		egMgrMiscWr.setValue("DEFAULT_LICENSING_POLICY","TotalMonitors",TotalMonitors);
		egMgrMiscWr.setValue("DEFAULT_LICENSING_POLICY","BasicMonitors",BasicMonitors);
		egMgrMiscWr.setValue("DEFAULT_LICENSING_POLICY","NetworkDevices",NetworkDevices);
		egMgrMiscWr.setValue("DEFAULT_LICENSING_POLICY","MonitorUsers",MonitorUsers);

		auditLogThread.setPreviousValue("01~~Total Monitors",checkUnlimitCount(preTotalMonitors));
		auditLogThread.setCurrentValue("01~~Total Monitors",checkUnlimitCount(TotalMonitors));
		auditLogThread.setPreviousValue("02~~Basic Monitors",checkUnlimitCount(preBasicMonitors));
		auditLogThread.setCurrentValue("02~~Basic Monitors",checkUnlimitCount(BasicMonitors));
		auditLogThread.setPreviousValue("03~~Network Devices",checkUnlimitCount(preNetworkDevices));
		auditLogThread.setCurrentValue("03~~Network Devices",checkUnlimitCount(NetworkDevices));
		auditLogThread.setPreviousValue("05~~Users Count",checkUnlimitCount(preMonitorUsers));
		auditLogThread.setCurrentValue("05~~Users Count",checkUnlimitCount(MonitorUsers));

		if ((TotalMonitors != null && !preTotalMonitors.equals(TotalMonitors)) ||
			(BasicMonitors != null && !preBasicMonitors.equals(BasicMonitors)) ||
			(NetworkDevices != null && !preNetworkDevices.equals(NetworkDevices)) ||
			(MonitorUsers != null && !preMonitorUsers.equals(MonitorUsers)))
		{
			isAuditChange = true;
		}

		if (isMgrUsedBased.equalsIgnoreCase("true"))
		{
			String UserBased = request.getParameter("UserBased");
			if(UserBased.equalsIgnoreCase("unlimited"))
			{
				UserBased = "-1";
			}
			String preUserBased = egMgrMiscWr.getValue("DEFAULT_LICENSING_POLICY","UserBased");
			preUserBased = preUserBased !=null ? preUserBased :"-1";
			egMgrMiscWr.setValue("DEFAULT_LICENSING_POLICY","UserBased",UserBased);

			if(isMgrConcUserBased)
			{
				auditLogThread.setPreviousValue("04~~Concurrent Users",checkUnlimitCount(preUserBased));
				auditLogThread.setCurrentValue("04~~Concurrent Users",checkUnlimitCount(UserBased));
			}
			else if(isMgrNamedUserBased)
			{
				auditLogThread.setPreviousValue("04~~Named Users",checkUnlimitCount(preUserBased));
				auditLogThread.setCurrentValue("04~~Named Users",checkUnlimitCount(UserBased));
			}

			if (UserBased != null && !preUserBased.equals(UserBased))
			{
				isAuditChange = true;
			}
		}
		if(isEndPointNames)
		{
			String endpointcnt = request.getParameter("Endpointname");
			if(endpointcnt.equalsIgnoreCase("unlimited"))
			{
				endpointcnt = "-1";
			}
			String preendpointcnt = egMgrMiscWr.getValue("DEFAULT_LICENSING_POLICY","EndPointsCount");
			preendpointcnt = preendpointcnt !=null ? preendpointcnt :"-1";
			egMgrMiscWr.setValue("DEFAULT_LICENSING_POLICY","EndPointsCount",endpointcnt);

			auditLogThread.setPreviousValue("05~~EndPointName Count",checkUnlimitCount(preendpointcnt));
			auditLogThread.setCurrentValue("05~~EndPointName Count",checkUnlimitCount(endpointcnt));

			if (endpointcnt != null && !preendpointcnt.equals(endpointcnt))
			{
				isAuditChange = true;
			}
		}
		if(isO365Lic)
		{
			String o365cnt = request.getParameter("o365UserCnt");
			if(o365cnt.equalsIgnoreCase("unlimited"))
			{
				o365cnt = "-1";
			}
			String preo365tcnt = egMgrMiscWr.getValue("DEFAULT_LICENSING_POLICY","O365UsersCount");
			preo365tcnt = preo365tcnt !=null ? preo365tcnt :"-1";
			egMgrMiscWr.setValue("DEFAULT_LICENSING_POLICY","O365UsersCount",o365cnt);

			auditLogThread.setPreviousValue("06~~O365Users Count",checkUnlimitCount(preo365tcnt));
			auditLogThread.setCurrentValue("06~~O365Users Count",checkUnlimitCount(o365cnt));

			if (o365cnt != null && !preo365tcnt.equals(o365cnt))
			{
				isAuditChange = true;
			}

		}
		if(enableOneLinerCommand.equalsIgnoreCase("true"))
		{
			String dalph = request.getParameter("LmtPerHour");
			System.out.println("dalph "+dalph);
			String dalpd = "";
			
			String preDalph = egMgrMiscWr.getValue("DEFAULT_LICENSING_POLICY","DALPH");
			preDalph = preDalph !=null ? preDalph :"5";

			try
			{
				int dalphVal = Integer.parseInt(dalph);
				dalpd = String.valueOf(dalphVal * 24);
			}
			catch(Exception ex)
			{
			}
			
			egMgrMiscWr.setValue("DEFAULT_LICENSING_POLICY","DALPH",dalph);
			egMgrMiscWr.setValue("DEFAULT_LICENSING_POLICY","DALPD",dalpd);

			auditLogThread.setPreviousValue("07~~Download Agent Limit Per Hour(s)",preDalph);
			auditLogThread.setCurrentValue("07~~Download Agent Limit Per Hour(s)",dalph);

			if (dalph != null && !preDalph.equals(dalph))
			{
				isAuditChange = true;
			}

		}
		
		egMgrMiscWr.saveFile();
		EgConfigFilesSync.releaseInstance(egMgrMiscWr);

		IniFile egPortalIniFileWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_ls_portal.ini",true);
		String expiryDate = request.getParameter("expiryDate");
		String preeGCloudUserSubscriptionPeriod = egPortalIniFileWr.getValue("LS_TRIAL_SETTINGS","eGCloudUserSubscriptionPeriod");
		if (expiryDate != null && expiryDate.trim().length() > 0)
		{
			egPortalIniFileWr.setValue("LS_TRIAL_SETTINGS","eGCloudUserSubscriptionPeriod",expiryDate);
			if (!preeGCloudUserSubscriptionPeriod.equalsIgnoreCase(expiryDate))
			{
				isAuditChange = true;
				String displayName = "05~~Expiry date of the self-registered users";
				auditLogThread.setPreviousValue(displayName,preeGCloudUserSubscriptionPeriod);
				auditLogThread.setCurrentValue(displayName,expiryDate);
			}
		}
		egPortalIniFileWr.saveFile();
		EgConfigFilesSync.releaseInstance(egPortalIniFileWr);

		if (isAuditChange)
		{
			auditLogThread.setValue("Description","Default license limit has been updated");
			auditLogThread.sendItToDB();
		}
		rootJson.put("success",true);
	}

	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgUserLicense.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgUserLicense.jsp");
	}
	out.println(rootJson.toString());
%>

<%!
	private String checkUnlimitCount(String count)
	{
		if (count != null && count.equals("-1"))
		{
			return "Unlimited";
		}
		return count;
	}
%>



