<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "egurkha.TransactionBean"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
/*
*	Processing page for Trouble Ticket Integration(CLI) node in Manager Settings tree.
*	ini File : eg_services.ini, subject : EXEC_TTMANAGER
*/
%>

<%
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();

	TransactionBean transBean = new TransactionBean();

	transBean.createSyncFile("eg_services.ini","Write");

	String exec_ttmanager = "EXEC_TTMANAGER";

	String[] keys = {"EnableExecForTT","Command","DateFormat","CommandLength","ProbDescLength"};

	ArrayList keysList = new ArrayList(java.util.Arrays.asList(keys));

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Manager Settings");
	auditLogThread.setValue("Activity","Configure");
	auditLogThread.setValue("Description","Manager settings have been configured successfully");


	int count = 0;
	boolean setAuditLog = false;

	String enableExecForTT = request.getParameter("EnableExecForTT");
	boolean isCLIEnabled = false;
	if(enableExecForTT != null && enableExecForTT.equalsIgnoreCase("yes")){
		isCLIEnabled = true;
	}
	
	if (enableExecForTT != null && enableExecForTT.length() > 0)
	{
		
		transBean.setValue(exec_ttmanager, "EnableExecForTT", enableExecForTT);
	}

	
	if (isCLIEnabled)
	{
		Enumeration enumeration = request.getParameterNames();
		while(enumeration.hasMoreElements())
		{
			String variable = ((String) enumeration.nextElement()).toString();
			String value = request.getParameter(variable);
			if(variable.startsWith("$"))
			{
				setAuditLog = false;
				if(value != null && value.length() > 0 && value.indexOf("$") > -1)
				{
					String displayName = value.substring(0,value.indexOf("$"));
					String displayValue = value.substring(value.indexOf("$")+1);
					String currentValue = "";
					if(displayValue != null && displayValue.length() > 0)
					{
						if(variable.equals("$_EnableExecForTT"))
						{
							currentValue = request.getParameter("EnableExecForTT");
							if(!displayValue.equalsIgnoreCase(currentValue))
							{
								setAuditLog = true;
								count++;
							}
						}
						else if(variable.equals("$_Command"))
						{
							currentValue = request.getParameter("Command");
							if(!displayValue.equalsIgnoreCase(currentValue))
							{
								setAuditLog = true;
								count++;
							}
						}
						else if(variable.equals("$_Command2"))
						{
							currentValue = request.getParameter("Command2");
							currentValue = StringUtils.decodeSecurityChar(currentValue);
							if(!displayValue.equalsIgnoreCase(currentValue))
							{
								setAuditLog = true;
								count++;
							}
						}
						else if(variable.equals("$_DateFormat"))
						{
							currentValue = request.getParameter("DateFormat");
							displayValue = displayValue.substring(0,displayValue.indexOf("HH")).trim();
							if(!displayValue.equalsIgnoreCase(currentValue))
							{
								setAuditLog = true;
								count++;
							}
						}
						else if(variable.equals("$_CommandLength"))
						{
							currentValue = request.getParameter("CommandLength");
							currentValue = StringUtils.decodeSecurityChar(currentValue);
							if(!displayValue.equalsIgnoreCase(currentValue))
							{
								setAuditLog = true;
								count++;
							}
						}
						else if(variable.equals("$_ProbDescLength"))
						{
							currentValue = request.getParameter("ProbDescLength");
							currentValue = StringUtils.decodeSecurityChar(currentValue);
							if(!displayValue.equalsIgnoreCase(currentValue))
							{
								setAuditLog = true;
								count++;
							}
						}
						if(setAuditLog)
						{
							auditLogThread.setPreviousValue(displayName,displayValue);
							auditLogThread.setCurrentValue(displayName,currentValue);
						}
					}
				}
			}
			if(variable.startsWith("$") || !keysList.contains(variable))
				continue;
			if(variable.equals("Command"))
			{
				String command2 = request.getParameter("Command2");
				value = command2 +"#"+ value;
			}
			if(variable != null && variable.equals("DateFormat")) {
				if (value != null ){
					value += " HH:mm:ss"; 
				}
			}
			value=StringUtils.decodeSecurityChar(value);
			transBean.setValue(exec_ttmanager,variable,value);
		}
	}
	if(count > 0)
	{
		auditLogThread.sendItToDB();
	}
	transBean.saveFileAndReleaseInstance();

	rootJson.put("success","true");
	out.println(rootJson.toString());
%>