<%
/*
 *	Name            :	EgconfigudserverpJson.jsp
 *	Purpose         :	Processing page for EgConfigUDServer.jsp
 *	CreationDate    :   01/10/2001
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>

<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	egurkha.ServiceBean serviceBean = new egurkha.ServiceBean();
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	auditLogThread.setValue("Activity","Component Layer Configuration");
	/* code for auditlog ends */
	String server = request.getParameter("server");
	String layerList = request.getParameter("fassociate");
	String oldLayerList = request.getParameter("layerlist");
	LayerBean layerBean = new LayerBean(true);

	//skm
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");

	Vector vec_aggtypes = aggregateInfo.getAggregateTypes();
	boolean isAggregateComponent = false;
	boolean isLayerContainsInternalTest = false;

	if(vec_aggtypes.contains(server))
	{
		isAggregateComponent = true;
	}

	if(isAggregateComponent && isLayerContainsInternalTest)
	{
		rootJSON.put("AlertType","Error");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Configure layers for component"));
		String msg = _mapping.getTextDescription("admin.error.One of the associated layer contains internal test(s)")+". <br>";
		msg += _mapping.getTextDescription("admin.error.Please associate another layer")+".";
		rootJSON.put("AlertMsg",msg);
		
		/* code for auditlog starts */
		auditLogThread.setCurrentValue("Associated layer(s)","$layer$:"+layerList);
		auditLogThread.setValue("Description","Layer configuration has been failed for component type"+" "+"$ctype$:"+server+" as one of the associated layers contains internal test(s)");
		auditLogThread.sendItToDB();
		/* code for auditlog endss */
		out.println(rootJSON);
		//return;
	}
	else //skm
	{
		if(isListValid(layerList))
		{
			//LayerBean layerBean = new LayerBean(true);
			if(layerBean.checkLayersForServer(server, layerList)) //ini related
			{
				layerBean = null;
				ServerBean serverBean = new ServerBean(true);
				serverBean.removeServerFromTables(server); //ini related
				serverBean = null;

				layerBean = new LayerBean(true);
				layerBean.updateLayersForServer(server, layerList); //ini related
				layerBean.updateTestsForServer(server, layerList, oldLayerList);//inirelated
				//DbBean dbBean = new DbBean(); //clustering //clustering
				UpdateAndTransmitICInfo updateICInfo = new UpdateAndTransmitICInfo();
				if(updateICInfo.updateLayersForServer(server, layerList))     //dbBean.getConnection()
				{
					/* code for auditlog starts */
						boolean test = false;
						ArrayList oldLayers = new ArrayList();
						ArrayList newLayers = new ArrayList();
						if(oldLayerList != null && !oldLayerList.equalsIgnoreCase("null") && oldLayerList.trim().length()>0)
						{
							StringTokenizer tokens = new StringTokenizer(oldLayerList,",");
							while(tokens.hasMoreTokens()){
								String layerTemp = tokens.nextToken();
								oldLayers.add(layerTemp);
								//auditLogThread.setPreviousValue("Associated layer(s)",layerTemp);
							}
							test = true;
						}
						if(layerList != null && !layerList.equalsIgnoreCase("null") && layerList.trim().length()>0)
						{
							StringTokenizer tokens = new StringTokenizer(layerList,",");
							while(tokens.hasMoreTokens()){
								String layerTemp = tokens.nextToken();
								newLayers.add(layerTemp);
								//auditLogThread.setCurrentValue("Associated layer(s)",layerTemp);
							}
							test = true;
						}
						if( !oldLayers.containsAll(newLayers) 
								|| !newLayers.containsAll(oldLayers) )
						{
							ArrayList alprevTemp = new ArrayList(oldLayers);
							ArrayList alCurrentTemp = new ArrayList(newLayers);
							alprevTemp.removeAll(alCurrentTemp);
							for(int i=0; i<alprevTemp.size(); i++)
							{
								String layerTmp = (String)alprevTemp.get(i);
								auditLogThread.setCurrentValue("Disassociated layer(s)","$layer$:"+layerTmp);
							}
							alprevTemp = new ArrayList(oldLayers);//reset to old condition
							alCurrentTemp.removeAll(alprevTemp);
							for(int i=0; i<alCurrentTemp.size(); i++)
							{
								String layerTmp = (String)alCurrentTemp.get(i);
								auditLogThread.setCurrentValue("Associated layer(s)","$layer$:"+layerTmp);
							}
						}
						auditLogThread.setValue("Description","Layers have been configured for component type"+" "+"$ctype$:"+server);
						auditLogThread.sendItToDB();
					/* code for auditlog endss */

					oldLayers.removeAll(newLayers);
					if(oldLayers.size() > 0)
					{
						DeleteMailFilterElements delMailFilterElements = new DeleteMailFilterElements();
						delMailFilterElements.deleteLayersForServerType(server,oldLayers);
					}
					
					//dbBean.updateLayersForServer(server, layerList);
					//dbBean.releaseConnection();
					//serviceBean.stopDiscovery();
					//serviceBean.startDiscovery("1");
					//response.sendRedirect("EgConfigUDServer.jsp?server=" + server);
					//String ur = "EgConfigUDServer.jsp?server=" + server + "&requestFrom=ProcessPage";
					String ur = "EgConfigUDServer.jsp?server=" + server;

					String tempScrollPosition_back = request.getParameter("tempScrollPosition_back");
					if (tempScrollPosition_back == null)
					{
						tempScrollPosition_back = "";
					}

					rootJSON.put("AlertType","Result");
					rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Integration Console - Component"));
					rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Layers have been configured successfully"));
					out.println(rootJSON);
					//return;
				}
				else
				{
					rootJSON.put("AlertType","Error");
					rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Configure layers for component"));
					String msg = _mapping.getTextDescription("admin.error.DB connection failed")+"<br>"+_mapping.getTextDescription("admin.error.Please check if the DB is up and try again");
					rootJSON.put("AlertMsg",msg);
					
					/* code for auditlog starts */
					auditLogThread.setValue("Description","DB connection had been failed"+". "+"Layer configuration failed for component type"+" "+"$ctype$:"+server);
					auditLogThread.sendItToDB();
					/* code for auditlog ends */

					out.println(rootJSON);
					//return;
				}
			}
			else
			{
				rootJSON.put("AlertType","Error");
				rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Configure layers for component"));
				String msg = _mapping.getTextDescription("admin.error.Layers specific to Oracle Server cannot be associated with other component types")+".<br>";
				msg+=_mapping.getTextDescription("admin.error.Please remove Oracle layers associated with this component type and try again")+".";
				rootJSON.put("AlertMsg",msg);

				/* code for auditlog starts */
				auditLogThread.setValue("Description","Layers specific to Oracle server cannot be associated with component type"+" " +"$ctype$:"+server);
				auditLogThread.sendItToDB();
				/* code for auditlog ends */

				out.println(rootJSON);
				//return;
			}
		}
		else
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Configure layers for component"));
			String msg = "";
			String auditMsg = "";
			ArrayList layersList = com.egurkha.util.StringUtils.egTokenizer(layerList, ",");
			if (layersList == null || layersList.equals(""))
			{
				msg = _mapping.getTextDescription("admin.error.Please associate atleast one layer to the component type")+".";
				auditMsg = "Associate atleast one layer to the component type";
			}
			else if(layersList.contains("HOST") && layersList.contains("HARDWARE"))
			{
				msg =_mapping.getTextDescription("admin.error.Hardware layer, if used, should be the lowest in hierarchy")+".<br>";
				msg+=_mapping.getTextDescription("admin.error.Place the Operating System layer on top of the Hardware layer, if used")+".";
				auditMsg = "Hardware layer should be the lowest in hierarchy and place the Operating System layer on top of the Hardware layer for component type";
			}
			else if(layersList.contains("HOST"))
			{
				msg =_mapping.getTextDescription("admin.error.Operating System layer, if used, should be the lowest in hierarchy")+".<br>";
				msg+=_mapping.getTextDescription("admin.error.Please change Operating System as the lowest layer and try again")+".";
				auditMsg = "Operating System layer should be the lowest in hierarchy for component type";
			}
			else if(layersList.contains("HARDWARE"))
			{
				msg =_mapping.getTextDescription("admin.error.Hardware layer, if used, should be the lowest in hierarchy")+".<br>";
				msg+=_mapping.getTextDescription("admin.error.Please change Hardware as the lowest layer and try again")+".";
				auditMsg = "Hardware layer should be the lowest in hierarchy for component type";
			}
			rootJSON.put("AlertMsg",msg);

			/* code for auditlog starts */
			auditLogThread.setValue("Description", auditMsg +" " + "$ctype$:"+server);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */

			out.println(rootJSON);
			//return;
		}
	}
%>

<%!
	private boolean isListValid(String layerList)
	{
		layerList = layerList.trim();
		if (layerList.equals(""))
		{
			return false;
		}
		int layerLen = layerList.length()-1;
		if(layerLen == layerList.lastIndexOf(","))
		{
			layerList = layerList.substring(0,layerLen);
		}
		ArrayList tokensList = com.egurkha.util.StringUtils.egTokenizer(layerList, ",", true, true, true);
		int hostPos = tokensList.indexOf("HOST");
		int hwPos = tokensList.indexOf("HARDWARE");
		int size = tokensList.size();

		if(hostPos == -1 && hwPos == -1)//No OS,HW layer
		{
			return true;
		}
		else if(hostPos != -1 && hwPos != -1)//OS,HW both exist
		{
			if(hostPos == (size-2) && hwPos == (size-1))
			{
				return true;
			}
		}
		else if(hwPos == (size-1) || hostPos == (size-1))//Either OS or HW exists
		{
			return true;
		}
		return false;
	}
%>



