<%
/*
 *		Name			:	EgConfigUDTest.jsp
 *		Purpose			:	IC - Component - Config performance tests
 *		CreationDate	:	01/10/2001
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>


<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
	
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	JSONObject hiddens = new JSONObject();
	boolean isCMEnabled = EgInstallInfo.isConfigSupported;
	//ensure whether the user is configuration management enabled
	if (_user != null && isCMEnabled)
	{
		EgUserRole userRole = _user.getUserRole();
		isCMEnabled = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}

	String server = request.getParameter("server");
	TestBean testBean = new TestBean(true);
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	ArrayList t_tests = testBean.getTestsForServer(server);
	ArrayList t_allTests = testBean.getAllowedTests(server);
	ArrayList aggregateTest= testBean.getAggregationAllTest();
	ArrayList desktopTest = testBean.getDeskTopAgentTests();
	Vector aggTypes = aggregateInfo.getAggregateTypes();
	ArrayList tests=new ArrayList();
	ArrayList allTests=new ArrayList();
	String tStr="";

	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	if(t_tests!=null && t_tests.size()>0)
	{
		if(!isCMEnabled)
		{
			for(int i=0;i<t_tests.size();i++)
			{
				tStr=(String)t_tests.get(i);
				if(!(tStr.endsWith("_cf")))
					tests.add(tStr);
			}
		}
		else
			tests=t_tests;
	}

	if(t_allTests!=null && t_allTests.size()>0)
	{
		if(!isCMEnabled)
		{
			for(int i=0;i<t_allTests.size();i++)
			{
				tStr=(String)t_allTests.get(i);
				if(!(tStr.endsWith("_cf")))
					allTests.add(tStr);
			}
		}
		else
			allTests=t_allTests;
	}

	//James Thomas
	String fileName = EgInstallInfo.getInstallDir() + "/manager/config/eg_specs.ini";
	IniFile ini_egSpecs= new IniFile(fileName);
	String str_subject = "TEST_MAPPING";
	String strValue = ini_egSpecs.getValue(str_subject, server);
	//James Thomas

	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	allTests = specsInfo.getLicensedTests(allTests);
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	String[] compTypes = discInfo.getServerTypes();
	if (!EgInstallInfo.isO365UsersLicense)
	{
		EgMsUsersInfo msUsers = new EgMsUsersInfo();
		ArrayList msTests = msUsers.getMSTestsForAgentGenerator();
		allTests.removeAll(msTests);
		tests.removeAll(msTests);
	}
	
	rootJSON.put("serverDispValue",_mapping.getComponentTypeDescription(server));
	String testlist = "";
	ArrayList testsList = new ArrayList();
	for (int i=0;i<tests.size();i++)
	{
		String test = (String) tests.get(i);
		if(desktopTest!=null && desktopTest.contains(test))
			continue;
		testlist += test + ",";
		if (test!=null && (EgInstallInfo.isConfigTest(test))) continue;

		testsList.add(test);
	}
	testsList = sorter.getSortedTestList(testsList);
	JSONArray assoList = new JSONArray();
	JSONArray cloneAssoTestsJSON = new JSONArray();
	JSONObject obj = new JSONObject();
	for(int j=0;j<testsList.size();j++)
	{
		EgName nameObj = (EgName)testsList.get(j);
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();
		obj = new JSONObject();
		obj.put("valueField",tmpVal);
		obj.put("displayField",tmpDis);
		assoList.add(obj);
		cloneAssoTestsJSON.add(obj);
	}	
	for (int a=0; a<assoList.size(); a++)
	{
		JSONObject nameObj1 = (JSONObject)assoList.get(a);
		String tmpVal1 = (String)nameObj1.get("valueField");
		String tmpDis1 = (String)nameObj1.get("displayField");
		for (int b=0; b<cloneAssoTestsJSON.size(); b++)
		{
			JSONObject nameObj2 = (JSONObject)cloneAssoTestsJSON.get(b);
			String tmpVal2 = (String)nameObj2.get("valueField");
			String tmpDis2 = (String)nameObj2.get("displayField");
			if (tmpVal1.equalsIgnoreCase(tmpVal2))
			{
				continue;
			}
			if (tmpDis1.equalsIgnoreCase(tmpDis2))
			{
				String compTypeStr = "";
				ArrayList compTypeArr = new ArrayList();
				for(int k =0; k<compTypes.length; k++)
				{
					String compType = compTypes[k];
					boolean flag = specsInfo.isTestRelevantForServer(compType,tmpVal2,true);
					if(flag)
					{
						compTypeArr.add(_mapping.getComponentTypeDescription(compType));
					}
				}
				Collections.sort(compTypeArr,String.CASE_INSENSITIVE_ORDER);
				for(int v=0; v<compTypeArr.size(); v++)
				{
					String compTypeVal = (String)compTypeArr.get(v);
					compTypeStr += compTypeVal+", ";
				}
				if(compTypeStr.endsWith(", "))
				{
					compTypeStr = compTypeStr.substring(0,compTypeStr.length()-2);
				}
				if(compTypeStr!= "" && compTypeStr!=null)
					tmpDis2 = tmpDis2+" ("+compTypeStr+")";
				JSONObject nameObj3 = new JSONObject();
				nameObj3.put("valueField",tmpVal2);
				nameObj3.put("displayField",tmpDis2);
				cloneAssoTestsJSON.remove(b);
				cloneAssoTestsJSON.add(b,nameObj3);
			}
		}
	}		
	rootJSON.put("assoTests",cloneAssoTestsJSON);
	if(testlist.length() > 0)
		testlist = testlist.substring(0, testlist.length()-1);
	hiddens.put("testlist",testlist);

	Collections.sort(allTests);
	ArrayList testsList2 = new ArrayList();
	for(int i=0; i<allTests.size(); i++)
	{
		String test = (String) allTests.get(i);
		if(tests.contains(test))
			continue;
		else if(aggTypes!=null && aggTypes.contains(server))
		{
			if(aggregateTest!=null && !aggregateTest.contains(test))
				continue;
		}
		else if(aggregateTest!=null && aggregateTest.contains(test))
			continue;
		else if(desktopTest!=null && desktopTest.contains(test))
			continue;
		if(test.endsWith("_ag") || test.endsWith("_agx"))
			continue;

		testsList2.add(test);
	}
	testsList2 = sorter.getSortedTestList(testsList2);
	JSONArray disoList = new JSONArray();
	JSONArray cloneDisoTestsJSON = new JSONArray();
	for (int j=0;j<testsList2.size();j++)
	{
		EgName nameObj = (EgName)testsList2.get(j);
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();
		obj = new JSONObject();
		obj.put("valueField",tmpVal);
		obj.put("displayField",tmpDis);
		disoList.add(obj);
		cloneDisoTestsJSON.add(obj);
	}	
	for (int a=0; a<disoList.size(); a++)
	{
		JSONObject nameObj1 = (JSONObject)disoList.get(a);
		String tmpVal1 = (String)nameObj1.get("valueField");
		String tmpDis1 = (String)nameObj1.get("displayField");
		for (int b=0; b<cloneDisoTestsJSON.size(); b++)
		{
			JSONObject nameObj2 = (JSONObject)cloneDisoTestsJSON.get(b);
			String tmpVal2 = (String)nameObj2.get("valueField");
			String tmpDis2 = (String)nameObj2.get("displayField");
			if (tmpVal1.equalsIgnoreCase(tmpVal2))
			{
				continue;
			}
			if (tmpDis1.equalsIgnoreCase(tmpDis2))
			{
				String compTypeStr = "";
				ArrayList compTypeArr = new ArrayList();
				for(int k =0; k<compTypes.length; k++)
				{
					String compType = compTypes[k];
					boolean flag = specsInfo.isTestRelevantForServer(compType,tmpVal2,true);
					if(flag)
					{
						compTypeArr.add(_mapping.getComponentTypeDescription(compType));
					}
				}
				Collections.sort(compTypeArr,String.CASE_INSENSITIVE_ORDER);
				for(int v=0; v<compTypeArr.size(); v++)
				{
					String compTypeVal = (String)compTypeArr.get(v);
					compTypeStr += compTypeVal+", ";
				}
				if(compTypeStr.endsWith(", "))
				{
					compTypeStr = compTypeStr.substring(0,compTypeStr.length()-2);
				}
				if(compTypeStr!= "" && compTypeStr!=null)
					tmpDis2 = tmpDis2+" ("+compTypeStr+")";
				JSONObject nameObj3 = new JSONObject();
				nameObj3.put("valueField",tmpVal2);
				nameObj3.put("displayField",tmpDis2);
				cloneDisoTestsJSON.remove(b);
				cloneDisoTestsJSON.add(b,nameObj3);
			}
		}
	}	
	rootJSON.put("disoTests",cloneDisoTestsJSON);
	hiddens.put("server",server);//fassociate,fdissociate
	hiddens.put("strValue",strValue);
	rootJSON.put("hiddens",hiddens);
	out.println(rootJSON);
%>



