<%
/************************************************************************************************************  
Name        :        EgUserRoles.jsp
*   Purpose     :        This page enables to create and modify user roles
*   Version     :        ASP-0.1
*   CreationDate:        20/12/2004
* Create a role with different access 
*Access  modifications are  allowed
* Selecting atleast one access in admin permits to choose complete list of component
*com.egurkha.EgUserRole class provides complete control over the User_role table
 *	Design Changes	:	Jaiwin
*************************************************************************************************************
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@  page import="com.egurkha.EgUserRole"%>
<%@  page import="com.egurkha.EgUserPermission"%>
<%@ page import="java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	boolean isDouble=EgDbInfo.doubleByteEnabled;
%>

<html>
<head>
	<title>Add New Role</title>
	<meta name="created" content="28/6/2k">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<egui:skin ui="admin"/>
	<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css" />  -->
	<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>

	<script language="JavaScript1.2">
		var previousSelectModule = "";
		function canHaveLimtedCompAcess(group)
		{
			var thisForm = document.userRole;
			if(group == 'admin')
			{
				if(isSelectedAny(group))
				{
					//For Limited Role
					//thisForm.notify[0].checked = true;
					//thisForm.notify[1].disabled = true;
				}else
					thisForm.notify[1].disabled = false;
			}
		}
		
		function selectAll(name,obj)
		{
			var chk = obj.checked;
			var thisForm = document.userRole;
			var ctrl=thisForm.elements[name];
			for(var j=0;j<ctrl.length;j++)
			{
				if(name=='admin')//For Limited Role
				{
					if(!thisForm.admin[j].disabled)
						ctrl[j].checked=chk;
				}
				else
					ctrl[j].checked=chk;
			}
			canHaveLimtedCompAcess(name);
			moveModuleButtonToDefault(name);
		}

		//For Limited Role  2/11/2006
		function limitedAccess(mainlist,type)
		{
			var thisForm=document.userRole;
			for(var i=0;i<mainlist;i++)
			{
				if(type=='limited')
				{
					//if(thisForm.admin[i].value==51539607678 || thisForm.admin[i].value==3145728 ||thisForm.admin[i].value==12582912 )
					if(thisForm.admin[i].value==3145728 ||thisForm.admin[i].value==12582912 || thisForm.admin[i].value==128)
						thisForm.admin[i].disabled=false;
					else
					{
						if(thisForm.admin[i].checked)
							thisForm.admin[i].checked=false;
						thisForm.admin[i].disabled=true;
					}
				}
				else
				{
					if(thisForm.checkall_admin.checked)
						thisForm.admin[i].checked=true;
					thisForm.admin[i].disabled=false;
				}
			}
		}

		function selectAny(ctrl)
		{
			moveModuleButtonToDefault(ctrl.name);
			var thisForm = document.userRole;
			thisForm.elements['checkall_' + ctrl.name].checked = (ctrl.checked && isSelectedAll(ctrl.name));
			canHaveLimtedCompAcess(ctrl.name);
		}

		function isSelectedAll(group)
		{
			var thisForm = document.userRole;
			var ctrl=thisForm.elements[group];
			
			for(var j=0;j<ctrl.length;j++)
			{
				if(ctrl[j].disabled)//For Limited Role
					continue;
				if(!ctrl[j].checked)
					return false;
			}
			return true;
		}

		function isSelectedAny(group)
		{
			var thisForm = document.userRole;
			var ctrl=thisForm.elements[group];
			for(var j=0;j<ctrl.length;j++)
			{
				if(ctrl[j].checked)
					return true;
			}
			return false;
		}

		function hasAnyPermission()
		{
			var flag = isSelectedAny('admin') || isSelectedAny('monitor');
			if("<%=EgInstallInfo.isReporterSupported%>" == "true")
			{
				flag =  flag || isSelectedAny('reporter');
			}

			/* uncomment the below code if the config mgmt enabled*/
			if("<%=EgInstallInfo.isConfigSupported%>" == "true")
			{
				flag = flag || isSelectedAny('config');
			}

			return flag;
		}

		function valForm()
		{
			var thisForm = document.userRole;
			var sub = true;
			var rolName = true;
			if('<%=isDouble%>'=="false")
			{
				rolName = validateSingleByte(thisForm.roleName.value);
			}
			if(!checkblank(thisForm.roleName))
			{
				alert('<egui:intnl text="admin.role.Please enter role name"/>.');
				thisForm.roleName.focus();
				sub = false;
			}
			else if(!checkspecial(thisForm.roleName,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,.?\/"))
			{
				thisForm.roleName.focus();
				sub = false;
			}
			else if(!checkspace(thisForm.roleName))
			{
				thisForm.roleName.focus();
				sub = false;
			}
			else if(thisForm.roleName.value.toUpperCase() == "ADMIN" || thisForm.roleName.value.toUpperCase() == "SUPERMONITOR"
			|| thisForm.roleName.value.toUpperCase() == "MONITOR" || thisForm.roleName.value.toUpperCase() == "ALARMVIEWER" || thisForm.roleName.value.toUpperCase() == "SERVERADMIN" || thisForm.roleName.value.toUpperCase() == "SUPERALARMVIEWER")
			{
				var name= thisForm.roleName.value
				alert('<egui:intnl text="admin.role.Cannot add a user by name"/> ' + name);
				thisForm.roleName.focus();
				sub = false;
			}
			else if(!rolName)
			{
				alert('<egui:intnl text="admin.role.Role name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
				thisForm.roleName.focus();
				sub = false;
				return;
			}
			else if(!hasAnyPermission())
			{
				alert('<egui:intnl text="admin.role.Atleast one module must be selected"/>');
				sub = false;
			}
			else if (!checkModuleRoles())
			{
				sub = false;
			}
			if(sub)
			{
				//alert("Please wait...");
				thisForm.update.disabled = true;
				thisForm.update.value='<egui:intnl text="admin.common.Updating"/>...';
				thisForm.action="Eguserrolesp.jsp";
				thisForm.submit();
			}
		}

		function checkModuleRoles()
		{
			var thisForm = document.userRole;
			var moduleName = thisForm.modules.options[thisForm.modules.options.selectedIndex].value;
			if(moduleName != "default")
			{
				var flag = document.getElementById("checkall_"+moduleName).checked;
				var roles = thisForm.elements[moduleName];
				if(flag != null && flag != true)
				{
					for(i=0;i<roles.length;i++)
					{
						if(roles[i].checked == true)
						{
							flag = true;
							break;
						}
					}
				}
				if(flag != null && flag == true)
				{
					previousSelectModule = moduleName;
				}
				if(flag != null && flag == false)
				{
					for(i=0;i<thisForm.modules.options.length;i++)
					{
						if(thisForm.modules.options[i].value == previousSelectModule)
						{
							thisForm.modules.options[i].selected = true;
						}
					}
					if(moduleName == "admin")
					{
						alert('<egui:intnl text="admin.role.Atleast one admin privilege must be selected to view the admin module on login" />');
						return false;
					}
					else if(moduleName == "monitor")
					{
						alert('<egui:intnl text="admin.role.Atleast one monitor privilege must be selected to view the monitor module on login" />');
						return false;
					}
					else if(moduleName == "reporter")
					{
						alert('<egui:intnl text="admin.role.Atleast one reporter privilege must be selected to view the reporter module on login" />');
						return false;
					}
					else if(moduleName == "config")
					{
						alert('<egui:intnl text="admin.role.Atleast one configuration mgmt privilege must be selected to view the configuration mgmt module on login" />');
						return false;
					}
				}
			}
			else
			{
				previousSelectModule = "default";
			}
			return true;
		}

		function moveModuleButtonToDefault(moduleName)
		{
			var thisForm = document.userRole;
			var selectedModule = thisForm.modules.options[thisForm.modules.selectedIndex].value;
			if(moduleName == selectedModule)
			{
				var roles = thisForm.elements[moduleName];
				var flag = true;
				for(i=0;i<roles.length;i++)
				{
					if(roles[i].checked == true)
					{
						flag = false;
						break;
					}
				}
				if(flag)
				{
					for(k=0;k<thisForm.modules.options.length;k++)
					{
						if(thisForm.modules.options[k].value == "default")
						{
							thisForm.modules.options[k].selected = true;
						}
					}
					previousSelectModule = "default";
				}
			}
		}
	</script>
</head>
<%
	Vector sess_vec = new Vector();
	Vector module=new Vector();
	Vector complist=new Vector();
	String fulcomp="";
	String mod="";
	String comp_list="";
	String type="";
	Vector next1=new Vector();
	String next="";
	String selectedModuleName = "default";
	String modifyrole=request.getParameter("modrole");
	if(modifyrole != null)
	{
		IniFile iniUI = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_ui.ini");
		selectedModuleName = iniUI.getValue("DEFAULT_MODULE",modifyrole);
	}
	if(selectedModuleName.equalsIgnoreCase("reporter") && !EgInstallInfo.isReporterSupported)
		selectedModuleName = "default";
	if(selectedModuleName.equalsIgnoreCase("config") && !EgInstallInfo.isConfigSupported)
		selectedModuleName = "default";
%>
<script language="JavaScript">
	previousSelectModule = '<%=selectedModuleName%>';
</script>
<%
	String[][] adminrolearr;
	String[][] monitorrolearr;
	String[][] reporterrolearr;
	String[][] configrolearr;
	//String[][] adminactionarr;
	//String[][] monitoractionarr;
	//String[][] reporteractionarr;
	EgUserPermission userPerm = EgUserPermission.getInstance();
	adminrolearr=userPerm.getAdminDesc();
	monitorrolearr=userPerm.getMonitorDesc();
	reporterrolearr=userPerm.getReporterDesc();
	configrolearr=userPerm.getConfigDesc();
	//adminactionarr=EgUserPermission.getAdminActionDesc();
	//monitoractionarr=EgUserPermission.getMonitorActionDesc();
	//reporteractionarr=EgUserPermission.getReporterActionDesc();

	String arr_modules[] = {"Admin","Monitor","Reporter","Config"};
	String displayNames[]={"Admin","Monitor","Reporter","Configuration"};
	boolean hasallcompaccess = false;
	//String allcheck = "";
	String [] allcheck = {"", "", "",""};
	Object arr_permList[] = {adminrolearr,monitorrolearr,reporterrolearr,configrolearr};
	//Object arr_actionList[] = {adminactionarr,monitoractionarr,reporteractionarr};
	long arr_perm[] = {0,0,0,0};
	long arr_action[]={0,0,0,0};
	long limtedAdminRole[] = {3145728,12582912,128}; 
	boolean isModify=false;
	boolean allowAllCompOnly =false;
	if(modifyrole!=null)
	{
		isModify=true;
		EgUserRole object = EgUserRole.getRoleObject(modifyrole);
		if(object==null)
		{
			/* code for auditlog starts */
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","User Management");
			auditLogThread.setValue("Activity","User Role");
			auditLogThread.setValue("Description",modifyrole + " " + "role might have been deleted while trying to modify");
			auditLogThread.sendItToDB();
			/* code for auditlog ends */

			Vector v_error=new Vector();
			v_error.removeAllElements();
			v_error.addElement(_mapping.getTextDescription("admin.role.Modify user role"));
			v_error.addElement("EgViewRoles.jsp");
			v_error.addElement(_mapping.getTextDescription("admin.role.Modify user role"));
			v_error.addElement(_mapping.getTextDescription("admin.role.Possible reasons"));
			v_error.addElement(_mapping.getTextDescription("admin.role.Error in transaction"));
			v_error.addElement(_mapping.getTextDescription("admin.role.Role might be deleted while trying to modify"));
			session.putValue("vec_Errors",v_error);
%>
			<jsp:forward page="EgErrors.jsp" />
<%
		}
		arr_perm[0]=  object.getAdminPerm();
		arr_perm[1] = object.getMonitorPerm();
		arr_perm[2] = object.getReporterPerm();
		arr_perm[3] = object.getConfigPerm();

		arr_action[0] = object.getAdminAction();
		arr_action[1] = object.getMonitorAction();
		arr_action[2] = object.getReporterAction();
		arr_action[3] = object.getConfigAction();

		hasallcompaccess=object.hasAllComponentAccess();
		long adminValue=0L;
		long monitorValue=0L;
		long reporterValue=0L;
		long configValue=0L;
		long limtedAdminRoleValue = 0L;

		for (int i=0;i<limtedAdminRole.length;i++)
		{
			limtedAdminRoleValue|= limtedAdminRole[i];
		}
		for(int i=0;i<adminrolearr.length;i++)
		{
			adminValue|= Long.valueOf(adminrolearr[i][1]).longValue();
		}
		for(int i=0;i<monitorrolearr.length;i++)
		{
			monitorValue|= Long.valueOf(monitorrolearr[i][1]).longValue();
		}
		for(int i=0;i<reporterrolearr.length;i++)
		{
			reporterValue|= Long.valueOf(reporterrolearr[i][1]).longValue();
		}
		for(int i=0;i<configrolearr.length;i++)
		{
			configValue|= Long.valueOf(configrolearr[i][1]).longValue();
		}
		if(adminValue==arr_perm[0])
			allcheck[0] = "checked";
		if (limtedAdminRoleValue==arr_perm[0] && !hasallcompaccess)
			allcheck[0] = "checked";
		if(monitorValue==arr_perm[1])
			allcheck[1] = "checked";
		if(reporterValue==arr_perm[2])
			allcheck[2] = "checked";
		if(configValue==arr_perm[3])
			allcheck[3] = "checked";

		allowAllCompOnly =arr_perm[0]>0;
	}

	//To get Admin Role Elements
	String compaccess;
	String mainlist[][] = (String[][]) arr_permList[0];
	if(hasallcompaccess)
		compaccess="complete";
	else
		compaccess="limited";

	String previousRole ="";
%>

<!-- <body  bgcolor="#FFFFFF" leftmargin="0" topmargin="20" marginwidth="0" marginheight="20"  -->
<body style="overflow:auto" id="space6" onLoad="javascript:limitedAccess('<%=mainlist.length%>','<%=compaccess%>')" scroll="auto">
<form name="userRole" method="post" action="javascript:valForm()" style="margin:0px" >
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" >
<jsp:include page="listSearch.jsp?title=USER ROLES CONFIGURATION&leftString=&backButton=true&subtitle=false&searchBox=false"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table border="0" align="center" cellspacing="0" cellpadding="0" width="85%">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr id="eg_subcontentbg" class="eg_subcontent" height="25">
					<!-- <td id="eg_subcontentbg"></td> -->
					<td  colspan="3" align="center" >
						<table border="0" cellspacing="0" cellpadding="3" width="100%">
							<tr>
								<td width="236" style="padding-left:50px"><egui:intnl text="admin.role.Role name"/> </td>
								<td width="10">:</td>
								<td id="eg_subcontentbg" align="left">
<%
	if(isModify)
		out.println(modifyrole);
	String chk="";
	String chk1="";
	String dis ="";
	if(hasallcompaccess)
	{
		chk=" checked ";
		previousRole ="Y";
	}
	else
	{
		chk1=" checked ";
		previousRole ="N";
	}
	//SN
	//if(allowAllCompOnly)
	//	chk1 +=" disabled=true ";
%>
								<input type=<%=isModify?"'hidden' value='"+modifyrole+"'":"'textbox'"%> style="width:150" name="roleName"></td>
							</tr>
							<tr id="eg_subcontentbg" class="eg_subcontent" height="25">
								<td width="236" style="padding-left:50px"><egui:intnl text="admin.role.Components access"/> </td>
								<td width="10">:</td>
								<td align="left" style="padding:0px"> 
									<table border="0" cellspacing="0" cellpadding="0">
										<tr>
											<td width="20" style="padding-bottom:1px"><input type="radio" id = "eg_input" value="Y" name="notify" <%=chk%> onClick="javacript:limitedAccess('<%=mainlist.length%>','complete')"></td>
											<td width="60" style="padding-bottom:1px"><egui:intnl text="admin.role.Complete"/></td>
											<td width="20"  style="padding-bottom:1px"><input type="radio" id = "eg_input" value="N" name="notify"   <%=chk1%> onClick ="javascript:limitedAccess('<%=mainlist.length%>','limited')"></td>
											<td width="60"  style="padding-bottom:1px"><egui:intnl text="admin.role.Limited"/></td>
										</tr>
<%
	if(chk.equals(" checked "))
	{
		type="complete";
	}
	else if(chk1.equals(" checked "))
	{
		type="limited";
	}
%>
									</table>
								</td>
							</tr>
						</table>
					</td>
					<!-- <td id="eg_subcontentbg">&nbsp;</td> -->
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td colspan="3" height="10">&nbsp;</td>
				</tr>
<%
	int i_colsPerRow = 3;
	float f_cellWidth =100/i_colsPerRow;
	for(int mIdx=0;mIdx<arr_modules.length;mIdx++)
	{
		String s_module= arr_modules[mIdx];
		String moduleDisplayName=displayNames[mIdx];

		// Added  for Citi bank  - Nagarajan
		// If u need Config Mgmt in admin - Add new roles - page just comment/remove the following two lines
		if (moduleDisplayName.equals("Reporter") && !EgInstallInfo.isReporterSupported)
			continue;
		if (moduleDisplayName.equals("Configuration") && !EgInstallInfo.isConfigSupported)
			continue;
		int idx =0;
		String arr_dispPerm[][] = (String[][]) arr_permList[mIdx];
%>
				<tr>
					<td align="center" height="22" width="85%" colspan="5">
						<table align="center" border="0" cellpadding="0" cellspacing="0" height="22" width="100%">
							<tr>
								<td id="subhead_left" width="7">
									<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td id="eg_subheadbg" align="center" width="100%">
									<table border="0" cellpadding="0" cellspacing="0" width="100%">
										<tr>
											<td width="90%"><b><%=moduleDisplayName%></b></td>
											<td align="right">
								<% 
		if(arr_dispPerm.length>1)
		{
%>
												<input type="checkbox" class="eg_input" name="checkall_<%=s_module.toLowerCase()%>" id="checkall_<%=s_module.toLowerCase()%>" <%=allcheck[mIdx]%> onClick ="javascript:selectAll('<%=s_module.toLowerCase()%>',this)">
											</td>
											<td style="text-transform:none;padding-right:8px" align="right" nowrap> <egui:intnl text="admin.common.Select all"/></td>
<%
		}
%>
											</td>
										</tr>
									</table>
								</td>
								<td id="subhead_right" width="7" >
									<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr height="25">
					<!-- <td id="eg_subcontentbg" >&nbsp;</td> -->
					<td id="eg_subcontentbg" colspan="3"  id="form_spacing">
						<table border="0" cellspacing="0" cellpadding="4" width="100%"  
							id="eg_subcontentbg" align="center" class="eg_subcontent">
<%
		for(;idx<arr_dispPerm.length;idx++)
		{
			String s_permDesc = arr_dispPerm[idx][0];
			s_permDesc=s_permDesc.trim();
			String mappingName=s_permDesc;
			long l_permValue= Long.valueOf(arr_dispPerm[idx][1].trim()).longValue();
			long l_permValue1 = l_permValue;
			long tmpLong = arr_perm[mIdx];
			if (l_permValue==132608)
			{
				l_permValue1=1536;
			}
			else if (l_permValue==115184)
			{
				l_permValue1=496;
			}
			boolean isChecked=(((tmpLong &l_permValue)==l_permValue1) || ((tmpLong &l_permValue)==l_permValue));
			if(idx % i_colsPerRow ==0)
				out.println("<tr>");						
%>

								<td align="left"  nowrap style="padding-left:15px" >
								<input type="checkbox" id="eg_input" name="<%=s_module.toLowerCase()%>" value="<%=l_permValue%>" <%=isChecked?" Checked ": ""%>  onClick="javascript:selectAny(this)"></td><td  align="left" nowrap width="<%=f_cellWidth%>%"> <egui:intnl text='<%="admin.role."+mappingName%>'/>
								</td>
<%
			module.add(s_module);
			fulcomp=s_module+":"+l_permValue+","+s_permDesc;
			complist.add(fulcomp);
			//next1.add(s_module+":"+isChecked+","+s_permDesc);
			if(isChecked)
			{
				next1.add(s_module+":"+s_permDesc);
			}

			if(idx % i_colsPerRow ==idx-1 || idx==arr_dispPerm.length-1)
				out.println("</tr>");
		}

		if(idx==0)
		{
%>
							<tr>
								<td  colspan="<%=i_colsPerRow%>" align="center"><egui:intnl text="admin.common.No"/> <%=s_module%> <egui:intnl text="admin.role.roles defined"/>.</b></td>
							</tr>
<%
		}
%>
						</table>
					</td>
					<!-- <td id="eg_subcontentbg">&nbsp;</td> -->
					<input type="hidden" name="<%=s_module.toLowerCase()%>Action" value="<%=arr_action[mIdx]%>">
					</tr>
					<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>

	<!--	 This commented portions are added for future for actions	</tr>
		<tr height="3">
			<td colspan="3">&nbsp;</td>
		</tr>
		<tr>
			<td colspan="3">
			<table border="0" cellspacing="0" cellpadding="4" width="100%"  id="eg_subcontentbg" class="eg_subcontent">
				<tr id="eg_subheadbg" class="eg_subhead">
					<td colspan="<%//=i_colsPerRow%>"><b>&nbsp;&nbsp;<%//=s_module%> Action</b></td>
				</tr> -->
<%
				/*String arr_dispAction[][] = (String[][]) arr_actionList[mIdx];

				for(idx=0;idx<arr_dispAction.length;idx++)
				{
					String s_actionDesc = arr_dispAction[idx][0];
					long l_actionValue= Long.valueOf(arr_dispAction[idx][1].trim()).longValue();

				}
					boolean isChecked=((arr_action[mIdx]&l_actionValue)==l_actionValue);

					if(idx % i_colsPerRow ==0)
						out.println("<tr>"); */
%>
			<!--		<td align="left">
						<input type="checkbox"  name="<%//=s_module.toLowerCase()%>Action" value="<%//=l_actionValue%>" <%//=isChecked?" Checked ": ""%> ><%//=s_actionDesc%>
					</td>	  -->
<%/*
						if(idx % i_colsPerRow ==idx-1 || idx==arr_dispAction.length-1)
							out.println("</tr>");
				}

				if(idx==0)
				{
					*/
%>
			<!--		<tr>
						<td colspan="<%//=i_colsPerRow%>" align="center">No <%//=s_module%> actions defined.</b></td>
					</tr>-->
<%
				//}
%>
		<!--		</table>
			<td>
		</tr> -->
				<!-- <tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr> -->
				<tr height="3">
					<td colspan="3">&nbsp;</td>
				</tr>
<%
	}
%>
				<tr>
					<td colspan="3">
						<table  border="0" align="center" cellspacing="0" cellpadding="0" width="100%" >
							<tr>
								<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<tr id="eg_subcontentbg" class="eg_subcontent" height="25">
								<td colspan="3" >
									<table border="0" cellspacing="0" cellpadding="3" width="100%">
										<tr>
											<td width="236" style="padding-left:50px"><egui:intnl text="admin.role.Module to be viewed on login"/> </td>
											<td width="10">:</td>
											<td align="left" style="padding:0px">
												<select name="modules" onChange ='javascript:checkModuleRoles()' style='width:190px;'>
													<option value="default" <%=(selectedModuleName.equalsIgnoreCase("default")|| selectedModuleName.equalsIgnoreCase(""))?"selected":""%>>Default</option>
													<option value = "admin" <%=selectedModuleName.equalsIgnoreCase("admin")?"selected":""%>>Admin</option>
													<option value = "monitor" <%=selectedModuleName.equalsIgnoreCase("monitor")?"selected":""%>>Monitor</option>
<%
	if(EgInstallInfo.isReporterSupported)
	{
%>
													<option value = "reporter" <%=selectedModuleName.equalsIgnoreCase("reporter")?"selected":""%>>Reporter</option>
<%
	}

	if(EgInstallInfo.isConfigSupported)
	{
%>
													<option value="config" <%=selectedModuleName.equalsIgnoreCase("config")?"selected":""
													%>>Configuration</option>
<%
	}
%>
												</select>
											</td>
										</tr>
									</table>
									
								</td>
							</tr>
							<input type='hidden' name='moduleView' value='Module to be viewed on login$<%=selectedModuleName%>'>
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
						</table>
					</td>
				<tr>

<%
	for(int i=0;i<module.size();i++)
	{
		if(mod==null||mod.equals(""))
		mod=(String)module.get(i);
		else
		mod=mod+"#"+(String)module.get(i);
	}
	for(int i=0;i<complist.size();i++)
	{
		if(comp_list==null||comp_list.equals(""))
		comp_list=(String)complist.get(i);
		else
		comp_list=comp_list+"#"+(String)complist.get(i);
	}
	for(int k=0;k<next1.size();k++)
	{
		if(next==null||next.equals(""))
			next=(String)next1.get(k);
		else
			next=next+"#"+(String)next1.get(k);
	}
%>
				<tr>
					<td colspan="3" height="10">&nbsp;</td>
				</tr>
				<tr  class="eg_subcontent" height="25">
					<td colspan="5" align="center">
					<input type="hidden" name="command" value="<%=isModify?"update":"add"%>">
					<input type="hidden" name="module" value="<%=mod%>">
					<input type="hidden" name="complist" value="<%=comp_list%>">
					<input type="hidden" name="type" value="<%=type%>">
					<input type="hidden" name="next" value="<%=next%>">
					<input type="button" value='<egui:intnl text="admin.common.Update"/>' name="update" style="width: 85px;" id="eg_back" onClick="javascript:valForm()">
					</td>
				</tr>
			</table><br>
		</td>
	</tr>
</table>
		<input type="hidden" name="previousrole" value="<%=previousRole%>">
</form>
<%
	session.setAttribute("adminLastAccessedURL","/final/admin/EgUserRoles.jsp?"+request.getQueryString());
%>

</body>
</html>



