<%
/********************************************************************************************************
*	Name			:	EgUnconfigTests.jsp
*	Purpose			:	Displays the tests which are not configured.
*	Version			:	3.0
*	CreationDate	:	13/11/2000
*	Last Modified	:	08/05/2002	Sandhya		Changed alert message.
*						13/11/2003	Williams	eG 3.0 Layout Modifications
*						17/12/2003	Arun		Only reads non-Site_servers subjects in eg_discover.ini
*												while locating servers with unconfigured tests
*						29/12/2003	Arun		Removes :NULL from server names
*						22/06/2004	Arun		Weblogic tests have use a "server" parameter which is also
*												used by the JSP to send the server type. Change the query
*												parameter to typeOfServer to remove ambiguity.
*	Author			:	KrishnaKumar.C
*	Design Changes	:	Jaiwin
*******************************************************************************************************/
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%//The following line should not be touched if the help pages have to work%>
<%//@ include file="EgTrackerA.jsp" %>
<%//Do not touch the line above%>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.SidCheck"%>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import= "com.eg.EgRoleInfo"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.egurkha.User" %>
<%@ page import = "com.egurkha.UserRegistry" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.admin.AdminOperations" %>
<%@ page import = "com.egurkha.admin.UpdateTestPeriod"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<!--<meta http-equiv="refresh" content="100;url=EgUnconfigTests.jsp?<%=request.getQueryString()%>">-->
<html>
<head>
<title> Unconfigured Tests &nbsp; - &nbsp; eG Manager &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>
<meta name="created" content="28/6/2k">
<egui:skin ui="admin"/>
<jsp:useBean id="TestConfig" scope="page" class="egurkha.TestsNotConfigured"/>

<%
	Vector v_tests;
	String s_server="";
	String s_test="";
	String str_stype="";
	String module = "";
%>

<jsp:useBean id="ConfigBean" scope="page" class="egurkha.ConfigBean"/>
<jsp:useBean id="TransactionBean" scope="page" class="egurkha.TransactionBean"/>

<%
	boolean isCMEnabled = EgInstallInfo.isConfigSupported;
	StringTokenizer st = null;
	ConfigBean.createFile("eg_discover.ini");
	String [] subjects=ConfigBean.getSubjects();
	ArrayList li=new ArrayList();
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));//by JJ
	li=ri.getAllServers();
	v_tests=TestConfig.display();
	Collections.sort(v_tests);

	TreeMap tmapExcludedTests = new TreeMap();
	if (v_tests != null && v_tests.size() > 0)
	{
		AdminOperations ao = new AdminOperations();
		tmapExcludedTests = ao.getExcludedTests(li);
	}

	String egTitleSearchStr=request.getParameter("egTitleSearchStr");
	String serverType = request.getParameter("serverType");
	boolean isSearchResult = (egTitleSearchStr!=null && !egTitleSearchStr.equals(""));
	ArrayList searchList = new ArrayList();
	IniFile agentsIni = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_agents.ini");
	IniFile externalIni = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_external.ini");
	if (isSearchResult)
	{
		StringTokenizer st1 = new StringTokenizer(egTitleSearchStr);
		while (st1.hasMoreTokens())
		{
			String thisToken = st1.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
	TransactionBean.createFile("eg_specs.ini");
	String s_check = request.getParameter("from");
	String fromSrc = request.getParameter("source"); //dashboard
	boolean fromAdminDB = fromSrc!=null && fromSrc.equals("dashboard");
	if(s_check!=null && s_check.equals("home"))
	{
		if(li.size()==0)
		{
%>
<jsp:forward page="../admin/EgNoUnconfiguredTests.jsp" />
<%
		}
	}

	String[] testSpecs = TransactionBean.getVariables("TEST_SPECIFICATION");
	testSpecs = (testSpecs != null)?testSpecs:new String[0];
	List listTestSpecifications = Arrays.asList(testSpecs);

	boolean loadDiscCompsPopupDiv = false;
	String showDiscCompsPopupInBack = request.getParameter("showDiscCompsPopupInBack");
	if(showDiscCompsPopupInBack != null && showDiscCompsPopupInBack.equalsIgnoreCase("yes"))
	{
		loadDiscCompsPopupDiv = true;
	}

	IniUI iniUI = IniUI.getInstance();
	boolean isDiscoveredCompsPopupEnabled = iniUI.isDiscoveredCompsPopupEnabled();
	String hideTimeDiscoverCompsPopup = iniUI.getDiscCompsPopTimeout();
	boolean allCompAccess = ri.hasAllComponentAccess();
	if(!allCompAccess)
	{
		isDiscoveredCompsPopupEnabled = false;
	}
	boolean updateTestPeriod = false;
	Vector aggregateTestDetails = null;
	if(EgInstallInfo.isAggregationSupported())
	{
		aggregateTestDetails = new UpdateTestPeriod().getAggregateTestsWithoutRecommendedTestPeriod();
		updateTestPeriod = (aggregateTestDetails != null && aggregateTestDetails.size()>0);
	}
%>

<script type="text/javascript" src="/final/admin/eg_scripts/ajaxutils.js"></script>
<script language="javascript1.2">

function refreshPage(button)
{
	if(button=='tests')
		window.location.href = "EgUnconfigTests.jsp?refresh=yes";
	else
		window.location.href = "EgUnconfigTests.jsp?from=home";
}

function callCheck()
{
<%
	if(v_tests.size() == 0 && !updateTestPeriod)
	{
		out.println("window.close();");
	}
%>
	if("<%=loadDiscCompsPopupDiv%>" == "true")
	{
		openDiscCompsDiv();
	}
	else
	{
		showDiscCompsText();
	}
}

function sid_check()
{
	alert("<egui:intnl text='admin.unconfig.The eG administrator has not configured SIDs for all of the managed Oracle component(s)'/>. <egui:intnl text='admin.unconfig.Users of type \'Monitor\' will not be allowed to sign in if any of the SIDs are not configured'/>.  <egui:intnl text='admin.unconfig.Please go to ADD/MODIFY option and configure SID for these components or go to MANAGE option and unmanage these components'/>.");
}

function egTitleSearch()
{
	var thisForm=document.AddUnconfigTest;
	var searchSt=thisForm.egTitleSearchStr.value;
	var src='<%=request.getParameter("source")%>';
	var comp_type = '<%=request.getParameter("serverType")%>';
	var frm = '<%=request.getParameter("from")%>';
	var show = '<%=request.getParameter("show")%>';
	if(comp_type == null || comp_type == "null")
	{
		comp_type = null;
	}
	if (searchSt==null || searchSt=="")
	{
		window.location.href = "EgUnconfigTests.jsp?source="+src+"&serverType="+comp_type+"&from="+frm+"&show="+show;
	}
	else if(searchSt!=null)
	{
		window.location.href = "EgUnconfigTests.jsp?egTitleSearchStr="+searchSt+"&serverType=<%=serverType%>&source="+src+"&from="+frm+"&show="+show;
		return;
	}
}
function hideFunction(search,id)
{
	if(search == 0)
		document.getElementById("display"+id).style.display = 'none';
}

function openDiscCompsDiv()
{
	var click_id = document.getElementById("DiscCompsInUnconfigTests");
	if(click_id != null)
	{
		click_id.value="clicked";
	}
	setShowFlag(true);	setProperties('<%=request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final"%>',true,"<%=hideTimeDiscoverCompsPopup%>",document.body.scrollTop);
	getDiscoveredComponents("-1");
}

function showDiscCompsText()
{
	setShowFlag(false);
	setProperties('<%=request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final"%>');
	getDiscoveredComponents("-1");
}

function scrollAdjust1()
{
	scrollAdjust(document.body.scrollTop)
}

</script>
</head>

<%

if(!isDiscoveredCompsPopupEnabled)
{
%>
<body id="space6" onLoad="callCheck();" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" style="overflow:auto" scroll="auto" class="white_bg">

<%
}
else
{
%>
<body id="space6" onLoad="callCheck();" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" style="overflow:auto" scroll="auto" class="white_bg" onscroll="javascript:scrollAdjust1()">

	<iframe id="divframe" name="divframe" frameborder="0" width="0" height="0" style="display:block;position:absolute;z-index:1000"></iframe>
	<div id="DiscCompsPopup" name="DiscCompsPopup" style="width:530px;height:210px;display:none;position:absolute;backgroundcolor:red;z-index:1000;border:0px solid #ff0000;">
		<table border="0" cellspacing="0" cellpadding="0" border="0">
			<tr>
				<td>
					<table width="100%" height="100%" cellspacing="0" cellpadding="0" border="0">
						<tr>
							<td width="11px" height="11px" class="pop2_lefttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11px" height="11px"/></td>
							<td height="11px" width="100%" class="pop2_top_bg"></td>
							<td width="11px" height="11px" class="pop2_righttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11px" height="11px"/></td>
						</tr>
						<tr>
							<td width="11px" height="100%" class="pop2_left_bg"></td>
							<td height="100%" width="100%" class="eg_whitebg">
								<table width="100%" border="0" height="100%" cellpadding="0" cellspacing="0">
									<tr>
										<td valign="top" width="100%">
										<div id="DetailedDiscComps" style="display:none;width:508px;height:188px;border:0px solid #00dd00;">
											<table border="0"  width="100%" height="100%" cellpadding="0" cellspacing="0" style="display:block">
												<tr>
													<td>
														<iframe src="javascript:false" width="500px" height="190px" frameborder="0" scrolling="no"  id="ListDiscComps" marginheight="0" marginwidth="0" leftmargin="0" topmargin="0"></iframe>
													</td>
												</tr>
											</table>
										</div>
										</td>
									</tr>
								</table>
							</td>
							<td  width="11px" height="100%" class="pop2_right_bg">&nbsp;</td>
						</tr>
						<tr>
							<td width="11px" height="11px" class="pop2_leftbottom_curve"></td>
							<td height="11px" width="100%" class="pop2_bottom_bg"></td>
							<td width="11px" height="11px" class="pop2_rightbottom_curve"></td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</div>
<%
}
%>

<form name="AddUnconfigTest" method="get" action="javascript:egTitleSearch()" style="margin:0px;width:100%">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
<%
	//String schStr = request.getParameter("egTitleSearchStr");
	session.setAttribute("forrefresh" ,"refresh");
	session.setAttribute("egBackComplete","/final/admin/EgUnconfigTests.jsp?serverType="+serverType);
	session.setAttribute("egPageDesc", "EgUnconfigTests.jsp");

	UserRegistry userRegistry = UserRegistry.getInstance();
	User user = userRegistry.getUser(session.getId());
	String defaultLanguage = iniUI.getDefaultLanguage();
	String adminSkin = user.getAdminSkin();
	if (user!=null)
	{
		String userLanguage = user.getLanguage();
		if (userLanguage!=null && !userLanguage.equalsIgnoreCase("NULL"))
		{
			defaultLanguage = userLanguage;
		}
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(defaultLanguage);

	if(fromSrc!=null&&fromSrc.equalsIgnoreCase("dashboard"))
	{
%>
<jsp:include page="listSearch.jsp?title=LIST OF UNCONFIGURED TESTS&backButton=true&subtitle=true&searchBox=true&leftString="/>
<%
	}
	else
	{
%>
<jsp:include page="listSearch.jsp?title=LIST OF UNCONFIGURED TESTS&backButton=false&subtitle=true&searchBox=true&leftString="/>
<%
	}
%>
	<tr>
		<td width="100%" valign="top" >
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0">
				<tr>
<%
	if(s_check != null)
	{
		if(s_check.equals("home"))
		{
%>
					<td width="77%"  align="center">
						<table cellspacing="0" cellpadding="0" border="0" width="100%" align="center" id="padding2">
							<tr>
								<td id="eg_maintitle" width="95%" align="center"><egui:intnl text="admin.unconfig.LIST OF TESTS THAT ARE NOT CONFIGURED"/></td>
							</tr>
						</table>
					</td>
<%
		}
		else if(s_check.equals("logout"))
		{
%>
					<td width="100%" valign="top" id="eg_whitebg" align="right" colspan="2" style="padding-bottom:12px">
						<table cellspacing="0" cellpadding="3" border="0" width="100%">
							<tr>
								<td width="82%" >&nbsp;</td>
								<td width="18%" id="cell_border1" align="center"><a class="body_link" href="EgLogoutA.jsp?proceed=yes" target="_parent"><b><egui:intnl text="admin.unconfig.Proceed to Signout"/></b>&nbsp;<img src="/final/admin/eg_images/arrow.gif" border="0"></a></td>
							</tr>
						</table>
					</td>
<%
		}
	}
%>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="top">
		<!-- <br>This table shows the list of tests that are not configured. &nbsp;These tests must be configured for agents to report proper measurements.<br><br> -->
		<!-- start of warning code -->
<%
	Vector v_server = new Vector();
	v_server = TestConfig.serversWithoutSID();
	if(v_server.size() > 0)
	{
%>
			<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0">
				<tr>
					<td width="100%" colspan="3">
						<table align="center" width="100%" cellspacing="0" cellpadding="2" border="0">
							<tr>
								<td><img src="eg_images/eg_warning.gif" height="20" hspace="3" vspace="0" border="0"></td>
								<td width="100%" ><b><egui:intnl text="admin.unconfig.The following Oracle components have not been configured yet"/>:</b></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td width="100%" colspan="3">
						<table align="center" width="100%" cellspacing="0" cellpadding="4" border="0">
<%
		for (int d=0;d<v_server.size();d=d+4)
		{
%>
							<tr>
<%
			for (int e=d;e<d+4;e++)
			{
				if (e < v_server.size())
				{
%>
								<td id="eg_subcontentbg" width="20%">&nbsp;<%=v_server.get(e)%></td>
<%
				}
				else
				{
%>
								<td id="eg_subcontentbg" width="20%">&nbsp;</td>
<%
				}
			}
%>
							</tr>
<%
		}
		v_server.clear();
%>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td width="100%" height="22" colspan="3">&nbsp;<egui:intnl text="admin.unconfig.Please go to ADD / MODIFY option and configure SIDs for these components"/>.</td>
				</tr>
			</table><br>
<%
	}
%>
		</td>
	</tr>

<%
	if(s_check != null && s_check.equals("logout"))
	{
		if(isDiscoveredCompsPopupEnabled)
		{
%>
	<tr id="showText" style="display:none">
		<td width="100%" valign="top" >
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td align="left" width="100%" id="eg_subcontentbg" colspan="3">&nbsp;
						<egui:intnl text="admin.unconfig.Discovery manager found new component(s) in the target environment"/>. <a class="eg_monlink" href="javascript:openDiscCompsDiv()"><b>Click here</b></a> <egui:intnl text="admin.unconfig.to view/manage the discovered components"/>.
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr id="showText1" style="display:none">
		<td>
			<br>
		</td>
	</tr>
	<input type="hidden" name="DiscCompsInUnconfigTests" id="DiscCompsInUnconfigTests" value="">
<%
		}
	}

	int disp=0;//newly defined
	int search=0;
	int search2 = 0;
	int search3 = 0;
	ArrayList temp = null;
	String tempServerType = null;
	String show;
	if(request.getParameter("showAll")!=null)
	{
		show=request.getParameter("showAll");
	}
	else
	{
		show="no";
	}

	boolean searchItemFound = false;
	int tmpTestCount=0;

	//int testCount = 0;
	//if(fromAdminDB)
	//{
	//	for(int ii=0;ii < v_tests.size();ii++)
	//	{
	//		String tmpTest=(String)v_tests.elementAt(ii);
	//		String DOUBLE_COLON = "::";
	//		String tmpServerType = "";
	//		if(tmpTest.indexOf(DOUBLE_COLON) < 0)
	//		{
	//			st = new StringTokenizer(tmpTest,":");
	//			String tmpTestName = st.nextToken() + "::";
	//			tmpServerType  = st.nextToken() ;
	//			tmpTest = tmpTestName + st.nextToken("").substring(1);
	//		}
	//		String tmpserverName=tmpTest.substring(tmpTest.indexOf(DOUBLE_COLON) + DOUBLE_COLON.length(), tmpTest.length());
	//		if (serverType == null ||serverType.equalsIgnoreCase("null")|| tmpServerType.equals(serverType))
	//		{
	//			if(li.contains(tmpServerType +":"+tmpserverName) || li.contains(tmpServerType+":"+tmpserverName+":NULL"))
	//			{
	//				testCount++;
	//			}
	//		}
	//	}
	//}

	byte forConfig = 1;
	String _normalTestTitle = "Performance Test(s)";
	String _configTestTitle = "Configuration Test(s)";
	String showTitle = "";
	String showTest = request.getParameter("show");
	showTest = (showTest == null?"":showTest);
	boolean flag = true;
	boolean isShowConfig = showTest.equalsIgnoreCase("configTest");
	boolean isShowNormal = showTest.equalsIgnoreCase("normalTest");
	boolean isShowBoth = showTest.equalsIgnoreCase("both");
	ArrayList normalTestsList = null;
	ArrayList configTestsList = null;
	if(isShowConfig)
		showTitle = _configTestTitle;
	if(isShowNormal)
		showTitle = _normalTestTitle;
	if(isShowBoth)
	{
		forConfig = 2;
		normalTestsList = getGroupOfTests(v_tests,0); // 0 - for performance tests
		configTestsList = getGroupOfTests(v_tests,1); // 1 - configuration Tests
	}
	String[] agentsIniSubjects = agentsIni.getSubjects();
	String[] ComponentsType = ri.getServerTypes();
	int numofDisplay = 0;
	int numofUnConfigTest = 0;
	String serType = ((serverType == null || serverType.equalsIgnoreCase("null"))?"":serverType);
	boolean forAllTestDisp = (s_check != null &&(s_check.equals("home") || s_check.equals("logout") || s_check.equals("testConfig")));

	if(li != null && v_tests != null)
	{
		if(ComponentsType.length == 1 || (ComponentsType.length > 1 && v_tests.size() == 0))
		{
			numofDisplay = 1;
		}
		if(ComponentsType.length > 1 && (v_tests.size() >= 1))
		{
			numofDisplay = 2;
		}
	}
	if(forAllTestDisp)
	{
		serverType = "null";
		numofDisplay = 1;
	}

	for(int c=0;c<numofDisplay;c++)
	{
		if(isShowBoth)
		{
			showTitle = _normalTestTitle;
			v_tests = new Vector(normalTestsList);
		}

%>
			<!-- warning code ends here -->
	<tr>
		<td>
			<table align="center" cellspacing="0" cellpadding="0" width="85%" id="eg_subcontentbg" border="0">
				<tr>
					<td>
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="padding:0px" >
<%
		if(!forAllTestDisp)
		{
%>
							<tr>
								<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
<%
			if (serType.equalsIgnoreCase("other Component types"))
			{
%>

								<td id="eg_subheadbg_lower" width="100%"  height="20" align="center" colspan="2"><b><egui:intnl text="admin.unconfig.List of unconfigured tests for other component types"/></b></td>
<%
			}
			else
			{
%>

								<td id="eg_subheadbg_lower" width="100%"  height="20" align="center" colspan="2"><b><egui:intnl text="admin.unconfig.List of unconfigured tests for"/>&nbsp;'<egui:intnl type='<%=serType%>'/>'</b></td>
<%
			}
%>
								<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							</tr>
<%
		}
		else
		{
%>
							<tr>
								<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%" colspan="2"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
<%
		}

		for(byte conf = 0;conf<forConfig;conf++)
		{
			if(v_tests!=null && v_tests.size() > 0)
			{
%>
							<tr id='display<%=c+""+conf%>' style="display:'';">
								<!-- <td width="7">
									<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td> -->
								<td colspan="4" class="space10" width="100%" >
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
										<tr>
											<td valign="top" colspan="4" align="center" width="100%" >
												<table border="0" cellspacing="0" cellpadding="0" id="cell_border1" width="90%" >
<%
				if(isCMEnabled)
				{
%>
													<tr>
														<td colspan="2" id="eg_cellbgdark" width="100%" class="head_padding4"><b><egui:intnl text='<%="admin.unconfig."+showTitle%>'/></b> </td>
													</tr>
<%
				}
%>
													<tr>
														<td height="2px" class="eg_blankspace">&nbsp; <img src="/final/admin/eg_images/spacer.gif" border="0"></td>
													</tr>
													<tr>
														<td height="20" width="60%" align="left" id="cell_border4" class="head_padding3" >&nbsp;&nbsp;<b><egui:intnl text="admin.unconfig.Test"/></b></td>
														<td height="20" width="40%" align="left" id="cell_border4" class="head_padding3" >&nbsp;&nbsp;<b><egui:intnl text="admin.unconfig.Component"/></b></td>
													</tr>
													<tr>
														<td colspan="2" >
															<table border="0" cellspacing="0" cellpadding="0" width="100%" style="table-layout:fixed"><col width="60%"><col width="40%">

<%
				for(int i=0;i < v_tests.size();i++)
				{
					String str_test=(String)v_tests.elementAt(i);
					if(isShowNormal)
						flag = !(str_test.indexOf("_cf:")>0);
					if(isShowConfig)
						flag = (str_test.indexOf("_cf:")>0);
					if(flag)
					{
						String ss_test = "::";
						str_stype = "";
						if(str_test.indexOf(ss_test) < 0)
						{
							st = new StringTokenizer(str_test,":");
							String s_tmp_test = st.nextToken() + "::";
							str_stype = st.nextToken() ;
							str_test = s_tmp_test + st.nextToken("").substring(1);//str_test.substring(str_test.lastIndexOf(str_stype)+str_stype.length() + 1);
						}
						s_test=str_test.substring(0,str_test.indexOf(ss_test));
						//if (isSearchResult && !doesExist(searchList, s_test))
							//continue;
						//searchItemFound=true;
						s_server=str_test.substring(str_test.indexOf(ss_test) + ss_test.length(), str_test.length());
						String server_name = s_server;
						if(s_server.indexOf(":$sid") > 0)
						{
							//Check for Oracle_server
							s_server = s_server.substring(0,s_server.indexOf(":$sid"));
						}
						temp = new ArrayList();
						if(str_stype.length() == 0 )
						{
							for(int j=0;j < subjects.length;j++)
							{
								if (!subjects[j].equalsIgnoreCase("Site_servers"))
								{
									String [] variables=ConfigBean.getVariables(subjects[j]);
									for(int k=0;k < variables.length;k++)
									{
										if(variables[k].startsWith("Format") || variables[k].startsWith("#"))
										{
											continue;
										}
										if(variables[k].indexOf(s_server) > -1)
										{
											st = new StringTokenizer(variables[k],":");
											String s_ttmp = st.nextToken() + ":" + st.nextToken();
											if(variables[k].equals(subjects[j] + ":" + s_server) || variables[k].equals(subjects[j] + ":" + s_server + ":NULL") || s_ttmp.equals(subjects[j] + ":" + s_server))
											{
												if(!temp.contains(subjects[j]))
												{
													temp.add(subjects[j]);
												}
											}
										}
									}
								}
							}
						}
						else
						{
							temp.add(str_stype);
						}
						if(temp.size() == 0)
						{
							continue;
						}
						for(int k=0; k<temp.size(); k++)
						{
							tempServerType = (String) temp.get(k);
							String testList = TransactionBean.getStrValue("TEST_MAPPING",tempServerType);
							if(testList == null || testList.length() == 0)
							{
								continue;
							}
							if(testList.indexOf(s_test) >= 0)
							{
								str_stype = tempServerType;
							}
							else
							{
								continue;
							}

							//Check whether the test is excluded or not for the component type - Start
							String strComponentName = new String(server_name);
							if (strComponentName.indexOf(":") == -1)
							{
								strComponentName = strComponentName + ":NULL";
							}
							ArrayList aListExcludedTests = (ArrayList)tmapExcludedTests.get(tempServerType+":"+strComponentName);
							if (aListExcludedTests != null && aListExcludedTests.contains(s_test))
							{
								continue;
							}
							//End

							String tmpServerName = server_name;
							if(!(server_name.indexOf("$sid") > 0 && str_stype.equals("Oracle_server")))
							{
								if (server_name.endsWith(EgConstants.NULL_PORT))
								{
									tmpServerName = Server.getServerNameWithoutPort(server_name);
								}
								else
								{
									tmpServerName = server_name;
								}
							}

							//String tdClass = "";
							//String searchstring=s_test+str_stype+tmpServerName;
							String searchstring = mappingInfo.getTestDescription(s_test);
							if (isSearchResult && !doesExist(searchList, searchstring))
								continue;
							searchItemFound=true;
							boolean display = str_stype.equals(serverType);
							if(c == 1)
							{
								display = !str_stype.equals(serverType);
							}
							if (serverType == null ||serverType.equalsIgnoreCase("null") || display)
							{
								if(server_name.indexOf("$sid") > 0 && str_stype.equals("Oracle_server"))
								{
									if (li.contains(str_stype+":"+server_name) || li.contains(str_stype+":"+server_name+":NULL"))
									{
										disp++;
										search++;
										search3++;
										//tdClass = (v_tests.size()==(i+1))?"form_spacing":"formtop_border";
%>
																<tr>
																	<!-- <td class="<%//=tdClass%>">&nbsp;</td> -->
																	<td id="cell_border4" class="head_padding3">&nbsp;(<egui:intnl type="<%=str_stype%>"/>) <egui:intnl test="<%=s_test%>"/></td>
																	<td id="cell_border4" class="head_padding3">&nbsp; <%=server_name%></td>
																	<!-- <td class="<%//=tdClass%>">&nbsp;</td> -->
																</tr>
<%
									}
								}
								else
								{
									String serverName = null;
									if (server_name.endsWith(EgConstants.NULL_PORT))
									{
										serverName = Server.getServerNameWithoutPort(server_name);
									}
									else
									{
										serverName = server_name;
									}
									EgSpecsInfo specs = new EgSpecsInfo("manager");
									boolean isHostTest = specs.isTestRelevantForServer("Host_system",s_test);
									String tempSType = str_stype;
									if(isHostTest)
									{
										tempSType = "";
									}
									//tdClass = (v_tests.size()==(i+1))?"form_spacing":"formtop_border";
									boolean isTestExist = false;
									if(li.contains(str_stype+":"+server_name) || li.contains(str_stype+":"+server_name+":NULL"))
									{
										isTestExist = true;
									}
									if (!isTestExist)
									{
										for (int j=0;j<li.size();j++)
										{
											String tmpServer  = (String)li.get(j);
											if (tmpServer.startsWith(str_stype+":"+server_name+":"))
												isTestExist = true;
										}
									}

									String defaultPattern = s_test + "::" + server_name;
									String specificPattern = s_test + ":" +  str_stype + ":"+ server_name;
									if (defaultPattern.equals((String)v_tests.get(i)))
									{
										if (v_tests.contains(specificPattern))
										{
											isTestExist = false;
										}

										if (isTestExist && listTestSpecifications != null)
										{
											String port = "";
											if (str_stype.equals("Oracle_server"))
											{
												port = "$portNo:$sid";
											}
											else
											{
												port = "$portNo";
											}
											String patternA = s_test + ":" + str_stype + ":" + "$hostName" + ":" + port;
											String patternB = s_test + ":" + str_stype + ":" + "$hostName";
											//while we specify a default pattern test as unconfigured,ensure no specific pattern test is found
											if (listTestSpecifications.contains(patternA) || listTestSpecifications.contains(patternB))
											{
												isTestExist = false;
											}
										}
									}

									//if(li.contains(str_stype+":"+server_name) || li.contains(str_stype+":"+server_name+":NULL"))
									if (isTestExist)
									{
										disp++;
										search++;
										search3++;
										numofUnConfigTest++;
										if(fromAdminDB)
										{
											tmpTestCount++;
											//tdClass = (testCount==tmpTestCount)?"form_spacing":"formtop_border";
										}
%>
																<tr>
																	<!-- <td class="<%//=tdClass%>" style="border-top:1px solid #ffffff">&nbsp;</td> -->
																	<td id="cell_border4" class="head_padding3" style="border-top:1px solid #ffffff">&nbsp; <a class="eg_monlink" href="EgConfigTest.jsp?reqFrom=unConTests&comptype=<%=EgURLEncoder.encode(tempSType,"UTF-8")%>&compname=<%=EgURLEncoder.encode(server_name,"UTF-8")%>&qctr=1&rctr=0&t_name=<%=s_test%>&typeOfServer=<%=EgURLEncoder.encode(str_stype,"UTF-8")%>&showAll=<%=show%>&fromDashboard=<%=fromAdminDB%>&searchString=<%=egTitleSearchStr%>" target="main">(<egui:intnl type="<%=str_stype%>"/>) <egui:intnl test="<%=s_test%>"/></a></td>
																	<td id="cell_border4" class="head_padding3" style="border-top:1px solid #ffffff">&nbsp; <a class="eg_monlink" href="EgConfigTest.jsp?reqFrom=unConTests&comptype=<%=EgURLEncoder.encode(tempSType,"UTF-8")%>&compname=<%=EgURLEncoder.encode(server_name,"UTF-8")%>&qctr=1&rctr=0&t_name=<%=s_test%>&typeOfServer=<%=EgURLEncoder.encode(str_stype,"UTF-8")%>&showAll=<%=show%>&fromDashboard=<%=fromAdminDB%>&searchString=<%=egTitleSearchStr%>" target="main"><%=serverName%></a></td>
																	<!-- <td class="<%//=tdClass%>" style="border-top:1px solid #ffffff">&nbsp;</td> -->
																</tr>
<%
									}
									else
									{
										disp=1;
									}
								}
							}
						}
					}
				}
%>
															</table>
														</td>
													</tr>
												</table>

											</td>
										</tr>
									</table>
								</td>
							</tr>
<script>
	hideFunction('<%=search3%>','<%=c+""+conf%>');
</script>
<%
			}
			if(forConfig == 2)
			{
				showTitle = _configTestTitle;
				v_tests = new Vector(configTestsList);
			}
			if(search3 == 0)
			{
				if(search2 == 0)
					search2 = 0;
			}
			else
				search2 = 1;
			search3 = 0;
		}
		if(numofDisplay==2)
		{
			serType = "other Component types";
		}
		if(search2 == 0)
		{
%>
								<tr>
									<td id="eg_subcontentbg" colspan="4">
										<table border="0" cellspacing="0" cellpadding="4" width="100%">
											<tr>
												<td width="100%" align="center">
													<img src="/final/admin/eg_images/<%=adminSkin%>/exclamation-icon.gif">
												</td>
											</tr>
											<tr>
												<td width="100%" align="center">
													<b><egui:intnl text="admin.unconfig.No unconfigured test(s) found"/>
<%
			if(egTitleSearchStr!=null && egTitleSearchStr.length()>0)
			{
				search = 1;
%>
					<egui:intnl text="admin.unconfig.for your search"/>, "<%=egTitleSearchStr%>"
<%
			}
%>
												</td>
											</tr>
										</table>
									</td>
								</tr>
<%
		}
%>
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%" colspan="2"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td height="15">&nbsp;</td>
	</tr>
<%
		search2 = 0;
	}
%>

<script language="JavaScript1.2">
<%
	if(search==0 && !updateTestPeriod)
	{
		out.println("window.close();");
	}
%>
</script>

<%
	SidCheck check = new SidCheck();
	if(numofUnConfigTest > 35)
	{
		if(s_check != null && s_check.equals("logout"))
		{
			if(check.sidNotConfigured)
			{
%>
	<tr>
		<td width="100%" valign="top">
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0" >
				<tr>
					<td width="100%" valign="top" id="eg_whitebg" align="right" colspan="2" style="padding-bottom:4px">
						<table cellspacing="0" cellpadding="3" border="0" width="100%">
							<tr>
								<td width="82%">&nbsp;</td>
								<td width="18%" id="cell_border1" align="center"><a class="body_link" onclick="javascript:sid_check()" id="mouse" target="_parent"><b><egui:intnl text="admin.unconfig.Proceed to Signout"/></b>&nbsp;<img src="/final/admin/eg_images/arrow.gif" border="0">&nbsp;</a></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table><br><br>
<%
			}
			else
			{
%>
	<tr>
		<td width="100%" valign="top" >
			<table  align="center" width="85%" cellspacing="0" cellpadding="0" border="0" >
				<tr>
					<td width="100%" valign="top" id="eg_whitebg" align="right" colspan="2" style="padding-bottom:4px">
						<table cellspacing="0" cellpadding="3" border="0" width="100%">
							<tr>
								<td width="82%" >&nbsp;</td>
								<td width="18%" id="cell_border1" align="center"><a class="body_link" href="EgLogoutA.jsp?proceed=yes" target="_parent"><b><egui:intnl text="admin.unconfig.Proceed to Signout"/></b>&nbsp;<img src="/final/admin/eg_images/arrow.gif" border="0"></a></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table><br><br>
<%
			}
		}
		else
		{
%>
</table>
<%
		}
	}
	v_tests.clear();
%>

</form>
<!-- show aggregate tests without recommended test period  -->
<%
if(EgInstallInfo.isAggregationSupported() && aggregateTestDetails != null && aggregateTestDetails.size()>0)
{
%>
	<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
		<tr>
			<td>
				<table align="center" cellspacing="0" cellpadding="0" width="85%" id="eg_subcontentbg" border="0">
					<tr>
						<td>
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="padding:0px" >
<%
	if(com.egurkha.util.StringUtils.isNull(s_check))
	{
%>
								<tr>
									<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
									<td id="eg_subheadbg_lower" width="100%"  height="20" align="center" colspan="2"><b><egui:intnl text="admin.unconfig.Aggregate tests not running with recommended test frequency"/></b></td>
									<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
								</tr>
<%
	}
%>
								<tr>
									<td colspan="4" class="space10" width="100%" >
										<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
											<tr>
												<td valign="top" colspan="4" align="center" width="100%" >
													<table border="0" cellspacing="0" cellpadding="0" id="cell_border1" width="90%" >
														<tr>
															<td colspan="2" id="eg_cellbgdark" width="100%" class="head_padding4"><b><egui:intnl text='admin.unconfig.Aggregate tests not running with recommended test frequency'/></b> </td>
														</tr>
														<tr>
															<td height="2px" class="eg_blankspace">&nbsp; <img src="/final/admin/eg_images/spacer.gif" border="0"></td>
														</tr>
														<tr>
															<td height="20" width="60%" align="left" id="cell_border4" class="head_padding3" >&nbsp;&nbsp;<b><egui:intnl text="admin.unconfig.Test"/></b></td>
															<td height="20" width="40%" align="left" id="cell_border4" class="head_padding3" >&nbsp;&nbsp;<b><egui:intnl text="admin.unconfig.Component"/></b></td>
														</tr>
														<tr>
															<td colspan="2" >
																<table border="0" cellspacing="0" cellpadding="0" width="100%" style="table-layout:fixed"><col width="60%"><col width="40%">
		<%
																for(int index=0;index<aggregateTestDetails.size();index++)
																{
																	String value = (String) aggregateTestDetails.get(index);
																	//ProcessAggTest:Agg_Generic_server:aggGen:NULL
																	String tokens[] = com.egurkha.util.StringUtils.getTokens(value,":");
		%>
																	<tr>
																		<td id="cell_border4" class="head_padding3">&nbsp;<a target="main" class="eg_monlink" href='/final/admin/updateTestPeriod.jsp?test_component=<%=value%>'>(<egui:intnl type="<%=tokens[1]%>"/>) <egui:intnl test="<%=tokens[0]%>"/></a></td>
																		<td id="cell_border4" class="head_padding3">&nbsp;<a target="main" class="eg_monlink" href='/final/admin/updateTestPeriod.jsp?test_component=<%=value%>'><%=tokens[2]%></a></td>
																	</tr>
		<%
																	}
		%>
																</table>
															</td>
														</tr>
													</table>

												</td>
											</tr>
										</table>
									</td>
								</tr>
								<tr>
									<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
									<td height="6" id="eg_subcontentbg" width="100%" colspan="2"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
									<td height="6" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td height="15">&nbsp;</td>
		</tr>
	</table>
<%
}
%>
<!-- show aggregate tests without recommended test period  -->
</body>
</html>
<%!
	private boolean doesExist(List searchList, String s_test)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (s_test.indexOf(nextStr)!=-1||(s_test.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
			{
				return true;
			}
		}
		return false;
	}
	private ArrayList getGroupOfTests(Vector allTests, int flag)
	{
		ArrayList result = new ArrayList();
		boolean checkIdx = false;
		for(int i=0;i<allTests.size();i++)
		{
			String test = (String)allTests.get(i);
			checkIdx = !(test.indexOf("_cf:") > 0);
			if(flag == 1)
				checkIdx = !checkIdx;
			if(checkIdx && !result.contains(test))
				result.add(test);
		}
		return result;
	}
%>



