<%
/***********************************************************************************
*	Name			:EgToolKitUI.jsp
***********************************************************************************/
%>

<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.admin.EgToolKitInfo"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.Iterator"%>
<%@ page import="java.util.LinkedHashMap"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	String session_status = com.egurkha.admin.EgToolKitInfo.getSessionStatus(session);
	if(session_status.equalsIgnoreCase("active"))
	{
		String sessionInUse = request.getParameter("sessionInUse");
		if(sessionInUse == null)
		{
			String redirectPage = (String)session.getAttribute("treeViewSrc");
			if(redirectPage == null || redirectPage.length() ==0)
			{
				redirectPage = "HomePage";
			}
			session.setAttribute("reqFromForTk",redirectPage);
			String redirectURL = request.getContextPath()+"/toolkit";
			response.sendRedirect(redirectURL);
		}
	}
	else
	{
		response.sendRedirect(request.getContextPath()+"/toolkitlogin");
	}
	
	String reqFrom = request.getParameter("reqFrom");	
	String tools = egurkha.EgUIUtils.encodeSecurityChar(request.getParameter("tools"));
	if (tools == null || tools.equalsIgnoreCase("null"))
	{
		Object toolsObj = session.getAttribute("tools");
		if (toolsObj != null)
		{
			tools = com.eg.EgURLDecoder.decode((String)toolsObj,"UTF-8");
		}
	}
	else
	{
		tools = com.eg.EgURLDecoder.decode(tools,"UTF-8");
	}
	
	EgToolKitInfo tkInfo = new EgToolKitInfo();
	String profileName = (String)session.getAttribute("tkProfileName");
	String display = tkInfo.getDisplayExpColButton(profileName);
	LinkedHashMap menuDynamicMap = new LinkedHashMap();
	
	String profileType = tkInfo.getProfileType(profileName);
	if(profileType.equalsIgnoreCase("Custom"))
	{
		menuDynamicMap = tkInfo.getCustomProfileMenuItems(profileName);
	}
	else if(profileType.equalsIgnoreCase("All"))
	{
		ArrayList optionList = new ArrayList();
		optionList.add("ConfigProfile");
		menuDynamicMap = tkInfo.getDynamicMenuMap(optionList,true);
	}
	else if(profileType.equalsIgnoreCase("Default"))
	{
		menuDynamicMap = tkInfo.getDynamicMenuMap(StringUtils.egTokenizer(tools,","));
	}

	String highLightNode = "";
	String highLightURL = "";
	if(reqFrom != null)
	{
		String[] highLight = tkInfo.getNodeURLTokens(reqFrom,true);
		if(highLight != null && highLight.length >1)
		{
			highLightNode = highLight[0];
			highLightURL = highLight[1];
		}
	}
%>

<html>
<head>
<title>
</title>
<LINK href="/final/admin/eg_styles/adminstyle_blue.css" type="text/css" rel="stylesheet">
<script language="javascript" src="/final/admin/eg_scripts/DiagnosisTree.js"></script>
</head>
<body style="overflow:auto;" class="padding4" scrolling="auto" >
	<table border="0" style="background-color:#E7EAF4;width:100%;padding:5px" cellpadding="0" cellspacing="0">
		<tr>
			<td align="center" style="display:<%=display%>"><a class="eg_adminlink" href="javascript:void(0);" onclick="d.oAll(true);">Expand All</a></td>
			<td align="center" style="display:<%=display%>">|</td>
			<td align="center" style="display:<%=display%>"><a class="eg_adminlink" href="javascript:void(0);" onclick="d.oAll(false);">Collapse All</a></td>
			<td align="center" style="display:<%=display%>">|</td>
			<td align="center"><a class="eg_adminlink" href="javascript:void(0);" onclick="signout();">Signout</a></td>
		</tr>
	</table>
	<div id="treeDiv">
	<script type="text/javascript">
	var d = new dTree('d');
	d.add('0','-1','TROUBLESHOOTING TOOLKIT','','TROUBLESHOOTING TOOLKIT','MonitorView','','',true,-1);
<%
	int node = 1;
	Iterator menuItr = menuDynamicMap.keySet().iterator();
	while(menuItr.hasNext())
	{
		String header = (String)menuItr.next();
		ArrayList list = (ArrayList)menuDynamicMap.get(header);
		String sub_menu = (String)list.get(0);
		String[] tokens = tkInfo.getNodeURLTokens(header);
		if(tokens == null || tokens.length <=1)
		{
			continue;
		}
		String display_menu = tokens[0];
		String menu_URL = tokens[1];
		
		if(header.equalsIgnoreCase(sub_menu))
		{
%>
			d.add('<%=String.valueOf(node++)%>','0','<%=display_menu%>','<%=menu_URL%>','<%=display_menu%>','MonitorView');
<%	
		}
		else
		{
%>
			d.add('<%=String.valueOf(node++)%>','0','<%=display_menu%>','','<%=display_menu%>','MonitorView','','',true,-1);
<%
			String link = String.valueOf(node-1);
			for(int i=0;i<list.size();i++)
			{
				sub_menu = (String)list.get(i);
				tokens = tkInfo.getNodeURLTokens(sub_menu);
				if(tokens == null || tokens.length <=1)
				{
					continue;
				}
				display_menu = tokens[0];
				menu_URL = tokens[1];
%>
				d.add('<%=String.valueOf(node++)%>','<%=link%>','<%=display_menu%>','<%=menu_URL%>','<%=display_menu%>','MonitorView');
<%
			}
		}
	}
%>
	document.write(d);
	if('<%=highLightNode.length() >0%>' == 'true' && '<%=highLightURL.length() >0%>' == 'true')
	{
		d.highlightNodeByProcess('<%=highLightNode%>');
		parent.frames[1].location.href = '<%=highLightURL%>';
	}
	
	function signout()
	{
		var form = document.createElement('form');
		form.setAttribute('target','_parent');
		form.setAttribute('method','post');
		form.setAttribute('action','/final/toolkitlogin');

		var hiddenField = document.createElement('input');
		hiddenField.setAttribute('type','hidden');
		hiddenField.setAttribute('name','fromSignOut');
		hiddenField.setAttribute('value','true');
		form.appendChild(hiddenField);
		document.body.appendChild(form);
		form.submit();
	}
	</script>
	</div>
</body>
</html>



