<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>

<%@ page import = "egurkha.ServiceBean"%>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "net.sf.json.JSONObject"%>

<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<jsp:useBean id="DiscBean" scope="page" class="egurkha.ServiceBean"/>

<%
/*
*	Processing page for Netscaler node in Discovery tree.
*	ini File : eg_services.ini, subject : NETSCALER
*/
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();

	EgDiscInfo discInfo = new EgDiscInfo("manager");

	String cloudDirectory = "VCLOUD_DIRECTOR";

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Discovery");

	String ipLabel = "vCloud Director Cell (IP or Host name)";
	String sslLabel = "Use SSL to connect to vCloud Director Cell";
	String discoverLabel = "Discover ESX hosts\\vCenters using this vCloud Director Cell";
	String vmLabel = "Discover Virtual Machines hosts using vCloud Director Cell";
	String userLabel = "Username to connect to vCloud Director Cell";
	String pwdLabel = "Password for the user";

	String from = request.getParameter("from");
	String ip = request.getParameter("ip");	
	String ssl = request.getParameter("ssl");
	String discover = request.getParameter("discover");
	String vm = request.getParameter("vm");
	String user = request.getParameter("user");
	String pwd = request.getParameter("pwd");

	rootJson.put("success","false");
	
	if(from != null && from.equalsIgnoreCase("addvClouds"))
	{
		auditLogThread.setValue("Activity","Add vCloud discovery");
		if(ip != null && ip.length() > 0)
		{
			ssl = (ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))? "Yes" :"No";
			discover = (discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))? "Yes" :"No";
			vm = (vm != null && (vm.equalsIgnoreCase("Yes") || vm.equalsIgnoreCase("True")))? "Yes" :"No";

			pwd = EgCrypt.encrypt(pwd);

			String value = ssl + "#" +  user + "#" + pwd + "#" + discover + "#" + vm;
			IniFile services = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			services.setValue(cloudDirectory,ip,value);
			services.saveFile();
			EgConfigFilesSync.releaseInstance(services);

			auditLogThread.setCurrentValue("00~~"+ipLabel,ip);
			auditLogThread.setCurrentValue("01~~"+sslLabel,ssl);
			auditLogThread.setCurrentValue("02~~"+discoverLabel,discover);
			auditLogThread.setCurrentValue("03~~"+vmLabel,vm);
			auditLogThread.setCurrentValue("04~~"+userLabel,user);
			auditLogThread.setCurrentValue("05~~"+pwdLabel,"*****");

			auditLogThread.setValue("Description","vCloud Director preferences have been added successfully");
			auditLogThread.sendItToDB();
			
			DiscBean.createAdmin();
			String autoManage = DiscBean.getAutomanage();
			autoManage = (autoManage == null || autoManage.length() == 0)?"No":autoManage;
			EgDiscoveryAutoManager autoManagerDisc = new EgDiscoveryAutoManager();
			String discovery = request.getParameter("discovery");
			String vmdiscovery = request.getParameter("vm");
			if(discovery != null && (discovery.equalsIgnoreCase("true") || vmdiscovery.equalsIgnoreCase("true")))
			{
				//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
				IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
				ServiceBean serviceBean = new ServiceBean();
				serviceBean.stopDiscovery();
				serviceBean.startDiscovery("10",true);
				EgConfigFilesSync.releaseInstance(infraIni);
				if (autoManage.equalsIgnoreCase("yes") || autoManage.equalsIgnoreCase("true"))
				{
					DiscoveryLicenseController.sesstionID = request.getSession().getId();
					DiscoveryLicenseController.userID = _user.getLoginID();
					autoManagerDisc.startAutoManager();
				}
			}

			rootJson.put("success","true");

		}
	}
	else if(from != null && from.equalsIgnoreCase("modifyvClouds"))
	{
		auditLogThread.setValue("Activity","Modify vCloud discovery");
		if(ip != null && ip.length() > 0)
		{
			String $_ssl = request.getParameter("$_ssl");			
			String $_discover = request.getParameter("$_discover");
			String $_vm = request.getParameter("$_vm");
			String $_user = request.getParameter("$_user");
			String $_pwd = request.getParameter("$_pwd");

			boolean setAudit = false;
			boolean updateAgents = false;

			if($_ssl != null && !$_ssl.equalsIgnoreCase(ssl))
			{
				auditLogThread.setPreviousValue("00~~"+sslLabel,$_ssl);
				auditLogThread.setCurrentValue("00~~"+sslLabel,ssl);
				setAudit = true;
				updateAgents = true;
			}

			if($_discover != null && !$_discover.equalsIgnoreCase(discover))
			{
				auditLogThread.setPreviousValue("01~~"+discoverLabel,$_discover);
				auditLogThread.setCurrentValue("01~~"+discoverLabel,discover);
				setAudit = true;
			}
			
			if($_vm != null && !$_vm.equalsIgnoreCase(vm))
			{
				auditLogThread.setPreviousValue("02~~"+vmLabel,$_vm);
				auditLogThread.setCurrentValue("02~~"+vmLabel,vm);
				setAudit = true;
			}

			if($_user != null && !$_user.equalsIgnoreCase(user))
			{
				auditLogThread.setPreviousValue("03~~"+userLabel,$_user);
				auditLogThread.setCurrentValue("03~~"+userLabel,user);
				setAudit = true;
				updateAgents= true;
			}

			if($_pwd != null && !$_pwd.equalsIgnoreCase(pwd))
			{
				auditLogThread.setPreviousValue("04~~"+pwdLabel,"*****");
				auditLogThread.setCurrentValue("04~~"+pwdLabel,"********");
				setAudit = true;
				updateAgents = true;
			}

			ssl = (ssl != null && (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True")))? "Yes" :"No";

			discover = (discover != null && (discover.equalsIgnoreCase("Yes") || discover.equalsIgnoreCase("True")))? "Yes" :"No";
			
			vm = (vm != null && (vm.equalsIgnoreCase("Yes") || vm.equalsIgnoreCase("True")))? "Yes" :"No";

			pwd = EgCrypt.encrypt(pwd);

			String value = ssl + "#" +  user + "#" + pwd + "#" + discover + "#" + vm;			
			
			IniFile services = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			services.setValue(cloudDirectory,ip,value);
			services.saveFile();
			EgConfigFilesSync.releaseInstance(services);

			auditLogThread.setValue("Description","vCloud Director for "+ip+" preferences have been modified successfully");
			auditLogThread.sendItToDB();

			if(updateAgents)
			{
				boolean managedState = false;
				String[] netScalerComps = discInfo.getAllServersOfType("vCloud_director");
				for (int i = 0; i < netScalerComps.length; i++)
				{
					String nsComp = netScalerComps[i];
					if(nsComp.startsWith("Format") || nsComp.startsWith("#"))
						continue;
					String nsCompValue[] = discInfo.getFieldValuesForServer("vCloud_director",nsComp);
					ArrayList ncCompValueList = new ArrayList();
					for (int j = 0; j < nsCompValue.length; j++)
					{
						ncCompValueList.add(nsCompValue[j].toLowerCase());
					}
					if(ncCompValueList.contains(ip.toLowerCase()))
					{
						EgExternalInfo externalInfo = new EgExternalInfo("manager");
						String ns = nsComp.substring(nsComp.indexOf(":")+1);
						ns = ns.substring(0,ns.indexOf(":"));
						List agents = externalInfo.getAgentsForHost(ns);
						if(agents != null)
						{
							IniFile agentIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
							for(int k = 0; k < agents.size(); k++)
							{
								String agent = (String) agents.get(k);
								String[] agentTests = agentIni.getVariables(agent);
								if(agentTests != null)
								{
									for(int l = 0; l < agentTests.length; l++)
									{
										String testNameVar = agentTests[l];
										String testValue = agentIni.getValue(agent,testNameVar);

										if(testValue.indexOf("-vCloud_director_user") > -1)
										{
											String host = testValue.substring(testValue.indexOf("-host")+5).trim();
											host = host.substring(0,host.indexOf(" -vCloud_director_user")).trim();
											String testVarLower = testNameVar.toLowerCase();

											if(testVarLower.indexOf(":"+ip.toLowerCase()+":") > 0 || 
												testVarLower.endsWith(":"+ip.toLowerCase()) || 
												host.equalsIgnoreCase(ip))
											{
												int unLen = "-vCloud_director_user".length();
												if(testValue.indexOf("-vCloud_director_user") > -1)
												{
													String value1 = testValue.substring(0,testValue.indexOf("-vCloud_director_user")+unLen).trim();
													String value2 = testValue.substring(testValue.indexOf("-vCloud_director_user")+unLen).trim();
													value2 = value2.substring(value2.indexOf(" ")).trim();
													testValue = value1+" "+user+" "+value2;
												}

												int pwdLen = "-vCloud_director_pass".length();
												if(testValue.indexOf("-vCloud_director_pass") > -1)
												{
													String value1 = testValue.substring(0,testValue.indexOf("-vCloud_director_pass")+pwdLen).trim();
													String value2 = testValue.substring(testValue.indexOf("-vCloud_director_pass")+pwdLen).trim();
													value2 = value2.substring(value2.indexOf(" ")).trim();
													testValue = value1+" "+pwd+" "+value2;
												}

												int sslLen = "-ssl".length();
												if(testValue.indexOf("-ssl") > -1)
												{
													String value1 = testValue.substring(0,testValue.indexOf("-ssl")+sslLen).trim();
													String value2 = testValue.substring(testValue.indexOf("-ssl")+sslLen).trim();
													value2 = value2.substring(value2.indexOf(" ")).trim();
													ssl = (ssl.equalsIgnoreCase("Yes") || ssl.equalsIgnoreCase("True"))? "true" :"false";
													testValue = value1+" "+ssl+" "+value2;
												}
												agentIni.setValue(agent,testNameVar,testValue);
											}
										}
									}
								}
							}
							agentIni.saveFile();
							EgConfigFilesSync.releaseInstance(agentIni);
						}
					}
				}
			}

			DiscBean.createAdmin();
			String autoManage = DiscBean.getAutomanage();
			autoManage = (autoManage == null || autoManage.length() == 0)?"No":autoManage;
			EgDiscoveryAutoManager autoManagerDisc = new EgDiscoveryAutoManager();
			String discovery = request.getParameter("discovery");
			String vmdiscovery = request.getParameter("vm");
			if(discovery != null && (discovery.equalsIgnoreCase("true") || vmdiscovery.equalsIgnoreCase("true")))
			{
				//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
				IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
				ServiceBean serviceBean = new ServiceBean();
				serviceBean.stopDiscovery();
				serviceBean.startDiscovery("10",true);
				EgConfigFilesSync.releaseInstance(infraIni);
				if (autoManage.equalsIgnoreCase("yes") || autoManage.equalsIgnoreCase("true"))
				{
					DiscoveryLicenseController.sesstionID = request.getSession().getId();
					DiscoveryLicenseController.userID = _user.getLoginID();
					autoManagerDisc.startAutoManager();
				}
			}

			rootJson.put("success","true");
		}
	}
	else if(from != null && from.equalsIgnoreCase("delvClouds"))
	{
		auditLogThread.setValue("Activity","Delete vCloud discovery");

		boolean success = false;
		boolean managedState = false;

		String vCloudIPs = request.getParameter("vclouds");		
		ArrayList allCompFieldLists = new ArrayList();
		ArrayList dontDelete = new ArrayList();
		if(vCloudIPs != null && vCloudIPs.length() > 0)
		{
			IniFile discFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini");
			IniFile services = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			IniFile netscalerMapping = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_netscalermapping.ini");

			String[] vClouds = discFile.getVariables("vCloud_director");
			if(vClouds != null)
			{
				for(int i = 0; i < vClouds.length; i++)
				{
					String vCloud = vClouds[i];
					if(vCloud.startsWith("#") || vCloud.startsWith("Format"))
						continue;
					String fieldValue = discFile.getValue("vCloud_director",vCloud);
					StringTokenizer st = new StringTokenizer(fieldValue,",");
					while(st.hasMoreTokens())
					{
						allCompFieldLists.add(st.nextToken());
					}
				}
			}

			StringTokenizer st = new StringTokenizer(vCloudIPs,",");
			while(st.hasMoreTokens())
			{
				String netIP = st.nextToken();
				if(allCompFieldLists.contains(netIP))
				{
					dontDelete.add(netIP);
				}
				else
				{
					services.deleteValue(cloudDirectory,netIP);
					netscalerMapping.deleteSubject(netIP);

					auditLogThread.setCurrentValue("Deleted vCloud Director IP/Host",netIP);
					success = true;
				}
			}
			services.saveFile();
			netscalerMapping.saveFile();

			EgConfigFilesSync.releaseInstance(services);
			EgConfigFilesSync.releaseInstance(netscalerMapping);

			if(success)
			{
				auditLogThread.setCurrentValue("ColumnName","Deleted vCloud");
				auditLogThread.setValue("Description","The vCloud Director IP/Hosts have been deleted");
				auditLogThread.sendItToDB();
			}

			if(dontDelete.size() == 0)
			{
				if(success)
				{
					rootJson.put("requestStatus","success");

					JSONObject resultMsg = new JSONObject();
					resultMsg.put("title",_mapping.getTextDescription("admin.discovery.NetScaler Settings"));
					resultMsg.put("message1",_mapping.getTextDescription("admin.discovery.vCloud Director(s) deleted successfully"));
					rootJson.put("result",resultMsg);
				}
				else
				{
					rootJson.put("requestStatus","failed");

					JSONObject errorObj = new JSONObject();
					errorObj.put("title",_mapping.getTextDescription("admin.discovery.NetScaler Settings"));
					errorObj.put("message1",_mapping.getTextDescription("admin.discovery.Error in vCloud Director(s) deletion"));
					rootJson.put("errors",errorObj);
				}
			}
			else
			{
				String dontDeleteStr = dontDelete.toString();
				dontDeleteStr = dontDeleteStr.substring(1,dontDeleteStr.length() -1);
				rootJson.put("requestStatus","failed");

				JSONObject errorObj = new JSONObject();
				errorObj.put("title",_mapping.getTextDescription("admin.discovery.NetScaler Settings"));
				errorObj.put("message1",_mapping.getTextDescription("admin.discovery.You cannot delete the following")+" NetScalers "+dontDeleteStr+". "+_mapping.getTextDescription("admin.discovery.One/more tests have been configured to use on this NetScaler Server"));
				rootJson.put("errors",errorObj);
			}
		}
	}

	out.println(rootJson.toString());

%>

