<%
/*******************************************************************************
*	Name					:	EgReportSettingJSON.jsp
*	Purpose					:	Code to allow the user to enable/disable tests for										capacity planning and associate percentile policy,
								report view for its measures.
*	Version					:	6.0
*	Creation Date			:	01/07/2013
*	Modified Date			:	
*	Author					:	Abdul Khader
*******************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgRoleInfo" %>

<%@ page import="com.eg.MappingNameSorter" %>

<%@ page import="com.egurkha.ini.IniUI" %>

<%@ page import="com.eg.EgName" %>

<%@ page import="com.eg.EgSpecsInfo" %>

<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="net.sf.json.*" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>



<%
	JSONObject rootJson = new JSONObject();
	JSONObject capacityEnabledJson = new JSONObject();
	JSONObject measureNameJson = new JSONObject();
	JSONObject measureNameBeforeMapJson = new JSONObject();

	JSONArray compTypeArrayJson = new JSONArray();
	JSONArray measureNameArrayJson = new JSONArray();
	JSONArray testsArrayJson = new JSONArray();
	JSONArray percentilePolicyArrayJson = new JSONArray();
	JSONArray minMaxArrayJson = new JSONArray();
	JSONArray selectedPercentilePolicyArrayJson = new JSONArray();
	JSONArray selectedReportViewArrayJson = new JSONArray();
	JSONArray dataForGridArray = new JSONArray();

	ArrayList percentilePolicyArray = new ArrayList();

	IniUI iniUI = IniUI.getInstance();

	String userLanguage = iniUI.getDefaultLanguage();

	if (_user != null)

	{

		userLanguage = _user.getLanguage();

	}

	MappingNameSorter sorter = new MappingNameSorter(userLanguage);



	//tells information about the corresponding authenticated user
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));

	List listComponentTypes = Arrays.asList(ri.getServerTypes());
	listComponentTypes = sorter.getSortedCompTypeList(listComponentTypes);

	IniFile tablesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tables.ini");

	IniFile servicesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

	IniFile testsIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");

	IniFile reportIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_report.ini");



	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

	EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");


	String[] capacityTestsDetails = testsIniFile.getVariables("CAPACITY_TESTS");
	ArrayList aListCapacityTestsEnabled = new ArrayList();
	ArrayList aListCapacityTestsDisabled = new ArrayList();
	for (int i=0;i<capacityTestsDetails.length;i++)
	{
		String strCapacityTestDetail = capacityTestsDetails[i];
		String strValue = testsIniFile.getValue("CAPACITY_TESTS",strCapacityTestDetail);
		if (strValue.equalsIgnoreCase("yes") || 
			strValue.equalsIgnoreCase("true") || 
			strValue.equalsIgnoreCase("y"))
		{
			aListCapacityTestsEnabled.add(strCapacityTestDetail);
		}
		else
		{
			aListCapacityTestsDisabled.add(strCapacityTestDetail);
		}
	}

	String componentType = request.getParameter("componentType");
	componentType = (componentType == null || componentType.equals("-1"))?"":componentType;

	String previousComponentType = request.getParameter("previousComponentType");
	previousComponentType = (previousComponentType == null)?"":previousComponentType;

	String testName = request.getParameter("testName");
	testName = (testName != null && !testName.equals("-1"))?testName:"";

	String previousTestName = request.getParameter("previousTestName");
	previousTestName = (previousTestName != null && !previousTestName.equals("-1"))?previousTestName:"";

	ArrayList aListEnabledTestForCompType = new ArrayList();
	if (!componentType.equals(""))
	{
		aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
	}

	String showAllTests = "selected";
	String showCETests = "";
	String cpctEnabledTest = request.getParameter("cpctEnabledTest");
	if (aListEnabledTestForCompType != null && aListEnabledTestForCompType.size() > 0)
	{
		if (cpctEnabledTest != null && cpctEnabledTest.equalsIgnoreCase("true"))
		{
			showAllTests = "";
			showCETests = "selected";

			ArrayList aListTemp = new ArrayList();
			for (int i=0;i<aListEnabledTestForCompType.size();i++)
			{
				String str = (String)aListEnabledTestForCompType.get(i);
				if (aListCapacityTestsEnabled.contains(str))
				{
					aListTemp.add(str);
				}
			}

			aListEnabledTestForCompType = aListTemp;
		}
	}

	String capacityTestStatus = request.getParameter("capacityTestStatus");
	if (!testName.equals("") && !previousTestName.equals(""))
	{
		if (!testName.equals(previousTestName))
		{
			capacityTestStatus = null;
		}
	}

	if (componentType.equals(""))
	{
		testName = "";
	}

	if (!componentType.equals("") && !previousComponentType.equals(""))
	{
		if (!previousComponentType.equals(componentType))
		{
			testName = "";
		}
		else if (!aListCapacityTestsEnabled.contains(testName))
		{
			if (cpctEnabledTest != null && cpctEnabledTest.equalsIgnoreCase("true"))
			{
				testName = "";
			}
		}
	}

	if (aListEnabledTestForCompType != null && aListEnabledTestForCompType.size() > 0)
	{
		aListEnabledTestForCompType = sorter.getSortedTestList(aListEnabledTestForCompType);
	}

	String[] measureLayerTable = tablesIniFile.getVariables("MEASUREMENT_LAYER_TABLE");

	int tableSize = measureLayerTable.length;

	TreeMap tmapTestAndMeasures = new TreeMap();

	for (int i=0;i<tableSize;i++)

	{

		String strPattern = measureLayerTable[i];

		int colonIdx = strPattern.indexOf(":");

		String strTestName = strPattern.substring(0,colonIdx);

		String strTestMeasure = strPattern.substring(colonIdx+1);

		ArrayList aListTemp = (ArrayList)tmapTestAndMeasures.get(strTestName);

		if (aListTemp == null)

		{

			aListTemp = new ArrayList();

			aListTemp.add(strTestMeasure);

			tmapTestAndMeasures.put(strTestName,aListTemp);

		}

		else

		{

			aListTemp.add(strTestMeasure);

		}

	}



	String[] testMeasuresValues = thresholdInfo.getMeasurementsForTest(testName);

	ArrayList aListMeasures = null;

	if (testMeasuresValues != null)

	{

		aListMeasures = new ArrayList(Arrays.asList(testMeasuresValues));

	}



	String[] percentiles = servicesIniFile.getVariables("CAPACITY_PLANNING_PERCENTILE");

	ArrayList aListPercentiles = null;

	if (testName.length() > 0 && aListMeasures != null)

	{

		aListPercentiles = new ArrayList(Arrays.asList(percentiles));

	}


	ArrayList aListResultantDetails = null;
	if (aListMeasures != null && testName.length() > 0)
	{
		aListResultantDetails = new ArrayList();

		for (int i=0;i<aListMeasures.size();i++)
		{
			String strMeasure = (String)aListMeasures.get(i);
			String tempValue = testsIniFile.getValue("CAPACITY_PLANNING_PERCENTILE",testName + ":" + strMeasure);

			String strPercentileValue = null;
			String strReportView = null;
			if (tempValue == null || tempValue.length() == 0)
			{
				strPercentileValue = "Default";
				strReportView = "XP";
			}
			else
			{
				strPercentileValue = tempValue;
				strReportView = reportIniFile.getValue("CAPACITY_PLANNING",testName + ":" + strMeasure);
				if (strReportView == null || strReportView.length() == 0)
				{
					strReportView = "XP";
				}
			}

			aListResultantDetails.add(strMeasure);
			aListResultantDetails.add(strPercentileValue);
			aListResultantDetails.add(strReportView);
		}

		session.setAttribute("aListMeasures",aListMeasures);
	}

%>
<%
	if (listComponentTypes.size() > 0)
	{
%>
<%
	}
	else
	{
%>
<%
	}
	//EgName class is used to hold name and its localised name.
	for (int j=0; j<listComponentTypes.size(); j++)
	{
		JSONObject compTypeObj = new JSONObject();
		EgName nameObj = (EgName)listComponentTypes.get(j);
		String actualname = nameObj.getActualName();
		String localname = nameObj.getLocalName();
		if (j == 0)
		{
			compTypeObj.put("displayField","Choose a component type");
			compTypeObj.put("valueField","Choose a component type");
			compTypeArrayJson.add(compTypeObj);
		}
		compTypeObj.put("displayField",localname);
		compTypeObj.put("valueField",actualname);
		compTypeArrayJson.add(compTypeObj);
		if (actualname.equals(componentType))
		{
%>
<%
		}
		else
		{
%>
<%
		}
	}
%>
<%

	if (aListEnabledTestForCompType.size() > 0)
	{

%>
<%

	}
	else

	{

%>
<%

	}


	//EgName class is used to hold name and its localised name.

	for (int j=0; j<aListEnabledTestForCompType.size(); j++)
	{
		JSONObject enabledTestObj = new JSONObject();

		EgName nameObj = (EgName)aListEnabledTestForCompType.get(j);

		String strTestName = nameObj.getActualName();

		if (j == 0)
		{
			/*enabledTestObj.put("valueField","Not Applicable");
			enabledTestObj.put("displayField","Not Applicable");
			testsArrayJson.add(enabledTestObj);*/
			enabledTestObj.put("valueField","Choose a test");
			enabledTestObj.put("displayField","Choose a test");
			testsArrayJson.add(enabledTestObj);
		}
		enabledTestObj.put("valueField",strTestName);

		String strTestDisplayValue = nameObj.getLocalName();
		enabledTestObj.put("displayField",strTestDisplayValue);

		testsArrayJson.add(enabledTestObj);

		if (testName != null && strTestName.equals(testName))
		{

%>
<%

		}
		else
		{

%>
<%

		}
	}

%>
<%
	if (aListPercentiles != null && aListPercentiles.size() > 0)
	{
		for (int j=0; j<aListPercentiles.size(); j++)
		{
			JSONObject percentileObj = new JSONObject();
			String strPercentile = (String)aListPercentiles.get(j);
			percentileObj.put("displayField",strPercentile);
			percentileObj.put("valueField",strPercentile);
			if (!percentilePolicyArray.contains(strPercentile))
			{
				percentilePolicyArray.add(strPercentile);
			}
		}

		for (int j=0; j<percentilePolicyArray.size(); j++)
		{
			JSONObject percentileObj = new JSONObject();
			String strPercentile = (String)percentilePolicyArray.get(j);
			percentileObj.put("displayField",strPercentile);
			percentileObj.put("valueField",strPercentile);
			percentilePolicyArrayJson.add(percentileObj);
		}
	}

	if (testName.length() > 0)
	{
%>
<%
		String strEnabled = "";
		String strDisabled = "";
		if (capacityTestStatus == null)
		{
			if (aListCapacityTestsEnabled.contains(testName))
			{
				strEnabled = "checked";
				strDisabled = "";
			}
			else
			{
				strEnabled = "";
				strDisabled = "checked";
			}
		}
		else
		{
			if (capacityTestStatus.equals("yes"))
			{
				strEnabled = "checked";
				strDisabled = "";
			}
			else
			{
				strEnabled = "";
				strDisabled = "checked";
			}
		}
		capacityEnabledJson.put("strEnabled",strEnabled);
		capacityEnabledJson.put("strDisabled",strDisabled);
%>
<%
		if (aListMeasures != null && aListMeasures.size() > 0)
		{
			
%>
<%
			for (int i=0;i<aListMeasures.size();i++)
			{
				JSONObject gridDataObj = new JSONObject();
				JSONObject measureObj = new JSONObject();
				String strMeasure = (String)aListMeasures.get(i);
				measureNameBeforeMapJson.put("strMeasure",strMeasure);
				String strDisplayValue = _mapping.getMeasureDescription(testName,strMeasure);
				measureObj.put("displayField",strDisplayValue);
				measureObj.put("valueField",strMeasure);
				measureNameArrayJson.add(measureObj);
				gridDataObj.put("Measures",strDisplayValue);
				measureNameJson.put("measureName",strDisplayValue);
				int idx1 = aListResultantDetails.indexOf(strMeasure);
				String tempPercentile = null;
				String tempReportView = null;
				if (idx1 > -1)
				{
					tempPercentile = (String)aListResultantDetails.get(idx1+1);
					tempReportView = (String)aListResultantDetails.get(idx1+2);
				}

				if (tempPercentile == null)
				{
					tempPercentile = "Default";
				}

				if (tempReportView == null)
				{
					tempReportView = "XP";
				}
%>
<%
				if (strDisabled.equalsIgnoreCase("checked"))
				{
%>
<%
				}
				else
				{
					if (i == 0)
					{
						if (aListMeasures.size() == 1)
						{
%>
<%
						}
						else
						{
%>
<%
						}
					}
					else
					{
%>
<%
					}
				}
				if (aListPercentiles == null || aListPercentiles.size() == 0)
				{
%>
<%
				}
				else
				{
					for (int j=0; j<aListPercentiles.size(); j++)
					{
						//JSONObject percentileObj = new JSONObject();
						String strPercentile = (String)aListPercentiles.get(j);
						//percentileObj.put("displayField",strPercentile);
						//percentileObj.put("valueField",strPercentile);
						//percentilePolicyArrayJson.add(percentileObj);
						if (tempPercentile.equals(strPercentile))
						{
							selectedPercentilePolicyArrayJson.add(tempPercentile);
							gridDataObj.put("Policy",strPercentile);
%>
<%
						}
						else
						{
%>
<%
						}
					}
				}
%>
<%
				if (strDisabled.equalsIgnoreCase("checked"))
				{
%>
<%
				}
				else
				{
%>
<%
				}
				if (tempReportView.equalsIgnoreCase("XP"))
				{
					selectedReportViewArrayJson.add("Maximum");
					gridDataObj.put("reportView","Maximum");
%>
<%
				}
				else
				{
					selectedReportViewArrayJson.add("Minimum");
					gridDataObj.put("reportView","Minimum");
%>
<%
				}
%>
<%
				dataForGridArray.add(gridDataObj);
			}
%>
<%
		}
%>
<%
	}
%>
<%
	String from = "";
	//session.setAttribute("showOnly","configTests");
	if(testName != null && testName.length() > 0)
	{
		//session.setAttribute("componentType",componentType);
		//session.setAttribute("cpctEnabledTest",cpctEnabledTest);
		//session.setAttribute("testName",testName);
		from = "/final/admin/EgReportSetting.jsp?componentType="+componentType+"&cpctEnabledTest="+cpctEnabledTest+"&testName="+testName;
		session.setAttribute("adminLastAccessedURL","/final/admin/EgReportCustomSetting.jsp?showOnly=2&from="+from);
	}
	else
	{
		from = "/final/admin/EgReportSetting.jsp";
		session.setAttribute("adminLastAccessedURL","/final/admin/EgReportCustomSetting.jsp?showOnly=2&from="+from);
		//session.setAttribute("showOnly","configTests");
	}

	rootJson.put("capacityEnabledJson",capacityEnabledJson);
	rootJson.put("compTypeArrayJson",compTypeArrayJson);
	rootJson.put("testsArrayJson",testsArrayJson);
	rootJson.put("measureNameJson",measureNameJson);
	rootJson.put("measureNameArrayJson",measureNameArrayJson);
	rootJson.put("percentilePolicyArrayJson",percentilePolicyArrayJson);
	rootJson.put("measureNameBeforeMapJson",measureNameBeforeMapJson);
	rootJson.put("selectedPercentilePolicyArray",selectedPercentilePolicyArrayJson);
	rootJson.put("selectedReportViewArray",selectedReportViewArrayJson);
	rootJson.put("dataForGridArray",dataForGridArray);

	out.println(rootJson);
%>



