<%
/*******************************************************************************
*       Name            :       EgExtrnlMonitorProcess.jsp
*       Purpose         :       This jsp is used to process(add/delete) external monitor
*       Version         :       6.0
*       CreationDate    :       26/06/2013
*       LastModified    :       26/06/2013
*       Author          :       Abdul Khader
*       Location        :       /final/admin/EgExternalMonitors/data/EgExtrnlMonitorProcess.jsp
*******************************************************************************/
%>

<%@ include file="../../EgTrackerA.jsp" %>
<%@ page import="java.util.*"%>
<%@ page import = "com.eg.EgDiscInfo"%> 
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%!
public boolean isSaveIni(String compType,String compName,String tool,String url)
{
	boolean isSaved = false;
	try
	{
		//IniFile egExternalUrlIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_externalURL.ini",true);
		if(compType!=null && !compName.equals("") && tool!=null && !tool.equals("") && url!=null && !url.equals(""))
		{
			IniFile egExternalUrlIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_externalURL.ini",true);
			egExternalUrlIni.setValue(compType,compName+":"+tool,url);
			String toolForCompName= egExternalUrlIni.getValue("MONITORING TOOLS",compType+":"+compName);
			if(toolForCompName!=null && !toolForCompName.equalsIgnoreCase(""))
			{
				tool=toolForCompName+","+tool;
				egExternalUrlIni.setValue("MONITORING TOOLS",compType+":"+compName,tool);
			}
			else
			{
				egExternalUrlIni.setValue("MONITORING TOOLS",compType+":"+compName,tool);
			}
			egExternalUrlIni.saveFile(true);
			EgConfigFilesSync.releaseInstance(egExternalUrlIni);
			isSaved=true;
		}
		else
		{
			isSaved=false;
		}
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
	return isSaved;
}

public boolean isModifyIni(String compType,String compName,String tool,String url)
{
	boolean isModified = false;
	try
	{
		//IniFile egExternalUrlIni=egExternalUrlIni=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_externalURL.ini",true);
		if(compType!=null && !compName.equals("") && tool!=null && !tool.equals("") && url!=null && !url.equals(""))
		{
			IniFile egExternalUrlIni=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_externalURL.ini",true);
			String urlForTool = egExternalUrlIni.getValue(compType,compName+":"+tool);
			if(url!=null && !url.equals(urlForTool))
			{
			egExternalUrlIni.setValue(compType,compName+":"+tool,url);
			}
			egExternalUrlIni.saveFile(true);
			EgConfigFilesSync.releaseInstance(egExternalUrlIni);
			isModified=true;
		}
		else
		{
			isModified=false;
		}
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
	return isModified;
}

public boolean isDeleteIni(String compType,String compName,String tool,String url)
{
	boolean isDeleted = false;
	try
	{
		//IniFile egExternalUrlIni=egExternalUrlIni=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_externalURL.ini",true);
		if(compType!=null && !compName.equals("") && tool!=null && !tool.equals("") && url!=null && !url.equals(""))
		{
			IniFile egExternalUrlIni=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_externalURL.ini",true);
			egExternalUrlIni.deleteValue(compType,compName+":"+tool);
			String ValueForUpdate="";
			String concatString = "";
			String toolForCompName= egExternalUrlIni.getValue("MONITORING TOOLS",compType+":"+compName);
			StringTokenizer toolNameToken = new StringTokenizer(toolForCompName,",");
			while(toolNameToken.hasMoreTokens())
			{
				String tokenString = toolNameToken.nextToken();
				if(tokenString!=null && !tokenString.equals(tool))
				{
					if(ValueForUpdate!=null && !ValueForUpdate.equals(""))
					{
						concatString=",";
					}
					else
					{
						concatString="";
					}
					ValueForUpdate=tokenString+concatString+ValueForUpdate;
				}
			}
			if(ValueForUpdate!=null && !ValueForUpdate.equals(""))
			{
				egExternalUrlIni.setValue("MONITORING TOOLS",compType+":"+compName,ValueForUpdate);
			}
			else
			{
				egExternalUrlIni.deleteValue("MONITORING TOOLS",compType+":"+compName);
			}
			egExternalUrlIni.saveFile(true);
			EgConfigFilesSync.releaseInstance(egExternalUrlIni);
			isDeleted=true;
		}
		else
		{
			isDeleted=false;
		}
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
	return isDeleted;
}
%>
<%
		IniFile egExternalUrlIni=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_externalURL.ini");
		String server = request.getParameter("server");
		String compName = request.getParameter("compname");
		String tool = request.getParameter("tool").trim();
		tool = com.egurkha.util.StringUtils.decodeSecurityChar(tool);
		String url = request.getParameter("url").trim();
		url = com.egurkha.util.StringUtils.decodeSecurityChar(url);
		String operation = request.getParameter("operation");
		url=com.egurkha.util.StringUtils.replace(url, "|amp|", "&");
		url=com.egurkha.util.StringUtils.replace(url,"|hash|","#");
		boolean isIniSaved=false;
		boolean isIniModified=false;
		boolean isIniDeleted=false;
		if(tool!=null && !tool.equals("") && compName!=null && !compName.equals(""))
		{
			if(operation!=null && operation.equalsIgnoreCase("ADDINI"))
			{
				String urlForTool = egExternalUrlIni.getValue("MONITORING TOOLS",server+":"+compName);
				if(urlForTool!=null && !urlForTool.equals(""))
				{
					StringTokenizer toolsList = new StringTokenizer(urlForTool,",");
					while(toolsList.hasMoreTokens())
					{
						String toolName = toolsList.nextToken();
						if(toolName!=null && toolName.equalsIgnoreCase(tool))
						{
				Vector sess_vec = new Vector();
				sess_vec.add(_mapping.getTextDescription("admin.server.Add/Modify External Monitors"));
				sess_vec.add("EgExternalMonitors.jsp");
				sess_vec.add(_mapping.getTextDescription("admin.server.Tool Name already managed."));
				sess_vec.add(_mapping.getTextDescription("admin.server.The Tool Name")+"' "+tool+" '"+_mapping.getTextDescription("admin.server.you are trying to add is already managed")+".");
				session.setAttribute("vec_Errors",sess_vec);
%>
<%
						}
					}
				}
			}
		}

		AuditLogThread auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","External Monitors");

		if(operation!=null && operation.equalsIgnoreCase("ADDINI"))
		{
			isIniSaved=isSaveIni(server,compName,tool,url);

			if(isIniSaved)
			{
				Vector sess_vec = new Vector();
				sess_vec.addElement(_mapping.getTextDescription("admin.em.External Monitor List"));
				sess_vec.addElement("EgExternalMonitors.jsp");
				sess_vec.addElement(_mapping.getTextDescription("admin.db.External Monitor URL is Added")+".");
				sess_vec.addElement(_mapping.getTextDescription("admin.db.External Monitor URL is Added successfully")+"...");
				session.setAttribute("vec_Results",sess_vec);

				auditLogThread.setValue("Activity","Add External Monitor");
				auditLogThread.setValue("Description","External Monitor" + " " + tool + " " + "has been added");

				auditLogThread.setCurrentValue("Server",server);
				auditLogThread.setCurrentValue("Component Name",compName);
				auditLogThread.setCurrentValue("Tool",tool);
				auditLogThread.setCurrentValue("URL",url);

				auditLogThread.sendItToDB();
%>
<%
			}
			else
			{
%>
<%
			}
		}
		if (operation!=null && operation.equalsIgnoreCase("ModifyINI"))
		{
			isIniModified=isModifyIni(server,compName,tool,url);
			if(isIniModified)
			{
				String urlForTool = egExternalUrlIni.getValue(server,compName+":"+tool);

				auditLogThread.setValue("Activity","Modify External Monitor");
				auditLogThread.setValue("Description","External Monitor "+ tool +" has been modified");

				auditLogThread.setPreviousValue("URL",urlForTool);
				auditLogThread.setCurrentValue("URL",url);

				auditLogThread.sendItToDB();

				Vector sess_vec = new Vector();
				sess_vec.addElement(_mapping.getTextDescription("admin.em.External Monitor List"));
				sess_vec.addElement("EgExternalMonitors.jsp");
				sess_vec.addElement(_mapping.getTextDescription("admin.db.External Monitor URL is Modified")+".");
				sess_vec.addElement(_mapping.getTextDescription("admin.db.External Monitor URL is modified successfully")+"...");
				session.setAttribute("vec_Results",sess_vec);
%>
<%
			}
			else
			{
%>
<%
			}
		}
		if (operation!=null && operation.equalsIgnoreCase("DeleteINI"))
		{
			isIniDeleted=isDeleteIni(server,compName,tool,url);
			if(isIniDeleted)
			{
				auditLogThread.setPreviousValue("External Monitor", tool);
				auditLogThread.setCurrentValue("External Monitor", tool);

				auditLogThread.setCurrentValue("ColumnName","Deleted " + " " + "External Monitor");
				auditLogThread.setCurrentValue("Deleted "+ " " +"External Monitor", tool);

				auditLogThread.setValue("Activity","Delete External Monitor");
				auditLogThread.setValue("Description",tool +" "+"External Monitor deleted successfully");
				auditLogThread.sendItToDB();
%>
<%
			}
			else
			{
%>
<%
			}
		}
%>
