<%
/**
 *	Name            :	EgDelUDTest.jsp
 *	Author          :	Bharath G
 *	Purpose         :
 *	Version         :	1.0
 *	CreationDate    :	01/10/2001
 *	LastModified    :	30/10/2001
 *						19/04/2004	Arun	Invokes testBean.removeDdEntries() to clear DD-related
 *											information from INI files, when the test is deleted.
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="java.io.File" %>
<%@ page import="java.util.*" %>
<%@ page import="egurkha.*" %>
<%@ page import="com.eg.UpdateAndTransmitICInfo"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<!-- skm -->
<%@ page import="com.eg.IniFile" %> 
<%@ page import="com.eg.EgConfigFilesSync"%>
<%@ page import="com.eg.EgInstallInfo" %> 
<%@ page import="com.eg.EgAggregateInfo"%>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.IniHelper" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<jsp:useBean id="serviceBean" scope="page" class="egurkha.ServiceBean"/>

<%
	/* code for auditlog starts */
	boolean isAggregate = false;	
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	auditLogThread.setValue("Activity","Delete Test");
	/* code for auditlog ends */
	String test = request.getParameter("test");
	TestBean testBean = new TestBean(true);
	String dbDir = EgInstallInfo.getInstallDir()+"/bin/database";
	String sqlFileName=dbDir+"/"+test+"_MsSql.sql";
	String oracleFileName=dbDir+"/"+test+"_Oracle.sql";
	
	/* code for delete the Loaded MBean files start */
	String deleteFlag = request.getParameter("deleteFlag");
	if(deleteFlag != null && deleteFlag.equals("true"))
	{
		String installDir = EgInstallInfo.getInstallDir();
		IniFile egUDTestFile = EgConfigFilesSync.getInstance(installDir+"/manager/config/eg_udtests.ini");
		String testVal = egUDTestFile.getValue("UPLOADED_FILES",test);
		String []allVariables = egUDTestFile.getVariables("UPLOADED_FILES");
		StringTokenizer str = null;
		ArrayList filesList = null;
		if(test != null && test.length() > 0)
		{
			str = new StringTokenizer(testVal,",");
			filesList = new ArrayList();
			if(str.countTokens() > 0)
			{
				while(str.hasMoreTokens())
				{
					String token = str.nextToken();
					filesList.add(token);
				}
			}
		}
		if(allVariables != null && allVariables.length > 0)
		{
			for(int k=0;k<allVariables.length;k++)
			{
				if(!allVariables[k].equals(test))
				{
					String value = egUDTestFile.getValue("UPLOADED_FILES",allVariables[k]);
					str = new StringTokenizer(value,",");
					if(str.countTokens() > 0)
					{
						while(str.hasMoreTokens())
						{
							String token = str.nextToken();
							if(filesList.contains(token))
								filesList.remove(token);
						}
					}
				}
			}
			if(filesList != null && filesList.size() > 0)
			{
				for(int x=0;x<filesList.size();x++)
				{
					String path = (String)filesList.get(x);
					path = installDir+"/tmp/"+path;
					File f = new File(path);
					if(f.exists())
					{
						f.delete();
					}
				}
			}
			egUDTestFile.deleteValue("UPLOADED_FILES",test);
			egUDTestFile.saveFile();
			EgConfigFilesSync.releaseInstance(egUDTestFile);
		}
	}
	/* code for delete the Loaded MBean files end */

	//skm
	EgAggregateInfo aggregateInfo = null;
	if (testBean.getTestType(test).equalsIgnoreCase("Aggregate"))
	{
		aggregateInfo = new EgAggregateInfo("manager"); 
		//aggregateInfo.deleteFromAggregateFunction(test);
		//aggregateInfo.deleteFromAggregateGroups(test);
		//aggregateInfo.deleteFromAggregateTestInfosExcluded(test);
		aggregateInfo.deleteValue("AGGREGATE_TEST",test);
		String variables[] = aggregateInfo.getVariables("SITE_AGGREGATE_TEST");
		if(variables != null && variables.length>0)
		{
			for(int i=0;i<variables.length;i++)
			{
				if(variables[i].equals(test))
					aggregateInfo.deleteValue("SITE_AGGREGATE_TEST",variables[i]);
			}
		}
		variables = aggregateInfo.getVariables("COLUMN_NAME_MAPPING");
		if(variables != null && variables.length>0)
		{
			for(int i=0;i<variables.length;i++)
			{
				String variable = test+":";
				if(variables[i].startsWith(variable))
					aggregateInfo.deleteValue("COLUMN_NAME_MAPPING",variables[i]);
			}
		}
		aggregateInfo.saveFile();
		testBean.deleteAggregateTest(test);
		isAggregate = true;
	}
	//skm
	
	//Issue-- If we delete a excluded IC test, then the test is not deleted from eg_disable.ini
	//Fix - starts
	EgSpecsInfo egSpecsInfo = new EgSpecsInfo("manager");
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	IniFile disableIniRead = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_disable.ini");
	boolean isPortRelevantForTest = egSpecsInfo.isPortRelevantForTest(test);
	String subject = "";
	ArrayList  compTypesForTest = new ArrayList();
	if (isPortRelevantForTest)
	{
		List listComponentTypes = Arrays.asList(ri.getServerTypes());
		for (int l=0;l<listComponentTypes.size();l++)
		{
			String compType = (String)listComponentTypes.get(l);
			if (egSpecsInfo.isTestRelevantForServer(compType,test))
			{
				compTypesForTest.add(compType);
			}
		}
	}
	else
	{
		compTypesForTest.add("Default_server");
	}
	
	StringTokenizer stt = null;	
	String tmpTestNames = "";
	boolean isTestRemoved =  false;
	ArrayList iniEntries = new ArrayList();
	for (int c=0;c<compTypesForTest.size();c++)
	{
		String tmpCompType = (String)compTypesForTest.get(c);
		String vars[] = disableIniRead.getVariables(tmpCompType);
		for (int v=0;v<vars.length;v++)
		{
			String var = vars[v];
			String val = disableIniRead.getValue(tmpCompType,var);
			stt = new StringTokenizer(val,",");
			tmpTestNames = "";
			isTestRemoved = false;
			val = "";
			while (stt.hasMoreTokens())
			{
				tmpTestNames = stt.nextToken();
				if (tmpTestNames.equals(test))
				{
					isTestRemoved = true;
					continue;
				}
				val += tmpTestNames+",";
			}
			if (isTestRemoved)
			{
				if (val.endsWith(","))
				{
					val  = val.substring(0,val.length()-1);
				}
				if (val.trim().length() == 0)
				{
					iniEntries.add(new IniHelper(IniHelper.DELETE,tmpCompType,var,""));
				}
				else
				{
					iniEntries.add(new IniHelper(IniHelper.SET,tmpCompType,var,val));
				}
			}
		}
	}

	if (iniEntries.size() > 0)
	{
		IniFile disableIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_disable.ini",true);
		for (int i=0; i<iniEntries.size(); i++)
		{
			IniHelper iniHlpr = (IniHelper)iniEntries.get(i);
			String iniAction = iniHlpr.getAction();
			String sub = iniHlpr.getSubject();
			String var = iniHlpr.getVariable();
			String val = iniHlpr.getValue();
			if (iniAction.equals(IniHelper.DELETE))
			{
				disableIni.deleteValue(sub,var);
			}
			else if (iniAction.equals(IniHelper.SET))
			{
				disableIni.setValue(sub,var,val);
			}
		}
		disableIni.saveFile();
		EgConfigFilesSync.releaseInstance(disableIni);
	}
	//Fix - ends
	/**
	 * Remove entries in eg_testparam.ini, if testtype is SNMP
	 */
	if (testBean.getTestType(test).equalsIgnoreCase("Snmp"))
	{
		EgTestParamBean testParamIni = new EgTestParamBean();
		//testParamIni.createFile("eg_testparam.ini","save");
		testParamIni.createSyncFile("eg_testparam.ini","save");
		testParamIni.deleteValues("SELECT",test);
		testParamIni.deleteValues("RADIO",test);
		testParamIni.deleteValues("PASSWORD",test);
		testParamIni.saveFile();
		testParamIni.releaseInstance();
	}

	/*
	 * Remove entries in eg_format.ini, set while enabling detailed diagnosis
	 * for tests enabled through IC.
	 *
	 * Remove these entries before removing any entry in any other INI file.
	 */
	testBean.removeDdEntries(test);
	testBean.deleteTest(test);



	DbBean dbBean = new DbBean(true);
	serviceBean.stopDiscovery();

	dbBean.removeTest(test);
	//clustering
	/*if(dbBean.getConnection())
	{
		dbBean.deleteTestFromDb(test);
		dbBean.releaseConnection();
	}*/
	UpdateAndTransmitICInfo updateICInfo = new UpdateAndTransmitICInfo();
	updateICInfo.deleteTestFromDb(test);

	serviceBean.startDiscovery("1");
	//response.sendRedirect("EgUDTest.jsp");

	if(isAggregate)
	{
		EgTestParamBean testParamIni = new EgTestParamBean();
		//testParamIni.createFile("eg_testparam.ini","save");
		testParamIni.createSyncFile("eg_testparam.ini","save");
		testParamIni.deleteValues("RADIO",test);
		testParamIni.saveFile();
		testParamIni.releaseInstance();

		if(test.endsWith("_ex"))
			auditLogThread.setValue("Description","Aggregate test "+test+" has been deleted");
		else
			auditLogThread.setValue("Description","Aggregate test "+"$test$:"+test+" has been deleted");
	}
	else
	{
		if(test.endsWith("_ex"))
			auditLogThread.setValue("Description","Test "+test+" has been deleted");
		else
			auditLogThread.setValue("Description","Test "+"$test$:"+test+" has been deleted");
	}

/*	if(isAggregate)
		auditLogThread.setValue("Description",test + " "+ "aggregate test has been deleted");
	else
		auditLogThread.setValue("Description",test + " "+ "test has been deleted");
*/
	auditLogThread.sendItToDB();
	this.deleteUDQueryFile(sqlFileName);
	this.deleteUDQueryFile(oracleFileName);
%>
	<jsp:forward page="EgUDTest.jsp" />
<%!
	private void deleteUDQueryFile(String fileName)
	{
		if(fileName == null || fileName.equals(""))
			return ;
		File file =new File(fileName);
		if(file != null)
		{
			if(file.isFile())
				file.delete();
		}
	}
%>
