<%
/*******************************************************************************
*	Name					:	EgConsolidatedMeasuresJSON.jsp
*	Purpose					:	Configures the details required for Consolidate/ThinClient reports
*	Version					:	6.0
*	CreationDate			:	01/07/2013
*	Author					:	Abdul Khader
*	Location				: /final/admin/EgConsolidatedMeasures/data/EgConsolidatedMeasuresJSON.jsp
*******************************************************************************/
%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgReportInfo" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgThresholdInfo" %>
<%@ page import = "com.eg.EgConfigInfo" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.User" %>
<%@ page import = "com.egurkha.UserRegistry" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgTesterInfo" %>
<%@ page import = "egurkha.ConfigSiteBean" %>
<%@ page import = "net.sf.json.*" %>

<%
	response.setContentType("application/json");
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootJson = new JSONObject();
	JSONObject optionsJson = new JSONObject();
	JSONObject hiddenJson = new JSONObject();

	JSONArray catTypeArrayJson = new JSONArray();
	JSONArray compTypeArrayJson = new JSONArray();
	JSONArray testsArrayJson = new JSONArray();
	JSONArray measuresArrayJson = new JSONArray();
	JSONArray functionsArrayJson = new JSONArray();
	JSONArray assocMeasuresArrayJson = new JSONArray();
	JSONArray serverMeasuresArrayJson = new JSONArray();

	ConfigSiteBean SiteBean = new ConfigSiteBean();
%>

<%!
	StringBuffer servMeasure=null;
	String selectedMeasures="";
%>
<%
	if(SiteBean.rcat())
	{
		UserRegistry registry1 = UserRegistry.getInstance();
		User user = registry1.getUser(session.getId());
		IniUI iniUI = IniUI.getInstance();
		//user language
		String userLanguage = iniUI.getDefaultLanguage();
		if (user != null)
		{
			userLanguage = user.getLanguage();
		}
		EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

		EgThresholdInfo et = new EgThresholdInfo("manager");
		EgReportInfo rep = new EgReportInfo("manager");
		EgConfigInfo econ= new EgConfigInfo("manager");
		EgDiscInfo ed = new EgDiscInfo("manager");
		EgSpecsInfo espec = new EgSpecsInfo("manager");
		EgTesterInfo testerInfo=new EgTesterInfo("manager");
		ErUserData erdata = new ErUserData("supermonitor",false);
		ErInfo erinfo = new ErInfo();
		ErUtils erUtils = new ErUtils();
		MappingNameSorter sorter = new MappingNameSorter(userLanguage);
		String fname = econ.getReportConfigFile();
		Vector v_cattype=new Vector();
		String DeletedMeasure=request.getParameter("DeletedMeasure");
		JSONObject catTypeZoneObj = new JSONObject();
		JSONObject catTypeServerObj = new JSONObject();
		v_cattype.add("Zone");
		v_cattype.add("Server");
		catTypeZoneObj.put("displayField","Zone");
		catTypeZoneObj.put("valueField","Zone");
		catTypeServerObj.put("displayField","Server");
		catTypeServerObj.put("valueField","Server");
		catTypeArrayJson.add(catTypeZoneObj);
		catTypeArrayJson.add(catTypeServerObj);
		//v_cattype.add("Services");

		IniFile irep = new IniFile(fname);
		String tests[];
		String dmeasures[];
		//String infos[];
		String testName="";
		String cattype = "";
		String cattypeT = "";
		String secType ="";
		String graphType = "";
		String comType = "";
		String comName="";
		String siteType="";
		String measureAdd="";
		String serverTests[];
		Vector dv_measures = new Vector();
		//ArrayList a_infos = new ArrayList();
		Vector v;
	
		String testinfo = "";
		String testselect="";
		String serverselect="";
		boolean serverlist=false;
		//boolean sitelist = false;
		//boolean netsyslist= false;
		int tind = 0;
		String serverType="";
		if(request.getParameter("catType")!=null)
			cattype=request.getParameter("catType");
		if(request.getParameter("graphType")!=null)
			graphType=request.getParameter("graphType");
		if(request.getParameter("secType")!=null)
			secType =request.getParameter("secType");
		if(request.getParameter("tests")!=null)
			testName = request.getParameter("tests");
		if(request.getParameter("serverType")!=null)
			serverType = request.getParameter("serverType");
		else
			serverType="Default";
		if(request.getParameter("comType")!=null)
			comType = request.getParameter("comType");
		if(request.getParameter("comName")!=null)
			comName = request.getParameter("comName");
		if(request.getParameter("measureToAdd")!=null)
			measureAdd = request.getParameter("measureToAdd");

		String selectedAassociatedMeasures = null;
		String selectedComponentType = null;
		String selectedTest = null;
		String selectedMeasure = null;
		String selectedFunctions = null;
		String secTypeI="";
		String cattypeVar = "";
		String graphTypeI="";
		String deleted=request.getParameter("Deleted");

		if (deleted==null)
			deleted="false";
		if(request.getParameter("graphTypeI")!=null)
			graphTypeI = request.getParameter("graphTypeI");
		if(cattype != null)
		{
			if((cattype.toUpperCase()).startsWith("ZONE"))
			{
				if(serverType!=null && serverType !="")
				cattypeVar = serverType+":"+testName;//.substring(0,comName.indexOf(":"));
			}
			else if((cattype.toUpperCase()).startsWith("SERVER"))
			{
				if(graphType !=null && graphType !="")
				cattypeVar = cattype+":"+graphType+":"+siteType;
			}
		}
		if(secType != null && secType !="")
		secTypeI=secType.toUpperCase()+"_REPORT";
		Vector v_func=new Vector();
		String functions = "";
		if (cattype.equalsIgnoreCase("Zone") || cattype.equalsIgnoreCase("Services"))
		{
			functions=irep.getValue("ZONE_REPORT","Function");
		}

		StringTokenizer st1 = new StringTokenizer(functions,",");
		while (st1.hasMoreTokens())
		{
			JSONObject aFuncObj = new JSONObject();
			String aFunc = (st1.nextToken()).trim();
			v_func.add((aFunc).trim());
			aFuncObj.put("displayField",aFunc);
			aFuncObj.put("valueField",aFunc);
			functionsArrayJson.add(aFuncObj);
		}
		String[] selectedfunc=request.getParameterValues("calfunc");
		if (selectedfunc==null )
		{
			if (v_func!=null && v_func.size()>0)
			{
				selectedfunc=new String[1];
				selectedfunc[0]=(String)v_func.get(0);
			}
		}
		ArrayList subjects=new ArrayList();
		ArrayList sub=new ArrayList();
		String[] measurelist=request.getParameterValues("associatem");
		if (deleted==null || (deleted!=null && deleted.equalsIgnoreCase("false")))
		{
			subjects=(ArrayList)rep.getVariables(secTypeI);
			sub=subjects;
		}
		if (cattype.equals("Services") && sub.size() ==0 )
		{
			subjects=(ArrayList)rep.getVariables("ZONE_REPORT");
			sub=subjects;
		}
		if (sub.size()>0)
		{
			subjects=new ArrayList();
			for (int i=0;i<sub.size();i++)
			{
				String vars=(String)sub.get(i);
				if (cattype.equalsIgnoreCase("Zone"))
				{
					//if (!testName.equals("") && vars.indexOf(serverType+":"+testName)>-1)
					if (vars.indexOf(serverType)>-1) 
					{
						String subTemp = (String) sub.get(i);
						String vals=irep.getValue(secTypeI,(String)sub.get(i));
						if (vals!=null && !vals.equals("")){
							subjects.add(sub.get(i)+"="+vals);
						}
					}
					else
					{
						//measurelist=null;
					}
				}
				else if (cattype.equalsIgnoreCase("Server"))
				{
					if (!testName.equals("") && vars.indexOf(testName)>-1)
					{
						String vals=irep.getValue(secTypeI,(String)sub.get(i));
						if (vals!=null && !vals.equals(""))
							subjects.add(sub.get(i)+"="+vals);
					}
					else
					{
						//measurelist=null;
					}
				}
				else if (cattype.equalsIgnoreCase("Services"))
				{
					if (serverType.equalsIgnoreCase("Default")||serverType.equalsIgnoreCase("---All Components---"))
					{
						if (vars.indexOf("Default")>-1)
						{
							String vals=irep.getValue("SERVICES_REPORT",(String)sub.get(i));
							if (vals!=null && !vals.equals(""))
								subjects.add(sub.get(i)+"="+vals);
						}
					}
					else
					{
						if (!testName.equals("") && vars.indexOf(serverType+":"+testName)>-1)
						{
							String vals=irep.getValue("ZONE_REPORT",(String)sub.get(i));
							if (vals!=null && !vals.equals(""))
								subjects.add(sub.get(i)+"="+vals);
						}
					}
				}
			}
		}
		String changed=request.getParameter("changed");
		if(measurelist!=null && measurelist.length>0 &&(changed==null || changed!=null && changed.equalsIgnoreCase("false")))
		{
			subjects=new ArrayList();
			for (int i=0;i<measurelist.length;i++)
				subjects.add(measurelist[i]);
		}
		irep = null;
		if(cattype != null)
		{
			if(cattype.startsWith("Application"))
				serverlist = true;
		}
		String backqs="";
		String zoneselect ="";
		String serselect ="";
		if(cattype != null)
		{
			if(cattype.startsWith("Zone"))
			{
				zoneselect = "checked";
				serverlist = true;
			}
			if(cattype.startsWith("Server"))
			{
				serselect = "checked";
				serverlist = true;
			}
			if(cattype.startsWith("Services"))
			{
				serselect = "checked";
				serverlist = true;
			}
		}

		if(!cattype.equalsIgnoreCase("Server"))
		{
					//System.out.println("IAM HERE");
			Vector v_server = new Vector();
			Vector v_comp = erdata.getAllUserComponents(0);
			if(v_comp != null)
			{
				for(int vc=0;vc<v_comp.size();vc++)
				{
					String tempvcom = (String)v_comp.get(vc);
					if(!v_server.contains(tempvcom))
					v_server.addElement(tempvcom);
				}
			}
			if(v_server != null)
			{
				ArrayList serverList = sorter.getSortedCompTypeList(v_server);

				JSONObject defaultListObj = new JSONObject();
				defaultListObj.put("valueField","Default");
				defaultListObj.put("displayField","Default");
				compTypeArrayJson.add(defaultListObj);

				for (int  i=0;i<serverList.size();i++)
				{
					JSONObject serverListObj = new JSONObject();
					EgName nameObj = (EgName)serverList.get(i);
					String tmpVal = nameObj.getActualName();
					String tmpDis = nameObj.getLocalName();
					serverListObj.put("valueField",tmpVal);
					serverListObj.put("displayField",tmpDis);
					compTypeArrayJson.add(serverListObj);
					if(serverType != null)
					{
						if(serverType.equals(tmpVal))
						{
							serverselect = "selected";
							selectedComponentType = serverType;
						}
						else
							serverselect = "";
					}
				}
			}

			Vector v_serverTests = new Vector();
			Vector v_serverTestsT = new Vector();
			//if(serverType.equalsIgnoreCase("---All Components---"))
			//serverType="Default";
			if(serverType.equals("") || serverType.trim().equals("Default"))
			{
				v_serverTests = new Vector();
				String hosttests[] = espec.getTestsForServer("Host_system");
				v_serverTestsT = new Vector();
				if(hosttests!=null && hosttests.length>0)
				{
					for(int ii=0;ii<hosttests.length;ii++)
					{
						v_serverTestsT.contains(hosttests[ii]);
						if(!v_serverTests.contains(hosttests[ii]))
						v_serverTests.addElement(hosttests[ii]);
					}
				}
			}
			else
			{
				if(!serverType.equals(""))
				{
					Vector v_complayers = erinfo.getLayersForCompType(serverType.trim());
					v_serverTests = new Vector();
					v_serverTestsT = new Vector();
					if(v_complayers != null)
					{
						for(int ll=0;ll<v_complayers.size();ll++)
						{
							v_serverTestsT = erdata.getTests(serverType,(String)v_complayers.get(ll));
							if(v_serverTestsT!=null && v_serverTestsT.size()>0)
							{
								for(int ii=0;ii<v_serverTestsT.size();ii++)
								{
									if(!v_serverTests.contains(v_serverTestsT.get(ii)))
									v_serverTests.addElement(v_serverTestsT.get(ii));
								}
							}
						}
					}
					v_serverTestsT=null;
				}
			}
			if (v_serverTests != null)
			{
				List tmpTests = espec.getManagedCompTestList(v_serverTests);
				v_serverTests = new Vector(tmpTests);
				ArrayList testsList = sorter.getSortedTestList(v_serverTests);
				JSONObject selectAnyObj = new JSONObject();
				selectAnyObj.put("displayField","Select any test");
				selectAnyObj.put("valueField","Select any test");
				testsArrayJson.add(selectAnyObj);
				for (int i=0;i<testsList.size();i++)
				{
					JSONObject testListObj = new JSONObject();
					EgName nameObj = (EgName)testsList .get(i);
					String tmpVal = nameObj.getActualName();	
					String tmpDis = nameObj.getLocalName();	
					testListObj.put("displayField",tmpDis);
					testListObj.put("valueField",tmpVal);
					testsArrayJson.add(testListObj);
					if(!tmpVal.equalsIgnoreCase("WebsiteTest")&&!tmpVal.equalsIgnoreCase("WebsiteTransactionTest"))
					{
						if(testName !=null && testName !="")
						{
							if(testName.equals(tmpVal)) 
							{
								testselect = "selected";
								selectedTest = testName;
							}
							else
								testselect = "";
						}
					}
				}
			}
		}
		else
		{
			String[] allTests=et.getAllTests();
			allTests = espec.getManagedCompTestList(allTests);
			if(allTests != null && allTests.length>0)
			{
				ArrayList testsList = new ArrayList();
				
				for (int s=0;s<allTests.length;s++)
				{
					if (!EgInstallInfo.isConfigTest(allTests[s]))
					{
						testsList.add(allTests[s]);
					}
				}
				//ArrayList testsList = sorter.getSortedTestList(allTests);
				ArrayList aListDesktopAgentTestNames = testerInfo.getDesktopAgentTestNames();
				testsList.removeAll(aListDesktopAgentTestNames);
				testsList = sorter.getSortedTestList(testsList);

				JSONObject selectAnyObj = new JSONObject();
				selectAnyObj.put("displayField","Select any test");
				selectAnyObj.put("valueField","Select any test");
				testsArrayJson.add(selectAnyObj);

				for (int i=0;i<testsList.size();i++)
				{
					JSONObject testListObj = new JSONObject();
					EgName nameObj = (EgName)testsList .get(i);
					String tmpVal = nameObj.getActualName();
					String tmpDis = nameObj.getLocalName();
					testListObj.put("displayField",tmpDis);
					testListObj.put("valueField",tmpVal);
					testsArrayJson.add(testListObj);
					if(testName !=null && testName !="")
					{
						if(testName.equals(tmpVal)) 
						{
							testselect = "selected";
							selectedTest = testName;
						}
						else
							testselect = "";
					}
				}
			}
		}

		if(testName!=null && testName !="")
		{
			dmeasures=et.getMeasurementsForTest(testName);
			if(dmeasures !=null && dmeasures.length > 0)
			{
				for(int j=0;j<dmeasures.length;j++)
				{
					if(!dv_measures.contains(dmeasures[j]))
						dv_measures.addElement(dmeasures[j]);
				}
				for(int i=0;i<subjects.size();i++)
				{
					String valusub=(String)subjects.get(i);
					if (cattype.equalsIgnoreCase("Server"))
					{
						//String remval=(String)dv_measures.get(k);
						StringTokenizer stokrem=new StringTokenizer(valusub,",");
						while(stokrem.hasMoreTokens())
						{
							String strmesa=stokrem.nextToken();
							for(int k1=0;k1<dv_measures.size();k1++)
							{
								String remval1=(String)dv_measures.get(k1);
								if(strmesa.indexOf(remval1)>-1)
								{
									int rem=dv_measures.indexOf(remval1);
									dv_measures.removeElementAt(rem);
								}
							}
						}
					}
					else
					{
						for(int k=0;k<dv_measures.size();k++)
						{
							String remval=(String)dv_measures.get(k);
							if(valusub.indexOf(testName+":"+remval)>-1)
							{
								//String remval=(String)dv_measures.get(k);
								int rem=dv_measures.indexOf(remval);  
								dv_measures.removeElementAt(rem);
							}
						}
					}
				}
				JSONObject measuresMappingObj = new JSONObject();
				for(int k=0;k<dmeasures.length;k++)
				{
					String measVal = dmeasures[k];
					String localName = mappingInfo.getMeasureDescription(testName,measVal);
					System.out.println("localName  : "+localName);
					measuresMappingObj.put(testName+':'+measVal,localName);
				}
				if (measuresMappingObj != null && !measuresMappingObj.isEmpty())
				{
					rootJson.put("measuresMappingObj",measuresMappingObj);
				}
			}
		}
		String colon=":";
		if (cattype.equalsIgnoreCase("Server"))
		{
			if(dv_measures.size()==0)
			{
				JSONObject selectAnyObj = new JSONObject();
				selectAnyObj.put("displayField","Not Applicable");
				selectAnyObj.put("valueField","-1");
				measuresArrayJson.add(selectAnyObj);
			}
			else
			{
				JSONObject selectAnyObj = new JSONObject();
				selectAnyObj.put("displayField","Select any measure");
				selectAnyObj.put("valueField","-1");
				measuresArrayJson.add(selectAnyObj);

				for (int i=0;i<dv_measures.size();i++)
				{
					JSONObject measureObj = new JSONObject();
					String meas=(String)dv_measures.get(i);
					String aVar = testName+colon+meas;
					String localName = mappingInfo.getMeasureDescription(testName,meas);
					//measureObj.put("displayField",aVar);
					measureObj.put("displayField",localName);
					measureObj.put("valueField",meas);
					measuresArrayJson.add(measureObj);
				}
			}
		}

		if(!cattype.equalsIgnoreCase("Server"))
		{
			if(dv_measures.size()==0)
			{
				JSONObject notApplicableObj = new JSONObject();
				notApplicableObj.put("displayField","Not Applicable");
				notApplicableObj.put("valueField","-1");
				measuresArrayJson.add(notApplicableObj);
			}
			else
			{
				JSONObject selectAnyObj = new JSONObject();
				selectAnyObj.put("displayField","Select any measure");
				selectAnyObj.put("valueField","-1");
				measuresArrayJson.add(selectAnyObj);

				for (int i=0;i<dv_measures.size();i++)
				{
					JSONObject measureObj = new JSONObject();
					String meas=(String)dv_measures.get(i);
					String aVar = testName+colon+meas;
					String localName = mappingInfo.getMeasureDescription(testName,meas);
					//measureObj.put("displayField",aVar);
					measureObj.put("displayField",localName);
					measureObj.put("valueField",meas);
					measuresArrayJson.add(measureObj);
				}
			}
		}

		if(secType.equalsIgnoreCase("Zone") || secType.equalsIgnoreCase("Services"))
		{
			if (selectedfunc != null && selectedfunc.length > 0)
			{
				for(int i=0;i<selectedfunc.length;i++)
				{
					if(i==0)
					selectedFunctions = selectedfunc[i];
					else
						selectedFunctions += ","+selectedfunc[i];
				}
			}
		}
//System.out.println("subjects  : "+subjects);
		for (int i=0;i<subjects.size();i++)
		{
			//new change
			String subjectTemp = (String)subjects.get(i);
			/* code for auditlog starts */
			if(i==0)
				selectedAassociatedMeasures = subjects.get(i).toString();
			else
				selectedAassociatedMeasures += "," + subjects.get(i).toString();
			/* code for auditlog ends */
			if(cattype != null && cattype.equalsIgnoreCase("Zone"))
			{
				String tempStr="";
				String display="";
				int idx = subjectTemp.indexOf("#");

				if(idx == -1)
				{
					int idxTemp = subjectTemp.indexOf("=");
					tempStr = subjectTemp.substring(0,idxTemp);
					display = subjectTemp.substring(idxTemp+1);
				}
				else
				{
					tempStr = subjectTemp.substring(0,idx);
					display = subjectTemp.substring(idx+1);
				}

				String typeTmp = tempStr.substring(0,tempStr.indexOf(":"));
				if(!"Default".equalsIgnoreCase(typeTmp))
				{
					typeTmp = mappingInfo.getComponentTypeDescription(typeTmp);
				}
				tempStr = tempStr.substring(tempStr.indexOf(":")+1);
				String testTmp = tempStr.substring(0,tempStr.indexOf(":"));
				String mesTmp = tempStr.substring(tempStr.indexOf(":")+1);
				mesTmp = mappingInfo.getMeasureDescription(testTmp,mesTmp);
				testTmp = mappingInfo.getTestDescription(testTmp);
				if(idx == -1)
				{
					subjectTemp = typeTmp+":"+testTmp+":"+mesTmp+"="+display;
				}
				else
				{
					subjectTemp = typeTmp+":"+testTmp+":"+mesTmp+"#"+display;
				}
			}
			else
			{
				String testStr = subjectTemp.substring(0,subjectTemp.indexOf("="));
				String mesStr = subjectTemp.substring(subjectTemp.indexOf("=")+1);
				StringTokenizer mesTokens = new StringTokenizer(mesStr,",");
				subjectTemp = "";
				String valueFieldTemp = "";
				while(mesTokens.hasMoreTokens())
				{
					String temp = mesTokens.nextToken();
					String mesTmp = "";
					String dispTmp = "";
					String measureValTmp = "";

					int idx = temp.indexOf("#");
					if(idx == -1)
					{
						mesTmp = temp.substring(0,temp.length());
						dispTmp = "";
					}
					else
					{
						mesTmp = temp.substring(0,temp.indexOf("#"));
						dispTmp = temp.substring(temp.indexOf("#")+1);
					}
					measureValTmp = mesTmp;
					mesTmp = mappingInfo.getMeasureDescription(testStr,mesTmp);
					if(subjectTemp.equals(""))
					{
						if(idx == -1)
						{
							subjectTemp = mesTmp;
							valueFieldTemp = measureValTmp;
						}
						else
						{
							subjectTemp = mesTmp + "#" + dispTmp;
							valueFieldTemp = measureValTmp + "#" + dispTmp;
						}
					}
					else
					{
						if(idx == -1)
						{
							subjectTemp = subjectTemp + ","+mesTmp;
							valueFieldTemp = valueFieldTemp + ","+measureValTmp;
						}
						else
						{
							subjectTemp = subjectTemp + ","+mesTmp + "#" + dispTmp;
							valueFieldTemp = valueFieldTemp + ","+measureValTmp + "#" + dispTmp;
						}
					}
				}// End of while
				valueFieldTemp = testStr+"="+valueFieldTemp;
				testStr = mappingInfo.getTestDescription(testStr);
				subjectTemp = testStr +"="+subjectTemp;
				JSONObject serverAssocMeasObj = new JSONObject();
				serverAssocMeasObj.put("displayField",subjectTemp);
				serverAssocMeasObj.put("valueField",valueFieldTemp);
				serverMeasuresArrayJson.add(serverAssocMeasObj);
			}
			//end
			JSONObject associatedMeasuresObj = new JSONObject();
			String aSubject = (String) subjects.get(i);
			associatedMeasuresObj.put("displayField",subjectTemp);
			//associatedMeasuresObj.put("displayField",aSubject);
			associatedMeasuresObj.put("valueField",aSubject);
			//associatedMeasuresObj.put("valueField",aSubject);
			assocMeasuresArrayJson.add(associatedMeasuresObj);
		}
		JSONObject associatedMeasToAddObj = new JSONObject();
		if (measureAdd != null && measureAdd.length() > 0)
		{
			associatedMeasToAddObj.put("displayField",measureAdd);
			associatedMeasToAddObj.put("valueField",measureAdd);
			assocMeasuresArrayJson.add(associatedMeasToAddObj);
		}

		ArrayList alllist = (ArrayList)rep.getVariables("ZONE_REPORT");
		String strDefaultVaribles = "";
		ArrayList defaultList = new ArrayList();
		if (alllist != null && cattype != null && cattype.equalsIgnoreCase("Zone"))
		{
			for (int j = 0; j < alllist.size(); j++)
			{
				String strVariable = (String)alllist.get(j);
				if (strVariable.indexOf("Default:") > -1)
				{
					if(strVariable.indexOf("#") > -1)
					{
						String strDefaultVar = strVariable.substring(strVariable.indexOf(":")+1,strVariable.indexOf("#"));
						strDefaultVaribles += strDefaultVar+",";
					}
				}
			}
			if(strDefaultVaribles.length() >0)
			{
				strDefaultVaribles = strDefaultVaribles.substring(0,strDefaultVaribles.length()-1);
			}
		}
		optionsJson.put("strDefaultVaribles_zoneReport",strDefaultVaribles);
		hiddenJson.put("secType",secType);
		hiddenJson.put("cons","Consolidated");
		hiddenJson.put("catType",cattype);
		hiddenJson.put("testName",testName);
		hiddenJson.put("defaultVaribles",strDefaultVaribles);
		hiddenJson.put("hassociatem",measurelist);
		hiddenJson.put("comName",comName);
		hiddenJson.put("serverMeasure",selectedMeasures);
		hiddenJson.put("Deleted",deleted);
		hiddenJson.put("DeletedMeasure",DeletedMeasure);
		hiddenJson.put("changed","false");
		hiddenJson.put("serverType",serverType);
	}
	else
	{
		Vector errors = new Vector();
		errors.addElement(_mapping.getTextDescription("admin.error.Admin Home"));
		errors.addElement("EgAdminOperations.jsp");
		errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
		errors.addElement(_mapping.getTextDescription("admin.error.Your license does not allow you to use this feature")+".");
		errors.addElement(_mapping.getTextDescription("admin.error.Please contact") + " <a href='mailTo:license@eginnovations.com' target='_parent' class='dash_link'><b>license@eginnovations.com</b></a> " + _mapping.getTextDescription("admin.error.for more details")+".");
		session.putValue("vec_Errors", errors);
		//response.sendRedirect("EgErrors.jsp");
	}
	
	session.setAttribute("adminLastAccessedURL","/final/admin/EgConsolidatedReports.jsp?"+request.getQueryString());
	rootJson.put("optionsJson",optionsJson);
	rootJson.put("hiddenJson",hiddenJson);
	rootJson.put("catTypeArrayJson",catTypeArrayJson);
	rootJson.put("compTypeArrayJson",compTypeArrayJson);
	rootJson.put("testsArrayJson",testsArrayJson);
	rootJson.put("measuresArrayJson",measuresArrayJson);
	rootJson.put("functionsArrayJson",functionsArrayJson);
	rootJson.put("assocMeasuresArrayJson",assocMeasuresArrayJson);
	rootJson.put("serverMeasuresArrayJson",serverMeasuresArrayJson);

out.println(rootJson);
%>



