<%
/*
 *   File			:	EgConfigureVCEventsp.jsp
 *   Purpose		:	Processing page for configuring events for vCenter server
 *   Creation Date	:	07/05/2009
 *   Author			:	Vaathsalya
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.AuditLogThread" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	//IniFile ini = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini",true);

	String strIncludedEvents = request.getParameter("strIncludedEvents");
	String strExcludedEvents = request.getParameter("strExcludedEvents");
	String descriptor = request.getParameter("descriptor");
	String strTestAndDescriptor = "VCEventsTest:"+descriptor.trim();
	String eventEntry = "";

	ArrayList aListIncludedEvents = new ArrayList();
	ArrayList aListExcludedEvents = new ArrayList();

	StringTokenizer eTokens = new StringTokenizer(strExcludedEvents,",");
	while (eTokens.hasMoreTokens())
	{
		String thisToken = eTokens.nextToken().trim();
		aListExcludedEvents.add(thisToken);
	}

	StringTokenizer iTokens = new StringTokenizer(strIncludedEvents,",");
	while (iTokens.hasMoreTokens())
	{
		String token = iTokens.nextToken().trim();
		aListIncludedEvents.add(token);
	}

	if (aListExcludedEvents.size() == 0)
	{
		eventEntry = "all:none";
	}
	else if (aListIncludedEvents.size() == 0)
	{
		eventEntry = "none:all";
	}
	else if (aListIncludedEvents.size() >= aListExcludedEvents.size())
	{
		eventEntry = "all:"+strExcludedEvents;
	}
	else if (aListIncludedEvents.size() < aListExcludedEvents.size())
	{
		eventEntry = strIncludedEvents+":none";
	}
	IniFile ini = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini");
	ini.setValue("VCEventFilterTypes",strTestAndDescriptor,eventEntry);
	ini.saveFile(); 
	EgConfigFilesSync.releaseInstance(ini);

	//auditlog - starts
	EgServicesInfo serviceInfo = new EgServicesInfo("manager");
	boolean isAuditLogEnabled = serviceInfo.isAuditlogEnabled();
	if (isAuditLogEnabled)
	{
		String prevIncludedEvents = request.getParameter("prevIncludedEvents");
		String prevExcludedEvents = request.getParameter("prevExcludedEvents");

		prevIncludedEvents = (prevIncludedEvents !=null)?prevIncludedEvents:"";
		prevExcludedEvents = (prevExcludedEvents !=null)?prevExcludedEvents:"";

		prevIncludedEvents = prevIncludedEvents.substring(1,prevIncludedEvents.length()-1);
		prevExcludedEvents = prevExcludedEvents.substring(1,prevExcludedEvents.length()-1);

		ArrayList aListprevIncludedEvents = new ArrayList();
		ArrayList aListprevExcludedEvents = new ArrayList(); 

		StringTokenizer iTok = new StringTokenizer(prevIncludedEvents,",");
		while (iTok.hasMoreTokens())
		{
			String prevInclEvents = iTok.nextToken().trim();
			aListprevIncludedEvents.add(prevInclEvents);
		}

		StringTokenizer eTok = new StringTokenizer(prevExcludedEvents,",");
		while (eTok.hasMoreTokens())
		{
			String prevExclEvents = eTok.nextToken().trim();
			aListprevExcludedEvents.add(prevExclEvents);
		}

		ArrayList aListNewInclEvent = (ArrayList)aListprevExcludedEvents.clone();
		aListNewInclEvent.removeAll(aListExcludedEvents);

		ArrayList aListNewExclEvent = (ArrayList)aListprevIncludedEvents.clone();
		aListNewExclEvent.removeAll(aListIncludedEvents);

		boolean allowAuditLogOperation = true;

		if (aListNewInclEvent.isEmpty() && aListNewExclEvent.isEmpty())
		{
			allowAuditLogOperation = false;
		}

		if (allowAuditLogOperation)
		{
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","vCenter Events");
			auditLogThread.setValue("Description","vCenter Events have been configured with "+descriptor);

			if (!aListNewInclEvent.isEmpty() && !aListNewExclEvent.isEmpty())
			{
				auditLogThread.setValue("Activity","Included/Excluded Events");
			}
			else if (!aListNewInclEvent.isEmpty() && aListNewExclEvent.isEmpty())
			{
				auditLogThread.setValue("Activity","Included Events");
			}
			else if (aListNewInclEvent.isEmpty() && !aListNewExclEvent.isEmpty())
			{
				auditLogThread.setValue("Activity","Excluded Events");
			}

			for (int i=0; i<aListNewInclEvent.size(); i++)
			{
				String inclEvents = (String)aListNewInclEvent.get(i);
				if (inclEvents != null && 
					!inclEvents.equalsIgnoreCase("null") && 
					inclEvents.trim().length() > 0)
				{
					auditLogThread.setCurrentValue("INCLUDED EVENT(S)",inclEvents);
				}
			}

			for (int i=0; i<aListNewExclEvent.size(); i++)
			{
				String exclEvents = (String)aListNewExclEvent.get(i);
				if (exclEvents != null && 
					!exclEvents.equalsIgnoreCase("null") && 
					exclEvents.trim().length() > 0)
				{
					auditLogThread.setCurrentValue("EXCLUDED EVENT(S)",exclEvents);
				}
			}

			auditLogThread.sendItToDB();
		}
	}
	//for auditlog - ends

	String query = "EgConfigureVCEvents.jsp?descriptor="+descriptor;
	String fromPage = request.getParameter("fromPage");
	if (fromPage != null && fromPage.equalsIgnoreCase("TestConfiguration"))
	{
		query = query + "&fromPage=TestConfiguration";
	}
%>

<jsp:forward page="<%=query%>"/>



