<%
/*************************************************************************************************/
/*                 Name          : EgAutoManageComponents.jsp                                    */
/*                 Purpose       : This page is used to manage all (or) specific components      */
/*                                 while creating Auto Topology segm ents                        */
/*                 Version       : 5.4                                                           */
/*                 Created On    : 05-08-2011                                                    */
/*************************************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.IniHelper"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.EgManagersIniForManager"%>
<%@ page import = "com.eg.TransmitInfosToAllSMs"%>
<%@ page import = "com.egurkha.util.*" %>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<jsp:useBean id="servicer" scope="request" class="egurkha.ServiceBean"/>
<jsp:useBean id="user" scope="request" class="egurkha.UserBean"/>
<jsp:useBean id="manager" scope="request" class="egurkha.ConfigBean"/>
<jsp:useBean id="EgConfigTopo1" scope="page" class="egurkha.ConfigTopology"/>
<jsp:useBean id="tpbean" scope="request" class="egurkha.EgTestParamBean"/>
<jsp:useBean id="trans" scope="request" class="egurkha.TransactionBean"/>
<jsp:useBean id="trans1" scope="request" class="egurkha.TransactionBean"/>
<jsp:useBean id="ecumb" scope="page" class="com.egurkha.monitor.EgComponentUserMappingBean" />
<%!
	/*
		This method returns, list of new components form the given segment name
	*/
	private ArrayList getNewComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		ArrayList result = new ArrayList();
		Set thisSet = new TreeSet();
		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String checkValue = disIniFile.getValue(thisCompName,newstr+varName);
			if(checkValue!=null && checkValue.length() > 0)
			{
				thisSet.add(varName);
			}

			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String chkval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				if(chkval!=null && chkval.length() > 0)
				{
					thisSet.add(tmpvar);
				}
			}
		}
		if(thisSet!=null && thisSet.size() > 0)
		{
			result = new ArrayList(thisSet);
		}
		return result;
	}


	/*
		This method returns, list of New & Unmanaged components form the given segment name
	*/
	private Hashtable getUnmanageAndNewComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		
		Hashtable result = new Hashtable();
		ArrayList newList = new ArrayList();
		ArrayList unmanageList = new ArrayList();
		Set newSet = new TreeSet();
		Set unmanageSet = new TreeSet();

		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName,newstr+varName);
			if(newValue!=null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else	// Check for unmanage component
			{
				String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
				if(unmanageValue!=null && unmanageValue.length() > 0)
				{
					unmanageSet.add(varName);
				}
			}

			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String newval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				if(newval!=null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else
				{
					String unmanageValue = disIniFile.getValue(tmpcompname,unmanagestr+tmpvar);
					if(unmanageValue!=null && unmanageValue.length() > 0)
					{
						unmanageSet.add(tmpvar);
					}
				}
			}
		}

		if(newSet!=null && newSet.size() > 0)
			newList = new ArrayList(newSet);
		if(unmanageSet!=null && unmanageSet.size() > 0)
			unmanageList = new ArrayList(unmanageSet);
		result.put("NEW" , newList);
		result.put("UNMANAGE" , unmanageList);
		return result;
	}
%>

<%

	String segment = request.getParameter("segment");
	String chkall = request.getParameter("chkall");
	ArrayList newServerList = new ArrayList();
	ArrayList unManageList = new ArrayList();
	
	String saveFrom = request.getParameter("saveFrom");
	if(saveFrom==null) saveFrom="";
	
	if(chkall!=null && chkall.equals("true"))
	{
		Hashtable myTable = getUnmanageAndNewComponents(segment);
		newServerList = (ArrayList) myTable.get("NEW");
		unManageList = (ArrayList) myTable.get("UNMANAGE");
		if(unManageList!=null && unManageList.size() > 0)
			newServerList.addAll(unManageList);
	}
	else
	{
		String test = request.getParameter("test");
		if(test!=null && test.length() > 0)
		{
			StringTokenizer st = new StringTokenizer(test,",");
			while(st.hasMoreTokens())
			{
				newServerList.add(st.nextToken());
			}
		}
	}

	EgConfigTopo1.createFile("eg_services.ini");
	int compSize = Integer.parseInt(EgConfigTopo1.getValues("MISC_ARGS","MaxManagedComponentsForDisc"));
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	String[] sTypes = egRoleInfo.getServerTypes();
	boolean hasLimitExceeded=false;
	int cnt=0;
	if (sTypes != null && sTypes.length > 0)
	{
		for (int st=0;st<sTypes.length;st++)
		{
			String[] strComps = egRoleInfo.getAllServersOfType(sTypes[st]);
			if (strComps.length > 0)
			{
				cnt = cnt + strComps.length;
				if (cnt > compSize)
				{
					hasLimitExceeded = true;
					break;
				}
			}
		}
	}

	Hashtable ht = new Hashtable();
	for(int k=0;k<newServerList.size();k++)
	{
		String element = (String) newServerList.get(k);
		String compType = element.substring(0,element.indexOf(":"));
		String compName = element.substring(element.indexOf(":")+1);

		Object hashValue =  ht.get(compType);
		if(hashValue!=null)
		{
			ArrayList compList = (ArrayList) hashValue;
			compList.add(compName);
			ht.put(compType,compList);
		}
		else
		{
			ArrayList compList = new ArrayList();
			compList.add(compName);
			ht.put(compType,compList);
		}
	}

	int status = 0;
	boolean callBasicErrorPage = false;
	Hashtable managedTable = new Hashtable();
	Hashtable nickExistsTable = new Hashtable();
	Vector err_msg = new Vector();
	Vector sess_vec = new Vector();
	Vector updateServers = new Vector();
	String eGInstallDir = EgInstallInfo.getInstallDir();

	IniFile serviceInfo = new IniFile(eGInstallDir + "/manager/config/eg_services.ini");
	IniFile discoverInfo = new IniFile(eGInstallDir + "/manager/config/eg_discover.ini");
	IniFile egUISave = new IniFile(eGInstallDir + "/manager/config/eg_ui.ini");
	String showUsers = egUISave.getValue("ALARM_HISTORY","Show_Users");
	
	String[] agentlessInfo = serviceInfo.getVariables("DEFAULT_AGENTLESS_SETTINGS");
	List agentlessInfoList = new ArrayList();
	if (agentlessInfo != null)
	{
		agentlessInfoList = new ArrayList(Arrays.asList(agentlessInfo));
	}

	//Basic Agent Check
	// new to put the new code for eg_external.ini
	String type1 = servicer.getAlOption();
	boolean flag11 = false;
	if(type1 == null)
		flag11 = false;
	else if(type1.equalsIgnoreCase("yes"))
		flag11 = true;
	else
		flag11 = false;

	EgSpecsInfo specsinfo1 = new EgSpecsInfo("manager");
	EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
	EgExternalInfo externalInfo = new EgExternalInfo("manager");

	Hashtable nickIPMap = new Hashtable();
	Hashtable hTableAllNicksIp = new Hashtable();
	Vector v_virtservers = externalInfo.getVirtualServers();

	Set keys = ht.keySet();
	Iterator itr = keys.iterator();

	while(itr.hasNext())
	{
		String srvtype = (String)itr.next();
		ArrayList thisList = (ArrayList) ht.get(srvtype);
		if(thisList == null)
			continue;

		nickIPMap = egDiscInfo.getNickIpMap();
		hTableAllNicksIp = egDiscInfo.getAllNicksIpMap();
		ArrayList aListNickAlreadyExists = new ArrayList();
		String strAlreadyExists = "";
		List preManagedList = new ArrayList();
		updateServers.clear();

		String[] comps = discoverInfo.getVariables(srvtype);
		if (comps != null)
		{
			for (int i=0; i<comps.length; i++)
			{
				String strComp = comps[i];
				if (strComp.startsWith(srvtype+":"))
				{
					strComp = strComp.substring(strComp.indexOf(":")+1);
					strComp = strComp.substring(0,strComp.indexOf(":"));
					preManagedList.add(strComp);
				}
			}
		}
		servicer.stopDiscovery();
		Vector finalServers = new Vector();
		Vector finalSvrs = new Vector();
		Vector managedVector = new Vector();
		Vector v_managedserver=new Vector();
		Vector newManServers = new Vector();
		Vector oldManServers = new Vector();
		StringBuffer manage = new StringBuffer();
		boolean update = false;

		String[] allServers = egDiscInfo.getAllServersOfType(srvtype); // Already managed components
		for(int k=0;k<allServers.length;k++)
		{
			String thisServer = allServers[k];
			managedVector.add(thisServer);
			oldManServers.add(thisServer);
			String nickWithPort = thisServer.substring(thisServer.indexOf(":")+1);
			manage.append(nickWithPort+",");
		}

		for(int k=0;k<thisList.size();k++)
		{
			String nickWithPort = (String)thisList.get(k);
			String strNick = nickWithPort.substring(0,nickWithPort.indexOf(":"));
			manage.append(nickWithPort+",");
		}

		StringTokenizer managedTokens = new StringTokenizer(manage.toString(),",");
		while(managedTokens.hasMoreTokens())
		{
			String token = (String) managedTokens.nextToken();
			String strNick = token.substring(0,token.indexOf(":"));
			if(!managedVector.contains(srvtype+":"+token))
			{
				if (nickIPMap.containsKey(strNick))
				{
					String managedIP = (String)nickIPMap.get(strNick);
					String manAndUnManIp = (String)hTableAllNicksIp.get(strNick);
					if (manAndUnManIp.indexOf(":")>-1)
					{
						StringTokenizer st = new StringTokenizer(manAndUnManIp,":");
						while (st.hasMoreTokens())
						{
							String thisTok = st.nextToken();
							if (thisTok.equals(managedIP))
							{
								String removeNull = "";
								String strForResultsPage = "";
								if (token.indexOf(":NULL")>-1)
								{
									removeNull = token.substring(0,token.indexOf(":NULL"));
									strForResultsPage = removeNull;
								}
								else
								{
									removeNull = token;
									strForResultsPage = token.substring(0,token.indexOf(":"))+"$#"+token.substring(token.indexOf(":")+1);
								}
								if (strAlreadyExists.equals(""))
								{
									strAlreadyExists = strForResultsPage;
								}
								else
								{
									strAlreadyExists = strAlreadyExists+", "+strForResultsPage;
								}
								aListNickAlreadyExists.add(removeNull);
								break;
							}
						}
					}
				}
				if (aListNickAlreadyExists.size()>0)
				{
					continue;
				}
			}
		}

		StringTokenizer st = new StringTokenizer(manage.toString(),",");
		String strTok = "";
		while(st.hasMoreTokens())
		{
			strTok = st.nextToken().trim();
			if (!aListNickAlreadyExists.contains(strTok))
			{
				if(!newManServers.contains(strTok))
					newManServers.add(strTok);
				if (!v_managedserver.contains(strTok))
				{
					v_managedserver.add(strTok);
				}
			}
		}

		for(int i=0; i<newManServers.size(); i++)
		{
			strTok = (String)newManServers.get(i);
			if(!finalSvrs.contains(strTok))
				finalSvrs.add(strTok);

			strTok = strTok.substring(0,strTok.indexOf(":"));
			if(!finalServers.contains(strTok))
				finalServers.add(strTok);
		}
		if(flag11) // default is agentless
		{
			boolean flag12=false;
			if(srvtype != null) 
				flag12 = specsinfo1.isAgentlessServer(srvtype);
			System.out.println("flag12 :"+flag12 + "  "+srvtype);
			if (flag12 && agentlessInfoList.contains(srvtype))
			{
				if (user.checkAlServers (srvtype,finalServers, finalSvrs))
				{
					System.out.println("\t user.checkAlServers :"+srvtype);
					EgConfigTopo1.createFile("eg_external.ini");
					String defaultRemoteAgent[] = EgConfigTopo1.getVariables("Eg_Remote_Agents");
					ArrayList extEntries = new ArrayList();
					if(defaultRemoteAgent != null && defaultRemoteAgent.length > 0)
					{
						for(int kk =0;kk<finalServers.size();kk++)
						{
							String value = (String)finalServers.get(kk);
							if (preManagedList.contains(value))
							{
								continue;
							}

							String temp12 = EgConfigTopo1.getValues("Remote_Agent_Mapping_Section", value);
							if (StringUtils.isNull(temp12))
							{
								temp12 = defaultRemoteAgent[0];
							}
							//EgConfigTopo1.setValues("Remote_Agent_Mapping_Section", value, temp12);
							extEntries.add(new IniHelper("Remote_Agent_Mapping_Section", value, temp12));
							String alTokens = EgConfigTopo1.getValues("Agentless_Infos_Section", value);
							String pwd="NONE";
							String useral="None";
							String modeal="None";
							String osal = "None";
							String sshport = "22";

							//if (agentlessInfoList.contains(srvtype))// Only the server type exist under 'DEFAULT_AGENTLESS_SETTINGS'
							//{
								String strVal = serviceInfo.getValue("DEFAULT_AGENTLESS_SETTINGS",srvtype);
								strVal = (strVal!=null)?strVal:"";
								StringTokenizer stt = new StringTokenizer(strVal,",");
								if(stt.countTokens()==4)
								{
									useral = stt.nextToken();
									pwd = stt.nextToken();
									osal = stt.nextToken();
									modeal = stt.nextToken();
								}
							//}

							if(alTokens == null || alTokens.length() == 0)
							{
								pwd = EgCrypt.decrypt(pwd);
								pwd = EgCrypt.encrypt(pwd);
							}
							else
							{
								StringTokenizer st1 = new StringTokenizer(alTokens,",");
								useral = (String)st1.nextToken();
								pwd = (String)st1.nextToken();
								modeal = (String)st1.nextToken();
								osal = (String)st1.nextToken();
								if(st1.hasMoreTokens())
									sshport = (String)st1.nextToken();
								else
									sshport ="";
								pwd = EgCrypt.decrypt(pwd);
								pwd = EgCrypt.encrypt(pwd);
							}
							if(sshport != null && !sshport.equals(""))
							{
								//EgConfigTopo1.setValues("Agentless_Infos_Section", value, useral+","+pwd+","+modeal+","+osal+","+sshport);
								extEntries.add(new IniHelper("Agentless_Infos_Section", value, useral+","+pwd+","+modeal+","+osal+","+sshport));
							}
							else
							{
								//EgConfigTopo1.setValues("Agentless_Infos_Section", value, useral+","+pwd+","+modeal+","+osal);
								extEntries.add(new IniHelper("Agentless_Infos_Section", value, useral+","+pwd+","+modeal+","+osal));
							}
						}
					}

					if (extEntries.size() > 0)
					{
						IniFile discWr = EgConfigFilesSync.getInstance(eGInstallDir + "/manager/config/eg_external.ini");
						for(int e=0; e < extEntries.size(); e++)
						{
							IniHelper iniHelr = (IniHelper) extEntries.get(e);
							String sub = iniHelr.getSubject();
							String key = iniHelr.getVariable();
							String value = iniHelr.getValue();
							discWr.setValue(sub,key,value);
						}
						discWr.saveFile();
						EgConfigFilesSync.releaseInstance(discWr);
					}
					//EgConfigTopo1.saveFile();
				}
				else
				{
					status = 6;
					callBasicErrorPage = true;
				}
			}
		}

		if(callBasicErrorPage)
		{
			System.out.println("callBasicErrorPage is True ... after status 6  so breaking...."); 
			break;
		}

		if (!callBasicErrorPage)
		{
			status = user.checkBasicAgentCount(srvtype,finalSvrs,1,"","","","");
			System.out.println("\t STATUS :"+status);
			if(status == 1)
				update = true;
			else if(status == 2 || status == 3 || status == 4 || status == 5)
				callBasicErrorPage = true;
		}

		if(update)
		{
			//Manage the component
			manager.createSyncFile("eg_discover.ini","save");
			for(int k=0;k<thisList.size();k++)
			{
				String thiscomp = (String) thisList.get(k);
				if(aListNickAlreadyExists.size() > 0)
				{
					if(aListNickAlreadyExists.contains(thiscomp))
					{
						//System.out.println("aListNickAlreadyExists .If BLOCK Going to continue..... :"+aListNickAlreadyExists);
						ArrayList tmpList = (ArrayList) nickExistsTable.get(srvtype);
						if(tmpList!=null && tmpList.size() > 0)
						{
							tmpList.add(thiscomp);
							nickExistsTable.put(srvtype,tmpList);
						}
						else
						{
							tmpList = new ArrayList();
							tmpList.add(thiscomp);
							nickExistsTable.put(srvtype,tmpList);
						}
						continue;
					}
				}
				else
				{
					// Manage the component .. add an entry in eg_discover.ini.
					manager.setManageNew(srvtype, thiscomp);
					ArrayList tmpList = (ArrayList) managedTable.get(srvtype);
					if(tmpList!=null && tmpList.size() > 0)
					{
						tmpList.add(thiscomp);
						managedTable.put(srvtype,tmpList);
					}
					else
					{
						tmpList = new ArrayList();
						tmpList.add(thiscomp);
						managedTable.put(srvtype,tmpList);
					}
				}
			}
			manager.saveFile();
			manager.releaseInstance();
			ArrayList externalEntries = new ArrayList();

			if(v_virtservers.contains(srvtype))
			{
				for (int m=0;m<v_managedserver.size(); m++)
				{
					String server = (String)v_managedserver.get(m);
					String serverName = Server.getServerNameWithoutPort(server);
					if(nickIPMap!=null )
					{
						String ip=(String)nickIPMap.get(serverName);
						if (ip!=null)
						{
							//EgConfigTopo1.setValues("Virtual_Hosts",serverType+":"+server,ip);
							externalEntries.add(new IniHelper(IniHelper.SET,"Virtual_Hosts",srvtype+":"+server,ip));
						}
					}
				}
			}

			if (externalEntries.size() > 0)
			{
				IniFile externalWrite = EgConfigFilesSync.getInstance(eGInstallDir +"/manager/config/eg_external.ini");
				for (int e=0; e < externalEntries.size(); e++)
				{
					IniHelper iniHelper = (IniHelper) externalEntries.get(e);
					String iniAction = iniHelper.getAction();
					String sub = iniHelper.getSubject();
					String key = iniHelper.getVariable();
					String value = iniHelper.getValue();
					if (iniAction != null)
					{
						if (iniAction.equals(IniHelper.SET))
						{
							externalWrite.setValue(sub,key,value);
						}
						else if (iniAction.equals(IniHelper.DELETE))
						{
							externalWrite.deleteValue(sub,key);
						}
					}
				}
				externalWrite.saveFile();
				EgConfigFilesSync.releaseInstance(externalWrite);
			}

			if (hasLimitExceeded)
			{
				servicer.startDiscovery("1");
			}
			else
			{
				servicer.startDiscovery("1",true);
			}

			String curr_date=null;
			if(showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
			{
				curr_date=String.valueOf(new java.util.Date());
				if(ecumb.hashLastComponentUserUpdated!=null && ecumb.hashLastComponentUserUpdated.size()>0)
				{
					ecumb.hashLastComponentUserUpdated.put("Updated",(String)curr_date);
				}
				else
				{
					ecumb.hashLastComponentUserUpdated=new Hashtable();
					ecumb.hashLastComponentUserUpdated.put("Updated",(String)curr_date);
				}
			}

			if(EgInstallInfo.isClusterSupported && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")) && curr_date!=null)
			{
				//upload the result file to all other managers
				EgManagersIniForManager mi = EgManagersIniForManager.getInstance();
				if(mi.isPrimaryManager())
				{
					TransmitInfosToAllSMs transmitInfoToSecondaryManagers = null;
					transmitInfoToSecondaryManagers =  TransmitInfosToAllSMs.getInstance();
					Vector param = new Vector();
					param.add(curr_date);

					Vector info = new Vector();
					info.add("UserCompUpdate");
					info.add(param);

					transmitInfoToSecondaryManagers.setData(info);
				}
			}

			if (aListNickAlreadyExists.size()>0)
			{
				sess_vec.add(_mapping.getTextDescription("admin.server.The following component(s) of type")+" "+_mapping.getComponentTypeDescription(srvtype)+" "+_mapping.getTextDescription("admin.server.could not be managed")+" ;"+strAlreadyExists);
				System.out.println(" EgAutoManageComponents ..aListNickAlreadyExists ...Last .");
				System.out.println("\t sess_vec:"+sess_vec);
			}
			else
			{
				sess_vec.add(_mapping.getTextDescription("admin.server.Components have been Managed successfully"));
			}
		}

		if (callBasicErrorPage)
		{
			String msgString = "";
			if(status==2)
			{
				msgString = "admin.error.You are exceeding the number of premium agents allowed by your license";
			}
			else if(status==3)
			{
				msgString = "admin.error.You are exceeding the total number of agents permitted by your license";
			}
			else if(status==4)
			{
				msgString = "admin.error.You are exceeding the total number of applications permitted by your license";
			}
			else if(status==5)
			{
				msgString = "admin.error.You are exceeding the total number of network devices permitted by your license";
			}
			else if(status==6)
			{
				msgString = "admin.error.You are exceeding the total number of agentless components permitted by your license";
			}
			err_msg.add(_mapping.getTextDescription(msgString)+"!");
			break;
		}
	}
%>
<html>
<head>
<title>Manage components</title>
<egui:skin ui="admin"/>
<script>
function hide()
{
	setTimeout(function(){
							var manageDiv = parent.document.getElementById("manageDiv");
							if(manageDiv!=null)
							{
								manageDiv.style.display='none';
							}
						}, 10000);
}
</script>
</head>
<!-- <body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onload="javascript:hide();"> -->
<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">

<%
	boolean anyManaged = false;
	boolean nickProblem = false;
	if(managedTable!=null && managedTable.size() > 0)
		anyManaged = true;
	if(nickExistsTable!=null && nickExistsTable.size() > 0)
		nickProblem = true;
	if(anyManaged)
	{
		Set serverTypes = managedTable.keySet();
		Iterator thisItr = serverTypes.iterator();
%>
<table border="0" cellspacing="0" cellpadding="0" align="center" width="100%">
	<tr>
		<td valign="top" width="100%" align="center" >&nbsp;</td>
	</tr>
	<tr>
		<td height="20" align="left"  class="eg_lightlight" style="border-bottom-width:1px">  
			<table align="center" cellspacing="0" cellpadding="4" border="0" >
				<tr>
					<td height="24" nowrap align="right"><img src="/final/admin/eg_images/info2.gif"> </td>
					<td height="24" nowrap><egui:intnl text="admin.servers.The following components are managed successfully "/></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="95%" border="0" style="table-layout:fixed;" >
				<col width="7"><col width="100%"><col width="150"><col width="250"><col width="7">
				<tr>
					<td colspan="5" >&nbsp;</td>
				</tr>
				<tr>
					<td id="subhead_left" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
					<td id="eg_subheadbg" height="22" align="center" style="border-left-width:0px"><strong><egui:intnl text="admin.servers.Host / Nick Name"/></strong></td>
					<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Port"/></strong></td>
					<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Component Type"/></strong></td>
					<td id="subhead_right" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
				</tr>
<%
		while(thisItr.hasNext())
		{
			String compType = (String) thisItr.next();
			ArrayList compList = (ArrayList) managedTable.get(compType);
			for(int k=0;k<compList.size();k++)
			{
				String compName = (String) compList.get(k);
				String hostName = compName.substring(0,compName.indexOf(":"));
				String portNo = compName.substring(compName.indexOf(":")+1);
%>
				<tr>
					<td width="7" id="cell_border3"  style="border-left-width:1px;border-right-width:0px" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
					<td id="cell_border3" align="left" class="left_space10" height="22"><b><%=hostName%></b></td>
					<td id="cell_border4" align="left"class="left_space10" height="22" style="border-right-width:0px"><%=portNo%></td>
					<td style="border-right-width:0px" id="cell_border3" align="left" class="left_space10" height="22"><egui:intnl type="<%=compType%>"/></td>
					<td width="7" id="cell_border3" height="22" style="border-left-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
				</tr>
<%
			}
		}
%>
			</table>
		</td>
	</tr>
	<tr>
		<td valign="top" width="100%" align="center" >&nbsp;</td>
	</tr>
	<tr>
		<td valign="top" width="100%" align="center" ><input type="button" id="eg_back" name="exitButton" value='<egui:intnl text="admin.servers.OK"/>' style="width:90px;" onclick="javascript:closeManageAllDiv();"></td>
	</tr>
	
	<%
		if(saveFrom.equals("previewPage"))
		{
			if(chkall!=null && chkall.equals("true"))
			{
	%>					
				<tr>
					<td valign="top" width="100%" align="center" >&nbsp;</td>
				</tr>
				<tr>
					<td valign="top" width="100%" align="center" ><input type="button" id="eg_back" name="exitButton" value='<egui:intnl text="admin.servers.Save Topology"/>' style="width:130px;" onclick="javascript:saveOption('<%=segment%>','AutoManageComponent',event);"></td>
				</tr>
	<%		}			
		}	
	%>
</table><br>
<%
	}

	if(nickProblem)
	{
		Set myKeys = nickExistsTable.keySet();
		Iterator tmpItr = myKeys.iterator();
%>
<table border="0" cellspacing="0" cellpadding="0" align="center" width="100%">
	<tr>
		<td valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0" style="table-layout:fixed;" >
				<col width="7"><col width="100%"><col width="150"><col width="250"><col width="7">
				<tr>
					<td colspan="5" >&nbsp;</td>
				</tr>
				<tr>
					<td colspan="5" class="padding6"><b><egui:intnl text="admin.server.The following components could not be managed due to nick name already exists "/></b></td>
				</tr>
				<tr>
					<td id="subhead_left" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
					<td id="eg_subheadbg" height="22" align="center" style="border-left-width:0px"><strong><egui:intnl text="admin.servers.Host / Nick Name"/></strong></td>
					<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Port"/></strong></td>
					<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><strong><egui:intnl text="admin.servers.Component Type"/></strong></td>
					<td id="subhead_right" width="7" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
				</tr>
<%
		while(tmpItr.hasNext())
		{
			String compType = (String) tmpItr.next();
			ArrayList compList = (ArrayList) nickExistsTable.get(compType);
			for(int k=0;k<compList.size();k++)
			{
				String compName = (String) compList.get(k);
				String hostName = compName.substring(0,compName.indexOf(":"));
				String portNo = compName.substring(compName.indexOf(":")+1);
%>
				<tr>
					<td width="7" id="cell_border3"  style="border-left-width:1px;border-right-width:0px" height="22"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
					<td id="cell_border3" align="left" class="left_space10" height="22"><b><%=hostName%></b></td>
					<td id="cell_border4" align="left"class="left_space10" height="22" style="border-right-width:0px"><%=portNo%></td>
					<td style="border-right-width:0px" id="cell_border3" align="left" class="left_space10" height="22"><egui:intnl type="<%=compType%>"/></td>
					<td width="7" id="cell_border3" height="22" style="border-left-width:0px"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
				</tr>
<%
			}
		}
%>
			</table>
		</td>
	</tr>
</table><br>
<%
	}
	if(callBasicErrorPage)
	{
		String licenseMsg = _mapping.getTextDescription("admin.error.To upgrade your license to support additional premium agents")+", "+_mapping.getTextDescription("admin.error.please contact")+" <b>license@eginnovations.com</b>";
%>
<table border="0" cellspacing="0" cellpadding="0" align="center" width="100%">
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td>
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" style="table-layout:collapse"><col width="7"><col width="175"><col width="40"><col width="100%"><col width="7">
							<tr>
								<td height="6" id="inner_top_left" width="7" ><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" id="inner_top_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<tr>
								<td colspan="5" height="50" nowrap align="center" id="eg_subcontentbg" class="form_spacing">
									<table border="0" cellspacing="0" cellpadding="5" bordercolor="red">
										<tr>
											<td style="width:100px" align="left" valign="top"><img src="/final/admin/eg_images/<%=admin_Skin%>/icon_okay.gif"></td>
											<td width="100%"><b>
<%
		for(int i=0;i<err_msg.size();i++)
		{
			String str_output=(String)err_msg.elementAt(i);
%>
												<%=str_output%><br>
<%
		}
%>
											</b></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td height="6" class="inner_bott_left" width="7" > <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" class="inner_bott_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<tr>
								<td colspan="5" width="100%" id="eg_whitebg" align="center" valign="middle"><br/> <%=licenseMsg%> </td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<%
	}
%>
</body>
</html>
