<%
/*************************************************************************************************/
/*                 Name          : EgAutoCompTypes.jsp                                           */
/*                 Purpose       : This page is used to create Java script Auto Topology         */
/*                                 When connect/ uses concepts involves in Auto Topology, this   */
/*                                 page shows the component type                                 */
/*                 Version       : 5.4                                                           */
/*                 Created On    : 05-08-2011                                                    */
/*************************************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.IniFile" %>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgDiscInfo2"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgDiscInfo2 discInfo2 = new EgDiscInfo2("manager");
	EgGroupInfo groupInfo = new EgGroupInfo();
	Vector resultVec = new Vector();
	Set serverTypes = new TreeSet();
	ArrayList thisZoneComponents = new ArrayList();		// Contains all components from the given zone.
	ArrayList allZoneComponents = new ArrayList();		// Contains all components from all Zones Except the selected Zone

	String zone = request.getParameter("zone");
	String segment = request.getParameter("segment");
	String frmcomptype =request.getParameter("frmcomptype");
	String frmcompname = request.getParameter("frmcompname");
	String link = request.getParameter("link");
	String zoom = request.getParameter("zoom");
	if(zoom == null)
			zoom = "100";
	if(link == null)
		link = "connect";

	String m_choice ="";
	String n_choice="";
	String un_choice="";
	String choice = request.getParameter("choice");
	if(choice == null){
		choice = "managedComp";
		m_choice = "checked";
	}
	else{
		if(choice.equals("managedComp")){
			m_choice ="checked";
		}
		else if(choice.equals("newComp")){
			n_choice = "checked";
		}
		else if(choice.equals("unManagedComp")){
			un_choice ="checked";
		}
	}

	String modifySegment = request.getParameter("modifySegment");
	if(modifySegment==null)
		modifySegment="";
	// Collect Zone componets, if zone is not Default
	boolean isZone = false;
	if(zone!=null && !zone.equals("-1")){
		thisZoneComponents = groupInfo.getAllComponentsUnderZone(zone);
		isZone = true;
	}
	Hashtable tmpHt = groupInfo.getAllComponentsUnderZone();
	if(tmpHt!=null && tmpHt.size() > 0)
	{
		if(isZone && tmpHt.containsKey(zone))
		{
			tmpHt.remove(zone);
		}
		ArrayList valList = new ArrayList(tmpHt.values());
		for(int k=0;k<valList.size();k++)
		{
			ArrayList tmpList = (ArrayList) valList.get(k);
			allZoneComponents.addAll(tmpList);
		}
	}
%>
<html>
<head>
<title>Auto Topology - Connect / Uses Page I</title>
<egui:skin ui="admin"/>
<script  src="/final/jquery/jquery.js"></script>
<script type="text/javascript">

var $j = jQuery.noConflict();

function createRequestObject()
{
	var request_o;
	var browser = navigator.appName;
	if(browser == "Microsoft Internet Explorer")
		request_o = new ActiveXObject("Microsoft.XMLHTTP");
	else
		request_o = new XMLHttpRequest();
	return request_o;
}

function showComps(val)
{
	var thissegment = document.getElementById("segment").value;
	var thiszone= document.getElementById("zone").value;
	var frmcomptype = document.getElementById('frmcomptype').value;
	var frmcompname = document.getElementById('frmcompname').value;
	var link = document.getElementById('link').value;
	var zoom = document.getElementById('zoom').value;
	var modifySegment ='<%=modifySegment%>';
	var url = "/final/admin/EgAutoCompTypes.jsp?segment="+encodeURI(thissegment)+"&zone="+encodeURI(thiszone)+"&choice="+encodeURI(val)+"&link="+encodeURI(link)+"&frmcomptype="+encodeURI(frmcomptype)+"&frmcompname="+encodeURI(frmcompname)+"&zoom="+encodeURI(zoom)+"&modifySegment="+encodeURI(modifySegment);
	$j("#innerConnectDiv").load(url);
	//setTimeout(function(){ window.location = url;}, 0);
}

function showComponent(value, choice)
{
	var thiszone = document.getElementById('zone').value;
	var thissegment = document.getElementById('segment').value;
	var frmcomptype = document.getElementById('frmcomptype').value;
	var frmcompname = document.getElementById('frmcompname').value;
	//var choice = 'managedComp';
	//if('<%//=n_choice%>' == 'checked')
	//	choice = 'newComp';
	var url = '/final/admin/EgAutoCompNames.jsp?comptype='+encodeURI(value)+"&zone="+encodeURI(thiszone)+"&segment="+encodeURI(thissegment)+"&choice="+encodeURI(choice)+"&frmcomptype="+encodeURI(frmcomptype)+"&frmcompname="+encodeURI(frmcompname);
	var compDiv = document.getElementById('compDiv');
	loadPage(url,compDiv, null);
}

function loadPage(url,divObj, action)
{
	var frmcomptype = document.getElementById('frmcomptype').value;
	var frmcompname = document.getElementById('frmcompname').value;
	if(frmcompname.indexOf(":NULL") > 0)
	{
		frmcompname = frmcompname.substring(0,frmcompname.indexOf(":NULL"));
	}
	var httpObj = createRequestObject();
	var params = "";
	var tempurl = "";
	if (url.indexOf("?") > -1)
	{
		params=url.substring(url.indexOf("?")+1);
		tempurl=url.substring(0,url.indexOf("?"));
	}
	else
	{
		tempurl=url;
	}
	httpObj.open('POST',tempurl,true);
	httpObj.setRequestHeader('Content-type','application/x-www-form-urlencoded');
	httpObj.setRequestHeader('Content-length',params.length);
	httpObj.setRequestHeader('Connection','close');
	httpObj.onreadystatechange = function() {
		if (httpObj.readyState == 4 && httpObj.status == 200)
		{
			if(action == null)
			{
				var res=httpObj.responseText;
				if(divObj!=null)
					divObj.innerHTML=res;
			}
			else
			{
				if(action == 'addlink' || action == 'removelink')
				{
					var thiszone = document.getElementById('zone').value;
					var thissegment = document.getElementById('segment').value;
					var myframe = document.getElementById('myFrame');
					var zoom = document.getElementById('zoom').value;
					var modifySegment ='<%=modifySegment%>';
					if(myframe!=null)
					{
						var myUrl = "/final/admin/EgAutoMainPage.jsp?segment="+encodeURI(thissegment) +"&zone="+encodeURI(thiszone)+"&zoom="+encodeURI(zoom)+"&hlcomp="+encodeURI(frmcompname)+"&hlcomptype="+encodeURI(frmcomptype)+"&modify="+encodeURI(modifySegment)
						+"&fromAutoCompType=true";
						setTimeout(function(){myframe.src = myUrl;}, 0);
					}
				}
			}
		}
	}
	httpObj.send(params);
}

function addOrRemove(chkname,chkvalue)
{
	var thissegment = document.getElementById("segment").value;
	var thiszone= document.getElementById("zone").value;
	var thiscomptype = document.getElementById('comptype').value;
	var thiscompname = chkvalue;
	var link = document.getElementById('link').value;
	var frmcomptype = document.getElementById('frmcomptype').value;
	var frmcompname = document.getElementById('frmcompname').value;

	var action = 'addlink';
	if(document.getElementById(chkname).checked){
		action = 'addlink';
	}
	else{
		action = 'removelink';
	}

	var url = '/final/servlet/com.eg.EgAutoTopologyServlet?segment='+encodeURI(thissegment)+'&zone='+encodeURI(thiszone)+'&comptype='+encodeURI(thiscomptype)+'&compname='+encodeURI(thiscompname)+'&link='+encodeURI(link)+'&action='+encodeURI(action)+"&frmcompname="+encodeURI(frmcompname)+"&frmcomptype="+encodeURI(frmcomptype);
	loadPage(url, null, action);
}

function showAlert(event,msg)
{
	var groupInfoDiv=document.getElementById("groupInfoDiv");
	if(groupInfoDiv!=null)
	{
		if(navigator.appName=="Microsoft Internet Explorer")
		{
			event = window.event;
		}
		groupInfoDiv.style.left = 25;
		groupInfoDiv.style.top = 55; //event.clientX;
		//var tmptokens = msg.split(",");
		var str = '<table cellspacing="0" cellpadding="0" border="0" width="75" class="linesquare">';
				str+= '<tr>';
					str+= '<td align="center" width="75">';
						str+= '<table cellspacing="0" cellpadding="2" border="0" bgcolor="white" width="100%">';
		//for(var i=0; i<tmptokens.length;i++)
		//{
							str+='<tr>';
								str+='<td id="cell_border4" align="left" class="left_space10" style="border-right-width:0px" nowrap >';
									str+="<egui:intnl text='It belongs to Group '/>" 
									str+="&nbsp;<b>"+ msg +"</b>";
								str+='</td>';
							str+='</tr>';
		//}

						str+='</table>';
					str+='</td>';
				str+='</tr>';
			str+='</table>';
		groupInfoDiv.innerHTML = str;
		groupInfoDiv.style.visibility='visible';
		groupInfoDiv.style.display='block';
	}
}

function removeAlert()
{
	var groupInfoDiv=document.getElementById("groupInfoDiv");
	if(groupInfoDiv!=null)
	{
		groupInfoDiv.style.visibility='hidden';
		groupInfoDiv.style.display='none';
	}
}


</script>
</head>
<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">

<div id="groupInfoDiv" name="groupInfoDiv" style="display:none;position:absolute;backgroundcolor:red;z-index:1000"  onmouseover="javascript:void(0)" onmouseout="javascript:void(0)"> </div>

<input type="hidden" id="zone" name="zone" value="<%=zone%>">
<input type="hidden" id="segment" name="segment" value="<%=segment%>">
<input type="hidden" id="frmcompname" name="frmcompname" value="<%=frmcompname%>">
<input type="hidden" id="frmcomptype" name="frmcomptype" value="<%=frmcomptype%>">
<input type="hidden" id="link" name="link" value="<%=link%>">
<input type="hidden" id="zoom" name="zoom" value="<%=zoom%>">
	<table border="0" cellspacing="0" cellpadding="4" align="center" width="100%" height="100%">
		<tr>
			<td valign="top" style="padding:0px" class="eg_cellbgmedium">
				<table  cellspacing="0" cellpadding="4" width="100%" border="0" align="center">
					<tr>
						<td style="width:15px"><input type="radio" name="comp" value="managedComp" <%=m_choice%> onclick="javascript:showComps(this.value);"></td>
						<td align="left"><img src="/final/admin/eg_images/icon_managed_component.png" title="<egui:intnl text='admin.server.Managed Component'/>"><!-- <egui:intnl text="admin.server.Managed"/> --></td>
						<td style="width:15px"> <input type="radio" name="comp" value="newComp" <%=n_choice%> onclick="javascript:showComps(this.value);" ></td>
						<td align="left"><img src="/final/admin/eg_images/icon_new_component.png" title="<egui:intnl text='admin.server.Discovered Component'/>"><!-- <egui:intnl text="admin.server.Discovered"/> --></td>
						<td style="width:15px"> <input type="radio" name="comp" value="unManagedComp" <%=un_choice%> onclick="javascript:showComps(this.value);"></td>
						<td align="left"><img src="/final/admin/eg_images/icon_unmanaged_component.png" title="<egui:intnl text='admin.server.Unmanaged Component'/>"><!-- <egui:intnl text="admin.server.UnManaged"/> --></td>
					</tr>
				</table>
			</td>
		</tr>
<%
	if(m_choice!=null && m_choice.equals("checked")){
		resultVec = discInfo.getAllManagedComponents();
		for(int k=0;k<resultVec.size();k++)
		{
			String arrEle = (String) resultVec.get(k);
			StringTokenizer st = new StringTokenizer(arrEle,",");
			int count = st.countTokens();
			if(count == 4 || count == 5)
			{
				String compType = st.nextToken();
				String hostIp = st.nextToken();
				String nickName = st.nextToken();
				String portNo = st.nextToken();
				String sid="";
				String findString="";
				if(count==4)
				{
					findString = compType+":"+nickName+":"+portNo;
				}
				else if(count == 5)
				{
					//This is Oracle Component.....
					sid = st.nextToken();
					findString = compType+":"+nickName+":"+portNo+":"+sid;
				}

				if(allZoneComponents.contains(findString))
					continue;

				//Check, if the component belongs to any group.
				String groupName = groupInfo.getValue("GROUP_DETAILS", findString);
				if(groupName!=null && groupName.length() > 0)
				{
					String groupComp = "Group:"+groupName+":"+"NULL";
					thisZoneComponents.add(groupComp);
				}
				else
				{
					thisZoneComponents.add(findString);
				}
			}
		}

		if(thisZoneComponents!=null && thisZoneComponents.size() > 0)
		{
			for(int k=0;k<thisZoneComponents.size(); k++)
			{
				String str = (String) thisZoneComponents.get(k);
				String stype = str.substring(0,str.indexOf(":"));
				if(serverTypes.contains(stype))
					continue;
				serverTypes.add(stype);
			}
		}
	}
	else if(n_choice!=null && n_choice.equals("checked"))
	{
		resultVec = discInfo.getNewComponents();
		for(int k=0;k<resultVec.size();k++)
		{
			String str = (String) resultVec.get(k);
			String stype = str.substring(0,str.indexOf(","));
			serverTypes.add(stype);
		}
	}
	else if(un_choice!=null && un_choice.equals("checked"))
	{
		// Get the unmanaged components
		Vector unManageVec = discInfo2.getAllUnManagedComponents();
		for(int k =0;k<unManageVec.size();k++)
		{
			String str = (String) unManageVec.get(k);
			String stype = str.substring(0,str.indexOf(":"));
			serverTypes.add(stype);
		}
	}
	int total = serverTypes.size();
	//out.println("total :"+total);
	if(total == 0)
	{
		String msgString = "admin.servertypes.No managed components!";
		if(n_choice!=null && n_choice.equals("checked"))
			msgString = "admin.servertypes.No newly discovered components!";
		else if(un_choice!=null && un_choice.equals("checked"))
			msgString = "admin.servertypes.No unmanaged components!";
%>
		<tr>
			<td width="100%" height="100%" >
				<table  cellspacing="0" cellpadding="0" width="100%" border="0" align="center">
					<tr>
						<td width="100%" height="100%" align="center" valign="middle"> <img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><egui:intnl text="<%=msgString%>"/>
						</td>
					</tr>
				</table>
			</td>
		</tr>
<%
	}
	else
	{
%>
		<tr>
			<td valign="top">
				<table  cellspacing="0" cellpadding="0" width="100%" border="0" align="center">
					<!-- <tr>
						<th class="eg_subheadbg padding2" id="cellborder1" ><egui:intnl text="admin.server.Component Type"/></th>
					</tr> -->
					<tr>
						<td align="center" nowrap width="100%" valign="top" height="100%" >
							<select name="servertypes" id="servertypes" onchange="showComponent(this.value , '<%=choice%>');" style="width:215px;">
<%
		String userLanguage = _user.getLanguage();
		IniUI iniUI = IniUI.getInstance();
		if (userLanguage == null)
			userLanguage = iniUI.getDefaultLanguage();

		ArrayList serverTypeArrList = new ArrayList(serverTypes);
		MappingNameSorter sorter = new MappingNameSorter(userLanguage);
		serverTypeArrList = sorter.getSortedCompTypeList(serverTypeArrList );
		
		for(int j=0;j<serverTypeArrList.size();j++)
		{
			EgName nameObj = (EgName)serverTypeArrList.get(j);
			String compType = nameObj.getActualName();
			String mappingCompType = nameObj.getLocalName();
%>
								<option value="<%=compType%>"> <%=mappingCompType%> </option>
<%
		}
%>
							</select>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<!-- <tr><td class="eg_blankspace" height="5px">&nbsp;</td></tr> -->
		<tr>
			<td valign="top">
				<table  cellspacing="0" cellpadding="0" width="100%" border="0" class="linesquare">
					<tr>
						<th class="eg_subheadbg padding2" id="cellborder1"  ><egui:intnl text="admin.server.List of components"/></th>
					</tr>
					<tr>
						<td  height="100%" valign="top" >
							<div id="compDiv" class="div_scroll" style="display:block;position:relative;border:0px solid #ff00cc;height:193px"></div> </td>
					</tr>
				</table>
			</td>
		</tr>
<%
	}
%>
	<script type="text/javascript">

			var x = document.getElementById("servertypes");
			if(x!=null && x.selectedIndex <= 0 )
			{
				x.selectedIndex = 0;
				var t=setTimeout("showComponent(x.value,'<%=choice%>')",0);
			}
	</script>
	</table>
</body>
</html>
<%
}
catch(Exception e)
{
	System.out.println(" Exception in This Page.... :");
	e.printStackTrace();
}
%>
