<%
/*
 *   File		:	EgApplyToOtherComponents.jsp
 *   Purpose	:	To view and configure tests for other components
 *   Author		:	S.Anand (2008)
 *   UI Design	:	Jaiwin & Krishnamurthi
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@page import="java.util.*"%>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgGroupInfo" %>
<%@ page import="com.eg.EgTopoInfo" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.egurkha.util.*" %>

<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<html>
<head>
<egui:skin ui="adminindex"/>
<META HTTP-EQUIV="expires" CONTENT="0">
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript">
function selectParameters()
{
	var thisForm = document.list;
	var check = thisForm.paramNameAndValue.checked;

	for (var i=0;i<thisForm.elements.length;i++)
	{
		if (thisForm.elements[i].type == "checkbox")
		{
			if (thisForm.elements[i].name.indexOf("_eachParam") > -1)
			{
				if (check == true)
				{
					thisForm.elements[i].checked = true;
				}
				else
				{
					thisForm.elements[i].checked = false;
				}
			}
		}
	}
}

function selectAndDeselectParameters()
{
	var thisForm = document.list;
	var flag = true;
	for (var i = 0;i<thisForm.elements.length;i++)
	{
		var param = thisForm.elements[i];
		if (param.type == "checkbox" && 
			(param.name.indexOf("_eachParam") > -1) && 
			param.checked == false)
		{
			flag = false;
			break
		}
	}
	thisForm.paramNameAndValue.checked = flag;
}

function applyToComponent()
{
	var thisForm = document.list;
	var managedComponentLen = thisForm.managed.options.length;
	var unmanagedComponentLen = thisForm.unmanaged.options.length;
	var managedComponentList = thisForm.managed;
	var unmanagedComponentList = thisForm.unmanaged;

	if (unmanagedComponentList.selectedIndex == -1)
	{
		alert(_valcomponent);
		return;
	}

	for (var i=0; i<unmanagedComponentLen; i++)
	{
		if (unmanagedComponentList.options[i].selected == true)
		{
			var compTxt = unmanagedComponentList.options[i].text;
			var compVal = unmanagedComponentList.options[i].value;
			managedComponentList.options[managedComponentLen++] = new Option(compTxt,compVal);
		}
	}

	for (var i = unmanagedComponentLen; i>0; i--)
	{
		if(unmanagedComponentList.options[i-1].selected == true)
		{
			unmanagedComponentList.options[i-1] = null;
		}
	}
}

function manageCompToUnmanageComp()
{
	var thisForm = document.list;
	var managedComponentLen = thisForm.managed.options.length;
	var unmanagedComponentLen = thisForm.unmanaged.options.length;
	var managedComponentList = thisForm.managed;
	var unmanagedComponentList = thisForm.unmanaged;

	if (managedComponentList.selectedIndex == -1)
	{
		alert(_valcomponent);
		return;
	}

	for (var i=0; i<managedComponentLen; i++)
	{
		if (managedComponentList.options[i].selected == true)
		{
			var compTxt = managedComponentList.options[i].text;
			var compVal = managedComponentList.options[i].value;
			unmanagedComponentList.options[unmanagedComponentLen++] = new Option(compTxt,compVal);
		}
	}

	for (var i = managedComponentLen; i>0; i--)
	{
		if(managedComponentList.options[i-1].selected == true)
		{
			managedComponentList.options[i-1] = null;
		}
	}
}

function apply()
{
	var thisForm = document.list;
	var parametersSelected = false;
	var allowToSubmit = true;
	var tickedParameters = "";
	var selectedComponents = "";
	for(i=0;i<thisForm.elements.length; i++)
	{
		if(thisForm.elements[i].type == "checkbox")
		{
			if(thisForm.elements[i].checked == true)
			{
				parametersSelected = true;
			}
		}
	}

	var managedComponentLen = thisForm.managed.options.length;
	if (managedComponentLen>0 && !parametersSelected)
	{
		alert('<egui:intnl text="admin.test.Please choose a parameter"/>');
		allowToSubmit = false;
	}
	else if (managedComponentLen==0 && parametersSelected)
	{
		alert('<egui:intnl text="admin.test.Please choose component(s) to be configured"/>');
		allowToSubmit = false;
	}
	else if (managedComponentLen==0 && !parametersSelected)
	{
		allowToSubmit = confirm('<egui:intnl text="admin.test.Do you want to continue with this configuration" />?');
	}

	if (allowToSubmit)
	{
		for (var i=0;i<thisForm.elements.length;i++)
		{
			if (thisForm.elements[i].type == "checkbox" && thisForm.elements[i].checked && thisForm.elements[i].name.indexOf("_eachParam") > -1)
			{
				var str = "-" + thisForm.elements[i].name;
				if (tickedParameters!="")
				{
					tickedParameters = tickedParameters + ",";
				}
				tickedParameters = tickedParameters + str.substring(0,str.indexOf("_eachParam"));
			}
		}
		thisForm.selectedParameters.value = tickedParameters;

		var managedComponentLen = thisForm.managed.options.length;
		var managedComponentList = thisForm.managed;
		for (var i=0; i<managedComponentLen; i++)
		{
				var compVal = managedComponentList.options[i].value;
				if (selectedComponents!="")
				{
					selectedComponents = selectedComponents + ",";
				}
				selectedComponents = selectedComponents + compVal;
		}
		thisForm.selectedComponents.value = selectedComponents
		thisForm.submit();
	}
}

function getDetails()
{
	var thisForm = document.list;

	var tickedParameters = "";
	for (var i=0;i<thisForm.elements.length;i++)
	{
		if (thisForm.elements[i].type == "checkbox" && thisForm.elements[i].checked && thisForm.elements[i].name.indexOf("_eachParam") > -1)
		{
			var str = "-" + thisForm.elements[i].name;
			if (tickedParameters!="")
			{
				tickedParameters = tickedParameters + ",";
			}
			tickedParameters = tickedParameters + str.substring(0,str.indexOf("_eachParam"));
		}
	}
	thisForm.selectedParameters.value = tickedParameters;

	thisForm.method = "post";
	thisForm.action = "../admin/EgApplyToOtherComponents.jsp";
	thisForm.submit();
}
</script>
</head>

<%!
	//param to continue globally
	String[] paramToContinue = {"-host","-port","-info","-agentless","-aluser","-alpassword","-almode","-os","-sshPort"};

	public static ArrayList breakString(String givenString,int screenLen)
	{
		ArrayList aListResultant = new ArrayList();
		int strLen = givenString.length();
		int resLen = strLen/screenLen;
		int idx = 0;
		int k = 0;
		if (givenString.indexOf(" ")>-1)
		{
			for (int i=0;i<resLen;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				int s = res.length();
				if (res.charAt(s-1)==' ')
				{
					res = res.trim();
					aListResultant.add(res);
					idx = idx+screenLen;
				}
				else
				{
					k = res.lastIndexOf(" ");
					if (k==0 || k == -1)
					{
						aListResultant.add(res.substring(0));
						idx = idx+screenLen;
					}
					else
					{
						aListResultant.add(res.substring(0,k));
						String temp = res.substring(k);
						int m = temp.length();
						idx = idx+screenLen;
						idx = idx-m;
					}
				}
				if (i == resLen-1)
				{
					int lastLen = strLen-idx;
					if (lastLen > screenLen)
					{
						resLen = resLen+1;
					}
				}
			}
			String ss = givenString.substring(idx).trim();
			aListResultant.add(ss);
		}
		else
		{
			for (int i=0;i<resLen ;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				aListResultant.add(res);
				idx = idx+screenLen;
			}
			aListResultant.add(givenString.substring(idx));
		}
		return aListResultant;
	}

	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	Arrays.sort(paramToContinue, String.CASE_INSENSITIVE_ORDER);

	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

	String fromPage = request.getParameter("requestFrom");
	fromPage = (fromPage == null)?"EgConfigureComponentTests.jsp":fromPage;

	//datas needed for processing page - starts
	String componentType = null;
	String componentName = null;
	String testName = null;
	String testType = null;
	String testPeriod = null;
	String detailedDiagnosis = null;
	ArrayList aListTemp1 = new ArrayList();

	if (fromPage.equals("EgConfigureComponentTests.jsp"))
	{
		componentType = request.getParameter("componentType");
		componentName = request.getParameter("componentName");
		testName = request.getParameter("testName");
		testType = request.getParameter("testType");
		testType = testType != null?testType:"PerformanceTest";
		testPeriod = request.getParameter("testPeriod");
		detailedDiagnosis = request.getParameter("detaileddiagnosis");
		detailedDiagnosis = (detailedDiagnosis != null)?detailedDiagnosis:"";
	}
	else
	{
		Hashtable hashParamNamesAndValuesTemp = (Hashtable)session.getAttribute("hashParamNamesAndValues");
		componentType = (String)hashParamNamesAndValuesTemp.get("componentType");
		componentName = (String)hashParamNamesAndValuesTemp.get("componentName");
		testName = (String)hashParamNamesAndValuesTemp.get("testName");
		testType = (String)hashParamNamesAndValuesTemp.get("testType");
		testPeriod = (String)hashParamNamesAndValuesTemp.get("testPeriod");
		detailedDiagnosis = (String)hashParamNamesAndValuesTemp.get("detaileddiagnosis");
		aListTemp1 = (ArrayList)hashParamNamesAndValuesTemp.get("userUpdatedParamNamesAndValues");
	}

	boolean isPortRelevantForTest = egSpecs.isPortRelevantForTest(testName);
	String displayComponentName = "";
	if (componentName.indexOf(":NULL") > -1)
	{
		displayComponentName = componentName.substring(0,componentName.indexOf(":"));
	}
	else
	{
		displayComponentName = componentName;
	}

	ArrayList aListDisplay = (ArrayList)session.getAttribute("aListDisplay");
	ArrayList aListPasswordParameters = (ArrayList)session.getAttribute("aListPasswordParameters");
	boolean hasPasswordParameters = false;
	if (aListPasswordParameters != null)
	{
		hasPasswordParameters = true;
	}
	ArrayList aListParamsWithDoubleQuotes = (ArrayList)session.getAttribute("aListParamsWithDoubleQuotes");
	if (aListParamsWithDoubleQuotes == null)
	{
		aListParamsWithDoubleQuotes = new ArrayList();
	}

	if (fromPage.equals("EgConfigureComponentTests.jsp"))
	{
		Enumeration e1 = request.getParameterNames();
		while (e1.hasMoreElements())
		{
			String strParamName = (String)e1.nextElement();
			String strParamValue = request.getParameter(strParamName);
			boolean isPasswordParameter = false;
			boolean allowToTrim = true;
			if (hasPasswordParameters)
			{
				if (aListPasswordParameters.contains("-"+strParamName))
				{
					isPasswordParameter = true;
					allowToTrim = false;
				}
			}

			if (!isPasswordParameter)
			{
				if (strParamValue.indexOf(" -") > -1 || aListParamsWithDoubleQuotes.contains(strParamName.toLowerCase()))
				{
					strParamValue = "\"" + strParamValue + "\"";
					allowToTrim = false;
				}
			}

			//a line feed ('\n') or enter key
			while(strParamValue.indexOf("\n") > -1)
			{
				int idx = strParamValue.indexOf("\n");
				String strPrefix = strParamValue.substring(0,idx-1);
				String strSuffix = strParamValue.substring(idx+1,strParamValue.length());
				strSuffix = strSuffix.trim();
				strParamValue = strPrefix + strSuffix;
			}
			//special case - if the user selects multiple value for filter
			if (strParamName.equalsIgnoreCase("filter"))
			{
				String[] filterValue = request.getParameterValues("filter");
				ArrayList aListFilterValue = new ArrayList(Arrays.asList(filterValue));
				strParamValue = aListFilterValue.toString();
				strParamValue = strParamValue.substring(1,strParamValue.length()-1);
				if (strParamValue.indexOf(",") > -1)
				{
					if (strParamValue.indexOf(";") == -1)
					{
						if (strParamValue.indexOf(":") > -1)
						{
							strParamValue = StringUtils.replace(strParamValue,",","|");
						}
						else
						{
							strParamValue = StringUtils.replace(strParamValue,",",";");
							strParamValue = StringUtils.replace(strParamValue," ","");
						}
					}
					else
					{
						strParamValue = StringUtils.replace(strParamValue,",","|");
					}
				}
			}
			else if (strParamName.equalsIgnoreCase("Target_DiskIO_Rate"))
			{
				String targetDiskIORate_select = request.getParameter("TargetDiskIORate_select");
				String targetDiskIORate = request.getParameter("Target_DiskIO_Rate");
				strParamValue = targetDiskIORate_select + "_" + targetDiskIORate;
			}
			else if (strParamName.equalsIgnoreCase("executionTime") && 
				request.getParameter("minutes") != null && 
				request.getParameter("hours") != null)
			{
				strParamValue = request.getParameter("hours") + ":" + request.getParameter("minutes");
			}
			aListTemp1.add("-"+strParamName);
			if (allowToTrim)
			{
				strParamValue = strParamValue.trim();
			}
			aListTemp1.add(strParamValue);
		}

		Hashtable hashParamNamesAndValues = new Hashtable();
		hashParamNamesAndValues.put("componentType",componentType);
		hashParamNamesAndValues.put("componentName",componentName);
		hashParamNamesAndValues.put("testName",testName);
		hashParamNamesAndValues.put("testPeriod",testPeriod);
		hashParamNamesAndValues.put("testType",testType);
		hashParamNamesAndValues.put("detaileddiagnosis",detailedDiagnosis);
		hashParamNamesAndValues.put("userUpdatedParamNamesAndValues",aListTemp1);

		session.setAttribute("hashParamNamesAndValues",hashParamNamesAndValues);
	}
	//datas needed for processing page - ends

	//for password - starts
	ArrayList aListDefaultPasswordParameters = (ArrayList)session.getAttribute("aListDefaultPasswordParameters");
	boolean hasDefaultPasswordParameter = false;
	if (aListDefaultPasswordParameters != null)
	{
		hasDefaultPasswordParameter = true;
	}
	//for password - ends

	//tells information about the corresponding authenticated user
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));

	String[] componentsList = null;
	ArrayList aListExpectedComponents = new ArrayList();
	ArrayList aListParamNamesAndValues = (ArrayList)session.getAttribute("aListParamNamesValues");
	ArrayList aListDisplayParamNameAndValues = new ArrayList();

	if (componentType != null && !componentType.equals(""))
	{
		componentsList = ri.getAllServersOfType(componentType);
		Arrays.sort(componentsList);
	}

	for(int i=0;i<componentsList.length;i++)
	{
		String strComp = componentsList[i];
		String strCompName = strComp.substring(strComp.indexOf(":")+1,strComp.length());
		if (strCompName.equals(componentName)) continue;
		aListExpectedComponents.add(strComp);
	}

	//remove the component from the aListExpectedComponents whose test is excluded - starts
	ArrayList aListTempExpectedComponents = new ArrayList(aListExpectedComponents);
	prgBean.createFile("eg_disable.ini");
	if (isPortRelevantForTest)
	{
		String[] variables = prgBean.getVariables(componentType);
		ArrayList aListVariables = new ArrayList(Arrays.asList(variables));
		for (int i=0;i<aListExpectedComponents.size();i++)
		{
			String tempComp = (String)aListExpectedComponents.get(i);
			String pattern = tempComp;
			if (aListVariables.contains(pattern))
			{
				String value = prgBean.getStrValue(componentType,pattern);
				if (value.indexOf(testName) > -1)
				{
					aListTempExpectedComponents.remove(tempComp);
				}
			}
		}
	}
	else
	{
		String[] variables = prgBean.getVariables("Default_server");
		ArrayList aListVariables = new ArrayList(Arrays.asList(variables));
		for (int i=0;i<aListExpectedComponents.size();i++)
		{
			String tempComp = (String)aListExpectedComponents.get(i);
			String strCompName = tempComp.substring(tempComp.indexOf(":")+1,tempComp.length());
			String pattern = "Default_server:"+strCompName.substring(0,strCompName.indexOf(":"));
			if (aListVariables.contains(pattern))
			{
				String value = prgBean.getStrValue("Default_server",pattern);
				if (value.indexOf(testName) > -1)
				{
					aListTempExpectedComponents.remove(tempComp);
				}
			}
		}
	}
	aListExpectedComponents = aListTempExpectedComponents;
	//remove the component from the aListExpectedComponents whose test is excluded - ends

	//Container for collecting parameters which are not part of request from main test config page
	ArrayList aListParamsNotPartOfRequest = null;
	if (fromPage.equals("EgConfigureComponentTests.jsp"))
	{
		aListParamsNotPartOfRequest = new ArrayList();
	}
	else
	{
		aListParamsNotPartOfRequest = (ArrayList)session.getAttribute("ParamsNotPartOfRequest");
	}

	//building the parameter names and values which should be shown in ui - starts
	aListDisplayParamNameAndValues.add("testPeriod");
	String tempValue=testPeriod;
	tempValue = tempValue.trim();
	if (Integer.parseInt(tempValue) <= 60)
	{
		tempValue+=" secs";
	}
	else if (Integer.parseInt(tempValue) <= 3599)
	{
		int tpmin=Integer.parseInt(tempValue)/60;
		tempValue=""+tpmin+" mins";
	}
	else if(tempValue.equals("3600"))
	{
		tempValue="1 hr";
	}
	else
	{
		int tphr=Integer.parseInt(tempValue)/3600;
		tempValue=""+tphr+" hrs";
	}
	aListDisplayParamNameAndValues.add(tempValue);

	for(int i=0;i<aListParamNamesAndValues.size();i=i+2)
	{
		String tempParamName = (String)aListParamNamesAndValues.get(i);
		int elementIdx = Arrays.binarySearch(paramToContinue,tempParamName,String.CASE_INSENSITIVE_ORDER);
		if (elementIdx > -1) continue;

		if(componentType.equals("Client_desktop") && testName.equals("ClientTcpTest") || testName.equals("ClientServiceTest"))
		{
			if(tempParamName.equals("-adapter_device_selection") || tempParamName.equals("-device_name") || tempParamName.equals("-device_id")) 
			{
				continue;
			}
		}

		if (tempParamName.equals("-rptName") || tempParamName.equals("-mCount")) continue;
		tempParamName = tempParamName.substring(1).trim();

		if (fromPage.equals("EgConfigureComponentTests.jsp"))
		{
			if (request.getParameter(tempParamName) == null)
			{
				aListParamsNotPartOfRequest.add(tempParamName);
				continue;
			}
		}
		else
		{
			if (aListParamsNotPartOfRequest.contains(tempParamName))
			{
				continue;
			}
		}

		String tempParamValue = (String)aListParamNamesAndValues.get(i+1);
		aListDisplayParamNameAndValues.add(tempParamName);
		int paramIdx = aListTemp1.indexOf("-"+tempParamName);
		String strValue = (String)aListTemp1.get(paramIdx+1);
		if (hasPasswordParameters && aListPasswordParameters.contains("-" + tempParamName))
		{
			strValue = "*";
		}
		else if (hasDefaultPasswordParameter && aListDefaultPasswordParameters.contains("-" + tempParamName.toLowerCase()))
		{
			strValue = "*";
		}

		if (strValue.startsWith("\"") && strValue.endsWith("\""))
		{
			strValue = strValue.substring(1,strValue.length()-1);
		}
		if (aListDisplay.contains(tempParamName+"#"+strValue))
		{
			int paramValIdx = aListDisplay.indexOf(tempParamName+"#"+strValue);
			strValue = (String)aListDisplay.get(paramValIdx+1);
		}
		if (tempParamName.equalsIgnoreCase("os"))
		{
			if (strValue.equalsIgnoreCase("xp"))
			{
				strValue = "Window XP";
			}
			else if (strValue.equalsIgnoreCase("2003"))
			{
				strValue = "Windows 2003";
			}
			else if (strValue.equalsIgnoreCase("2008"))
			{
				strValue = "Windows 2008";
			}
			else if (strValue.equalsIgnoreCase("w2k"))
			{
				strValue = "Windows 2000";
			}
			else if (strValue.equalsIgnoreCase("nt"))
			{
				strValue = "Windows NT";
			}
			else if (strValue.equalsIgnoreCase("hpux") || 
						strValue.equalsIgnoreCase("aix"))
			{
				strValue = strValue.toUpperCase();
			}
			else if (strValue.equalsIgnoreCase("tru64"))
			{
				strValue = "Tru64";
			}
			else if (strValue.equalsIgnoreCase("linux"))
			{
				strValue = "Linux";
			}
			else if (strValue.equalsIgnoreCase("solaris"))
			{
				strValue = "Solaris";
			}
			else if (strValue.equalsIgnoreCase("other"))
			{
				strValue = "Other";
			}
		}
		else if(tempParamName.equalsIgnoreCase("credentials"))
		{
			StringBuffer credBuff = new StringBuffer();
			StringTokenizer st = new StringTokenizer(strValue,",");
			while(st.hasMoreTokens())
			{
				String credentialToken = st.nextToken();
				credentialToken = credentialToken.substring(0,credentialToken.indexOf(":"));
				credBuff.append(credentialToken + ",");
			}
			strValue = credBuff.toString();
			strValue = strValue.substring(0,strValue.length()-1);
		}
		else if (tempParamName.equalsIgnoreCase("Inside_view_using"))
		{
			if (strValue.equalsIgnoreCase("tcp") || strValue.equalsIgnoreCase("wmi"))
			{
				strValue = _mapping.getTextDescription("admin.test.TCP/WMI (Windows)");
			}
			else
			{
				strValue = _mapping.getTextDescription("admin.test.Netbios (Windows)");
			}
		}
		else if (tempParamName.equalsIgnoreCase("filter"))
		{
			strValue = StringUtils.replace(strValue,"|",",");
		}
		else if (tempParamName.equalsIgnoreCase("Target_DiskIO_Rate"))
		{
			String tempTargetDiskIORate = strValue.substring(0,strValue.indexOf("_"));
			String tempTargetDiskIORateValue = strValue.substring(strValue.indexOf("_")+1,strValue.length());

			if (tempTargetDiskIORate.equalsIgnoreCase("eq"))
			{
				tempTargetDiskIORate = "Equals";
			}
			else if (tempTargetDiskIORate.equalsIgnoreCase("lt"))
			{
				tempTargetDiskIORate = "Less Than";
			}
			else if (tempTargetDiskIORate.equalsIgnoreCase("le"))
			{
				tempTargetDiskIORate = "Less Than or Equal To";
			}
			else if (tempTargetDiskIORate.equalsIgnoreCase("gt"))
			{
				tempTargetDiskIORate = "Greater Than";
			}
			else
			{
				tempTargetDiskIORate = "Greater Than or Equal To";
			}

			strValue = tempTargetDiskIORate + " " + tempTargetDiskIORateValue;
		}

		if (strValue.equalsIgnoreCase("true") || 
			strValue.equalsIgnoreCase("y"))
		{
			strValue = "yes";
		}
		else if (strValue.equalsIgnoreCase("false") || 
			strValue.equalsIgnoreCase("n"))
		{
			strValue = "no";
		}
		aListDisplayParamNameAndValues.add(strValue);
	}
	if (!detailedDiagnosis.equals(""))
	{
		aListDisplayParamNameAndValues.add("detaileddiagnosis");
		aListDisplayParamNameAndValues.add(detailedDiagnosis);
	}
	//building the parameter names and values which should be shown in ui - ends

	//Add the parameters which are not part of the request to the session object
	if (fromPage.equals("EgConfigureComponentTests.jsp"))
	{
		session.setAttribute("ParamsNotPartOfRequest",aListParamsNotPartOfRequest);
	}

	//For Zones, Services, Segments and Components - Start
	String ea_criteria = request.getParameter("ea_criteria");
	if (ea_criteria == null)
	{
		ea_criteria = "Component";
	}
	String ea_criteriaPrevious = request.getParameter("ea_criteriaPrevious");

	String ea_userOption = request.getParameter("ea_userOption");
	if (ea_criteria != null && 
		ea_criteriaPrevious != null && 
		!ea_criteriaPrevious.equals(ea_criteria))
	{
		ea_userOption = null;
	}

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	EgGroupInfo egGroupInfo = new EgGroupInfo();
	EgTopoInfo egTopoInfo = egGroupInfo.getTopoInfoObject();
	Vector vecUserOptions = null;
	ArrayList aListAssociatedComponents = new ArrayList();
	if (ea_criteria != null && ea_criteria.equalsIgnoreCase("Zone"))
	{
		List zoneList = _user.getZones();

		//To fetch all components from user associated zones
		ArrayList aListComponentsFromZone = new ArrayList();
		if (zoneList != null && !zoneList.isEmpty())
		{
			vecUserOptions = new Vector(zoneList);
			Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);

			Vector vecTemp = new Vector();
			for (int i=0;i<vecUserOptions.size();i++)
			{
				String strZone = (String)vecUserOptions.get(i);
				ArrayList aListCompsUnderZone = egGroupInfo.getAllComponentsUnderZone(strZone,true);
				aListComponentsFromZone.addAll(aListCompsUnderZone);
				for (int j=0;j<aListCompsUnderZone.size();j++)
				{
					String compUnderZone = (String)aListCompsUnderZone.get(j);
					int index = aListExpectedComponents.indexOf(compUnderZone);
					if (index != -1)
					{
						vecTemp.add(strZone);
						break;
					}
				}
			}

			vecUserOptions = vecTemp;
		}

		if (aListComponentsFromZone != null && !aListComponentsFromZone.isEmpty())
		{
			boolean defaultZoneExists = false;
			for (int i=0;i<aListExpectedComponents.size();i++)
			{
				String component = (String)aListExpectedComponents.get(i);
				if (!aListComponentsFromZone.contains(component))
				{
					defaultZoneExists = true;
					break;
				}
			}

			if (defaultZoneExists)
			{
				vecUserOptions.add(0,"--Default--");
			}
		}
		else
		{
			if (aListExpectedComponents != null && !aListExpectedComponents.isEmpty())
			{
				vecUserOptions = new Vector();
				vecUserOptions.add("--Default--");
			}
		}

		if (ea_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			ea_userOption = (String)vecUserOptions.get(0);
		}

		if (ea_userOption != null)
		{
			if (!ea_userOption.equalsIgnoreCase("--Default--"))
			{
				ArrayList aListCompsUnderChosenZone = egGroupInfo.getAllComponentsUnderZone(ea_userOption,true);
				for (int i=0;i<aListCompsUnderChosenZone.size();i++)
				{
					String compUnderZone = (String)aListCompsUnderChosenZone.get(i);
					int index = aListExpectedComponents.indexOf(compUnderZone);
					if (index != -1)
					{
						aListAssociatedComponents.add(compUnderZone);
					}
				}
			}
			else
			{
				aListAssociatedComponents = new ArrayList();
				for (int i=0;i<aListExpectedComponents.size();i++)
				{
					String userComponent = (String)aListExpectedComponents.get(i);
					int index = aListComponentsFromZone.indexOf(userComponent);
					if (index == -1)
					{
						aListAssociatedComponents.add(userComponent);
					}
				}
			}
		}
	}
	else if (ea_criteria != null && ea_criteria.equalsIgnoreCase("Service"))
	{
		List serviceList = new ArrayList();
		serviceList.addAll(_user.getServices());
		ArrayList aListSites = new ArrayList();
		aListSites.addAll(_user.getSites());
		aListSites.removeAll(serviceList);
		serviceList.addAll(aListSites);
		if (serviceList != null && !serviceList.isEmpty())
		{
			vecUserOptions = new Vector(serviceList);
			Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);

			Vector vecTemp = new Vector();
			for (int i=0;i<vecUserOptions.size();i++)
			{
				String strService = (String)vecUserOptions.get(i);
				Vector vecServiceComponents = egTopoInfo.getAssociatesForSite(strService);
				for (int j=0;j<vecServiceComponents.size();j++)
				{
					String compUnderService = (String)vecServiceComponents.get(j);
					int index = aListExpectedComponents.indexOf(compUnderService);
					if (index != -1)
					{
						vecTemp.add(strService);
						break;
					}
				}
			}

			vecUserOptions = vecTemp;
		}

		if (ea_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			ea_userOption = (String)vecUserOptions.get(0);
		}

		if (ea_userOption != null)
		{
			Vector vecServiceComponents = egTopoInfo.getAssociatesForSite(ea_userOption);
			for (int i=0;i<vecServiceComponents.size();i++)
			{
				String compUnderService = (String)vecServiceComponents.get(i);
				int index = aListExpectedComponents.indexOf(compUnderService);
				if (index != -1)
				{
					aListAssociatedComponents.add(compUnderService);
				}
			}
		}
	}
	else if (ea_criteria != null && ea_criteria.equalsIgnoreCase("Segment"))
	{
		List segmentList = _user.getSegments();
		if (segmentList != null && !segmentList.isEmpty())
		{
			vecUserOptions = new Vector(segmentList);
			Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);

			Vector vecTemp = new Vector();
			for (int i=0;i<vecUserOptions.size();i++)
			{
				String strSegment = (String)vecUserOptions.get(i);
				Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(strSegment,2);
				for (int j=0;j<vecSegmentComponents.size();j++)
				{
					String compUnderSegment = (String)vecSegmentComponents.get(j);
					int index = aListExpectedComponents.indexOf(compUnderSegment);
					if (index != -1)
					{
						vecTemp.add(strSegment);
						break;
					}
				}
			}

			vecUserOptions = vecTemp;
		}

		if (ea_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			ea_userOption = (String)vecUserOptions.get(0);
		}

		if (ea_userOption != null)
		{
			Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(ea_userOption,2);
			for (int i=0;i<vecSegmentComponents.size();i++)
			{
				String compUnderSegment = (String)vecSegmentComponents.get(i);
				int index = aListExpectedComponents.indexOf(compUnderSegment);
				if (index != -1)
				{
					aListAssociatedComponents.add(compUnderSegment);
				}
			}
		}
	}

	if (ea_criteria != null && !ea_criteria.equalsIgnoreCase("Component"))
	{
		aListExpectedComponents = aListAssociatedComponents;
	}
	//For Zones, Services, Segments and Components - End

	String allParamsChecked = "checked";
	ArrayList aListSelectedParameters = null;
	String selectedParameters = request.getParameter("selectedParameters");
	if (selectedParameters != null)
	{
		aListSelectedParameters = new ArrayList();
		StringTokenizer st = new StringTokenizer(selectedParameters,",");
		while(st.hasMoreTokens())
		{
			String credentialToken = st.nextToken();
			aListSelectedParameters.add(credentialToken.substring(1));
		}
		for(int i=0;i<aListDisplayParamNameAndValues.size();i=i+2)
		{
			String strDisplayName = (String)aListDisplayParamNameAndValues.get(i);
			if (aListSelectedParameters != null && !aListSelectedParameters.contains(strDisplayName))
			{
				allParamsChecked = "";
				break;
			}
		}
	}
%>
<body style="overflow:auto" id="space6">
<form name="list" method="post" action="EgConfigureComponentTestsp.jsp" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="listSearch.jsp?title=AGENT - TESTS - APPLY CONFIGURATION&subtitle=false&backButton=true"/>
	<tr>
		<td align="center">
			<table width="85%" cellpadding="4" cellspacing="0" border="0" valign="top" class="linesquare2">
				<tr>
					<td class="linebg">
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td align="left"><strong><egui:intnl text="admin.test.Parameters of"/>&nbsp;<%=_mapping.getTestDescription(testName)%><strong></td>
								<td align="right"><strong>Component&nbsp;:</strong>&nbsp;<%=displayComponentName%>&nbsp;(<egui:intnl type="<%=componentType%>"/>)</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td style="padding:0px">
						<table width="100%" cellpadding="2" cellspacing="0" border="0" style="table-layout:fixed"><col width="30px"><col width="250px"><col width="70%">
							<tr>
								<td align="center" class="linebg2"><input type="checkbox" id="eg_input" name="paramNameAndValue" border="0" <%=allParamsChecked%> onclick="javascript:selectParameters()"></td>
								<td class="linebg2"><strong> <egui:intnl text="admin.test.Param Name"/><strong></td>
								<td class="linebg2"><strong> <egui:intnl text="admin.test.Param Value"/><strong></td>
							</tr>
							<tr>
								<td width="100%" colspan="3" style="padding:0px">
									<div style="width:100%;height:170px;overflow:auto; border:0px solid #ff0000;">
										<table width="100%" cellpadding="2" cellspacing="0" border="0" align="center" valign="top" class="tableborder_ad" style="table-layout:fixed"><col width="30px"><col width="250px"><col width="70%">
<%
	for(int i=0;i<aListDisplayParamNameAndValues.size();i=i+2)
	{
		String strDisplayName = (String)aListDisplayParamNameAndValues.get(i);
		String strChecked = "checked";
		if (!fromPage.equals("EgConfigureComponentTests.jsp"))
		{
			if (aListSelectedParameters != null && !aListSelectedParameters.contains(strDisplayName))
			{
				strChecked = "";
			}
		}
%>
											<tr>
												<td align="center" wrap = "true"  class = "tdborder_ad">
												<input type="checkbox" id = "eg_input" name = <%=aListDisplayParamNameAndValues.get(i).toString()+"_eachParam"%> border = "0" <%=strChecked%> onclick = "javascript:selectAndDeselectParameters()">
												</td>
												<td align="left" wrap="true" class = "tdborder_ad"><egui:intnl text='<%="admin.test."+strDisplayName.toUpperCase()%>'/>
												</td>
<%
		String value = (String)aListDisplayParamNameAndValues.get(i+1);
		if (value.length() < 85)
		{
%>
												<td align = "left" wrap = "true" class = "tdborder_ad"><%=value%>
												</td>
<%
		}
		else
		{
			ArrayList aListBreakString = breakString(value,85);
%>
												<td align = "left" wrap = "true" class = "tdborder_ad">
													<table border="0" cellspacing="0" cellpadding="0">
														<tr>
															<td>
<%
			for (int j=0; j<aListBreakString.size(); j++)
			{
%>
				<%=(String)aListBreakString.get(j)%>
<%
			}
%>
															</td>
														</tr>
													</table>
												</td>
<%
		}
	}
%>
											</tr>
										</table>
									</div>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr><td class="eg_blankspace" height="10px">&nbsp;</td></tr>

	<tr>
		<td style="padding:0px">
			<table align="center" cellspacing="0" cellpadding="4" border="0" width="85%" class="linesquare2">
				<tr><td class="linebg" colspan="3"><strong><egui:intnl text="admin.test.Components"/></strong></td></tr>
				<tr><td class="eg_blankspace" height="2px" colspan="3">&nbsp;</td></tr>

				<!-- new panel start here -->
				<tr>
					<td id="padding2" style="padding-bottom:0px" colspan="3">
						<table align="center" cellspacing="0" cellpadding="4" width="98%" border="0" id="top table" style="table-layout:fixed" class="linebg2">
							<col width="55"><col width="10"><col width="170">
							<col width="80"><col width="10"><col width="420">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ea_criteria" style="width:170px;" onChange='javascript:getDetails()'>
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ea_criteria != null && strCriteria.equals(ea_criteria))
			{
				selected = "selected";
			}
%>
				<option value="<%=strCriteria%>" <%=selected%>>
					<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
				</option>
<%
		}
	}
	else
	{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
	}
%>
									</select>
								</td>
<%
	if (ea_criteria != null && !ea_criteria.equalsIgnoreCase(criterias[3]) && !ea_criteria.equals("-1"))
	{
%>
								<td align="right" nowrap>
<%
		if (ea_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ea_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ea_userOption" style="width: 250px;" onChange='javascript:getDetails()'>
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ea_userOption != null && strUserOption.equals(ea_userOption))
				{
					selected = "selected";
				}
%>
					<option value="<%=strUserOption%>" <%=selected%>>
						<%=strUserOption%>
					</option>
<%
			}
		}
		else
		{
%>
				<option value="-1">
					<egui:intnl text="configmgmt.common.Not Applicable" />
				</option>
<%
		}
%>
									</select>
								</td>
<%
	}
	else
	{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new panel end here -->

				<tr><td class="eg_blankspace" height="2px" colspan="3">&nbsp;</td></tr>
				<tr>
					<td width="45%" style="padding:0px">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-left-width:1px"><strong><egui:intnl text="admin.server.components to be configured"/></strong></td>
							</tr>
							<tr>
								<td align="center" valign="middle">
									<select name="managed" size="11" multiple width="320" style="width:320px;"></select>
								</td>
							</tr>
						</table>
					</td>
					<td width="10%" align="center" valign="middle"  style="padding:0px">
						<input type="button" value='&lsaquo;&lsaquo;' class="eg_lightbutton" onClick="javascript:applyToComponent();" name="man" style="width: 85px; letter-spacing: 0px;"><br><br><br>
						<input type="button" value='&rsaquo;&rsaquo;' class="eg_lightbutton" onClick="javascript:manageCompToUnmanageComp();" name="unman" style="width: 85px; letter-spacing: 0px;">
					</td>
					<td width="45%" style="padding:0px">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4"><strong><egui:intnl text="admin.server.Existing components"/></strong></td>
							</tr>
							<tr>
								<td align="center" valign="middle">
									<select name="unmanaged" size="11" multiple width="320" style="width:320px;">
<%
		for (int i=0;i<aListExpectedComponents.size();i++)
		{
			String strComponent = (String)aListExpectedComponents.get(i);
			strComponent = strComponent.substring(strComponent.indexOf(":")+1,strComponent.length());
			String str = strComponent;
			if (str.indexOf(":NULL") > -1)
			{
				str = str.substring(0,str.indexOf(":"));
			}
%>
										<option value="<%=strComponent%>"><%=str%></option>
<%
		}
%>
									</select>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td class="eg_blankspace" height="4px" colspan="3">&nbsp;</td></tr>
			</table>
		</td>
	</tr>
	<tr><td class="eg_blankspace" height="6px">&nbsp;</td></tr>
	<tr>
		<td width="100%" align="center">
			<input type="button" value='<egui:intnl text="admin.test.Apply"/>' onClick="javascript:apply();" class="eg_back">
			<input type="hidden" name="selectedParameters" value="">
			<input type="hidden" name="selectedComponents" value="">
			<input type="hidden" name="requestFrom" value="EgApplyToOtherComponents.jsp">
			<input type="hidden" name="ea_criteriaPrevious" value="<%=ea_criteria%>">
		</td>
	</tr>
</table>
</form>
</body>
</html>



