<%
/*****************************************************************************
*  File         :       EgAlarmPolicies.jsp
*  Purpose      :       To display the existing alarm policies and enable
                        the user to modify and delete alarm policies.
*  Version	:	0.0
*  Creation Date:       05/12/2000
*  Last Modified:       08/12/2000
*  Author       :       Lavanya.T.K
*	Design Changes		:	Jaiwin
******************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import="java.sql.*" %>
<%@ page import="java.util.*" %>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	EgRoleInfo ri=EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));//by JJ
	boolean allPermission=ri.hasAllComponentAccess();//by JJ
%>

<html>
<head>
<title>Alarm Policies</title>
<egui:skin ui = "admin"/>
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css">  -->
<style>
.dot {font-family: Verdana,Arial,Helvetica;font-size: 8px;}
.p {font-family: Verdana,Arial,Helvetica;font-size: 10pt;}
.tdtext {font-family: Verdana,Arial,Helvetica;font-size: 10pt;color: White;font-weight: bold;}
</style>
<script language="JavaScript">
<!--
imgon1 = new Image;imgon1.src = "images/addnewpol1.gif";
imgoff1 = new Image;imgoff1.src = "images/addnewpol.gif";

imgon2 = new Image;imgon2.src = "images/mod1.gif";
imgoff2 = new Image;imgoff2.src = "images/mod.gif";

imgon3 = new Image;imgon3.src = "images/del1.gif";
imgoff3 = new Image;imgoff3.src = "images/del.gif";
//-->
function populate()
{
	document.list.submit();
}

function delalarm(thispolicy)
{
	if(confirm("<egui:intnl text='admin.alarmpolicy.Are you sure you want to delete the alarm policy'/>,'"+thispolicy+"'?"))
	{
		window.location.href="Egconfigalarmpolicyp.jsp?mode=del&alarmName="+encodeURIComponent(thispolicy);
	}
}

function egTitleSearch()
{
	var searchSt = document.AddNewPolicy.egTitleSearchStr.value;
	if (searchSt == null || searchSt == "")
	{
		window.location.href = "/final/admin/EgAlarmPolicies.jsp";
	}
	else if (searchSt != null)
	{
		window.location.href="/final/admin/EgAlarmPolicies.jsp?egTitleSearchStr="+encodeURI(searchSt);
	}
}
</script>
</head>
<body scroll="auto">
<!-- variable declaration -->
<%!
	EgThresholdInfo threshInfo = new EgThresholdInfo("manager");
%>
<form name="AddNewPolicy" method="post" style="margin:0px" action="javascript:egTitleSearch();">
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" >
<%
	session.setAttribute("egPageDesc","EgAlarmPolicies.jsp");
	session.setAttribute("egBackComplete","/final/admin/EgAlarmPolicies.jsp");
	session.setAttribute("egTitlehref","/final/admin/EgConfigAlarmPolicy.jsp?alarmName=new");

	if (allPermission)
	{
%>
	<jsp:include page="listSearch.jsp?title=AGENTS - ALARM POLICIES&leftString=Add New Policy&backButton=false&subtitle=true"/>
<%
	}
	else
	{
%>
	<jsp:include page="listSearch.jsp?title=AGENTS - ALARM POLICIES&backButton=false&subtitle=true"/>
<%
	}
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="top" height="100%">
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0">
				<tr>
<%
	StringTokenizer st;
	String value="";
	String name="";
	String windowSize="";
	String numCrossings="";
	int len;
	int i;
	String egTitleSearchStr=request.getParameter("egTitleSearchStr");
	boolean isSearchResult =(egTitleSearchStr!=null);
	if (egTitleSearchStr==null)
	{
		egTitleSearchStr="";
	}
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st1 = new StringTokenizer(egTitleSearchStr);
		while (st1.hasMoreTokens())
		{
			String thisToken = st1.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}

	String[] strVarArr = threshInfo.getAllAlarmPolicies();
	String[] alarmPolicies  = (String[])strVarArr.clone();
	List alarmPoliciesList = new ArrayList();
	for (int j=0;j<alarmPolicies.length;j++)
	{
		if(isSearchResult)
		{
			if (doesExist(searchList,alarmPolicies[j]))
				alarmPoliciesList.add(alarmPolicies[j]);
		}
		else
			alarmPoliciesList.add(alarmPolicies[j]);
	}
	alarmPolicies = (String[])alarmPoliciesList.toArray(new String[0]);
	Vector defalarm=new Vector();
	defalarm.add("immediate");
	defalarm.add("shortterm");
	defalarm.add("standard");
	defalarm.add("longterm");

	if(alarmPolicies.length>0)
	{
		for(i=0; i<alarmPolicies.length; i++)
		{
			String thisPolicy=alarmPolicies[i];
			if(thisPolicy.startsWith(";Format"))
				continue;
			value = threshInfo.getAlarmPolicy(thisPolicy);
			if(value.indexOf(",") > 0)
			{
				st=new StringTokenizer(value, ",");
				windowSize=st.nextToken();
				numCrossings=st.nextToken();
			}
%>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td  align='center' valign='middle' height='25'  class="form_spacing" id="eg_subcontentbg"> &nbsp;</td>
<%
			if (allPermission)
			{
%>
					<td width="476" id="eg_subcontentbg" class="eg_subcontent">
<%
			}
			else
			{
%>
					<td width="476" id="eg_subcontentbg" class="eg_subcontent" colspan="3">
<%
			}

			String alarmPolicy = "";	
			if(defalarm.contains(thisPolicy))
			{
				alarmPolicy =thisPolicy;
			}
			else
			{
				alarmPolicy = thisPolicy;
			}
			if (allPermission)
			{
%>
						<a href="javascript:window.location.href='EgConfigAlarmPolicy.jsp?mod=modify&window=<%=windowSize%>&noCross=<%=numCrossings%>&alarmName=<%=EgURLEncoder.encode(EgURLEncoder.encode(thisPolicy,"UTF-8"),"UTF-8")%>'" class="body_link"><%=alarmPolicy%></a>
<%
			}
			else
			{
				out.println(alarmPolicy);
			}
%>
					</td>
<%
			if (allPermission)
			{
%>
					<td width="89" id="eg_subcontentbg" class="eg_subcontent" valign="middle" align="center">
						<input type="button" value='<egui:intnl text="admin.common.Modify"/>' style="width: 80px;" class="eg_lightbutton" onClick="javascript:window.location.href='EgConfigAlarmPolicy.jsp?mod=modify&window=<%=windowSize%>&noCross=<%=numCrossings%>&alarmName=<%=EgURLEncoder.encode(thisPolicy,"UTF-8")%>'">
					</td>
<%
				if(defalarm.contains(thisPolicy))
				{
%>
					<td width="92" id="eg_subcontentbg" class="eg_subcontent" valign="middle" align="center"> 
						<input type="button" value='<egui:intnl text="admin.common.Delete"/>' style="width: 80px;" class="eg_lightbutton" disabled onClick="javascript:window.location.href='Egconfigalarmpolicyp.jsp?mode=del&alarmName=<%=EgURLEncoder.encode(thisPolicy,"UTF-8")%>'">
					</td>
<%
				}
				else
				{
%>
					<td width="92" id="eg_subcontentbg" class="eg_subcontent" valign="middle" align="center"> 
						<input type="button" value='<egui:intnl text="admin.common.Delete"/>' style="width: 80px;" class="eg_lightbutton" onClick="javascript:delalarm('<%=thisPolicy%>')">
					</td>
<%
				}
			} // allpermission
%>
					<td  align='center' valign='middle' height='25'  class="form_spacing" id="eg_subcontentbg"> &nbsp;</td>
				</tr>
				<tr>
					<td colspan="5" class="eg_subcontent" valign="top" id="eg_subcontentbg" style="padding-left:5px">
						<table border="0" cellspacing="0" cellpadding="0" >
							<tr>
								<td width="80" id="eg_75"><egui:intnl text="admin.alarmpolicy.Window size"/></td>
								<td width="10">:</td>
								<td width="40"><%=windowSize%></td>
								<td width="10">&nbsp;</td>
								<td width="120"><egui:intnl text="admin.alarmpolicy.Number of crossings"/></td> <td  width="10">:</td><td width="80"><%=numCrossings%></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td colspan="5" id="eg_blankspace" height="10" nowrap>&nbsp;</td> 
				</tr>
<%
		}
	}
	else
	{
		if(egTitleSearchStr!=null&&!egTitleSearchStr.equals(""))
		{
%>
					<td height="300">
						<table border="0" cellspacing="0" cellpadding="4" width="100%" >
							<tr>
								<td width="100%" align="center"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"></td>
							</tr>
							<tr>
								<td width="100%" align="center" id="eg_errorsmall">
									<egui:intnl text="admin.alarmpolicy.No Alarm Policy found for your search"/>,&nbsp;"<i><%=egTitleSearchStr%></i>"
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
		}
	}
%>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>

<%!
	private boolean doesExist(List searchList,String policy)
	{
		Iterator i = searchList.iterator();
		while (i.hasNext())
		{
			String nextStr = (String) i.next();
			if (policy.indexOf(nextStr)!=-1||(policy.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
				return true;
		}
		return false;
	}
%>

<%
	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgAlarmPolicies.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgAlarmPolicies.jsp");
	}
%>



