<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="java.util.*" %>
<%@ page import="java.io.*" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import = "org.json.simple.*"%>
<%@ page import = "com.egurkha.ini.IniUI" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootObj = new JSONObject();

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = _user.getLanguage();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	EgMappingInfo mappingInfo =  new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	String typeOfAgent = request.getParameter("typeOfAgent");
	
	List server_list = new ArrayList();

	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	String ext_servers [] = egSpecs.getAllExternalServerTypes();
	ArrayList ext_server_list = ext_servers==null?new ArrayList():new ArrayList(Arrays.asList(ext_servers));

	IniFile serIni = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_services.ini");
	String agentless_servers [] = serIni.getVariables("DEFAULT_AGENTLESS_SETTINGS");
	ArrayList agentless_server_list = agentless_servers==null?new ArrayList():new ArrayList(Arrays.asList(agentless_servers));

	if (typeOfAgent != null && typeOfAgent.length() > 0)
	{
		if (typeOfAgent.equalsIgnoreCase("internal"))
		{
			EgDiscInfo discInfo = new EgDiscInfo("manager");
			String servers [] = discInfo.getServerTypes();
			ArrayList all_server_list = new ArrayList();
			for (int m=0; m<servers.length; m++)
			{
				String strComponentType = (String) servers[m];
				//if (strComponentType.startsWith("Agg_"))
				//{
					//continue;
				//}
				all_server_list.add(strComponentType);
			}
			all_server_list.removeAll(ext_server_list);
			all_server_list.removeAll(agentless_server_list);

			server_list.addAll(all_server_list);
		}
		else if (typeOfAgent.equalsIgnoreCase("external"))
		{
			server_list.addAll(ext_server_list);
		}
		else if (typeOfAgent.equalsIgnoreCase("remote"))
		{
			server_list.addAll(agentless_server_list);
		}
	}

	if (server_list != null && server_list.size() > 0)
	{
		server_list = sorter.getSortedCompTypeList(server_list);
	}

	JSONObject generalSettings = new JSONObject();
	IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
	String[] subs = iniFile.getSubjects();
	if(subs!=null)
	{
		Arrays.sort(subs);
		JSONArray allSrvrArray = new JSONArray();
		String keywordsearch = request.getParameter("keywordsearch");

		for (int s=0;s<subs.length;s++)
		{
			JSONArray compArray = new JSONArray();
			JSONObject availSrvrObj = new JSONObject();
			String sub = subs[s];
			if (server_list != null && server_list.size() > 0)
			{
				JSONArray tmpList = new JSONArray();
				for (int i = 0;i<server_list.size();i++)
				{
					JSONObject compObj = new JSONObject();
					EgName nameObj = (EgName)server_list.get(i);
					String tmpVal = nameObj.getActualName();
					String tmpDis = nameObj.getLocalName();
					if (tmpVal.startsWith("Agg_"))
					{
						continue;
					}

					String[] vars = iniFile.getVariables(sub);
					if (vars!=null)
					{
						List compTypes = Arrays.asList(vars);
						if (compTypes.contains(tmpVal))
						{
							if (keywordsearch != null && keywordsearch.trim().length() > 0)
							{
								if ((tmpDis.toLowerCase()).indexOf(keywordsearch.toLowerCase()) != -1)
								{
									compObj.put("displayField",tmpDis);
									compArray.add(compObj);
									availSrvrObj.put(getCapitalizedCategory(sub),compArray);
								}
							}
							else
							{
								compObj.put("displayField",tmpDis);
								compArray.add(compObj);
								availSrvrObj.put(getCapitalizedCategory(sub),compArray);
							}
						}
					}
				}
				if (!availSrvrObj.isEmpty())
				{
					allSrvrArray.add(availSrvrObj);
				}
			}
		}
		generalSettings.put("configuredServersList",allSrvrArray);
		generalSettings.put("configuredServersCount",server_list.size());
	}
	rootObj.put("generalSettings",generalSettings);
	out.println(rootObj.toString());
%>

<%!


	public String getCapitalizedCategory(String categoryName)
	{
		StringBuffer buff = new StringBuffer();
		int j = 0;
		if (categoryName != null)
		{
			//for (int i = 0;i<grps.size();i++ )
			//{
				//String val = (String)grps.get(i);
				if (categoryName.indexOf("_") != -1)
				{
					categoryName = StringUtils.replace(categoryName,"_"," ");
				}
				StringTokenizer tokens = new StringTokenizer(categoryName," ");
				while(tokens.hasMoreTokens())
				{
					String token = tokens.nextToken();
					token = token.trim();
					token = token.toLowerCase();
					String sub = token.substring(1);
					String initial = (token.substring(0,1)).toUpperCase();
					initial = initial + sub;
					if (j == 0)
					{
						buff.append(initial);
					}
					else
					{
						buff.append(" ");
						buff.append(initial);
					}
					j++;
				}
			//}
		}
		return buff.toString();
	}
%>



