<%@ include file = "../../EgTrackerAJSON.jsp"%>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="egurkha.*" %>
<%@ page import="com.eg.*" %>
<%@ page import="com.eg.EgName"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	MappingNameSorter sorter = new MappingNameSorter(trackerLanguage);

	JSONObject rootJson = new JSONObject();
	rootJson.put("success","true");
	JSONObject obj = new JSONObject();

	Hashtable compTestDetails = (Hashtable)session.getAttribute("compTestDetails");
	String masterInfosTest = "-1";
	String masterInfosTestDisplay = "-1";
	if(compTestDetails.containsKey("masterInfosTest"))
	{
		masterInfosTest = (String)compTestDetails.get("masterInfosTest");
	}
	if(masterInfosTest != null && !masterInfosTest.equals("-1"))
		masterInfosTestDisplay = _mapping.getTestDescription(masterInfosTest);
	rootJson.put("masterInfosTest",masterInfosTest);
	rootJson.put("masterInfosTestDisplay",masterInfosTestDisplay);

	Vector measures = null;
	if(compTestDetails != null && compTestDetails.containsKey("MEASURE_NAMES"))
	{
		measures = (Vector)compTestDetails.get("MEASURE_NAMES");
	}
	if(measures == null || measures.size() == 0)
	{
		rootJson.put("noMeasuresAdded",true);
	}
	else
	{
		rootJson.put("noMeasuresAdded",false);
		String compType = (String)compTestDetails.get("compType");
		String compTest = (String)compTestDetails.get("compTest");

		String tdesc = _mapping.getTestDescription(compTest);
		if(tdesc.equals(compTest) && compTestDetails.containsKey("testDescription"))
		{
			tdesc = (String)compTestDetails.get("testDescription");
		}
		rootJson.put("test_desc_measure_panel",tdesc);
		rootJson.put("type_desc_measure_panel",_mapping.getComponentTypeDescription(compType));
		String descBased="No";
		if(compTestDetails.containsKey("descriptorBasedTest"))
		{
			descBased = (String)compTestDetails.get("descriptorBasedTest");
			descBased = (descBased.equals("true") || descBased.equals("yes"))?"Yes":"No";
		}
		rootJson.put("descriptor_measure_panel",_mapping.getTextDescription("admin.common."+descBased));
		rootJson.put("start_descriptorBasedTest",descBased);

		boolean pre_defined_test = (compTest.indexOf("_")==compTest.lastIndexOf("_"));
		rootJson.put("pre_defined_test",pre_defined_test);
		LinkedHashMap all = (LinkedHashMap)compTestDetails.get("TEST_MEASURES");

		Hashtable measure_name_mapping = (Hashtable)compTestDetails.get("MEASURE_NAME_MAPPING");

		JSONArray measureList = new JSONArray();
		for(int i=0; i<measures.size(); i++)
		{
			String org_measure = (String)measures.get(i);
			String compMeasureDescription = null;
			String tempKey = compTest + ":" + org_measure;
			if(measure_name_mapping != null && measure_name_mapping.containsKey(tempKey))
			{
				compMeasureDescription = (String)measure_name_mapping.get(tempKey);
			}
			String s_individualTestName = null;
			if(masterInfosTest != null && !masterInfosTest.equals("-1"))
				s_individualTestName = masterInfosTest;

			JSONArray display_associated_measures_grid = new JSONArray();
			String tmas = (String)all.get(compTest+":"+org_measure);
			if(tmas != null && tmas.indexOf("~")>0 && tmas.indexOf(":")>0)
			{
				Set testSet = new TreeSet();
				Hashtable atmht = new Hashtable();
				String tokens[] = StringUtils.getTokens(tmas,"|");
				for(int j=0; j<tokens.length; j++)
				{
					String tma[] = StringUtils.getTokens(tokens[j],",");
					for(int k=0; k<tma.length; k++)
					{
						String tm = tma[k];
						int tild_index = tm.indexOf("~");
						if(tild_index>-1)
						{
							tm = tm.substring(0,tild_index);
							int idx = tm.indexOf(":");
							if(idx>0)
							{
								String t = tm.substring(0,idx);
								testSet.add(t);
								if(atmht.containsKey(t))
								{
									ArrayList a_mlist = (ArrayList)atmht.get(t);
									a_mlist.add(_mapping.getMeasureDescription(t,tm.substring(idx+1)));
								}
								else
								{
									ArrayList a_mlist = new ArrayList();
									a_mlist.add(_mapping.getMeasureDescription(t,tm.substring(idx+1)));
									atmht.put(t,a_mlist);
								}
							}
						}
					}
				}
				if(!testSet.isEmpty())
				{
					ArrayList a_testList = new ArrayList(testSet);
					a_testList = sorter.getSortedTestList(a_testList);

					for(int k=0;k<a_testList.size();k++)
					{
						EgName egName=(EgName)a_testList.get(k);
						String actualName=egName.getActualName();
						if(s_individualTestName==null)
						{
							s_individualTestName = actualName;
						}
						String displayName=egName.getLocalName();
						ArrayList measureDispList = (ArrayList)atmht.get(actualName);
						if(measureDispList != null)
						{
							String str="";
							for(int l=0;l<measureDispList.size();l++)
							{
								str +=((String)measureDispList.get(l)).trim()+",&nbsp;";
							}
							if(str.length()>0)
								str=str.substring(0,str.lastIndexOf(","));
							JSONObject m_obj = new JSONObject();
							m_obj.put("test_name",displayName);
							m_obj.put("measure_description",str);
							display_associated_measures_grid.add(m_obj);
						}
					}
				}
			}
			String modifyURL = "individualTestInfo.jsp?individualTestName="+s_individualTestName+"&compType="+compType+"&compTest="+compTest+"&compMeasure="+org_measure;
			String deleteURL = "EgconfigmeasurepJson.jsp?add=del&test="+compTest+"&measure="+org_measure;
			obj = new JSONObject();
			if(compMeasureDescription == null)
			{
				obj.put("measureDispName",_mapping.getMeasureDescription(compTest,org_measure));
			}
			else
			{
				obj.put("measureDispName",compMeasureDescription);
			}
			obj.put("display_associated_measures_grid",display_associated_measures_grid);
			obj.put("measureName",org_measure);
			obj.put("modifyURL",modifyURL);
			if(pre_defined_test)
			{
				// this is pre-defined composite test measure. we do not delete this measure.
				obj.put("deleteURL","none");
			}
			else
			{
				obj.put("deleteURL",deleteURL);
			}
			measureList.add(obj);
		}
		rootJson.put("measuresList",measureList);
	}

	boolean individualTestFound = false;
	String compType = (String)compTestDetails.get("compType");
	if(compType != null && !compType.equalsIgnoreCase("null"))
	{
		rootJson.put("testListLabel",_mapping.getTextDescription("admin.ic.Tests of") + " " + _mapping.getComponentTypeDescription(compType));// + " "+_mapping.getTextDescription("admin.ic.component type"));

		rootJson.put("compTypeDesc",_mapping.getComponentTypeDescription(compType));

		ArrayList testList = new ArrayList();
		IniFile specsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");
		String value = specsIni.getValue("TEST_MAPPING",compType);
		if(value != null && value.trim().length()>0)
		{
			StringTokenizer st = new StringTokenizer(value,",");
			while(st.hasMoreTokens())
			{
				String s = st.nextToken().trim();
				if(s.length()==0 || s.endsWith("_rx") || s.endsWith("_cf") || testList.contains(s))
				{
					continue;
				}
				testList.add(s);
			}
		}

		String selectDefaultTest = null;
		JSONArray individual_tests = new JSONArray();
		testList = sorter.getSortedTestList(testList);
		for(int i=0;i<testList.size();i++)
		{
			individualTestFound=true;
			EgName egNameObj = (EgName)testList.get(i);
			String testName = egNameObj.getActualName();
			String testDisplayName = egNameObj.getLocalName();
			obj.put("displayField",testDisplayName);
			obj.put("valueField",testName);
			obj.put("groupField","Available Tests");
			individual_tests.add(obj);
			if(selectDefaultTest == null)
				selectDefaultTest = testName;
		}
		rootJson.put("individual_tests",individual_tests);
		rootJson.put("selectDefaultTest",selectDefaultTest);
	}
	rootJson.put("individualTestFound",new Boolean(individualTestFound));
	out.println(rootJson);
%>



