
<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.apm.AppflowAutoNaming" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	_user.getUserPreferences();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	EgMappingInfo mapping = new EgMappingInfo(userLanguage);
	
	String printThis = new Date()+" EgBtmAppNameUpdate.jsp - BTM jar download :";
	
	String sessId = request.getParameter("sessionId");
	if (sessId == null)
		sessId = session.getId();

	User user = UserRegistry.getInstance().getUser(sessId,true);
	
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",user.getLoginID());
	auditLogThread.setValue("Host_ip",user.getUserIP(sessId));
	auditLogThread.setValue("Session_id",sessId);
	auditLogThread.setValue("Module","BTM Profiler Settings");
	/* code for auditlog ends */
	
	String appName = request.getParameter("appName");
	String tierName = request.getParameter("tierName");
	String compType = request.getParameter("compType");
	String compName = request.getParameter("compName");
	String compNameWithPort = request.getParameter("compNameWithPort");
	String updateInterLinkComp = request.getParameter("updateInterLinkComp");
	//System.out.println(printThis +" - appName : " + appName);
	//System.out.println(printThis +" - tierName : " + tierName);
	//System.out.println(printThis +" - compType : " + compType);
	//System.out.println(printThis +" - compName : " + compName);
	//System.out.println(printThis +" - compNameWithPort : " + compNameWithPort);
	//System.out.println(printThis +" - updateInterLinkComp : " + updateInterLinkComp);
	if (compType != null && compType.length() > 0) {
		compType = egurkha.EgUIUtils.decodeSecurityChar(compType);
	}
	if (compType == null || compType.equalsIgnoreCase("null"))
		compType = "";
	if (appName == null || appName.equalsIgnoreCase("null")|| appName.length() <= 0)
		appName = "none";
	if (tierName == null || tierName.equalsIgnoreCase("null") || tierName.length() <= 0)
		tierName = "none";	
	if (updateInterLinkComp == null || updateInterLinkComp.equalsIgnoreCase("null") || updateInterLinkComp.length() <= 0)
		updateInterLinkComp = "no";
	boolean success = false;
try {
	if(compType != null && !compType.equalsIgnoreCase("null") && compType.length() > 0)
	{
		EgRoleInfo roleInfo = EgRoleInfo.getInstance(session.getId(), (String) session.getAttribute("sess_userid"));
		EgDiscInfo egDisc = new EgDiscInfo("manager");
		
		String CompTypeNew = mapping.getReverseComponentTypeDescription(compType);
		String var = CompTypeNew+":"+compNameWithPort;

		String prevAppName = "-";
		String prevTierName = "-";
		String prevInterLink = "No";

		IniFile apmIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_apm.ini");
		try{
			String previousValue = apmIni.getValue("BTM_PROFILER_APPNAME_MAPPING",var);
			prevInterLink = apmIni.getValue("BTM_PROFILER_APPNAME_MAPPING",var+":InterLink");
			//System.out.println("The Prev Inter-Link Value: "+prevInterLink);
			if(prevInterLink == null || prevInterLink.equalsIgnoreCase("")){
				prevInterLink="Yes";
			}

			if(previousValue!=null){
				int index = previousValue.indexOf(":");
				if(index > 0){
					prevAppName = previousValue.substring(0,index);
					prevTierName = previousValue.substring(index+1);
				}
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}
		finally{
			apmIni.setValue("BTM_PROFILER_APPNAME_MAPPING", var, appName+":"+tierName);
			apmIni.setValue("BTM_PROFILER_APPNAME_MAPPING", var+":InterLink",updateInterLinkComp);
			apmIni.saveFile();
			EgConfigFilesSync.releaseInstance(apmIni);
		}

		List compListOfSameApp = null;  //TODO: In future, use for apply same app name to multiple components
		List compListOfSameTier = null; //TODO: in future, use for apply same tier name to multiple components
		List interLinkedComp = new ArrayList();
		interLinkedComp.add(compNameWithPort);
		String updateInterLinkCompFlag = "none";
		if(updateInterLinkComp.equalsIgnoreCase("yes"))
		{
			updateInterLinkCompFlag = "Yes";
		}
		else{
			updateInterLinkCompFlag = "No";
		}
		AppflowAutoNaming app = new AppflowAutoNaming();
		// app.updateDB();
		app.updateDB(interLinkedComp,updateInterLinkCompFlag,compListOfSameApp,"Yes",compListOfSameTier,"Yes");
		auditLogThread.setCurrentValue("Appliation Name",appName);
		auditLogThread.setPreviousValue("Appliation Name",prevAppName);
		auditLogThread.setPreviousValue("Tier Name",prevTierName);
		auditLogThread.setCurrentValue("Tier Name",tierName);
		auditLogThread.setPreviousValue("Update Inter-Link Comp",prevInterLink);
		auditLogThread.setCurrentValue("Update Inter-Link Comp",updateInterLinkComp);
		success=true;
	} else {
			rootJson.put("NoAppnameUpdate", "true");
		}
	}
	catch (Exception e) {
		System.out.println(printThis + "  Unable to do App name update " + e);
	}

	if(success){
		auditLogThread.setValue("Activity","Update App/Tier name");
		if(tierName.equalsIgnoreCase("none") && appName.equalsIgnoreCase("none"))
			auditLogThread.setValue("Description","App/Tier name has been deleted for "+compNameWithPort);
		else
			auditLogThread.setValue("Description","App/Tier name has been updated for "+compNameWithPort);
		auditLogThread.sendItToDB();
	}
%>

<%
	if(request.getQueryString()!=null)
	session.setAttribute("adminLastAccessedURL","/final/admin/EgBTMProfilerDownload.jsp?"+request.getQueryString());
	else session.setAttribute("adminLastAccessedURL","/final/admin/EgBTMProfilerDownload.jsp");

	out.println(rootJson.toString());
%>

