<%
/*************************************************************************************************/
/*                 Name          : EgAutoCompTypesJson.jsp                                           */
/*                 Purpose       : This page is used to create Java script Auto Topology         */
/*                                 When connect/ uses concepts involves in Auto Topology, this   */
/*                                 page shows the component type                                 */
/*                 Version       : 5.4                                                           */
/*                 Created On    : 05-08-2011                                                    */
/*************************************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp"%>
<%@ page import="com.eg.IniFile" %>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgDiscInfo2"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%
try
{
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject compTypeObj = new JSONObject();
	JSONObject grpObj = new JSONObject();
	JSONArray compTypeArr = new JSONArray();
	JSONArray grpArr = new JSONArray();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgDiscInfo2 discInfo2 = new EgDiscInfo2("manager");
	EgGroupInfo groupInfo = new EgGroupInfo();
	Vector resultVec = new Vector();
	Set serverTypes = new TreeSet();
	ArrayList grpTypes = new ArrayList();
	ArrayList thisZoneComponents = new ArrayList();		// Contains all components from the given zone.
	ArrayList allZoneComponents = new ArrayList();		// Contains all components from all Zones Except the selected Zone

	String zone = request.getParameter("zone");
	String segment = request.getParameter("segment");
	String frmcomptype =request.getParameter("frmcomptype");
	String frmcompname = request.getParameter("frmcompname");
	String link = request.getParameter("link");
	String zoom = request.getParameter("zoom");

	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	boolean isLimitedAdmin = !egRoleInfo.hasAllComponentAccess();
	String UserName = _user.getLoginID();
	
	if(zoom == null)
			zoom = "100";
	if(link == null)
		link = "connect";

	String m_choice ="";
	String n_choice="";
	String un_choice="";
	String mgrp_choice="";
	String dgrp_choice="";
	String choice = request.getParameter("choice");
	if(choice == null){
		choice = "managedComp";
		m_choice = "checked";
	}
	else{
		if(choice.equals("managedComp")){
			m_choice ="checked";
		}
		else if(choice.equals("newComp")){
			n_choice = "checked";
		}
		else if(choice.equals("unManagedComp")){
			un_choice ="checked";
		}
		else if(choice.equals("managedGrp")){
			mgrp_choice ="checked";
		}
		else if(choice.equals("discGrp")){
			dgrp_choice ="checked";
		}
	}

	String modifySegment = request.getParameter("modifySegment");
	if(modifySegment==null)
		modifySegment="";
	// Collect Zone componets, if zone is not Default
	boolean isZone = false;
	if(zone!=null && !zone.equals("-1")){
		thisZoneComponents = groupInfo.getAllComponentsUnderZone(zone);
		isZone = true;
	}
	Hashtable tmpHt = new Hashtable();//groupInfo.getAllComponentsUnderZone();
	if(tmpHt!=null && tmpHt.size() > 0)
	{
		if(isZone && tmpHt.containsKey(zone))
		{
			tmpHt.remove(zone);
		}
		ArrayList valList = new ArrayList(tmpHt.values());
		for(int k=0;k<valList.size();k++)
		{
			ArrayList tmpList = (ArrayList) valList.get(k);
			allZoneComponents.addAll(tmpList);
		}
	}
	JSONObject hiddenValues = new JSONObject();
	hiddenValues.put("zone",zone);
	hiddenValues.put("segment",segment);
	hiddenValues.put("frmcompname",frmcompname);
	hiddenValues.put("frmcomptype",frmcomptype);
	hiddenValues.put("link",link);
	hiddenValues.put("zoom",zoom);
	rootJson.put("hiddenValues",hiddenValues);
	rootJson.put("managedChoice",m_choice);
	rootJson.put("discoveredChoice",n_choice);
	rootJson.put("unmanagedChoice",un_choice);

	if(m_choice!=null && m_choice.equals("checked"))
	{
		resultVec = discInfo.getAllManagedComponents();
		for(int k=0;k<resultVec.size();k++)
		{
			String arrEle = (String) resultVec.get(k);
			StringTokenizer st = new StringTokenizer(arrEle,",");
			int count = st.countTokens();
			if(count == 4 || count == 5)
			{
				String compType = st.nextToken();
				String hostIp = st.nextToken();
				String nickName = st.nextToken();
				String portNo = st.nextToken();
				String sid="";
				String findString="";
				if(count==4)
				{
					findString = compType+":"+nickName+":"+portNo;
				}
				else if(count == 5)
				{
					//This is Oracle Component.....
					sid = st.nextToken();
					findString = compType+":"+nickName+":"+portNo+":"+sid;
				}

				if(allZoneComponents.contains(findString))
					continue;

				//Check, if the component belongs to any group.
				String groupName = "";//groupInfo.getValue("GROUP_DETAILS", findString);
				if(groupName!=null && groupName.length() > 0)
				{
					String groupComp = "Group:"+groupName+":"+"NULL";
					thisZoneComponents.add(groupComp);
				}
				else
				{
					thisZoneComponents.add(findString);
				}
			}
		}

		if(thisZoneComponents!=null && thisZoneComponents.size() > 0)
		{
			List UserCompTypeList = new ArrayList();
			if(isLimitedAdmin)
			{
				UserCompTypeList = _user.getServerTypes();
			}
			for(int k=0;k<thisZoneComponents.size(); k++)
			{
				String str = (String) thisZoneComponents.get(k);
				String stype = str.substring(0,str.indexOf(":"));
				if(serverTypes.contains(stype))
				{
					continue;
				}
				if(isLimitedAdmin)
				{
					if(UserCompTypeList.contains(stype))
					{
						serverTypes.add(stype);
					}
				}
				else
				{
					serverTypes.add(stype);
				}
			}
		}
	}
	else if(n_choice!=null && n_choice.equals("checked"))
	{
		
		List UserCompTypeList = new ArrayList();
		if(isLimitedAdmin)
		{
			UserCompTypeList = getAllNeworUnmangeComonent(UserName,"#New");//_user.getServerTypes();
			serverTypes.addAll(UserCompTypeList);
			
		}
		else
		{
			resultVec = discInfo.getNewComponents();
			for(int k=0;k<resultVec.size();k++)
			{
				String str = (String) resultVec.get(k);
				String stype = str.substring(0,str.indexOf(","));
				serverTypes.add(stype);
			}
		}
	}
	else if(un_choice!=null && un_choice.equals("checked"))
	{
		List UserCompTypeList = new ArrayList();
		if(isLimitedAdmin)
		{
			UserCompTypeList = getAllNeworUnmangeComonent(UserName,"#Unmanage|");//_user.getServerTypes();
			serverTypes.addAll(UserCompTypeList);
		}
		else
		{
			// Get the unmanaged components
			Vector unManageVec = discInfo2.getAllUnManagedComponents();
			for(int k =0;k<unManageVec.size();k++)
			{
				String str = (String) unManageVec.get(k);
				String stype = str.substring(0,str.indexOf(":"));
				serverTypes.add(stype);
			}
		}
	}
	else if(mgrp_choice!=null && mgrp_choice.equals("checked"))
	{
		grpObj.put("displayField","DGroup");
		grpObj.put("valueField","DGroup");
		grpArr.add(grpObj);
		grpTypes.add(grpArr);
		rootJson.put("SelectedCompType","DGroup");
	}
	else if(dgrp_choice!=null && dgrp_choice.equals("checked"))
	{
		grpObj.put("displayField","DGroup");
		grpObj.put("valueField","DGroup");
		grpArr.add(grpObj);
		grpTypes.add(grpArr);
		rootJson.put("SelectedCompType","DGroup");
	}
	int total = 0;
	if( mgrp_choice.equals("checked") || dgrp_choice.equals("checked") )
	{
		total = grpTypes.size();
	}
	else
	{
		total = serverTypes.size();
	}
	rootJson.put("Total",total);
	if(total == 0)
	{
		String msgString = "admin.servertypes.No managed components!";
		if(n_choice!=null && n_choice.equals("checked"))
			msgString = "admin.servertypes.No newly discovered components!";
		else if(un_choice!=null && un_choice.equals("checked"))
			msgString = "admin.servertypes.No unmanaged components!";
		else if(mgrp_choice!=null && mgrp_choice.equals("checked"))
			msgString = "admin.servertypes.No managed groups!";
		else if(dgrp_choice!=null && dgrp_choice.equals("checked"))
			msgString = "admin.servertypes.No discovered groups!";
		screenLabels.put("admin.servertype.No component",_mapping.getTextDescription(msgString));
	}
	else
	{
		rootJson.put("Choice",choice);
		
		String userLanguage = _user.getLanguage();
		IniUI iniUI = IniUI.getInstance();
		if (userLanguage == null)
			userLanguage = iniUI.getDefaultLanguage();

		ArrayList serverTypeArrList = new ArrayList(serverTypes);
		MappingNameSorter sorter = new MappingNameSorter(userLanguage);
		serverTypeArrList = sorter.getSortedCompTypeList(serverTypeArrList );
		
		for(int j=0;j<serverTypeArrList.size();j++)
		{
			EgName nameObj = (EgName)serverTypeArrList.get(j);
			String compType = nameObj.getActualName();
			String mappingCompType = nameObj.getLocalName();

			compTypeObj.put("displayField",mappingCompType);
			compTypeObj.put("valueField",compType);
			compTypeArr.add(compTypeObj);
			if(j==0)
				rootJson.put("SelectedCompType",compType);
		}
	}
	if(n_choice.equals("checked") || un_choice.equals("checked") || m_choice.equals("checked"))
	{
		rootJson.put("ComponentTypes",compTypeArr);
	}
	else
	{
		rootJson.put("ComponentTypes",grpArr);
	}
	rootJson.put("grpTypes",grpTypes);
	rootJson.put("screenLabels",screenLabels);
	out.println(rootJson.toString());
}
catch(Exception e)
{
	System.out.println(" Exception in This Page.... :");
	e.printStackTrace();
}
%>
<%!
 private ArrayList getAllNeworUnmangeComonent(String userName,String NeworUnman)
	{
		IniFile userCompMap = new IniFile(EgConfigInfo.egMgrConfigDir+ "eg_usercompmapping.ini");
		String[] vars = userCompMap.getVariables(userName);
		ArrayList result = new ArrayList();
		if (vars != null)
		{
			for (int v=0; v<vars.length; v++)
			{
				String compType = vars[v];
				if(compType.startsWith(NeworUnman))
				{
					compType = compType.substring(compType.indexOf("|")+1,compType.indexOf(":"));
					result.add(compType);
				}
				//compNick = compNick.substring(compNick.indexOf(":")+1);
				//compNick = compNick.substring(0,compNick.indexOf(":"));
				
			}
		}
		return result;
	}

%>