<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.util.*"%>
<%@ page import="com.eg.EgDiscInfo"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.EgAggregateInfo"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJson = new JSONObject();
	if(!EgInstallInfo.isAggregationSupported())
	{
	}
	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	boolean isSearchResult =(egTitleSearchStr!=null);
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		egTitleSearchStr = egurkha.EgUIUtils.decodeSecurityChar(egTitleSearchStr);
		JSONObject searchStr = new JSONObject();
		searchStr.put("egTitleSearchStr",egTitleSearchStr);
		rootJson.put("searchStr",searchStr);
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	Vector tests=aggregateInfo.getAggregateTests();
	Vector preDefinedTests=aggregateInfo.getPreDefinedAggregateTests();
	if(tests != null && tests.size()>0 && preDefinedTests != null && preDefinedTests.size()>0)
	{
		tests.removeAll(preDefinedTests);
	}
	if(tests == null || tests.size() == 0)
	{
		JSONObject message = new JSONObject();
		message.put("text",_mapping.getTextDescription("admin.ic.No user defined tests found")+"!");
		rootJson.put("message",message);
	}
	else
	{
		ArrayList testList = new ArrayList();
		testList.addAll(tests);
		MappingNameSorter sorter = new MappingNameSorter(trackerLanguage);
		testList = sorter.getSortedTestList(testList);

		Collections.sort(tests,String.CASE_INSENSITIVE_ORDER);
		JSONArray upperRowDataArray = new JSONArray();
		boolean searchItemFound = false;
		for(int i=0;i<testList.size();i++)
		{
			EgName egName=(EgName)testList.get(i);
			String test=egName.getActualName();
			String displayName=egName.getLocalName();
			if (isSearchResult && !doesExist(searchList,test,_mapping.getTestDescription(test)))
			{
				continue;
			}
			searchItemFound=true;
			JSONObject upperRowData = new JSONObject();
			upperRowData.put("agg_test_name",displayName);
			upperRowData.put("hidden_agg_test_name",test);
			upperRowDataArray.add(upperRowData);
		}
		if(!searchItemFound && egTitleSearchStr!=null && !egTitleSearchStr.trim().equals(""))
		{
			JSONObject message = new JSONObject();
			message.put("text",_mapping.getTextDescription("admin.ic.No test(s) found for your current search")+" \"<b>"
			+egTitleSearchStr+"</b>\"");
			rootJson.put("message",message);
		}
		else
		{
			rootJson.put("upperRowDataArray",upperRowDataArray);
			JSONObject header = new JSONObject();
			header.put("headername",_mapping.getTextDescription("admin.test.AGGREGATE TESTS"));
			rootJson.put("gridheader",header);
		}
	}
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>
<%!
	private boolean doesExist(List searchList, String actual_test, String test)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (test.indexOf(nextStr)!=-1 || (test.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1 || actual_test.indexOf(nextStr)!=-1 || (actual_test.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
			{
				return true;
			}
		}
		return false;
	}
%>