/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast;

import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.ForecastingModel;
import net.sourceforge.openforecast.models.AbstractForecastingModel;
import net.sourceforge.openforecast.models.AbstractTimeBasedModel;
import net.sourceforge.openforecast.models.DoubleExponentialSmoothingModel;
import net.sourceforge.openforecast.models.MovingAverageModel;
import net.sourceforge.openforecast.models.MultipleLinearRegressionModel;
import net.sourceforge.openforecast.models.PolynomialRegressionModel;
import net.sourceforge.openforecast.models.RegressionModel;
import net.sourceforge.openforecast.models.SimpleExponentialSmoothingModel;
import net.sourceforge.openforecast.models.TripleExponentialSmoothingModel;

public class Forecaster {
    private Forecaster() {
    }

    public static ForecastingModel getBestForecast(DataSet dataSet) {
        String[] independentVariable = dataSet.getIndependentVariables();
        AbstractForecastingModel bestModel = null;
        String bestRegressionVariable = null;
        int i = 0;
        while (i < independentVariable.length) {
            AbstractForecastingModel model = new RegressionModel(independentVariable[i]);
            model.init(dataSet);
            if (Forecaster.betterThan(model, bestModel)) {
                bestModel = model;
                bestRegressionVariable = independentVariable[i];
            }
            int order = 10;
            if (dataSet.size() / 2 < order) {
                order = dataSet.size() / 2;
            }
            model = new PolynomialRegressionModel(independentVariable[i], order);
            model.init(dataSet);
            if (Forecaster.betterThan(model, bestModel)) {
                bestModel = model;
            }
            ++i;
        }
        ArrayList<String> availableVariables = new ArrayList<String>(independentVariable.length);
        int i2 = 0;
        while (i2 < independentVariable.length) {
            availableVariables.add(independentVariable[i2]);
            ++i2;
        }
        ArrayList<String> bestVariables = new ArrayList<String>(independentVariable.length);
        while (availableVariables.size() > 0) {
            int count = bestVariables.size();
            String[] workingList = new String[count + 1];
            if (count > 0) {
                int i3 = 0;
                while (i3 < count) {
                    workingList[i3] = (String)bestVariables.get(i3);
                    ++i3;
                }
            }
            String bestAvailVariable = null;
            Iterator it = availableVariables.iterator();
            while (it.hasNext()) {
                String currentVar;
                workingList[count] = currentVar = (String)it.next();
                MultipleLinearRegressionModel model = new MultipleLinearRegressionModel(workingList);
                model.init(dataSet);
                if (Forecaster.betterThan(model, bestModel)) {
                    bestModel = model;
                    bestAvailVariable = currentVar;
                }
                workingList[count] = null;
            }
            if (bestAvailVariable == null) break;
            int bestVarIndex = availableVariables.indexOf(bestAvailVariable);
            availableVariables.remove(bestVarIndex);
            bestVariables.add(count, bestAvailVariable);
            ++count;
        }
        if (dataSet.getTimeVariable() != null) {
            String timeVariable = dataSet.getTimeVariable();
            AbstractTimeBasedModel model = new MovingAverageModel();
            model.init(dataSet);
            if (Forecaster.betterThan(model, bestModel)) {
                bestModel = model;
            }
            if (dataSet.getPeriodsPerYear() > 0) {
                model = new MovingAverageModel(dataSet.getPeriodsPerYear());
                model.init(dataSet);
                if (Forecaster.betterThan(model, bestModel)) {
                    bestModel = model;
                }
            }
            if (Forecaster.betterThan(model = SimpleExponentialSmoothingModel.getBestFitModel(dataSet), bestModel)) {
                bestModel = model;
            }
            if (Forecaster.betterThan(model = DoubleExponentialSmoothingModel.getBestFitModel(dataSet), bestModel)) {
                bestModel = model;
            }
            if (Forecaster.betterThan(model = TripleExponentialSmoothingModel.getBestFitModel(dataSet), bestModel)) {
                bestModel = model;
            }
        }
        return bestModel;
    }

    private static boolean betterThan(ForecastingModel model1, ForecastingModel model2) {
        if (model2 == null) {
            return true;
        }
        double tolerance = 1.0E-8;
        int score = 0;
        if (model1.getBias() - model2.getBias() <= tolerance) {
            ++score;
        } else if (model1.getBias() - model2.getBias() >= tolerance) {
            --score;
        }
        if (model1.getMAD() - model2.getMAD() <= tolerance) {
            ++score;
        } else if (model1.getMAD() - model2.getMAD() >= tolerance) {
            --score;
        }
        if (model1.getMAPE() - model2.getMAPE() <= tolerance) {
            ++score;
        } else if (model1.getMAPE() - model2.getMAPE() >= tolerance) {
            --score;
        }
        if (model1.getMSE() - model2.getMSE() <= tolerance) {
            ++score;
        } else if (model1.getMSE() - model2.getMSE() >= tolerance) {
            --score;
        }
        if (model1.getSAE() - model2.getSAE() <= tolerance) {
            ++score;
        } else if (model1.getSAE() - model2.getSAE() >= tolerance) {
            --score;
        }
        if (score == 0) {
            double diff = model1.getBias() - model2.getBias() + model1.getMAD() - model2.getMAD() + model1.getMAPE() - model2.getMAPE() + model1.getMSE() - model2.getMSE() + model1.getSAE() - model2.getSAE();
            return diff < 0.0;
        }
        return score > 0;
    }
}

