/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.commons;

import com.eg.org.objectweb.asm.AnnotationVisitor;
import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.Opcodes;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.TypePath;

public class LocalVariablesSorter
extends MethodVisitor {
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private int[] remappedVariableIndices = new int[40];
    private Object[] remappedLocalTypes = new Object[20];
    protected final int firstLocal;
    protected int nextLocal;

    public LocalVariablesSorter(int n2, String string, MethodVisitor methodVisitor) {
        this(589824, n2, string, methodVisitor);
        if (this.getClass() != LocalVariablesSorter.class) {
            throw new IllegalStateException();
        }
    }

    protected LocalVariablesSorter(int n2, int n3, String string, MethodVisitor methodVisitor) {
        super(n2, methodVisitor);
        this.nextLocal = (8 & n3) == 0 ? 1 : 0;
        for (Type type : Type.getArgumentTypes(string)) {
            this.nextLocal += type.getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    public void visitVarInsn(int n2, int n3) {
        Type type;
        switch (n2) {
            case 22: 
            case 55: {
                type = Type.LONG_TYPE;
                break;
            }
            case 24: 
            case 57: {
                type = Type.DOUBLE_TYPE;
                break;
            }
            case 23: 
            case 56: {
                type = Type.FLOAT_TYPE;
                break;
            }
            case 21: 
            case 54: {
                type = Type.INT_TYPE;
                break;
            }
            case 25: 
            case 58: 
            case 169: {
                type = OBJECT_TYPE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid opcode " + n2);
            }
        }
        super.visitVarInsn(n2, this.remap(n3, type));
    }

    public void visitIincInsn(int n2, int n3) {
        super.visitIincInsn(this.remap(n2, Type.INT_TYPE), n3);
    }

    public void visitMaxs(int n2, int n3) {
        super.visitMaxs(n2, this.nextLocal);
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        int n3 = this.remap(n2, Type.getType(string2));
        super.visitLocalVariable(string, string2, string3, label, label2, n3);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int n2, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl2) {
        Type type = Type.getType(string);
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray2[i2] = this.remap(nArray[i2], type);
        }
        return super.visitLocalVariableAnnotation(n2, typePath, labelArray, labelArray2, nArray2, string, bl2);
    }

    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        Object object;
        int n5;
        if (n2 != -1) {
            throw new IllegalArgumentException("LocalVariablesSorter only accepts expanded frames (see ClassReader.EXPAND_FRAMES)");
        }
        Object[] objectArray3 = new Object[this.remappedLocalTypes.length];
        System.arraycopy(this.remappedLocalTypes, 0, objectArray3, 0, objectArray3.length);
        this.updateNewLocals(this.remappedLocalTypes);
        int n6 = 0;
        for (n5 = 0; n5 < n3; ++n5) {
            Object object2 = objectArray[n5];
            if (object2 != Opcodes.TOP) {
                object = OBJECT_TYPE;
                if (object2 == Opcodes.INTEGER) {
                    object = Type.INT_TYPE;
                } else if (object2 == Opcodes.FLOAT) {
                    object = Type.FLOAT_TYPE;
                } else if (object2 == Opcodes.LONG) {
                    object = Type.LONG_TYPE;
                } else if (object2 == Opcodes.DOUBLE) {
                    object = Type.DOUBLE_TYPE;
                } else if (object2 instanceof String) {
                    object = Type.getObjectType((String)object2);
                }
                this.setFrameLocal(this.remap(n6, (Type)object), object2);
            }
            n6 += object2 == Opcodes.LONG || object2 == Opcodes.DOUBLE ? 2 : 1;
        }
        n5 = 0;
        int n7 = 0;
        for (n6 = 0; n6 < this.remappedLocalTypes.length; n6 += (object = this.remappedLocalTypes[n6]) == Opcodes.LONG || object == Opcodes.DOUBLE ? 2 : 1) {
            if (object != null && object != Opcodes.TOP) {
                this.remappedLocalTypes[n5++] = object;
                n7 = n5;
                continue;
            }
            this.remappedLocalTypes[n5++] = Opcodes.TOP;
        }
        super.visitFrame(n2, n7, this.remappedLocalTypes, n4, objectArray2);
        this.remappedLocalTypes = objectArray3;
    }

    public int newLocal(Type type) {
        Object object;
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                object = Opcodes.INTEGER;
                break;
            }
            case 6: {
                object = Opcodes.FLOAT;
                break;
            }
            case 7: {
                object = Opcodes.LONG;
                break;
            }
            case 8: {
                object = Opcodes.DOUBLE;
                break;
            }
            case 9: {
                object = type.getDescriptor();
                break;
            }
            case 10: {
                object = type.getInternalName();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        int n2 = this.newLocalMapping(type);
        this.setLocalType(n2, type);
        this.setFrameLocal(n2, object);
        return n2;
    }

    protected void updateNewLocals(Object[] objectArray) {
    }

    protected void setLocalType(int n2, Type type) {
    }

    private void setFrameLocal(int n2, Object object) {
        int n3 = this.remappedLocalTypes.length;
        if (n2 >= n3) {
            Object[] objectArray = new Object[Math.max(2 * n3, n2 + 1)];
            System.arraycopy(this.remappedLocalTypes, 0, objectArray, 0, n3);
            this.remappedLocalTypes = objectArray;
        }
        this.remappedLocalTypes[n2] = object;
    }

    private int remap(int n2, Type type) {
        int n3;
        int n4;
        if (n2 + type.getSize() <= this.firstLocal) {
            return n2;
        }
        int n5 = 2 * n2 + type.getSize() - 1;
        if (n5 >= (n4 = this.remappedVariableIndices.length)) {
            int[] nArray = new int[Math.max(2 * n4, n5 + 1)];
            System.arraycopy(this.remappedVariableIndices, 0, nArray, 0, n4);
            this.remappedVariableIndices = nArray;
        }
        if ((n3 = this.remappedVariableIndices[n5]) == 0) {
            n3 = this.newLocalMapping(type);
            this.setLocalType(n3, type);
            this.remappedVariableIndices[n5] = n3 + 1;
        } else {
            --n3;
        }
        return n3;
    }

    protected int newLocalMapping(Type type) {
        int n2 = this.nextLocal;
        this.nextLocal += type.getSize();
        return n2;
    }
}

