/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.pattern;

import com.eg.ch.qos.logback.classic.pattern.ClassicConverter;
import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.core.util.CachingDateFormatter;
import java.util.List;
import java.util.TimeZone;

public class DateConverter
extends ClassicConverter {
    long lastTimestamp = -1L;
    String timestampStrCache = null;
    CachingDateFormatter cachingDateFormatter = null;

    public void start() {
        String string = this.getFirstOption();
        if (string == null) {
            string = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        if (string.equals("ISO8601")) {
            string = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        try {
            this.cachingDateFormatter = new CachingDateFormatter(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + string, illegalArgumentException);
            this.cachingDateFormatter = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss,SSS");
        }
        List<String> list = this.getOptionList();
        if (list != null && list.size() > 1) {
            TimeZone timeZone = TimeZone.getTimeZone(list.get(1));
            this.cachingDateFormatter.setTimeZone(timeZone);
        }
    }

    public String convert(ILoggingEvent iLoggingEvent) {
        long l2 = iLoggingEvent.getTimeStamp();
        return this.cachingDateFormatter.format(l2);
    }
}

