/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.client;

import com.oracle.ovm.mgr.ws.model.ArchiveManagementAttributes;
import com.oracle.ovm.mgr.ws.model.BackupManagementAttributes;
import com.oracle.ovm.mgr.ws.model.BaseObject;
import com.oracle.ovm.mgr.ws.model.BusinessSelection;
import com.oracle.ovm.mgr.ws.model.CloneTargetType;
import com.oracle.ovm.mgr.ws.model.CloneType;
import com.oracle.ovm.mgr.ws.model.Cluster;
import com.oracle.ovm.mgr.ws.model.ClusterStorageFs;
import com.oracle.ovm.mgr.ws.model.EthernetPort;
import com.oracle.ovm.mgr.ws.model.EventManagementAttributes;
import com.oracle.ovm.mgr.ws.model.FileServer;
import com.oracle.ovm.mgr.ws.model.FileSystem;
import com.oracle.ovm.mgr.ws.model.Hypervisor;
import com.oracle.ovm.mgr.ws.model.Id;
import com.oracle.ovm.mgr.ws.model.Job;
import com.oracle.ovm.mgr.ws.model.JobManagementAttributes;
import com.oracle.ovm.mgr.ws.model.LoggerManagementAttributes;
import com.oracle.ovm.mgr.ws.model.LoginCertificate;
import com.oracle.ovm.mgr.ws.model.MacManagementAttributes;
import com.oracle.ovm.mgr.ws.model.Network;
import com.oracle.ovm.mgr.ws.model.PeriodicTask;
import com.oracle.ovm.mgr.ws.model.Repository;
import com.oracle.ovm.mgr.ws.model.Server;
import com.oracle.ovm.mgr.ws.model.ServerEventAttributes;
import com.oracle.ovm.mgr.ws.model.ServerPool;
import com.oracle.ovm.mgr.ws.model.StatisticsManagementAttributes;
import com.oracle.ovm.mgr.ws.model.StorageArray;
import com.oracle.ovm.mgr.ws.model.StorageElement;
import com.oracle.ovm.mgr.ws.model.StorageUse;
import com.oracle.ovm.mgr.ws.model.Vm;
import com.oracle.ovm.mgr.ws.model.VmCloneDefinition;
import com.oracle.ovm.mgr.ws.model.VolumeGroup;
import com.oracle.ovm.mgr.ws.model.WsException;
import java.util.List;

public interface OvmWsUtilitiesClient {
    public BusinessSelection<EthernetPort> utilGetAvailableEthernetPorts(Id<Server> var1, Id<Network> var2) throws WsException;

    public BusinessSelection<FileSystem> utilGetAvailableFileSystems(Id<FileServer> var1, StorageUse var2) throws WsException;

    public BusinessSelection<Network> utilGetAvailableNetworksForVm(Id<Vm> var1) throws WsException;

    public List<Id<Repository>> utilGetAvailableRepositoriesForExport(Id<Server> var1) throws WsException;

    public BusinessSelection<Server> utilGetAvailableServers() throws WsException;

    public BusinessSelection<Server> utilGetAvailableServersForRepository(Id<Repository> var1) throws WsException;

    public BusinessSelection<Server> utilGetAvailableServersForServerPool(Id<ServerPool> var1, Server.ProcessorType var2, Hypervisor.HypervisorType var3) throws WsException;

    public BusinessSelection<Server> utilGetAvailableServersForVm(Id<Vm> var1, List<Id<Server>> var2) throws WsException;

    public BusinessSelection<Repository> utilGetAvailableRepositoriesForVm(Id<Vm> var1) throws WsException;

    public BusinessSelection<Server> utilGetAvailableServersForVmClone(Id<Vm> var1, Id<VmCloneDefinition> var2, Id<Repository> var3, List<Id<Server>> var4) throws WsException;

    public BusinessSelection<ServerPool> utilGetAvailableServerPoolsForVmClone(Id<Vm> var1, Id<VmCloneDefinition> var2, Id<Repository> var3) throws WsException;

    public BusinessSelection<StorageElement> utilGetAvailableStorageElements(List<Id<StorageElement>> var1, StorageUse var2) throws WsException;

    public BusinessSelection<StorageElement> utilGetAvailableStorageElementsForVm(Id<Vm> var1) throws WsException;

    public BusinessSelection<StorageArray> utilGetStorageArraysWithAvailableStorageElements(Id<ServerPool> var1, StorageUse var2) throws WsException;

    public BusinessSelection<VolumeGroup> utilGetVolumeGroupsWithAvailableStorageElements(Id<StorageArray> var1, StorageUse var2) throws WsException;

    public BusinessSelection<? extends BaseObject> utilGetCloneTargets(Id<Vm> var1, Id<?> var2, CloneTargetType var3) throws WsException;

    public List<CloneType> utilGetCloneTypes(Id<?> var1, Id<?> var2) throws WsException;

    public List<Id<FileSystem>> utilGetClusteredFileSystems() throws WsException;

    public List<Id<ServerPool>> utilGetClusteredServerPools() throws WsException;

    public List<Id<ClusterStorageFs>> utilGetClusterStorageFs(Id<Cluster> var1) throws WsException;

    public List<Id<?>> utilGetEthernetDevicesWithIpAddress(String var1) throws WsException;

    public List<Id<FileSystem>> utilGetLocalFileSystems() throws WsException;

    public List<Id<Network>> utilGetNetworksOnServers(List<Id<Server>> var1) throws WsException;

    public List<Id<Server>> utilGetServersByStorageElement(Id<StorageElement> var1) throws WsException;

    public BusinessSelection<Server> utilGetWorkerServersForFileServer(Id<FileServer> var1) throws WsException;

    public BusinessSelection<Server> utilGetWorkerServersForFileSystem(Id<FileSystem> var1) throws WsException;

    public BusinessSelection<Server> utilGetWorkerServersForRepository(Id<Repository> var1) throws WsException;

    public Id<Server> utilGetWorkerServerForServerPool(Id<ServerPool> var1) throws WsException;

    public BusinessSelection<Server> utilGetWorkerServersForStorageArray(Id<StorageArray> var1) throws WsException;

    public boolean utilIsThinCloneSupported(Id<?> var1) throws WsException;

    public StatisticsManagementAttributes statisticsManagementAttributesGet() throws WsException;

    public Job statisticsManagementAttributesModify(StatisticsManagementAttributes var1) throws WsException;

    public MacManagementAttributes macManagementAttributesGet() throws WsException;

    public Job macManagementAttributesModify(MacManagementAttributes var1) throws WsException;

    public ArchiveManagementAttributes archiveManagementAttributesGet() throws WsException;

    public Job archiveManagementAttributesModify(ArchiveManagementAttributes var1) throws WsException;

    public BackupManagementAttributes backupManagementAttributesGet() throws WsException;

    public List<String> backupManagementGetAvailableBackups() throws WsException;

    public Job backupManagementStartBackup(String var1) throws WsException;

    public Job backupManagementCleanupOldBackups(int var1) throws WsException;

    public Job modelManagementExportModelData() throws WsException;

    public Job modelManagementCleanupOldExportedModelData(int var1) throws WsException;

    public List<LoggerManagementAttributes> loggerManagementAttributesGet(String var1) throws WsException;

    public Job loggerManagementAttributesModify(List<LoggerManagementAttributes> var1) throws WsException;

    public String rasManagementGenerateUniqueSessionId() throws WsException;

    public List<PeriodicTask> periodicTaskGetAll() throws WsException;

    public PeriodicTask periodicTaskGetById(Id<PeriodicTask> var1) throws WsException;

    public List<Id<PeriodicTask>> periodicTaskGetIds() throws WsException;

    public List<PeriodicTask> periodicTaskGetListById(List<Id<PeriodicTask>> var1) throws WsException;

    public Job periodicTaskResetToDefaults(Id<PeriodicTask> var1) throws WsException;

    public Job periodicTaskModify(PeriodicTask var1) throws WsException;

    public EventManagementAttributes eventManagementAttributesGet() throws WsException;

    public Job eventManagementAttributesModify(EventManagementAttributes var1) throws WsException;

    public ServerEventAttributes eventManagementServerAttributesGet(Id<Server> var1) throws WsException;

    public Job eventManagementServerAttributesModify(Id<Server> var1, ServerEventAttributes var2) throws WsException;

    public Job modelManagementRefreshModel() throws WsException;

    public Job jobManagementAttributesModify(JobManagementAttributes var1) throws WsException;

    public JobManagementAttributes jobManagementAttributesGet() throws WsException;

    public Id<Job> jobManagementGetLockingJob(Id<? extends BaseObject> var1) throws WsException;

    public List<LoginCertificate> certificateGetAll() throws WsException;

    public LoginCertificate certificateCreate() throws WsException;

    public void certificateRegister(LoginCertificate var1) throws WsException;

    public LoginCertificate certificateSignAndRegister(LoginCertificate var1) throws WsException;

    public void certificateUnregister(String var1) throws WsException;

    public String certificateGetCaCertificate() throws WsException;
}

