/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.client;

import com.oracle.ovm.mgr.ws.client.OvmWsClient;
import com.oracle.ovm.mgr.ws.client.OvmWsUtilitiesClient;
import com.oracle.ovm.mgr.ws.client.OvmWsUtilitiesRestClient;
import com.oracle.ovm.mgr.ws.client.RestClient;
import com.oracle.ovm.mgr.ws.model.AccessGroup;
import com.oracle.ovm.mgr.ws.model.AffinityGroup;
import com.oracle.ovm.mgr.ws.model.Assembly;
import com.oracle.ovm.mgr.ws.model.AssemblyVirtualDisk;
import com.oracle.ovm.mgr.ws.model.AssemblyVm;
import com.oracle.ovm.mgr.ws.model.BaseObject;
import com.oracle.ovm.mgr.ws.model.CloneType;
import com.oracle.ovm.mgr.ws.model.Cluster;
import com.oracle.ovm.mgr.ws.model.ClusterHeartbeatDevice;
import com.oracle.ovm.mgr.ws.model.ClusterStorageFs;
import com.oracle.ovm.mgr.ws.model.ControlDomain;
import com.oracle.ovm.mgr.ws.model.Cpu;
import com.oracle.ovm.mgr.ws.model.CpuCompatibilityGroup;
import com.oracle.ovm.mgr.ws.model.EthernetPort;
import com.oracle.ovm.mgr.ws.model.Event;
import com.oracle.ovm.mgr.ws.model.FileServer;
import com.oracle.ovm.mgr.ws.model.FileServerPlugin;
import com.oracle.ovm.mgr.ws.model.FileSystem;
import com.oracle.ovm.mgr.ws.model.FileSystemMount;
import com.oracle.ovm.mgr.ws.model.Id;
import com.oracle.ovm.mgr.ws.model.Job;
import com.oracle.ovm.mgr.ws.model.KeyValuePair;
import com.oracle.ovm.mgr.ws.model.Manager;
import com.oracle.ovm.mgr.ws.model.Network;
import com.oracle.ovm.mgr.ws.model.PasswordChange;
import com.oracle.ovm.mgr.ws.model.Repository;
import com.oracle.ovm.mgr.ws.model.RepositoryExport;
import com.oracle.ovm.mgr.ws.model.ResourceGroup;
import com.oracle.ovm.mgr.ws.model.Server;
import com.oracle.ovm.mgr.ws.model.ServerController;
import com.oracle.ovm.mgr.ws.model.ServerPool;
import com.oracle.ovm.mgr.ws.model.ServerPoolNetworkPolicy;
import com.oracle.ovm.mgr.ws.model.ServerPoolPolicy;
import com.oracle.ovm.mgr.ws.model.ServerUpdateConfiguration;
import com.oracle.ovm.mgr.ws.model.ServerUpdateRepositoryConfiguration;
import com.oracle.ovm.mgr.ws.model.SimpleId;
import com.oracle.ovm.mgr.ws.model.Statistic;
import com.oracle.ovm.mgr.ws.model.StorageArray;
import com.oracle.ovm.mgr.ws.model.StorageArrayPlugin;
import com.oracle.ovm.mgr.ws.model.StorageElement;
import com.oracle.ovm.mgr.ws.model.StorageInitiator;
import com.oracle.ovm.mgr.ws.model.StoragePath;
import com.oracle.ovm.mgr.ws.model.StorageTarget;
import com.oracle.ovm.mgr.ws.model.StringList;
import com.oracle.ovm.mgr.ws.model.VirtualDisk;
import com.oracle.ovm.mgr.ws.model.VirtualNic;
import com.oracle.ovm.mgr.ws.model.VirtualSwitch;
import com.oracle.ovm.mgr.ws.model.VlanInterface;
import com.oracle.ovm.mgr.ws.model.Vm;
import com.oracle.ovm.mgr.ws.model.VmCloneDefinition;
import com.oracle.ovm.mgr.ws.model.VmCloneNetworkMapping;
import com.oracle.ovm.mgr.ws.model.VmCloneStorageMapping;
import com.oracle.ovm.mgr.ws.model.VmDiskMapping;
import com.oracle.ovm.mgr.ws.model.VmMessageType;
import com.oracle.ovm.mgr.ws.model.VolumeGroup;
import com.oracle.ovm.mgr.ws.model.WsErrorCode;
import com.oracle.ovm.mgr.ws.model.WsException;
import com.oracle.ovm.mgr.ws.model.Zone;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.GenericEntity;

public class OvmWsRestClient
extends RestClient
implements OvmWsClient {
    public static final String URI_BASE_PATH = "/ovm/core/wsapi/rest";

    public OvmWsRestClient() {
    }

    public OvmWsRestClient(HostnameVerifier hv, SSLContext sslContext) {
        super(hv, sslContext);
    }

    @Override
    public boolean login(String username, String password, Locale locale) throws WsException {
        return super.login(username, password, locale, "login");
    }

    @Override
    public void authenticate(String s) {
    }

    @Override
    public boolean initialize(String hostname, String port, boolean secure) throws MalformedURLException, URISyntaxException {
        return super.initialize(hostname, port, secure, URI_BASE_PATH);
    }

    @Override
    public OvmWsUtilitiesClient getWsUtilities() throws WsException {
        return new OvmWsUtilitiesRestClient(this);
    }

    @Override
    public List<AccessGroup> accessGroupGetAll() throws WsException {
        return this.getAll(AccessGroup.class);
    }

    @Override
    public List<Id<AccessGroup>> accessGroupGetIds() throws WsException {
        return this.getIds(AccessGroup.class);
    }

    @Override
    public AccessGroup accessGroupGetById(Id<AccessGroup> accessGroupId) throws WsException {
        return this.getById(accessGroupId, AccessGroup.class);
    }

    @Override
    public List<AccessGroup> accessGroupGetListById(List<Id<AccessGroup>> accessGroupIds) throws WsException {
        return this.getListById(accessGroupIds, AccessGroup.class);
    }

    @Override
    public Job accessGroupModify(AccessGroup accessGroup) throws WsException {
        return this.modify(accessGroup);
    }

    @Override
    public Job accessGroupAddStorageElement(Id<AccessGroup> accessGroupId, Id<StorageElement> storageElementId) throws WsException {
        return this.addChildObject(accessGroupId, storageElementId);
    }

    @Override
    public Job accessGroupRemoveStorageElement(Id<AccessGroup> accessGroupId, Id<StorageElement> storageElementId) throws WsException {
        return this.removeChildObject(accessGroupId, storageElementId);
    }

    @Override
    public Job accessGroupAddStorageInitiator(Id<AccessGroup> accessGroupId, Id<StorageInitiator> storageInitiatorId) throws WsException {
        return this.addChildObject(accessGroupId, storageInitiatorId);
    }

    @Override
    public Job accessGroupRemoveStorageInitiator(Id<AccessGroup> accessGroupId, Id<StorageInitiator> storageInitiatorId) throws WsException {
        return this.removeChildObject(accessGroupId, storageInitiatorId);
    }

    @Override
    public Job accessGroupAddServer(Id<AccessGroup> accessGroupId, Id<Server> serverId) throws WsException {
        return this.addChildObject(accessGroupId, serverId);
    }

    @Override
    public Job accessGroupRemoveServer(Id<AccessGroup> accessGroupId, Id<Server> serverId) throws WsException {
        return this.removeChildObject(accessGroupId, serverId);
    }

    @Override
    public Job accessGroupAddFileSystem(Id<AccessGroup> accessGroupId, Id<FileSystem> fileSystemId) throws WsException {
        return this.addChildObject(accessGroupId, fileSystemId);
    }

    @Override
    public Job accessGroupRemoveFileSystem(Id<AccessGroup> accessGroupId, Id<FileSystem> fileSystemId) throws WsException {
        return this.removeChildObject(accessGroupId, fileSystemId);
    }

    @Override
    public Job accessGroupRefresh(Id<AccessGroup> accessGroupId) throws WsException {
        return this.action(accessGroupId, "refresh");
    }

    @Override
    public Job affinityGroupAddServer(Id<AffinityGroup> affinityGroupId, Id<Server> serverId) throws WsException {
        return this.addChildObject(affinityGroupId, serverId);
    }

    @Override
    public Job affinityGroupRemoveServer(Id<AffinityGroup> affinityGroupId, Id<Server> serverId) throws WsException {
        return this.removeChildObject(affinityGroupId, serverId);
    }

    @Override
    public Job affinityGroupAddVm(Id<AffinityGroup> affinityGroupId, Id<Vm> vmId) throws WsException {
        return this.addChildObject(affinityGroupId, vmId);
    }

    @Override
    public Job affinityGroupRemoveVm(Id<AffinityGroup> affinityGroupId, Id<Vm> vmId) throws WsException {
        return this.removeChildObject(affinityGroupId, vmId);
    }

    @Override
    public List<AffinityGroup> affinityGroupGetAll() throws WsException {
        return this.getAll(AffinityGroup.class);
    }

    @Override
    public List<Id<AffinityGroup>> affinityGroupGetIds() throws WsException {
        return this.getIds(AffinityGroup.class);
    }

    @Override
    public AffinityGroup affinityGroupGetById(Id<AffinityGroup> affinityGroupId) throws WsException {
        return this.getById(affinityGroupId, AffinityGroup.class);
    }

    @Override
    public List<AffinityGroup> affinityGroupGetListById(List<Id<AffinityGroup>> affinityGroupIds) throws WsException {
        return this.getListById(affinityGroupIds, AffinityGroup.class);
    }

    @Override
    public Job affinityGroupModify(AffinityGroup affinityGroup) throws WsException {
        return this.modify(affinityGroup);
    }

    @Override
    public List<Assembly> assemblyGetAll() throws WsException {
        return this.getAll(Assembly.class);
    }

    @Override
    public List<Id<Assembly>> assemblyGetIds() throws WsException {
        return this.getIds(Assembly.class);
    }

    @Override
    public Assembly assemblyGetById(Id<Assembly> assemblyId) throws WsException {
        return this.getById(assemblyId, Assembly.class);
    }

    @Override
    public List<Assembly> assemblyGetListById(List<Id<Assembly>> assemblyIds) throws WsException {
        return this.getListById(assemblyIds, Assembly.class);
    }

    @Override
    public Job assemblyModify(Assembly assembly) throws WsException {
        return this.modify(assembly);
    }

    @Override
    public String assemblyGetDescriptor(Id<Assembly> assemblyId) throws WsException {
        try {
            WebResource.Builder b = this.getResourceForAction(assemblyId, "descriptor", null);
            return (String)b.get(String.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job assemblyRefresh(Id<Assembly> assemblyId) throws WsException {
        return this.action(assemblyId, "refresh");
    }

    @Override
    public List<AssemblyVm> assemblyVmGetAll() throws WsException {
        return this.getAll(AssemblyVm.class);
    }

    @Override
    public List<Id<AssemblyVm>> assemblyVmGetIds() throws WsException {
        return this.getIds(AssemblyVm.class);
    }

    @Override
    public AssemblyVm assemblyVmGetById(Id<AssemblyVm> assemblyVmId) throws WsException {
        return this.getById(assemblyVmId, AssemblyVm.class);
    }

    @Override
    public List<AssemblyVm> assemblyVmGetListById(List<Id<AssemblyVm>> assemblyVmIds) throws WsException {
        return this.getListById(assemblyVmIds, AssemblyVm.class);
    }

    @Override
    public Job assemblyVmModify(AssemblyVm assemblyVm) throws WsException {
        return this.modify(assemblyVm);
    }

    @Override
    public List<AssemblyVirtualDisk> assemblyVirtualDiskGetAll() throws WsException {
        return this.getAll(AssemblyVirtualDisk.class);
    }

    @Override
    public List<Id<AssemblyVirtualDisk>> assemblyVirtualDiskGetIds() throws WsException {
        return this.getIds(AssemblyVirtualDisk.class);
    }

    @Override
    public AssemblyVirtualDisk assemblyVirtualDiskGetById(Id<AssemblyVirtualDisk> assemblyVirtualDiskId) throws WsException {
        return this.getById(assemblyVirtualDiskId, AssemblyVirtualDisk.class);
    }

    @Override
    public List<AssemblyVirtualDisk> assemblyVirtualDiskGetListById(List<Id<AssemblyVirtualDisk>> assemblyVirtualDiskIds) throws WsException {
        return this.getListById(assemblyVirtualDiskIds, AssemblyVirtualDisk.class);
    }

    @Override
    public Job assemblyVirtualDiskModify(AssemblyVirtualDisk assemblyVirtualDisk) throws WsException {
        return this.modify(assemblyVirtualDisk);
    }

    @Override
    public Job clusterCreateHeartbeatDevice(Id<Cluster> clusterId, ClusterHeartbeatDevice heartbeatDevice) throws WsException {
        return this.createChildObject(clusterId, heartbeatDevice);
    }

    @Override
    public Job clusterDeleteHeartbeatDevice(Id<Cluster> clusterId, Id<ClusterHeartbeatDevice> heartbeatDeviceId) throws WsException {
        return this.deleteChildObject(clusterId, heartbeatDeviceId);
    }

    @Override
    public Job clusterAddFileSystem(Id<Cluster> clusterId, Id<FileSystem> fileSystemId) throws WsException {
        return this.addChildObject(clusterId, fileSystemId);
    }

    @Override
    public Job clusterRemoveFileSystem(Id<Cluster> clusterId, Id<FileSystem> fileSystemId) throws WsException {
        return this.removeChildObject(clusterId, fileSystemId);
    }

    @Override
    public List<Cluster> clusterGetAll() throws WsException {
        return this.getAll(Cluster.class);
    }

    @Override
    public List<Id<Cluster>> clusterGetIds() throws WsException {
        return this.getIds(Cluster.class);
    }

    @Override
    public Cluster clusterGetById(Id<Cluster> clusterId) throws WsException {
        return this.getById(clusterId, Cluster.class);
    }

    @Override
    public List<Cluster> clusterGetListById(List<Id<Cluster>> clusterIds) throws WsException {
        return this.getListById(clusterIds, Cluster.class);
    }

    @Override
    public Job clusterModify(Cluster cluster) throws WsException {
        return this.modify(cluster);
    }

    @Override
    public List<ClusterHeartbeatDevice> clusterHeartbeatDeviceGetAll() throws WsException {
        return this.getAll(ClusterHeartbeatDevice.class);
    }

    @Override
    public List<Id<ClusterHeartbeatDevice>> clusterHeartbeatDeviceGetIds() throws WsException {
        return this.getIds(ClusterHeartbeatDevice.class);
    }

    @Override
    public ClusterHeartbeatDevice clusterHeartbeatDeviceGetById(Id<ClusterHeartbeatDevice> clusterHeartbeatDeviceId) throws WsException {
        return this.getById(clusterHeartbeatDeviceId, ClusterHeartbeatDevice.class);
    }

    @Override
    public List<ClusterHeartbeatDevice> clusterHeartbeatDeviceGetListById(List<Id<ClusterHeartbeatDevice>> clusterHeartbeatDeviceIds) throws WsException {
        return this.getListById(clusterHeartbeatDeviceIds, ClusterHeartbeatDevice.class);
    }

    @Override
    public Job clusterHeartbeatDeviceModify(ClusterHeartbeatDevice clusterHeartbeatDevice) throws WsException {
        return this.modify(clusterHeartbeatDevice);
    }

    @Override
    public List<ClusterStorageFs> clusterStorageFsGetAll() throws WsException {
        return this.getAll(ClusterStorageFs.class);
    }

    @Override
    public List<Id<ClusterStorageFs>> clusterStorageFsGetIds() throws WsException {
        return this.getIds(ClusterStorageFs.class);
    }

    @Override
    public ClusterStorageFs clusterStorageFsGetById(Id<ClusterStorageFs> clusterStorageFsId) throws WsException {
        return this.getById(clusterStorageFsId, ClusterStorageFs.class);
    }

    @Override
    public List<ClusterStorageFs> clusterStorageFsGetListById(List<Id<ClusterStorageFs>> clusterStorageFsIds) throws WsException {
        return this.getListById(clusterStorageFsIds, ClusterStorageFs.class);
    }

    @Override
    public Job clusterStorageFsModify(ClusterStorageFs clusterStorageFs) throws WsException {
        return this.modify(clusterStorageFs);
    }

    @Override
    public List<ControlDomain> controlDomainGetAll() throws WsException {
        return this.getAll(ControlDomain.class);
    }

    @Override
    public List<Id<ControlDomain>> controlDomainGetIds() throws WsException {
        return this.getIds(ControlDomain.class);
    }

    @Override
    public ControlDomain controlDomainGetById(Id<ControlDomain> controlDomainId) throws WsException {
        return this.getById(controlDomainId, ControlDomain.class);
    }

    @Override
    public List<ControlDomain> controlDomainGetListById(List<Id<ControlDomain>> controlDomainIds) throws WsException {
        return this.getListById(controlDomainIds, ControlDomain.class);
    }

    @Override
    public Job controlDomainModify(ControlDomain controlDomain) throws WsException {
        return this.modify(controlDomain);
    }

    @Override
    public List<Cpu> cpuGetAll() throws WsException {
        return this.getAll(Cpu.class);
    }

    @Override
    public List<Id<Cpu>> cpuGetIds() throws WsException {
        return this.getIds(Cpu.class);
    }

    @Override
    public Cpu cpuGetById(Id<Cpu> cpuId) throws WsException {
        return this.getById(cpuId, Cpu.class);
    }

    @Override
    public List<Cpu> cpuGetListById(List<Id<Cpu>> cpuIds) throws WsException {
        return this.getListById(cpuIds, Cpu.class);
    }

    @Override
    public Job cpuModify(Cpu cpu) throws WsException {
        return this.modify(cpu);
    }

    @Override
    public Job cpuCompatibilityGroupCreate(CpuCompatibilityGroup cpuCompatibilityGroup) throws WsException {
        return this.create(cpuCompatibilityGroup);
    }

    @Override
    public Job cpuCompatibilityGroupDelete(Id<CpuCompatibilityGroup> cpuCompatibilityGroupId) throws WsException {
        return this.delete(cpuCompatibilityGroupId);
    }

    @Override
    public List<CpuCompatibilityGroup> cpuCompatibilityGroupGetAll() throws WsException {
        return this.getAll(CpuCompatibilityGroup.class);
    }

    @Override
    public List<Id<CpuCompatibilityGroup>> cpuCompatibilityGroupGetIds() throws WsException {
        return this.getIds(CpuCompatibilityGroup.class);
    }

    @Override
    public CpuCompatibilityGroup cpuCompatibilityGroupGetById(Id<CpuCompatibilityGroup> cpuCompatibilityGroupId) throws WsException {
        return this.getById(cpuCompatibilityGroupId, CpuCompatibilityGroup.class);
    }

    @Override
    public List<CpuCompatibilityGroup> cpuCompatibilityGroupGetListById(List<Id<CpuCompatibilityGroup>> cpuCompatibilityGroupIds) throws WsException {
        return this.getListById(cpuCompatibilityGroupIds, CpuCompatibilityGroup.class);
    }

    @Override
    public Job cpuCompatibilityGroupModify(CpuCompatibilityGroup cpuCompatibilityGroup) throws WsException {
        return this.modify(cpuCompatibilityGroup);
    }

    @Override
    public Job cpuCompatibilityGroupAddServer(Id<CpuCompatibilityGroup> cpuCompatibilityGroupId, Id<Server> serverId) throws WsException {
        return this.addChildObject(cpuCompatibilityGroupId, serverId);
    }

    @Override
    public Job cpuCompatibilityGroupRemoveServer(Id<CpuCompatibilityGroup> cpuCompatibilityGroupId, Id<Server> serverId) throws WsException {
        return this.removeChildObject(cpuCompatibilityGroupId, serverId);
    }

    @Override
    public List<EthernetPort> ethernetPortGetAll() throws WsException {
        return this.getAll(EthernetPort.class);
    }

    @Override
    public List<Id<EthernetPort>> ethernetPortGetIds() throws WsException {
        return this.getIds(EthernetPort.class);
    }

    @Override
    public EthernetPort ethernetPortGetById(Id<EthernetPort> ethernetPortId) throws WsException {
        return this.getById(ethernetPortId, EthernetPort.class);
    }

    @Override
    public List<EthernetPort> ethernetPortGetListById(List<Id<EthernetPort>> ethernetPortIds) throws WsException {
        return this.getListById(ethernetPortIds, EthernetPort.class);
    }

    @Override
    public Job ethernetPortModify(EthernetPort ethernetPort) throws WsException {
        return this.modify(ethernetPort);
    }

    @Override
    public Job ethernetPortAddEthernetPortToBond(Id<EthernetPort> bondPortId, Id<EthernetPort> ethernetPortId) throws WsException {
        return this.action(bondPortId, "addEthernetPortToBond", ethernetPortId);
    }

    @Override
    public Job ethernetPortRemoveEthernetPortFromBond(Id<EthernetPort> bondPortId, Id<EthernetPort> ethernetPortId) throws WsException {
        return this.action(bondPortId, "removeEthernetPortFromBond", ethernetPortId);
    }

    @Override
    public Job ethernetPortCreateVlanInterface(Id<EthernetPort> ethernetPortId, VlanInterface vlanInterface) throws WsException {
        return this.createChildObject(ethernetPortId, vlanInterface);
    }

    @Override
    public Job ethernetPortDeleteVlanInterface(Id<EthernetPort> ethernetPortId, Id<VlanInterface> vlanInterfaceId) throws WsException {
        return this.deleteChildObject(ethernetPortId, vlanInterfaceId);
    }

    @Override
    public Job eventAcknowledge(Id<Event> eventId) throws WsException {
        return this.action(eventId, "acknowledge");
    }

    @Override
    public List<Event> eventGetAll(Id<? extends BaseObject> objectId, String eventType, Event.EventSeverity eventSeverity, boolean acknowledged, long startTime, long endTime, boolean queryModifyTime, int maxEvents) throws WsException {
        try {
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            if (objectId != null) {
                queryParameters.put("objectType", objectId.getType().getCanonicalName());
                queryParameters.put("objectId", objectId.getValue());
            }
            if (eventType != null) {
                queryParameters.put("type", eventType.toString());
            }
            if (eventSeverity != null) {
                queryParameters.put("severity", eventSeverity.toString());
            }
            queryParameters.put("acknowledged", Boolean.toString(acknowledged));
            if (startTime != 0L) {
                queryParameters.put("startTime", Long.toString(startTime));
            }
            if (endTime != 0L) {
                queryParameters.put("endTime", Long.toString(endTime));
            }
            queryParameters.put("queryModifyTime", Boolean.toString(queryModifyTime));
            if (maxEvents != 0) {
                queryParameters.put("maxEvents", Integer.toString(maxEvents));
            }
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(null, queryParameters, Event.class.getSimpleName());
            return (List)((WebResource.Builder)b.type(this.getMediaType())).get(this.getGenericListType(Event.class));
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Event>> eventGetIds(Id<? extends BaseObject> objectId, String eventType, Event.EventSeverity eventSeverity, boolean acknowledged, long startTime, long endTime, boolean queryModifyTime, int maxEvents) throws WsException {
        try {
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            if (objectId != null) {
                queryParameters.put("objectType", objectId.getType().getCanonicalName());
                queryParameters.put("objectId", objectId.getValue());
            }
            if (eventType != null) {
                queryParameters.put("type", eventType.toString());
            }
            if (eventSeverity != null) {
                queryParameters.put("severity", eventSeverity.toString());
            }
            queryParameters.put("acknowledged", Boolean.toString(acknowledged));
            if (startTime != 0L) {
                queryParameters.put("startTime", Long.toString(startTime));
            }
            if (endTime != 0L) {
                queryParameters.put("endTime", Long.toString(endTime));
            }
            queryParameters.put("queryModifyTime", Boolean.toString(queryModifyTime));
            if (maxEvents != 0) {
                queryParameters.put("maxEvents", Integer.toString(maxEvents));
            }
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(null, queryParameters, Event.class.getSimpleName(), "id");
            List simpleIdList = (List)b.get((GenericType)new GenericType<List<SimpleId>>(){});
            ArrayList<Id<Event>> ids = new ArrayList<Id<Event>>(simpleIdList.size());
            for (SimpleId simpleId : simpleIdList) {
                ids.add(new Id(simpleId));
            }
            return ids;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Event eventGetById(Id<Event> eventId) throws WsException {
        return this.getById(eventId, Event.class);
    }

    @Override
    public List<Event> eventGetListById(List<Id<Event>> eventIds) throws WsException {
        return this.getListById(eventIds, Event.class);
    }

    @Override
    public Event eventGetTriage(Id<? extends BaseObject> objectId) throws WsException {
        try {
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            if (objectId != null) {
                queryParameters.put("objectType", objectId.getType().getCanonicalName());
                queryParameters.put("objectId", objectId.getValue());
            }
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(null, queryParameters, Event.class.getSimpleName(), "triage");
            return (Event)((WebResource.Builder)b.type(this.getMediaType())).get(Event.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Event> eventGetTriageList(List<Id<? extends BaseObject>> objectIds) throws WsException {
        ArrayList<Event> eventList = new ArrayList<Event>();
        for (Id<? extends BaseObject> objectId : objectIds) {
            Event event = this.eventGetTriage(objectId);
            if (event == null) continue;
            eventList.add(event);
        }
        return eventList;
    }

    @Override
    public List<String> eventGetTypes() throws WsException {
        WebResource.Builder b = this.getResourceFromPathElements(Event.class.getSimpleName(), "EventTypes");
        StringList eventTypes = (StringList)b.get(StringList.class);
        ArrayList<String> types = new ArrayList<String>();
        for (String type : eventTypes.getStrings()) {
            types.add(type);
        }
        return types;
    }

    @Override
    public List<Id<? extends BaseObject>> eventGetFullyPopulatedIds(List<Id<? extends BaseObject>> objectIds) throws WsException {
        try {
            List simpleObjectIds = new ArrayList<SimpleId>();
            for (Id<? extends BaseObject> id : objectIds) {
                simpleObjectIds.add(new SimpleId(id));
            }
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getBaseURI(), "Event", "fullyPopulatedIds");
            simpleObjectIds = (List)((WebResource.Builder)b.type(this.getMediaType())).put((GenericType)new GenericType<List<SimpleId>>(){}, (Object)new GenericEntity<List<SimpleId>>(simpleObjectIds){});
            objectIds = new ArrayList<Id<? extends BaseObject>>(simpleObjectIds.size());
            for (SimpleId simpleId : simpleObjectIds) {
                objectIds.add(new Id(simpleId));
            }
            return objectIds;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<FileServer> fileServerGetAll() throws WsException {
        return this.getAll(FileServer.class);
    }

    @Override
    public List<Id<FileServer>> fileServerGetIds() throws WsException {
        return this.getIds(FileServer.class);
    }

    @Override
    public FileServer fileServerGetById(Id<FileServer> fileServerId) throws WsException {
        return this.getById(fileServerId, FileServer.class);
    }

    @Override
    public List<FileServer> fileServerGetListById(List<Id<FileServer>> fileServerIds) throws WsException {
        return this.getListById(fileServerIds, FileServer.class);
    }

    @Override
    public Job fileServerDiscover(FileServer fileServer) throws WsException {
        return this.create(fileServer);
    }

    @Override
    public Job fileServerDelete(Id<FileServer> fileServerId) throws WsException {
        return this.delete(fileServerId);
    }

    @Override
    public Job fileServerModify(FileServer fileServer) throws WsException {
        return this.modify(fileServer);
    }

    @Override
    public Job fileServerRefresh(Id<FileServer> fileServerId) throws WsException {
        return this.action(fileServerId, "refresh");
    }

    @Override
    public Job fileServerSetFileServerPlugin(Id<FileServer> fileServerId, Id<FileServerPlugin> pluginId) throws WsException {
        return this.setChildObject(fileServerId, pluginId, "fileServerPluginId");
    }

    @Override
    public Job fileServerAddAdminServer(Id<FileServer> fileServerId, Id<Server> adminServerId) throws WsException {
        return this.action(fileServerId, "addAdminServer", adminServerId);
    }

    @Override
    public Job fileServerRemoveAdminServer(Id<FileServer> fileServerId, Id<Server> adminServerId) throws WsException {
        return this.action(fileServerId, "removeAdminServer", adminServerId);
    }

    @Override
    public Job fileServerAddRefreshServer(Id<FileServer> fileServerId, Id<Server> refreshServerId) throws WsException {
        return this.action(fileServerId, "addRefreshServer", refreshServerId);
    }

    @Override
    public Job fileServerRemoveRefreshServer(Id<FileServer> fileServerId, Id<Server> refreshServerId) throws WsException {
        return this.action(fileServerId, "removeRefreshServer", refreshServerId);
    }

    @Override
    public Job fileServerCreateAccessGroup(Id<FileServer> fileServerId, AccessGroup accessGroup) throws WsException {
        return this.createChildObject(fileServerId, accessGroup);
    }

    @Override
    public Job fileServerDeleteAccessGroup(Id<FileServer> fileServerId, Id<AccessGroup> accessGroupId) throws WsException {
        return this.deleteChildObject(fileServerId, accessGroupId);
    }

    @Override
    public Job fileServerCreateFileSystem(Id<FileServer> fileServerId, FileSystem fileSystem) throws WsException {
        return this.createChildObject(fileServerId, fileSystem);
    }

    @Override
    public Job fileServerDeleteFileSystem(Id<FileServer> fileServerId, Id<FileSystem> fileSystemId) throws WsException {
        return this.deleteChildObject(fileServerId, fileSystemId);
    }

    @Override
    public List<FileServerPlugin> fileServerPluginGetAll() throws WsException {
        return this.getAll(FileServerPlugin.class);
    }

    @Override
    public List<Id<FileServerPlugin>> fileServerPluginGetIds() throws WsException {
        return this.getIds(FileServerPlugin.class);
    }

    @Override
    public FileServerPlugin fileServerPluginGetById(Id<FileServerPlugin> fileServerPluginId) throws WsException {
        return this.getById(fileServerPluginId, FileServerPlugin.class);
    }

    @Override
    public List<FileServerPlugin> fileServerPluginGetListById(List<Id<FileServerPlugin>> fileServerPluginIds) throws WsException {
        return this.getListById(fileServerPluginIds, FileServerPlugin.class);
    }

    @Override
    public Job fileServerPluginModify(FileServerPlugin fileServerPlugin) throws WsException {
        return this.modify(fileServerPlugin);
    }

    @Override
    public List<FileSystem> fileSystemGetAll() throws WsException {
        return this.getAll(FileSystem.class);
    }

    @Override
    public List<Id<FileSystem>> fileSystemGetIds() throws WsException {
        return this.getIds(FileSystem.class);
    }

    @Override
    public FileSystem fileSystemGetById(Id<FileSystem> fileSystemId) throws WsException {
        return this.getById(fileSystemId, FileSystem.class);
    }

    @Override
    public List<FileSystem> fileSystemGetListById(List<Id<FileSystem>> fileSystemIds) throws WsException {
        return this.getListById(fileSystemIds, FileSystem.class);
    }

    @Override
    public Job fileSystemModify(FileSystem fileSystem) throws WsException {
        return this.modify(fileSystem);
    }

    @Override
    public Job fileSystemCreateRepository(Id<FileSystem> fileSystemId, Repository repository) throws WsException {
        return this.createChildObject(fileSystemId, repository);
    }

    @Override
    public Job fileSystemDeleteRepository(Id<FileSystem> fileSystemId, Id<Repository> repositoryId) throws WsException {
        return this.deleteChildObject(fileSystemId, repositoryId);
    }

    @Override
    public Job fileSystemRefresh(Id<FileSystem> fileSystemId) throws WsException {
        return this.action(fileSystemId, "refresh");
    }

    @Override
    public Job fileSystemRefreshMetadata(Id<FileSystem> fileSystemId) throws WsException {
        return this.action(fileSystemId, "refreshMetadata");
    }

    @Override
    public List<FileSystemMount> fileSystemMountGetAll() throws WsException {
        return this.getAll(FileSystemMount.class);
    }

    @Override
    public List<Id<FileSystemMount>> fileSystemMountGetIds() throws WsException {
        return this.getIds(FileSystemMount.class);
    }

    @Override
    public FileSystemMount fileSystemMountGetById(Id<FileSystemMount> fileSystemMountId) throws WsException {
        return this.getById(fileSystemMountId, FileSystemMount.class);
    }

    @Override
    public List<FileSystemMount> fileSystemMountGetListById(List<Id<FileSystemMount>> fileSystemMountIds) throws WsException {
        return this.getListById(fileSystemMountIds, FileSystemMount.class);
    }

    @Override
    public Job fileSystemMountModify(FileSystemMount fileSystemMount) throws WsException {
        return this.modify(fileSystemMount);
    }

    @Override
    public List<Job> jobGetAll(long startTime, long endTime, int maxJobs) throws WsException {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        if (startTime != 0L) {
            queryParameters.put("startTime", Long.toString(startTime));
        }
        if (endTime != 0L) {
            queryParameters.put("endTime", Long.toString(endTime));
        }
        if (maxJobs != 0) {
            queryParameters.put("maxJobs", Integer.toString(maxJobs));
        }
        WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(null, queryParameters, Job.class.getSimpleName());
        return (List)((WebResource.Builder)b.type(this.getMediaType())).get(this.getGenericListType(Job.class));
    }

    @Override
    public List<Id<Job>> jobGetIds(long startTime, long endTime, int maxJobs) throws WsException {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        if (startTime != 0L) {
            queryParameters.put("startTime", Long.toString(startTime));
        }
        if (endTime != 0L) {
            queryParameters.put("endTime", Long.toString(endTime));
        }
        if (maxJobs != 0) {
            queryParameters.put("maxJobs", Integer.toString(maxJobs));
        }
        WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(null, queryParameters, Job.class.getSimpleName(), "id");
        List simpleIdList = (List)b.get((GenericType)new GenericType<List<SimpleId>>(){});
        ArrayList<Id<Job>> ids = new ArrayList<Id<Job>>(simpleIdList.size());
        for (SimpleId simpleId : simpleIdList) {
            ids.add(new Id(simpleId));
        }
        return ids;
    }

    @Override
    public Job jobGetById(Id<Job> jobId) throws WsException {
        return this.getById(jobId, Job.class);
    }

    @Override
    public String jobGetDebugTranscript(Id<Job> jobId) throws WsException {
        WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getUri(jobId), "transcript");
        return (String)b.get(String.class);
    }

    @Override
    public List<Job> jobGetListById(List<Id<Job>> jobIds) throws WsException {
        return this.getListById(jobIds, Job.class);
    }

    @Override
    public void jobAbort(Id<Job> jobId) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getUri(jobId), "abort");
            b.put();
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Id<Job> jobCreateGroup(Job job) throws WsException {
        try {
            WebResource.Builder b = this.getResourceForType(job.getClass());
            SimpleId simpleId = (SimpleId)((WebResource.Builder)b.type(this.getMediaType())).post(SimpleId.class, this.createJAXBElement(job));
            return new Id<Job>(simpleId);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void jobDelete(Id<Job> jobId) throws WsException {
        try {
            WebResource.Builder b = this.getResourceById(jobId);
            b.delete();
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void jobAddChildToGroup(Id<Job> jobGroupId, Id<Job> jobId) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getUri(jobGroupId), "addChildJob");
            b.put(jobId);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void jobModify(Job job) throws WsException {
        try {
            WebResource.Builder b = this.getResourceById(job.getId());
            ((WebResource.Builder)b.type(this.getMediaType())).put((Object)job);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Manager managerGet() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements("Manager", "Manager");
            Manager manager = (Manager)b.get(Manager.class);
            return manager;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Manager> managerGetAll() throws WsException {
        return this.getAll(Manager.class);
    }

    @Override
    public List<Id<Manager>> managerGetIds() throws WsException {
        return this.getIds(Manager.class);
    }

    @Override
    public Manager managerGetById(Id<Manager> managerId) throws WsException {
        return this.getById(managerId, Manager.class);
    }

    @Override
    public List<Manager> managerGetListById(List<Id<Manager>> managerIds) throws WsException {
        return this.getListById(managerIds, Manager.class);
    }

    @Override
    public Job managerModify(Manager manager) throws WsException {
        return this.modify(manager);
    }

    @Override
    public Job networkAddEthernetPort(Id<Network> networkId, Id<EthernetPort> ethernetPortId) throws WsException {
        return this.addChildObject(networkId, ethernetPortId);
    }

    @Override
    public Job networkAddVlanInterface(Id<Network> networkId, Id<VlanInterface> vlanInterfaceId) throws WsException {
        return this.addChildObject(networkId, vlanInterfaceId);
    }

    @Override
    public Job networkAddVirtualNic(Id<Network> networkId, Id<VirtualNic> vnicId) throws WsException {
        return this.addChildObject(networkId, vnicId);
    }

    @Override
    public Job networkCreate(Network network) throws WsException {
        return this.create(network);
    }

    @Override
    public Job networkDelete(Id<Network> networkId) throws WsException {
        return this.delete(networkId);
    }

    @Override
    public List<Network> networkGetAll() throws WsException {
        return this.getAll(Network.class);
    }

    @Override
    public List<Id<Network>> networkGetIds() throws WsException {
        return this.getIds(Network.class);
    }

    @Override
    public Network networkGetById(Id<Network> networkId) throws WsException {
        return this.getById(networkId, Network.class);
    }

    @Override
    public List<Network> networkGetListById(List<Id<Network>> networkIds) throws WsException {
        return this.getListById(networkIds, Network.class);
    }

    @Override
    public Job networkModify(Network network) throws WsException {
        return this.modify(network);
    }

    @Override
    public Job networkRemoveEthernetPort(Id<Network> networkId, Id<EthernetPort> ethernetPortId) throws WsException {
        return this.removeChildObject(networkId, ethernetPortId);
    }

    @Override
    public Job networkRemoveVlanInterface(Id<Network> networkId, Id<VlanInterface> vlanInterfaceId) throws WsException {
        return this.removeChildObject(networkId, vlanInterfaceId);
    }

    @Override
    public Job networkRemoveVirtualNic(Id<Network> networkId, Id<VirtualNic> vnicId) throws WsException {
        return this.removeChildObject(networkId, vnicId);
    }

    @Override
    public List<Repository> repositoryGetAll() throws WsException {
        return this.getAll(Repository.class);
    }

    @Override
    public List<Id<Repository>> repositoryGetIds() throws WsException {
        return this.getIds(Repository.class);
    }

    @Override
    public Repository repositoryGetById(Id<Repository> repositoryId) throws WsException {
        return this.getById(repositoryId, Repository.class);
    }

    @Override
    public List<Repository> repositoryGetListById(List<Id<Repository>> repositoryIds) throws WsException {
        return this.getListById(repositoryIds, Repository.class);
    }

    @Override
    public List<RepositoryExport> repositoryExportGetAll() throws WsException {
        return this.getAll(RepositoryExport.class);
    }

    @Override
    public List<Id<RepositoryExport>> repositoryExportGetIds() throws WsException {
        return this.getIds(RepositoryExport.class);
    }

    @Override
    public RepositoryExport repositoryExportGetById(Id<RepositoryExport> repositoryExportId) throws WsException {
        return this.getById(repositoryExportId, RepositoryExport.class);
    }

    @Override
    public List<RepositoryExport> repositoryExportGetListById(List<Id<RepositoryExport>> repositoryExportIds) throws WsException {
        return this.getListById(repositoryExportIds, RepositoryExport.class);
    }

    @Override
    public Job repositoryExportModify(RepositoryExport repositoryExport) throws WsException {
        return this.modify(repositoryExport);
    }

    @Override
    public Job repositoryImportAssembly(Id<Repository> repositoryId, String url, String proxy) throws WsException {
        Map<String, Object> params = this.createQueryParameterMap("url", url);
        if (proxy != null) {
            params.put("proxy", proxy);
        }
        return this.actionWithQueryParameters(repositoryId, "importAssembly", params, null);
    }

    @Override
    public Job repositoryDeleteAssembly(Id<Repository> repositoryId, Id<Assembly> assemblyId) throws WsException {
        return this.deleteChildObject(repositoryId, assemblyId);
    }

    @Override
    public Job repositoryImportVm(Id<Repository> repositoryId, List<String> urls, String proxy, boolean createTemplate) throws WsException {
        Map<String, Object> params = this.createQueryParameterMap("url", urls, "createTemplate", createTemplate);
        if (proxy != null) {
            params.put("proxy", proxy);
        }
        return this.actionWithQueryParameters(repositoryId, "importVm", params, null);
    }

    @Override
    public Job repositoryAddVm(Id<Repository> repositoryId, Id<Vm> vmId) throws WsException {
        return this.addChildObject(repositoryId, vmId);
    }

    @Override
    public Job repositoryRemoveVm(Id<Repository> repositoryId, Id<Vm> vmId) throws WsException {
        return this.removeChildObject(repositoryId, vmId);
    }

    @Override
    public Job repositoryCreateVirtualDisk(Id<Repository> repositoryId, VirtualDisk virtualDisk, boolean sparse) throws WsException {
        Map<String, Object> map = this.createQueryParameterMap("sparse", new Boolean(sparse));
        return this.createChildObject(repositoryId, virtualDisk, map);
    }

    @Override
    public Job repositoryImportVirtualDisk(Id<Repository> repositoryId, String url, String proxy, VirtualDisk.DiskType diskType) throws WsException {
        Map<String, Object> params = this.createQueryParameterMap(new Object[]{"url", url, "diskType", diskType});
        if (proxy != null) {
            params.put("proxy", proxy);
        }
        return this.actionWithQueryParameters(repositoryId, "importVirtualDisk", params, null);
    }

    @Override
    public Job repositoryDeleteVirtualDisk(Id<Repository> repositoryId, Id<VirtualDisk> virtualDiskId) throws WsException {
        return this.deleteChildObject(repositoryId, virtualDiskId);
    }

    @Override
    public Job repositoryModify(Repository repository) throws WsException {
        return this.modify(repository);
    }

    @Override
    public Job repositoryRefresh(Id<Repository> repositoryId) throws WsException {
        return this.action(repositoryId, "refresh");
    }

    @Override
    public Job repositoryPresent(Id<Repository> repositoryId, Id<Server> serverId) throws WsException {
        return this.action(repositoryId, "present", serverId);
    }

    @Override
    public Job repositoryUnpresent(Id<Repository> repositoryId, Id<Server> serverId) throws WsException {
        return this.action(repositoryId, "unpresent", serverId);
    }

    @Override
    public Job repositoryTakeOwnership(Id<Repository> repositoryId, Id<ServerPool> serverPoolId) throws WsException {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        if (serverPoolId != null) {
            queryParameters.put("serverPoolId", serverPoolId.getValue());
        }
        return this.actionWithQueryParameters(repositoryId, "takeOwnership", queryParameters, null);
    }

    @Override
    public Job repositoryReleaseOwnership(Id<Repository> repositoryId) throws WsException {
        return this.action(repositoryId, "releaseOwnership");
    }

    @Override
    public List<ResourceGroup> resourceGroupGetAll() throws WsException {
        return this.getAll(ResourceGroup.class);
    }

    @Override
    public List<Id<ResourceGroup>> resourceGroupGetIds() throws WsException {
        return this.getIds(ResourceGroup.class);
    }

    @Override
    public ResourceGroup resourceGroupGetById(Id<ResourceGroup> resourceGroupId) throws WsException {
        return this.getById(resourceGroupId, ResourceGroup.class);
    }

    @Override
    public List<ResourceGroup> resourceGroupGetListById(List<Id<ResourceGroup>> resourceGroupIds) throws WsException {
        return this.getListById(resourceGroupIds, ResourceGroup.class);
    }

    @Override
    public Job resourceGroupCreate(ResourceGroup resourceGroup) throws WsException {
        return this.create(resourceGroup);
    }

    @Override
    public Job resourceGroupModify(ResourceGroup resourceGroup) throws WsException {
        return this.modify(resourceGroup);
    }

    @Override
    public Job resourceGroupDelete(Id<ResourceGroup> resourceGroupId) throws WsException {
        return this.delete(resourceGroupId);
    }

    @Override
    public Job resourceGroupAddResource(Id<ResourceGroup> resourceGroupId, Id<? extends BaseObject> objectId) throws WsException {
        return this.action(resourceGroupId, "addResource", objectId);
    }

    @Override
    public Job resourceGroupRemoveResource(Id<ResourceGroup> resourceGroupId, Id<? extends BaseObject> objectId) throws WsException {
        return this.action(resourceGroupId, "removeResource", objectId);
    }

    @Override
    public Job serverAddVm(Id<Server> serverId, Id<Vm> vm) throws WsException {
        return this.addChildObject(serverId, vm);
    }

    @Override
    public Job serverRemoveVm(Id<Server> serverId, Id<Vm> vm) throws WsException {
        return this.removeChildObject(serverId, vm);
    }

    @Override
    public Job serverCreateBondPort(Id<Server> serverId, EthernetPort ethernetPort) throws WsException {
        return this.createChildObject(serverId, ethernetPort);
    }

    @Override
    public Job serverDeleteBondPort(Id<Server> serverId, Id<EthernetPort> ethernetPortId) throws WsException {
        return this.deleteChildObject(serverId, ethernetPortId);
    }

    @Override
    public Job serverCreateNetwork(Id<Server> serverId, Network network) throws WsException {
        return this.createChildObject(serverId, network);
    }

    @Override
    public Job serverDeleteNetwork(Id<Server> serverId, Id<Network> networkId) throws WsException {
        return this.deleteChildObject(serverId, networkId);
    }

    @Override
    public List<Server> serverGetAll() throws WsException {
        return this.getAll(Server.class);
    }

    @Override
    public List<Id<Server>> serverGetIds() throws WsException {
        return this.getIds(Server.class);
    }

    @Override
    public Server serverGetById(Id<Server> serverId) throws WsException {
        return this.getById(serverId, Server.class);
    }

    @Override
    public List<Server> serverGetListById(List<Id<Server>> serverIds) throws WsException {
        return this.getListById(serverIds, Server.class);
    }

    @Override
    public Job serverModify(Server server) throws WsException {
        return this.modify(server);
    }

    @Override
    public Job serverDiscover(String serverName, String agentPassword, boolean takeOwnership) {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("serverName", serverName);
        queryParameters.put("takeOwnership", takeOwnership);
        WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(null, queryParameters, Server.class.getSimpleName(), "discover");
        return (Job)((WebResource.Builder)b.type(this.getMediaType())).post(Job.class, (Object)agentPassword);
    }

    @Override
    public Job serverEnableMaintenanceMode(Id<Server> serverId, boolean enabled) throws WsException {
        Map<String, Object> params = this.createQueryParameterMap("enabled", enabled);
        return this.actionWithQueryParameters(serverId, "enableMaintenanceMode", params, null);
    }

    @Override
    public Job serverUpdateAgentPassword(Id<Server> serverId, String currentPassword, String newPassword) throws WsException {
        PasswordChange passwords = new PasswordChange();
        passwords.setCurrentPassword(currentPassword);
        passwords.setNewPassword(newPassword);
        WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getUri(serverId), "updateAgentPassword");
        return (Job)((WebResource.Builder)b.type(this.getMediaType())).put(Job.class, this.createJAXBElement(passwords));
    }

    @Override
    public ServerUpdateConfiguration serverUpdateConfigurationGetDefault(ServerUpdateConfiguration.ServerUpdateRepositoryType repositoryType) throws WsException {
        WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getBaseURI(), "ServerUpdateConfiguration", "Default", repositoryType.name());
        return (ServerUpdateConfiguration)b.get(ServerUpdateConfiguration.class);
    }

    @Override
    public List<Id<ServerUpdateConfiguration>> serverUpdateConfigurationGetIds() throws WsException {
        return this.getIds(ServerUpdateConfiguration.class);
    }

    @Override
    public List<ServerUpdateConfiguration> serverUpdateConfigurationGetAll() throws WsException {
        return this.getAll(ServerUpdateConfiguration.class);
    }

    @Override
    public ServerUpdateConfiguration serverUpdateConfigurationGetById(Id<ServerUpdateConfiguration> serverUpdateConfigurationId) throws WsException {
        return this.getById(serverUpdateConfigurationId, ServerUpdateConfiguration.class);
    }

    @Override
    public List<ServerUpdateConfiguration> serverUpdateConfigurationGetListById(List<Id<ServerUpdateConfiguration>> serverUpdateConfigurationIds) throws WsException {
        return this.getListById(serverUpdateConfigurationIds, ServerUpdateConfiguration.class);
    }

    @Override
    public Job serverUpdateConfigurationModify(ServerUpdateConfiguration serverUpdateConfiguration) throws WsException {
        return this.modify(serverUpdateConfiguration);
    }

    @Override
    public Job serverUpdateConfigurationCreateServerUpdateRepositoryConfiguration(Id<ServerUpdateConfiguration> serverUpdateConfigurationId, ServerUpdateRepositoryConfiguration serverUpdateRepositoryConfiguration) throws WsException {
        return this.createChildObject(serverUpdateConfigurationId, serverUpdateRepositoryConfiguration);
    }

    @Override
    public Job serverUpdateConfigurationDeleteServerUpdateRepositoryConfiguration(Id<ServerUpdateConfiguration> serverUpdateConfigurationId, Id<ServerUpdateRepositoryConfiguration> serverUpdateRepositoryConfigurationId) throws WsException {
        return this.deleteChildObject(serverUpdateConfigurationId, serverUpdateRepositoryConfigurationId);
    }

    @Override
    public ServerUpdateRepositoryConfiguration serverUpdateRepositoryConfigurationGetById(Id<ServerUpdateRepositoryConfiguration> serverUpdateRepositoryConfigurationId) throws WsException {
        return this.getById(serverUpdateRepositoryConfigurationId, ServerUpdateRepositoryConfiguration.class);
    }

    @Override
    public List<Id<ServerUpdateRepositoryConfiguration>> serverUpdateRepositoryConfigurationGetIds() throws WsException {
        return this.getIds(ServerUpdateRepositoryConfiguration.class);
    }

    @Override
    public List<ServerUpdateRepositoryConfiguration> serverUpdateRepositoryConfigurationGetAll() throws WsException {
        return this.getAll(ServerUpdateRepositoryConfiguration.class);
    }

    @Override
    public List<ServerUpdateRepositoryConfiguration> serverUpdateRepositoryConfigurationGetListById(List<Id<ServerUpdateRepositoryConfiguration>> serverUpdateRepositoryConfigurationIds) throws WsException {
        return this.getListById(serverUpdateRepositoryConfigurationIds, ServerUpdateRepositoryConfiguration.class);
    }

    @Override
    public Job serverUpdateRepositoryConfigurationModify(ServerUpdateRepositoryConfiguration serverUpdateRepositoryConfiguration) throws WsException {
        return this.modify(serverUpdateRepositoryConfiguration);
    }

    @Override
    public Job serverDelete(Id<Server> serverId) throws WsException {
        return this.delete(serverId);
    }

    @Override
    public Job serverRefresh(Id<Server> serverId) throws WsException {
        return this.action(serverId, "refresh");
    }

    @Override
    public Job serverRefreshStorageLayer(Id<Server> serverId) throws WsException {
        return this.action(serverId, "refreshStorageLayer");
    }

    @Override
    public Job serverTakeOwnership(Id<Server> serverId, String agentPassword) throws WsException {
        return this.action(serverId, "takeOwnership", agentPassword);
    }

    @Override
    public Job serverReleaseOwnership(Id<Server> serverId) throws WsException {
        return this.action(serverId, "releaseOwnership");
    }

    @Override
    public Job serverStop(Id<Server> serverId) throws WsException {
        return this.action(serverId, "stop");
    }

    @Override
    public Job serverKill(Id<Server> serverId) throws WsException {
        return this.action(serverId, "kill");
    }

    @Override
    public Job serverStart(Id<Server> serverId) throws WsException {
        return this.action(serverId, "start");
    }

    @Override
    public Job serverRestart(Id<Server> serverId) throws WsException {
        return this.action(serverId, "restart");
    }

    @Override
    public Job serverUpgrade(Id<Server> serverId) throws WsException {
        return this.action(serverId, "upgrade");
    }

    @Override
    public Job serverCheckUpToDate(Id<Server> serverId) throws WsException {
        return this.action(serverId, "checkUpToDate");
    }

    @Override
    public Job serverCreateRepositoryExport(Id<Server> serverId, RepositoryExport repositoryExport) throws WsException {
        return this.createChildObject(serverId, repositoryExport);
    }

    @Override
    public Job serverDeleteRepositoryExport(Id<Server> serverId, Id<RepositoryExport> repositoryExportId) throws WsException {
        return this.deleteChildObject(serverId, repositoryExportId);
    }

    @Override
    public Job serverCreateServerController(Id<Server> serverId, ServerController serverController) throws WsException {
        return this.createChildObject(serverId, serverController);
    }

    @Override
    public Job serverDeleteServerController(Id<Server> serverId) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getUri(serverId), "ServerController");
            return (Job)b.delete(Job.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<String> serverGetPackageList(Id<Server> serverId, Server.PackageType packageType) throws WsException {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("packageType", (Object)packageType);
        WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.getUri(serverId), queryParameters, "Packages");
        StringList packageNames = (StringList)b.get(StringList.class);
        ArrayList<String> installedPackages = new ArrayList<String>();
        if (packageNames != null && packageNames.getStrings() != null) {
            for (String packageName : packageNames.getStrings()) {
                installedPackages.add(packageName);
            }
        }
        return installedPackages;
    }

    @Override
    public Job serverRefreshPackageList(Id<Server> serverId, Server.PackageType packageType) throws WsException {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("packageType", (Object)packageType);
        return this.actionWithQueryParameters(serverId, "refreshPackageList", queryParameters, null);
    }

    @Override
    public Job serverRemovePackageList(Id<Server> serverId, List<String> packageNames) throws WsException {
        StringList names = new StringList(packageNames);
        return this.action(serverId, "removePackageList", names);
    }

    @Override
    public List<ServerController> serverControllerGetAll() throws WsException {
        return this.getAll(ServerController.class);
    }

    @Override
    public List<Id<ServerController>> serverControllerGetIds() throws WsException {
        return this.getIds(ServerController.class);
    }

    @Override
    public ServerController serverControllerGetById(Id<ServerController> serverControllerId) throws WsException {
        return this.getById(serverControllerId, ServerController.class);
    }

    @Override
    public List<ServerController> serverControllerGetListById(List<Id<ServerController>> serverControllerIds) throws WsException {
        return this.getListById(serverControllerIds, ServerController.class);
    }

    @Override
    public Job serverControllerModify(ServerController serverController) throws WsException {
        return this.modify(serverController);
    }

    @Override
    public Job serverPoolAddServer(Id<ServerPool> serverPoolId, Id<Server> serverId) throws WsException {
        return this.addChildObject(serverPoolId, serverId);
    }

    @Override
    public Job serverPoolAddVm(Id<ServerPool> serverPoolId, Id<Vm> vmId) throws WsException {
        return this.addChildObject(serverPoolId, vmId);
    }

    @Override
    public Job serverPoolCreate(ServerPool serverPool) throws WsException {
        return this.create(serverPool);
    }

    @Override
    public Job serverPoolCreateAffinityGroup(Id<ServerPool> serverPoolId, AffinityGroup affinityGroup) throws WsException {
        return this.createChildObject(serverPoolId, affinityGroup);
    }

    @Override
    public Job serverPoolCreateCluster(Id<ServerPool> serverPoolId, Cluster cluster) throws WsException {
        return this.createChildObject(serverPoolId, cluster);
    }

    @Override
    public Job serverPoolCreateServerUpdateConfiguration(Id<ServerPool> serverPoolId, ServerUpdateConfiguration serverUpdateConfiguration) throws WsException {
        return this.createChildObject(serverPoolId, serverUpdateConfiguration);
    }

    @Override
    public Job serverPoolDeleteServerUpdateConfiguration(Id<ServerPool> serverPoolId) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getUri(serverPoolId), "ServerUpdateConfiguration");
            return (Job)b.delete(Job.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolDelete(Id<ServerPool> serverPoolId) throws WsException {
        return this.delete(serverPoolId);
    }

    @Override
    public Job serverPoolDeleteAffinityGroup(Id<ServerPool> serverPoolId, Id<AffinityGroup> affinityGroupId) throws WsException {
        return this.deleteChildObject(serverPoolId, affinityGroupId);
    }

    @Override
    public Job serverPoolDeleteCluster(Id<ServerPool> serverPoolId, Id<Cluster> clusterId) throws WsException {
        return this.deleteChildObject(serverPoolId, clusterId);
    }

    @Override
    public List<ServerPool> serverPoolGetAll() throws WsException {
        return this.getAll(ServerPool.class);
    }

    @Override
    public List<Id<ServerPool>> serverPoolGetIds() throws WsException {
        return this.getIds(ServerPool.class);
    }

    @Override
    public ServerPool serverPoolGetById(Id<ServerPool> serverPoolId) throws WsException {
        return this.getById(serverPoolId, ServerPool.class);
    }

    @Override
    public List<ServerPool> serverPoolGetListById(List<Id<ServerPool>> serverPoolIds) throws WsException {
        return this.getListById(serverPoolIds, ServerPool.class);
    }

    @Override
    public Job serverPoolModify(ServerPool serverPool) throws WsException {
        return this.modify(serverPool);
    }

    @Override
    public Job serverPoolRemoveServer(Id<ServerPool> serverPoolId, Id<Server> serverId) throws WsException {
        return this.removeChildObject(serverPoolId, serverId);
    }

    @Override
    public Job serverPoolRemoveVm(Id<ServerPool> serverPoolId, Id<Vm> vmId) throws WsException {
        return this.removeChildObject(serverPoolId, vmId);
    }

    @Override
    public Job serverPoolSetMasterServer(Id<ServerPool> serverPoolId, Id<Server> masterServerId) throws WsException {
        return this.action(serverPoolId, "setMasterServer", masterServerId);
    }

    @Override
    public List<StorageArray> storageArrayGetAll() throws WsException {
        return this.getAll(StorageArray.class);
    }

    @Override
    public ServerPoolPolicy serverPoolPolicyGetById(Id<ServerPoolPolicy> serverPoolPolicyId) throws WsException {
        return this.getById(serverPoolPolicyId, ServerPoolPolicy.class);
    }

    @Override
    public List<ServerPoolPolicy> serverPoolPolicyGetAll() throws WsException {
        return this.getAll(ServerPoolPolicy.class);
    }

    @Override
    public List<Id<ServerPoolPolicy>> serverPoolPolicyGetIds() throws WsException {
        return this.getIds(ServerPoolPolicy.class);
    }

    @Override
    public List<ServerPoolPolicy> serverPoolPolicyGetListById(List<Id<ServerPoolPolicy>> serverPoolPolicyIds) throws WsException {
        return this.getListById(serverPoolPolicyIds, ServerPoolPolicy.class);
    }

    @Override
    public ServerPoolNetworkPolicy serverPoolNetworkPolicyGetById(Id<ServerPoolNetworkPolicy> serverPoolNetworkPolicyId) throws WsException {
        return this.getById(serverPoolNetworkPolicyId, ServerPoolNetworkPolicy.class);
    }

    @Override
    public List<ServerPoolNetworkPolicy> serverPoolNetworkPolicyGetAll() throws WsException {
        return this.getAll(ServerPoolNetworkPolicy.class);
    }

    @Override
    public List<Id<ServerPoolNetworkPolicy>> serverPoolNetworkPolicyGetIds() throws WsException {
        return this.getIds(ServerPoolNetworkPolicy.class);
    }

    @Override
    public List<ServerPoolNetworkPolicy> serverPoolNetworkPolicyGetListById(List<Id<ServerPoolNetworkPolicy>> serverPoolNetworkPolicyIds) throws WsException {
        return this.getListById(serverPoolNetworkPolicyIds, ServerPoolNetworkPolicy.class);
    }

    @Override
    public Job serverPoolNetworkPolicyModify(ServerPoolNetworkPolicy serverPoolNetworkPolicy) throws WsException {
        return this.modify(serverPoolNetworkPolicy);
    }

    @Override
    public Job serverPoolPolicyModify(ServerPoolPolicy serverPoolPolicy) throws WsException {
        return this.modify(serverPoolPolicy);
    }

    @Override
    public Job serverPoolPolicyAddServer(Id<ServerPoolPolicy> serverPoolPolicyId, Id<Server> serverId) throws WsException {
        return this.addChildObject(serverPoolPolicyId, serverId);
    }

    @Override
    public Job serverPoolPolicyRemoveServer(Id<ServerPoolPolicy> serverPoolPolicyId, Id<Server> serverId) throws WsException {
        return this.removeChildObject(serverPoolPolicyId, serverId);
    }

    @Override
    public Job serverPoolPolicyCreateNetworkPolicy(Id<ServerPoolPolicy> serverPoolPolicyId, ServerPoolNetworkPolicy serverPoolNetworkPolicy) throws WsException {
        return this.createChildObject(serverPoolPolicyId, serverPoolNetworkPolicy);
    }

    @Override
    public Job serverPoolPolicyDeleteNetworkPolicy(Id<ServerPoolPolicy> serverPoolPolicyId, Id<ServerPoolNetworkPolicy> serverPoolNetworkPolicyId) throws WsException {
        return this.deleteChildObject(serverPoolPolicyId, serverPoolNetworkPolicyId);
    }

    @Override
    public List<Statistic> statisticGetListForObject(Id<? extends BaseObject> objectId, Statistic.StatisticType statisticType, long startTime, long endTime) throws WsException {
        try {
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            queryParameters.put("startTime", Long.toString(startTime));
            queryParameters.put("endTime", Long.toString(endTime));
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(null, queryParameters, Statistic.class.getSimpleName(), this.getSimpleName(objectId.getType()), objectId.getValue(), statisticType.toString(), "range");
            return (List)((WebResource.Builder)b.type(this.getMediaType())).get(this.getGenericListType(Statistic.class));
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Statistic statisticGetAverageForObject(Id<? extends BaseObject> objectId, Statistic.StatisticType statisticType, long startTime, long endTime) throws WsException {
        try {
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            queryParameters.put("startTime", Long.toString(startTime));
            queryParameters.put("endTime", Long.toString(endTime));
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(null, queryParameters, Statistic.class.getSimpleName(), this.getSimpleName(objectId.getType()), objectId.getValue(), statisticType.toString(), "average");
            return (Statistic)((WebResource.Builder)b.type(this.getMediaType())).get(Statistic.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Statistic statisticGetCurrentValueForObject(Id<? extends BaseObject> objectId, Statistic.StatisticType statisticType) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(Statistic.class.getSimpleName(), this.getSimpleName(objectId.getType()), objectId.getValue(), statisticType.toString());
            return (Statistic)((WebResource.Builder)b.type(this.getMediaType())).get(Statistic.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Statistic statisticGetLatestForObject(Id<? extends BaseObject> objectId, Statistic.StatisticType statisticType) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(Statistic.class.getSimpleName(), this.getSimpleName(objectId.getType()), objectId.getValue(), statisticType.toString());
            return (Statistic)((WebResource.Builder)b.type(this.getMediaType())).get(Statistic.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Statistic> statisticGetLatestForObjectList(List<Id<? extends BaseObject>> objectIds, Statistic.StatisticType statisticType) throws WsException {
        try {
            ArrayList<String> idStrings = new ArrayList<String>();
            String type = null;
            for (Id<? extends BaseObject> objectId : objectIds) {
                type = this.getSimpleName(objectId.getType());
                idStrings.add(objectId.getValue());
            }
            Map<String, Object> queryParameters = this.createQueryParameterMap(new Object[]{"objectId", idStrings, "statisticType", statisticType});
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(null, queryParameters, Statistic.class.getSimpleName(), type);
            return (List)((WebResource.Builder)b.type(this.getMediaType())).get(this.getGenericListType(Statistic.class));
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<StorageArray>> storageArrayGetIds() throws WsException {
        return this.getIds(StorageArray.class);
    }

    @Override
    public StorageArray storageArrayGetById(Id<StorageArray> storageArrayId) throws WsException {
        return this.getById(storageArrayId, StorageArray.class);
    }

    @Override
    public List<StorageArray> storageArrayGetListById(List<Id<StorageArray>> storageArrayIds) throws WsException {
        return this.getListById(storageArrayIds, StorageArray.class);
    }

    @Override
    public Job storageArrayModify(StorageArray storageArray) throws WsException {
        return this.modify(storageArray);
    }

    @Override
    public Job storageArraySetStorageArrayPlugin(Id<StorageArray> fileServerId, Id<StorageArrayPlugin> pluginId) throws WsException {
        return this.setChildObject(fileServerId, pluginId, "storageArrayPluginId");
    }

    @Override
    public Job storageArrayCreateAccessGroup(Id<StorageArray> storageArrayId, AccessGroup accessGroup) throws WsException {
        return this.createChildObject(storageArrayId, accessGroup);
    }

    @Override
    public Job storageArrayDeleteAccessGroup(Id<StorageArray> storageArrayId, Id<AccessGroup> accessGroupId) throws WsException {
        return this.deleteChildObject(storageArrayId, accessGroupId);
    }

    @Override
    public Job storageArrayDiscover(StorageArray storageArray) throws WsException {
        return this.create(storageArray);
    }

    @Override
    public Job storageArrayDelete(Id<StorageArray> storageArrayId) throws WsException {
        return this.delete(storageArrayId);
    }

    @Override
    public Job storageArrayAddAdminServer(Id<StorageArray> storageArrayId, Id<Server> serverId) throws WsException {
        return this.action(storageArrayId, "addAdminServer", serverId);
    }

    @Override
    public Job storageArrayRemoveAdminServer(Id<StorageArray> storageArrayId, Id<Server> serverId) throws WsException {
        return this.action(storageArrayId, "removeAdminServer", serverId);
    }

    @Override
    public Job storageArrayRefresh(Id<StorageArray> storageArrayId) throws WsException {
        return this.action(storageArrayId, "refresh");
    }

    @Override
    public Job storageArrayValidate(Id<StorageArray> storageArrayId) throws WsException {
        return this.action(storageArrayId, "validate");
    }

    @Override
    public List<StorageArrayPlugin> storageArrayPluginGetAll() throws WsException {
        return this.getAll(StorageArrayPlugin.class);
    }

    @Override
    public List<Id<StorageArrayPlugin>> storageArrayPluginGetIds() throws WsException {
        return this.getIds(StorageArrayPlugin.class);
    }

    @Override
    public StorageArrayPlugin storageArrayPluginGetById(Id<StorageArrayPlugin> storageArrayPluginId) throws WsException {
        return this.getById(storageArrayPluginId, StorageArrayPlugin.class);
    }

    @Override
    public List<StorageArrayPlugin> storageArrayPluginGetListById(List<Id<StorageArrayPlugin>> storageArrayPluginIds) throws WsException {
        return this.getListById(storageArrayPluginIds, StorageArrayPlugin.class);
    }

    @Override
    public Job storageArrayPluginModify(StorageArrayPlugin storageArrayPlugin) throws WsException {
        return this.modify(storageArrayPlugin);
    }

    @Override
    public List<StorageElement> storageElementGetAll() throws WsException {
        return this.getAll(StorageElement.class);
    }

    @Override
    public List<Id<StorageElement>> storageElementGetIds() throws WsException {
        return this.getIds(StorageElement.class);
    }

    @Override
    public StorageElement storageElementGetById(Id<StorageElement> storageElementId) throws WsException {
        return this.getById(storageElementId, StorageElement.class);
    }

    @Override
    public List<StorageElement> storageElementGetListById(List<Id<StorageElement>> storageElementIds) throws WsException {
        return this.getListById(storageElementIds, StorageElement.class);
    }

    @Override
    public Job storageElementModify(StorageElement storageElement) throws WsException {
        return this.modify(storageElement);
    }

    @Override
    public Job storageElementClone(Id<StorageElement> storageElementId, Id<? extends BaseObject> cloneTargetId, CloneType cloneType, String userFriendlyName) throws WsException {
        Map<String, Object> queryParameters = this.createQueryParameterMap(new Object[]{"cloneType", cloneType, "userFriendlyName", userFriendlyName});
        return this.actionWithQueryParameters(storageElementId, "clone", queryParameters, cloneTargetId);
    }

    @Override
    public Job storageElementRefresh(Id<StorageElement> storageElementId) throws WsException {
        return this.action(storageElementId, "refresh");
    }

    @Override
    public Job storageElementResize(Id<StorageElement> storageElementId, long size) throws WsException {
        Map<String, Object> queryParameters = this.createQueryParameterMap("size", size);
        return this.actionWithQueryParameters(storageElementId, "resize", queryParameters, null);
    }

    @Override
    public List<StorageInitiator> storageInitiatorGetAll() throws WsException {
        return this.getAll(StorageInitiator.class);
    }

    @Override
    public List<Id<StorageInitiator>> storageInitiatorGetIds() throws WsException {
        return this.getIds(StorageInitiator.class);
    }

    @Override
    public StorageInitiator storageInitiatorGetById(Id<StorageInitiator> storageInitiatorId) throws WsException {
        return this.getById(storageInitiatorId, StorageInitiator.class);
    }

    @Override
    public List<StorageInitiator> storageInitiatorGetListById(List<Id<StorageInitiator>> storageInitiatorIds) throws WsException {
        return this.getListById(storageInitiatorIds, StorageInitiator.class);
    }

    @Override
    public Job storageInitiatorModify(StorageInitiator storageInitiator) throws WsException {
        return this.modify(storageInitiator);
    }

    @Override
    public List<StoragePath> storagePathGetAll() throws WsException {
        return this.getAll(StoragePath.class);
    }

    @Override
    public List<Id<StoragePath>> storagePathGetIds() throws WsException {
        return this.getIds(StoragePath.class);
    }

    @Override
    public StoragePath storagePathGetById(Id<StoragePath> storagePathId) throws WsException {
        return this.getById(storagePathId, StoragePath.class);
    }

    @Override
    public List<StoragePath> storagePathGetListById(List<Id<StoragePath>> storagePathIds) throws WsException {
        return this.getListById(storagePathIds, StoragePath.class);
    }

    @Override
    public Job storagePathModify(StoragePath storagePath) throws WsException {
        return this.modify(storagePath);
    }

    @Override
    public List<StorageTarget> storageTargetGetAll() throws WsException {
        return this.getAll(StorageTarget.class);
    }

    @Override
    public List<Id<StorageTarget>> storageTargetGetIds() throws WsException {
        return this.getIds(StorageTarget.class);
    }

    @Override
    public StorageTarget storageTargetGetById(Id<StorageTarget> storageTargetId) throws WsException {
        return this.getById(storageTargetId, StorageTarget.class);
    }

    @Override
    public List<StorageTarget> storageTargetGetListById(List<Id<StorageTarget>> storageTargetIds) throws WsException {
        return this.getListById(storageTargetIds, StorageTarget.class);
    }

    @Override
    public Job storageTargetModify(StorageTarget storageTarget) throws WsException {
        return this.modify(storageTarget);
    }

    @Override
    public List<VirtualSwitch> virtualSwitchGetAll() throws WsException {
        return this.getAll(VirtualSwitch.class);
    }

    @Override
    public List<Id<VirtualSwitch>> virtualSwitchGetIds() throws WsException {
        return this.getIds(VirtualSwitch.class);
    }

    @Override
    public VirtualSwitch virtualSwitchGetById(Id<VirtualSwitch> virtualSwitchId) throws WsException {
        return this.getById(virtualSwitchId, VirtualSwitch.class);
    }

    @Override
    public List<VirtualSwitch> virtualSwitchGetListById(List<Id<VirtualSwitch>> virtualSwitchIds) throws WsException {
        return this.getListById(virtualSwitchIds, VirtualSwitch.class);
    }

    @Override
    public List<VlanInterface> vlanInterfaceGetAll() throws WsException {
        return this.getAll(VlanInterface.class);
    }

    @Override
    public List<Id<VlanInterface>> vlanInterfaceGetIds() throws WsException {
        return this.getIds(VlanInterface.class);
    }

    @Override
    public VlanInterface vlanInterfaceGetById(Id<VlanInterface> vlanInterfaceId) throws WsException {
        return this.getById(vlanInterfaceId, VlanInterface.class);
    }

    @Override
    public List<VlanInterface> vlanInterfaceGetListById(List<Id<VlanInterface>> vlanInterfaceIds) throws WsException {
        return this.getListById(vlanInterfaceIds, VlanInterface.class);
    }

    @Override
    public Job vlanInterfaceModify(VlanInterface vlanInterface) throws WsException {
        return this.modify(vlanInterface);
    }

    @Override
    public Job vmClearAllMessages(Id<Vm> vmId, VmMessageType messageType) throws WsException {
        Map<String, Object> queryParams = this.createQueryParameterMap(new Object[]{"messageType", messageType});
        return this.actionWithQueryParameters(vmId, "clearAllMessages", queryParams, null);
    }

    @Override
    public Job vmClearMessage(Id<Vm> vmId, VmMessageType messageType, String messageKey) throws WsException {
        Map<String, Object> queryParams = this.createQueryParameterMap(new Object[]{"messageType", messageType, "messageKey", messageKey});
        return this.actionWithQueryParameters(vmId, "clearMessage", queryParams, null);
    }

    @Override
    public Job vmClearMessageList(Id<Vm> vmId, VmMessageType messageType, List<String> messageKeys) throws WsException {
        Map<String, Object> queryParams = this.createQueryParameterMap(new Object[]{"messageType", messageType, "messageKey", messageKeys});
        return this.actionWithQueryParameters(vmId, "clearMessageList", queryParams, null);
    }

    @Override
    public List<KeyValuePair> vmGetAllMessages(Id<Vm> vmId, VmMessageType messageType) throws WsException {
        Map<String, Object> queryParams = this.createQueryParameterMap(new Object[]{"messageType", messageType});
        try {
            WebResource.Builder b = this.getResourceForAction(vmId, "messages", queryParams);
            return (List)b.get(this.getGenericListType(KeyValuePair.class));
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<String> vmGetAllMessageKeys(Id<Vm> vmId, VmMessageType messageType) throws WsException {
        Map<String, Object> queryParams = this.createQueryParameterMap(new Object[]{"messageType", messageType});
        try {
            WebResource.Builder b = this.getResourceForAction(vmId, "messageKeys", queryParams);
            StringList stringList = (StringList)b.get(StringList.class);
            return stringList.getStrings();
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public KeyValuePair vmGetMessage(Id<Vm> vmId, VmMessageType messageType, String messageKey) throws WsException {
        Map<String, Object> queryParams = this.createQueryParameterMap(new Object[]{"messageType", messageType, "messageKey", messageKey});
        try {
            WebResource.Builder b = this.getResourceForAction(vmId, "message", queryParams);
            return (KeyValuePair)b.get(KeyValuePair.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<KeyValuePair> vmGetMessageList(Id<Vm> vmId, VmMessageType messageType, List<String> messageKeys) throws WsException {
        Map<String, Object> queryParams = this.createQueryParameterMap(new Object[]{"messageType", messageType, "messageKey", messageKeys});
        try {
            WebResource.Builder b = this.getResourceForAction(vmId, "messageList", queryParams);
            return (List)b.get(this.getGenericListType(KeyValuePair.class));
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmClone(Id<Vm> vmId, Id<ServerPool> serverPoolId, Id<Repository> repositoryId, Id<VmCloneDefinition> vmCloneDefinitionId, boolean createTemplate) throws WsException {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("serverPoolId", serverPoolId.getValue());
        queryParameters.put("repositoryId", repositoryId == null ? null : repositoryId.getValue());
        queryParameters.put("vmCloneDefinitionId", vmCloneDefinitionId == null ? null : vmCloneDefinitionId.getValue());
        queryParameters.put("createTemplate", createTemplate);
        return this.actionWithQueryParameters(vmId, "clone", queryParameters, null);
    }

    @Override
    public Job vmCreate(Vm vm, Id<ServerPool> serverPoolId) throws WsException {
        vm.setServerPoolId(serverPoolId);
        return this.create(vm);
    }

    @Override
    public Job vmCreateFromAssemblyVm(Id<AssemblyVm> assemblyVmId) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(Vm.class.getSimpleName(), "createFromAssemblyVm", assemblyVmId.getValue());
            Job job = (Job)b.put(Job.class);
            return job;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCreateCloneDefinition(Id<Vm> vmId, VmCloneDefinition vmCloneDefinition) throws WsException {
        return this.createChildObject(vmId, vmCloneDefinition);
    }

    @Override
    public Job vmCreateDiskMapping(Id<Vm> vmId, VmDiskMapping vmDiskMapping) throws WsException {
        return this.createChildObject(vmId, vmDiskMapping);
    }

    @Override
    public Job vmCreateVirtualNic(Id<Vm> vmId, VirtualNic vnic) throws WsException {
        return this.createChildObject(vmId, vnic);
    }

    @Override
    public Job vmDelete(Id<Vm> vmId) throws WsException {
        return this.delete(vmId);
    }

    @Override
    public Job vmDeleteCloneDefinition(Id<Vm> vmId, Id<VmCloneDefinition> vmCloneDefinitionId) throws WsException {
        return this.deleteChildObject(vmId, vmCloneDefinitionId);
    }

    @Override
    public Job vmDeleteDiskMapping(Id<Vm> vmId, Id<VmDiskMapping> vmDiskMappingId) throws WsException {
        return this.deleteChildObject(vmId, vmDiskMappingId);
    }

    @Override
    public Job vmDeleteVirtualNic(Id<Vm> vmId, Id<VirtualNic> vnicId) throws WsException {
        return this.deleteChildObject(vmId, vnicId);
    }

    @Override
    public List<Vm> vmGetAll() throws WsException {
        return this.getAll(Vm.class);
    }

    @Override
    public List<Id<Vm>> vmGetIds() throws WsException {
        return this.getIds(Vm.class);
    }

    @Override
    public Vm vmGetById(Id<Vm> vmId) throws WsException {
        return this.getById(vmId, Vm.class);
    }

    @Override
    public List<Vm> vmGetListById(List<Id<Vm>> vmIds) throws WsException {
        return this.getListById(vmIds, Vm.class);
    }

    @Override
    public List<String> vmGetSupportedOsTypes() throws WsException {
        WebResource.Builder b = this.getResourceFromPathElements(Vm.class.getSimpleName(), "SupportedOsTypes");
        StringList osTypes = (StringList)b.get(StringList.class);
        ArrayList<String> types = new ArrayList<String>();
        for (String os : osTypes.getStrings()) {
            types.add(os);
        }
        return types;
    }

    @Override
    public Job vmKill(Id<Vm> vmId) throws WsException {
        return this.action(vmId, "kill");
    }

    @Override
    public Job vmMigrate(Id<Vm> vmId, Id<Server> destinationServerId) throws WsException {
        return this.action(vmId, "migrate", destinationServerId);
    }

    @Override
    public Job vmModify(Vm vm) throws WsException {
        return this.modify(vm);
    }

    @Override
    public Job vmMove(Id<Vm> vmId, Id<Repository> repositoryId, Id<VmCloneDefinition> vmCloneDefinitionId) throws WsException {
        Map<String, Object> queryParameters = this.createQueryParameterMap("repositoryId", repositoryId.getValue(), "vmCloneDefinitionId", vmCloneDefinitionId.getValue());
        return this.actionWithQueryParameters(vmId, "move", queryParameters, null);
    }

    @Override
    public Job vmRestart(Id<Vm> vmId) throws WsException {
        return this.action(vmId, "restart");
    }

    @Override
    public Job vmResume(Id<Vm> vmId) throws WsException {
        return this.action(vmId, "resume");
    }

    @Override
    public Job vmSendMessage(Id<Vm> vmId, List<KeyValuePair> message, boolean logFlag) throws WsException {
        Map<String, Object> map = this.createQueryParameterMap("logFlag", logFlag);
        WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.getUri(vmId), map, "sendMessage");
        Job job = (Job)b.put(Job.class, (Object)message.toArray(new KeyValuePair[message.size()]));
        return job;
    }

    @Override
    public Job vmStart(Id<Vm> vmId) throws WsException {
        return this.action(vmId, "start");
    }

    @Override
    public Job vmStop(Id<Vm> vmId) throws WsException {
        return this.action(vmId, "stop");
    }

    @Override
    public Job vmSuspend(Id<Vm> vmId) throws WsException {
        return this.action(vmId, "suspend");
    }

    @Override
    public String vmGetConsoleUrl(Id<Vm> vmId) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getUri(vmId), "vmConsoleUrl");
            return (String)b.get(String.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public String vmGetSerialConsoleUrl(Id<Vm> vmId) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getUri(vmId), "vmSerialConsoleUrl");
            return (String)b.get(String.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VirtualDisk> virtualDiskGetAll() throws WsException {
        return this.getAll(VirtualDisk.class);
    }

    @Override
    public List<Id<VirtualDisk>> virtualDiskGetIds() throws WsException {
        return this.getIds(VirtualDisk.class);
    }

    @Override
    public VirtualDisk virtualDiskGetById(Id<VirtualDisk> virtualDiskId) throws WsException {
        return this.getById(virtualDiskId, VirtualDisk.class);
    }

    @Override
    public List<VirtualDisk> virtualDiskGetListById(List<Id<VirtualDisk>> virtualDiskIds) throws WsException {
        return this.getListById(virtualDiskIds, VirtualDisk.class);
    }

    @Override
    public Job virtualDiskModify(VirtualDisk virtualDisk) throws WsException {
        return this.modify(virtualDisk);
    }

    @Override
    public Job virtualDiskClone(Id<VirtualDisk> virtualDiskId, Id<? extends BaseObject> cloneTargetId, CloneType cloneType) throws WsException {
        Map<String, Object> queryParameters = this.createQueryParameterMap(new Object[]{"cloneType", cloneType});
        return this.actionWithQueryParameters(virtualDiskId, "clone", queryParameters, cloneTargetId);
    }

    @Override
    public VirtualDisk virtualDiskGetEmptyCdrom() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(VirtualDisk.class.getSimpleName(), "virtualDiskGetEmptyCdrom");
            return (VirtualDisk)b.get(VirtualDisk.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job virtualDiskResize(Id<VirtualDisk> virtualDiskId, long size, boolean sparse) throws WsException {
        Map<String, Object> queryParameters = this.createQueryParameterMap("size", size, "sparse", sparse);
        return this.actionWithQueryParameters(virtualDiskId, "resize", queryParameters, null);
    }

    @Override
    public List<VmCloneDefinition> vmCloneDefinitionGetAll() throws WsException {
        return this.getAll(VmCloneDefinition.class);
    }

    @Override
    public List<Id<VmCloneDefinition>> vmCloneDefinitionGetIds() throws WsException {
        return this.getIds(VmCloneDefinition.class);
    }

    @Override
    public VmCloneDefinition vmCloneDefinitionGetById(Id<VmCloneDefinition> vmCloneDefinitionId) throws WsException {
        return this.getById(vmCloneDefinitionId, VmCloneDefinition.class);
    }

    @Override
    public List<VmCloneDefinition> vmCloneDefinitionGetListById(List<Id<VmCloneDefinition>> vmCloneDefinitionIds) throws WsException {
        return this.getListById(vmCloneDefinitionIds, VmCloneDefinition.class);
    }

    @Override
    public Job vmCloneDefinitionModify(VmCloneDefinition vmCloneDefinition) throws WsException {
        return this.modify(vmCloneDefinition);
    }

    @Override
    public Job vmCloneDefinitionCreateNetworkMapping(Id<VmCloneDefinition> vmCloneDefinitionId, VmCloneNetworkMapping vmCloneNetworkMapping) throws WsException {
        return this.createChildObject(vmCloneDefinitionId, vmCloneNetworkMapping);
    }

    @Override
    public Job vmCloneDefinitionDeleteNetworkMapping(Id<VmCloneDefinition> vmCloneDefinitionId, Id<VmCloneNetworkMapping> vmCloneNetworkMappingId) throws WsException {
        return this.deleteChildObject(vmCloneDefinitionId, vmCloneNetworkMappingId);
    }

    @Override
    public Job vmCloneDefinitionCreateStorageMapping(Id<VmCloneDefinition> vmCloneDefinitionId, VmCloneStorageMapping vmCloneStorageMapping) throws WsException {
        return this.createChildObject(vmCloneDefinitionId, vmCloneStorageMapping);
    }

    @Override
    public Job vmCloneDefinitionDeleteStorageMapping(Id<VmCloneDefinition> vmCloneDefinitionId, Id<VmCloneStorageMapping> vmCloneStorageMappingId) throws WsException {
        return this.deleteChildObject(vmCloneDefinitionId, vmCloneStorageMappingId);
    }

    @Override
    public List<VmCloneNetworkMapping> vmCloneNetworkMappingGetAll() throws WsException {
        return this.getAll(VmCloneNetworkMapping.class);
    }

    @Override
    public List<Id<VmCloneNetworkMapping>> vmCloneNetworkMappingGetIds() throws WsException {
        return this.getIds(VmCloneNetworkMapping.class);
    }

    @Override
    public VmCloneNetworkMapping vmCloneNetworkMappingGetById(Id<VmCloneNetworkMapping> vmCloneNetworkMappingId) throws WsException {
        return this.getById(vmCloneNetworkMappingId, VmCloneNetworkMapping.class);
    }

    @Override
    public List<VmCloneNetworkMapping> vmCloneNetworkMappingGetListById(List<Id<VmCloneNetworkMapping>> vmCloneNetworkMappingIds) throws WsException {
        return this.getListById(vmCloneNetworkMappingIds, VmCloneNetworkMapping.class);
    }

    @Override
    public Job vmCloneNetworkMappingModify(VmCloneNetworkMapping vmCloneNetworkMapping) throws WsException {
        return this.modify(vmCloneNetworkMapping);
    }

    @Override
    public Job vmCloneNetworkMappingSetNetwork(Id<VmCloneNetworkMapping> vmCloneNetworkMappingId, Id<Network> networkId) throws WsException {
        return this.setChildObject(vmCloneNetworkMappingId, networkId, "networkId");
    }

    @Override
    public List<VmCloneStorageMapping> vmCloneStorageMappingGetAll() throws WsException {
        return this.getAll(VmCloneStorageMapping.class);
    }

    @Override
    public List<Id<VmCloneStorageMapping>> vmCloneStorageMappingGetIds() throws WsException {
        return this.getIds(VmCloneStorageMapping.class);
    }

    @Override
    public VmCloneStorageMapping vmCloneStorageMappingGetById(Id<VmCloneStorageMapping> vmCloneStorageMappingId) throws WsException {
        return this.getById(vmCloneStorageMappingId, VmCloneStorageMapping.class);
    }

    @Override
    public List<VmCloneStorageMapping> vmCloneStorageMappingGetListById(List<Id<VmCloneStorageMapping>> vmCloneStorageMappingIds) throws WsException {
        return this.getListById(vmCloneStorageMappingIds, VmCloneStorageMapping.class);
    }

    @Override
    public Job vmCloneStorageMappingModify(VmCloneStorageMapping vmCloneStorageMapping) throws WsException {
        return this.modify(vmCloneStorageMapping);
    }

    @Override
    public Job vmCloneStorageMappingSetStorageCloneTarget(Id<VmCloneStorageMapping> vmCloneStorageMappingId, Id<? extends BaseObject> storageCloneTargetId) throws WsException {
        return this.action(vmCloneStorageMappingId, "setStorageCloneTarget", storageCloneTargetId);
    }

    @Override
    public List<VmDiskMapping> vmDiskMappingGetAll() throws WsException {
        return this.getAll(VmDiskMapping.class);
    }

    @Override
    public List<Id<VmDiskMapping>> vmDiskMappingGetIds() throws WsException {
        return this.getIds(VmDiskMapping.class);
    }

    @Override
    public VmDiskMapping vmDiskMappingGetById(Id<VmDiskMapping> vmDiskMappingId) throws WsException {
        return this.getById(vmDiskMappingId, VmDiskMapping.class);
    }

    @Override
    public List<VmDiskMapping> vmDiskMappingGetListById(List<Id<VmDiskMapping>> vmDiskMappingIds) throws WsException {
        return this.getListById(vmDiskMappingIds, VmDiskMapping.class);
    }

    @Override
    public Job vmDiskMappingModify(VmDiskMapping vmDiskMapping) throws WsException {
        return this.modify(vmDiskMapping);
    }

    @Override
    public Job vmDiskMappingSetVirtualDisk(Id<VmDiskMapping> vmDiskMappingId, Id<VirtualDisk> virtualDiskId) throws WsException {
        return this.setChildObject(vmDiskMappingId, virtualDiskId, "virtualDiskId");
    }

    @Override
    public List<VirtualNic> virtualNicGetAll() throws WsException {
        return this.getAll(VirtualNic.class);
    }

    @Override
    public List<Id<VirtualNic>> virtualNicGetIds() throws WsException {
        return this.getIds(VirtualNic.class);
    }

    @Override
    public VirtualNic virtualNicGetById(Id<VirtualNic> vnicId) throws WsException {
        return this.getById(vnicId, VirtualNic.class);
    }

    @Override
    public List<VirtualNic> virtualNicGetListById(List<Id<VirtualNic>> vnicIds) throws WsException {
        return this.getListById(vnicIds, VirtualNic.class);
    }

    @Override
    public Job virtualNicModify(VirtualNic vnic) throws WsException {
        return this.modify(vnic);
    }

    @Override
    public List<VolumeGroup> volumeGroupGetAll() throws WsException {
        return this.getAll(VolumeGroup.class);
    }

    @Override
    public List<Id<VolumeGroup>> volumeGroupGetIds() throws WsException {
        return this.getIds(VolumeGroup.class);
    }

    @Override
    public VolumeGroup volumeGroupGetById(Id<VolumeGroup> volumeGroupId) throws WsException {
        return this.getById(volumeGroupId, VolumeGroup.class);
    }

    @Override
    public List<VolumeGroup> volumeGroupGetListById(List<Id<VolumeGroup>> volumeGroupIds) throws WsException {
        return this.getListById(volumeGroupIds, VolumeGroup.class);
    }

    @Override
    public Job volumeGroupModify(VolumeGroup volumeGroup) throws WsException {
        return this.modify(volumeGroup);
    }

    @Override
    public Job volumeGroupCreateStorageElement(Id<VolumeGroup> volumeGroupId, StorageElement storageElement) throws WsException {
        return this.createChildObject(volumeGroupId, storageElement);
    }

    @Override
    public Job volumeGroupDeleteStorageElement(Id<VolumeGroup> volumeGroupId, Id<StorageElement> storageElementId) throws WsException {
        return this.deleteChildObject(volumeGroupId, storageElementId);
    }

    @Override
    public Job zoneCreate(Zone zone) throws WsException {
        return this.create(zone);
    }

    @Override
    public Job zoneModify(Zone zone) throws WsException {
        return this.modify(zone);
    }

    @Override
    public List<Zone> zoneGetAll() throws WsException {
        return this.getAll(Zone.class);
    }

    @Override
    public List<Id<Zone>> zoneGetIds() throws WsException {
        return this.getIds(Zone.class);
    }

    @Override
    public Zone zoneGetById(Id<Zone> zoneId) throws WsException {
        return this.getById(zoneId, Zone.class);
    }

    @Override
    public List<Zone> zoneGetListById(List<Id<Zone>> zoneIds) throws WsException {
        return this.getListById(zoneIds, Zone.class);
    }

    @Override
    public Job zoneAddServerPool(Id<Zone> zoneId, Id<ServerPool> serverPoolId) throws WsException {
        return this.addChildObject(zoneId, serverPoolId);
    }

    @Override
    public Job zoneRemoveServerPool(Id<Zone> zoneId, Id<ServerPool> serverPoolId) throws WsException {
        return this.removeChildObject(zoneId, serverPoolId);
    }

    @Override
    public Job zoneAddStorageArray(Id<Zone> zoneId, Id<StorageArray> storageArrayId) throws WsException {
        return this.addChildObject(zoneId, storageArrayId);
    }

    @Override
    public Job zoneRemoveStorageArray(Id<Zone> zoneId, Id<StorageArray> storageArrayId) throws WsException {
        return this.removeChildObject(zoneId, storageArrayId);
    }

    @Override
    public Job zoneAddFileServer(Id<Zone> zoneId, Id<FileServer> fileServerId) throws WsException {
        return this.addChildObject(zoneId, fileServerId);
    }

    @Override
    public Job zoneRemoveFileServer(Id<Zone> zoneId, Id<FileServer> fileServerId) throws WsException {
        return this.removeChildObject(zoneId, fileServerId);
    }

    @Override
    public Job zoneDelete(Id<Zone> zoneId) throws WsException {
        return this.delete(zoneId);
    }

    public <T extends BaseObject<T>> Job create(T newObject) throws WsException {
        try {
            WebResource.Builder b = this.getResourceForType(newObject.getClass());
            return (Job)((WebResource.Builder)b.type(this.getMediaType())).post(Job.class, this.createJAXBElement(newObject));
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public <O extends BaseObject<O>, P extends BaseObject<P>> Job createChildObject(Id<P> parentId, O newObject) throws WsException {
        return this.createChildObject(parentId, newObject, null);
    }

    public <O extends BaseObject<O>, P extends BaseObject<P>> Job createChildObject(Id<P> parentId, O newObject, Map<String, Object> queryParameters) throws WsException {
        try {
            WebResource.Builder b = this.getResourceForCreateChild(parentId, newObject.getClass(), queryParameters);
            return (Job)((WebResource.Builder)b.type(this.getMediaType())).post(Job.class, this.createJAXBElement(newObject));
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public Job delete(Id<?> id) throws WsException {
        return this.delete(id, null);
    }

    public Job delete(Id<?> id, Map<String, Object> queryParameters) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.getUri(id), queryParameters, new String[0]);
            return (Job)b.delete(Job.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public Job deleteChildObject(Id<?> parentId, Id<?> childId) throws WsException {
        try {
            WebResource.Builder b = this.getResourceForChild(parentId, childId);
            return (Job)b.delete(Job.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public Job setChildObject(Id<?> parent, Id<?> child, String argumentName) throws WsException {
        if (child == null) {
            throw new WsException(WsErrorCode.GENERAL_NULL_ARGUMENT, argumentName);
        }
        try {
            return this.action(parent, "set" + this.getSimpleName(child.getType()), child);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public Job addChildObject(Id<?> parent, Id<?> child) throws WsException {
        try {
            return this.action(parent, "add" + this.getSimpleName(child.getType()), child);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public Job removeChildObject(Id<?> parent, Id<?> child) throws WsException {
        try {
            return this.action(parent, "remove" + this.getSimpleName(child.getType()), child);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public <T extends BaseObject<T>> T getAssociatedObject(Id<?> parent, Class<T> childClass, String associationName) throws WsException {
        if (associationName == null) {
            associationName = childClass.getSimpleName();
        }
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getUri(parent), associationName);
            return (T)((BaseObject)b.get(childClass));
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public <T extends BaseObject<T>> Id<T> getAssociatedObjectId(Id<?> parent, Class<T> childClass, String associationName) throws WsException {
        if (associationName == null) {
            associationName = childClass.getSimpleName();
        }
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getUri(parent), associationName, "id");
            SimpleId simpleId = (SimpleId)b.get(SimpleId.class);
            return new Id(simpleId);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public <T extends BaseObject<T>> List<T> getAssociatedObjectList(Id<?> parent, Class<T> childClass, String associationName) throws WsException {
        if (associationName == null) {
            associationName = childClass.getSimpleName();
        }
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getUri(parent), associationName);
            return (List)b.get(this.getGenericListType(childClass));
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public <T extends BaseObject<T>> List<Id<T>> getAssociatedObjectIdList(Id<?> parent, Class<T> childClass, String associationName) throws WsException {
        if (associationName == null) {
            associationName = childClass.getSimpleName();
        }
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getUri(parent), associationName, "id");
            List simpleIdList = (List)b.get((GenericType)new GenericType<List<SimpleId>>(){});
            ArrayList<Id<T>> ids = new ArrayList<Id<T>>(simpleIdList.size());
            for (SimpleId simpleId : simpleIdList) {
                ids.add(new Id(simpleId));
            }
            return ids;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }
}

