/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Filters;

import Acme.JPM.Filters.Enlarge;
import Acme.JPM.Filters.ImageFilterPlus;
import Acme.JPM.Filters.RGBAllFilter;
import java.awt.image.ImageProducer;

public class Shrink
extends RGBAllFilter {
    private int divisor;

    public Shrink(ImageProducer producer, int divisor) {
        super(producer);
        this.divisor = divisor;
    }

    public void filterRGBAll(int width, int height, int[][] rgbPixels) {
        int divisor2 = this.divisor * this.divisor;
        int newWidth = Math.max(width / this.divisor, 1);
        int newHeight = Math.max(height / this.divisor, 1);
        int[][] newPixels = new int[newHeight][newWidth];
        int newRow = 0;
        while (newRow < newHeight) {
            int newCol = 0;
            while (newCol < newWidth) {
                int a = 0;
                int r = 0;
                int g = 0;
                int b = 0;
                int i = 0;
                while (i < this.divisor) {
                    int row = newRow * this.divisor + i;
                    if (row < height) {
                        int j = 0;
                        while (j < this.divisor) {
                            int col = newCol * this.divisor + j;
                            if (col < width) {
                                int rgb = rgbPixels[row][col];
                                a += rgb >> 24 & 0xFF;
                                r += rgb >> 16 & 0xFF;
                                g += rgb >> 8 & 0xFF;
                                b += rgb & 0xFF;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                newPixels[newRow][newCol] = (a /= divisor2) << 24 | (r /= divisor2) << 16 | (g /= divisor2) << 8 | (b /= divisor2);
                ++newCol;
            }
            ++newRow;
        }
        this.setPixels(newWidth, newHeight, newPixels);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            Shrink.usage();
        }
        Enlarge filter = new Enlarge(null, Integer.parseInt(args[0]));
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Shrink <divisor>");
        System.exit(1);
    }
}

