/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.AdminCatalogType;
import com.vmware.vcloud.api.rest.schema.AdminOrgType;
import com.vmware.vcloud.api.rest.schema.AdminVdcType;
import com.vmware.vcloud.api.rest.schema.CertificateUpdateParamsType;
import com.vmware.vcloud.api.rest.schema.CertificateUploadSocketType;
import com.vmware.vcloud.api.rest.schema.CreateVdcParamsType;
import com.vmware.vcloud.api.rest.schema.EventType;
import com.vmware.vcloud.api.rest.schema.GroupType;
import com.vmware.vcloud.api.rest.schema.KeystoreUpdateParamsType;
import com.vmware.vcloud.api.rest.schema.KeystoreUploadSocketType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.OrgAssociationType;
import com.vmware.vcloud.api.rest.schema.OrgAssociationsType;
import com.vmware.vcloud.api.rest.schema.OrgEmailSettingsType;
import com.vmware.vcloud.api.rest.schema.OrgFederationSettingsType;
import com.vmware.vcloud.api.rest.schema.OrgGeneralSettingsType;
import com.vmware.vcloud.api.rest.schema.OrgGuestPersonalizationSettingsType;
import com.vmware.vcloud.api.rest.schema.OrgLdapSettingsType;
import com.vmware.vcloud.api.rest.schema.OrgLeaseSettingsType;
import com.vmware.vcloud.api.rest.schema.OrgNetworkType;
import com.vmware.vcloud.api.rest.schema.OrgOAuthSettingsType;
import com.vmware.vcloud.api.rest.schema.OrgOperationLimitsSettingsType;
import com.vmware.vcloud.api.rest.schema.OrgPasswordPolicySettingsType;
import com.vmware.vcloud.api.rest.schema.OrgSettingsType;
import com.vmware.vcloud.api.rest.schema.OrgVAppTemplateLeaseSettingsType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.SelectorExtensionType;
import com.vmware.vcloud.api.rest.schema.SelectorExtensionsType;
import com.vmware.vcloud.api.rest.schema.SspiKeytabUpdateParamsType;
import com.vmware.vcloud.api.rest.schema.SspiKeytabUploadSocketType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.UserType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.admin.AdminCatalog;
import com.vmware.vcloud.sdk.admin.AdminOrgNetwork;
import com.vmware.vcloud.sdk.admin.AdminVdc;
import com.vmware.vcloud.sdk.admin.AdminsConstants;
import com.vmware.vcloud.sdk.admin.Group;
import com.vmware.vcloud.sdk.admin.User;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;

public class AdminOrganization
extends VcloudEntity<AdminOrgType> {
    private static final Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private HashMap<String, ReferenceType> userRefsByName;
    private Collection<ReferenceType> catalogRefs;
    private HashMap<String, ReferenceType> groupRefsByName;
    private HashMap<String, ReferenceType> adminVdcRefsByName;
    private HashMap<String, ReferenceType> orgNetworkRefsByName;
    private ReferenceType orgReference;
    private ReferenceType tasksListRef;
    private VcloudClient client;

    AdminOrganization(VcloudClient client, AdminOrgType adminOrgType_v1_5) {
        super(client, adminOrgType_v1_5);
        this.sortAdminOrgRefs_v1_5();
        this.client = client;
    }

    public static AdminOrganization getAdminOrgByReference(VcloudClient client, ReferenceType orgRef) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + orgRef.getHref());
        return new AdminOrganization(client, (AdminOrgType)AdminOrganization.getResourceByReference(client, orgRef));
    }

    public static AdminOrganization getAdminOrgById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new AdminOrganization(client, (AdminOrgType)AdminOrganization.getEntityById(client, vCloudId, "application/vnd.vmware.admin.organization+xml"));
    }

    public OrgSettingsType getOrgSettings() {
        return ((AdminOrgType)this.getResource()).getSettings();
    }

    public static OrgSettingsType getOrgSettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgSettingsUrl = adminOrgReference.getHref() + "/settings";
        return (OrgSettingsType)SdkUtil.get(client, adminOrgSettingsUrl, 200);
    }

    public OrgSettingsType updateOrgSettings(OrgSettingsType orgSettingsType) throws VCloudException {
        String adminOrgSettingsUpdateUrl = this.getReference().getHref() + "/settings";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createOrgSettings(orgSettingsType));
        return (OrgSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgSettingsUpdateUrl, adminOrgSettingsUpdateXml, "application/vnd.vmware.admin.orgSettings+xml", 200);
    }

    public AdminCatalog createCatalog(AdminCatalogType adminCatalogType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement catalogParams = of.createAdminCatalog(adminCatalogType);
        String requestBodyXml = JAXBUtil.marshal(catalogParams);
        String postURL = this.getReference().getHref() + "/catalogs";
        return new AdminCatalog(this.getVcloudClient(), (AdminCatalogType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.admin.catalog+xml", 201));
    }

    public User createUser(UserType userType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement userParams = of.createUser(userType);
        String requestBodyXml = JAXBUtil.marshal(userParams);
        String postURL = this.getReference().getHref() + "/users";
        return new User(this.getVcloudClient(), (UserType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.admin.user+xml", 201));
    }

    public Group importGroup(GroupType groupType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement groupParams = of.createGroup(groupType);
        String requestBodyXml = JAXBUtil.marshal(groupParams);
        String postURL = this.getReference().getHref() + "/groups";
        return new Group(this.getVcloudClient(), (GroupType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.admin.group+xml", 201));
    }

    public AdminVdc createAdminVdc(AdminVdcType adminVdcType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement adminVdcParams = of.createAdminVdc(adminVdcType);
        String requestBodyXml = JAXBUtil.marshal(adminVdcParams);
        String postURL = this.getReference().getHref() + "vdcs";
        return new AdminVdc(this.getVcloudClient(), (AdminVdcType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.admin.vdc+xml", 201));
    }

    public AdminVdc createAdminVdc(CreateVdcParamsType vdcParams) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement adminVdcParams = of.createCreateVdcParams(vdcParams);
        String requestBodyXml = JAXBUtil.marshal(adminVdcParams);
        String postURL = this.getReference().getHref() + "/vdcsparams";
        return new AdminVdc(this.getVcloudClient(), (AdminVdcType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.admin.createVdcParams+xml", 201));
    }

    public AdminOrgNetwork createOrgNetwork(OrgNetworkType orgNetworkType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement orgNetworkParams = of.createOrgNetwork(orgNetworkType);
        String requestBodyXml = JAXBUtil.marshal(orgNetworkParams);
        String postURL = this.getReference().getHref() + "/networks";
        return new AdminOrgNetwork(this.getVcloudClient(), (OrgNetworkType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.admin.orgNetwork+xml", 201));
    }

    public ReferenceType getOrgReference() throws VCloudException {
        if (this.orgReference != null) {
            return this.orgReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getTaskListReference() throws VCloudException {
        if (this.tasksListRef != null) {
            return this.tasksListRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    private void sortAdminOrgRefs_v1_5() {
        this.userRefsByName = new HashMap();
        this.groupRefsByName = new HashMap();
        this.catalogRefs = new ArrayList<ReferenceType>();
        this.adminVdcRefsByName = new HashMap();
        this.orgNetworkRefsByName = new HashMap();
        if (((AdminOrgType)this.getResource()).getUsers() != null) {
            for (ReferenceType userRef : ((AdminOrgType)this.getResource()).getUsers().getUserReference()) {
                this.userRefsByName.put(userRef.getName(), userRef);
            }
        }
        if (((AdminOrgType)this.getResource()).getGroups() != null) {
            for (ReferenceType groupRef : ((AdminOrgType)this.getResource()).getGroups().getGroupReference()) {
                this.groupRefsByName.put(groupRef.getName(), groupRef);
            }
        }
        if (((AdminOrgType)this.getResource()).getCatalogs() != null) {
            for (ReferenceType catalogRef : ((AdminOrgType)this.getResource()).getCatalogs().getCatalogReference()) {
                this.catalogRefs.add(catalogRef);
            }
        }
        if (((AdminOrgType)this.getResource()).getVdcs() != null) {
            for (ReferenceType vdcRef : ((AdminOrgType)this.getResource()).getVdcs().getVdc()) {
                this.adminVdcRefsByName.put(vdcRef.getName(), vdcRef);
            }
        }
        if (((AdminOrgType)this.getResource()).getNetworks() != null) {
            for (ReferenceType networkRef : ((AdminOrgType)this.getResource()).getNetworks().getNetwork()) {
                this.orgNetworkRefsByName.put(networkRef.getName(), networkRef);
            }
        }
        for (LinkType adminOrgLink : ((AdminOrgType)this.getResource()).getLink()) {
            if (adminOrgLink.getRel().equals("alternate") && adminOrgLink.getType().equals("application/vnd.vmware.vcloud.org+xml")) {
                this.orgReference = adminOrgLink;
            }
            if (!adminOrgLink.getRel().equals("down") || !adminOrgLink.getType().equals("application/vnd.vmware.vcloud.tasksList+xml")) continue;
            this.tasksListRef = adminOrgLink;
        }
    }

    public static OrgVAppTemplateLeaseSettingsType getvAppTemplateLeaseSettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgvAppTemplateLeaseSettingsUrl = adminOrgReference.getHref() + "/settings" + "/vAppTemplateLeaseSettings";
        return (OrgVAppTemplateLeaseSettingsType)SdkUtil.get(client, adminOrgvAppTemplateLeaseSettingsUrl, 200);
    }

    public OrgVAppTemplateLeaseSettingsType getvAppTemplateLeaseSettings() throws VCloudException {
        return ((AdminOrgType)this.getResource()).getSettings().getVAppTemplateLeaseSettings();
    }

    public OrgVAppTemplateLeaseSettingsType updatevAppTemplateLeaseSettings(OrgVAppTemplateLeaseSettingsType orgVAppTemplateLeaseSettingsType) throws VCloudException {
        String adminOrgvAppTemplateLeaseSettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/vAppTemplateLeaseSettings";
        ObjectFactory objectFactory101 = new ObjectFactory();
        String adminOrgvAppTemplateLeaseSettingsUpdateXml = JAXBUtil.marshal(objectFactory101.createOrgVAppTemplateLeaseSettings(orgVAppTemplateLeaseSettingsType));
        return (OrgVAppTemplateLeaseSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgvAppTemplateLeaseSettingsUpdateUrl, adminOrgvAppTemplateLeaseSettingsUpdateXml, "application/vnd.vmware.admin.vAppTemplateLeaseSettings+xml", 200);
    }

    public static OrgLeaseSettingsType getvAppLeaseSettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgvAppLeaseSettingsUrl = adminOrgReference.getHref() + "/settings" + "/vAppLeaseSettings";
        return (OrgLeaseSettingsType)SdkUtil.get(client, adminOrgvAppLeaseSettingsUrl, 200);
    }

    public OrgLeaseSettingsType getvAppLeaseSettings() throws VCloudException {
        return ((AdminOrgType)this.getResource()).getSettings().getVAppLeaseSettings();
    }

    public OrgLeaseSettingsType updatevAppLeaseSettings(OrgLeaseSettingsType orgVAppLeaseSettingsType) throws VCloudException {
        String adminOrgvAppLeaseSettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/vAppLeaseSettings";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgvAppLeaseSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createVAppLeaseSettings(orgVAppLeaseSettingsType));
        return (OrgLeaseSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgvAppLeaseSettingsUpdateUrl, adminOrgvAppLeaseSettingsUpdateXml, "application/vnd.vmware.admin.vAppLeaseSettings+xml", 200);
    }

    public static OrgFederationSettingsType getFederationSettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgEmailSettingsUrl = adminOrgReference.getHref() + "/settings" + "/federation";
        return (OrgFederationSettingsType)SdkUtil.get(client, adminOrgEmailSettingsUrl, 200);
    }

    public OrgFederationSettingsType getFederationSettings() {
        return ((AdminOrgType)this.getResource()).getSettings().getOrgFederationSettings();
    }

    public OrgFederationSettingsType updateFederationSettings(OrgFederationSettingsType orgFederationSettingsType) throws VCloudException {
        String adminOrgFederationSettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/federation";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgFederationSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createOrgFederationSettings(orgFederationSettingsType));
        return (OrgFederationSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgFederationSettingsUpdateUrl, adminOrgFederationSettingsUpdateXml, "application/vnd.vmware.admin.organizationFederationSettings+xml", 200);
    }

    public static OrgEmailSettingsType getEmailSettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgEmailSettingsUrl = adminOrgReference.getHref() + "/settings" + "/email";
        return (OrgEmailSettingsType)SdkUtil.get(client, adminOrgEmailSettingsUrl, 200);
    }

    public OrgEmailSettingsType getEmailSettings() {
        return ((AdminOrgType)this.getResource()).getSettings().getOrgEmailSettings();
    }

    public OrgEmailSettingsType updateEmailSettings(OrgEmailSettingsType orgEmailSettingsType) throws VCloudException {
        String adminOrgEmailSettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/email";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgEmailSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createOrgEmailSettings(orgEmailSettingsType));
        return (OrgEmailSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgEmailSettingsUpdateUrl, adminOrgEmailSettingsUpdateXml, "application/vnd.vmware.admin.organizationEmailSettings+xml", 200);
    }

    public static OrgGeneralSettingsType getGeneralSettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgGeneralSettingsUrl = adminOrgReference.getHref() + "/settings" + "/general";
        return (OrgGeneralSettingsType)SdkUtil.get(client, adminOrgGeneralSettingsUrl, 200);
    }

    public OrgGeneralSettingsType getGeneralSettings() {
        return ((AdminOrgType)this.getResource()).getSettings().getOrgGeneralSettings();
    }

    public OrgGeneralSettingsType updateGeneralSettings(OrgGeneralSettingsType orgGeneralSettingsType) throws VCloudException {
        String adminOrgGeneralSettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/general";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgGeneralSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createGeneralOrgSettings(orgGeneralSettingsType));
        return (OrgGeneralSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgGeneralSettingsUpdateUrl, adminOrgGeneralSettingsUpdateXml, "application/vnd.vmware.admin.organizationGeneralSettings+xml", 200);
    }

    public static OrgPasswordPolicySettingsType getPasswordPolicySettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgPasswordPolicySettingsUrl = adminOrgReference.getHref() + "/settings" + "/passwordPolicy";
        return (OrgPasswordPolicySettingsType)SdkUtil.get(client, adminOrgPasswordPolicySettingsUrl, 200);
    }

    public OrgPasswordPolicySettingsType getPasswordPolicySettings() {
        return ((AdminOrgType)this.getResource()).getSettings().getOrgPasswordPolicySettings();
    }

    public OrgPasswordPolicySettingsType updatePasswordPolicySettings(OrgPasswordPolicySettingsType orgPasswordPolicySettingsType) throws VCloudException {
        String adminOrgPasswordPolicySettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/passwordPolicy";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgPasswordPolicySettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createOrgPasswordPolicySettings(orgPasswordPolicySettingsType));
        return (OrgPasswordPolicySettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgPasswordPolicySettingsUpdateUrl, adminOrgPasswordPolicySettingsUpdateXml, "application/vnd.vmware.admin.organizationPasswordPolicySettings+xml", 200);
    }

    public AdminOrganization updateAdminOrg(AdminOrgType adminOrgType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String adminOrgUpdateUrl = this.getReference().getHref();
        String adminOrgUpdateRequestXmlString = JAXBUtil.marshal(of.createAdminOrg(adminOrgType));
        return new AdminOrganization(this.getVcloudClient(), (AdminOrgType)SdkUtil.put(this.getVcloudClient(), adminOrgUpdateUrl, adminOrgUpdateRequestXmlString, "application/vnd.vmware.admin.organization+xml", 200));
    }

    public void delete() throws VCloudException, TimeoutException {
        String ver = this.getVcloudClient().getVcloudClientVersion().value();
        System.out.println(ver);
        String adminOrgUrl = this.getReference().getHref();
        if (Double.parseDouble(ver) <= AdminsConstants.VERSION_5_6) {
            AdminOrganization.deleteAdminOrg(this.getVcloudClient(), adminOrgUrl);
        } else {
            this.deleteAdminOrg(false, false).waitForTask(0L);
        }
    }

    public Task deleteAdminOrg(boolean force, boolean recrusive) throws VCloudException {
        String adminOrgUrl = this.getReference().getHref() + "?" + "force=" + force + "&" + "recursive=" + recrusive;
        return AdminOrganization.deleteAdminOrganization(this.getVcloudClient(), adminOrgUrl);
    }

    public static void delete(VcloudClient client, ReferenceType adminOrgRef) throws VCloudException {
        AdminOrganization.deleteAdminOrg(client, adminOrgRef.getHref());
    }

    private static void deleteAdminOrg(VcloudClient client, String adminOrgUrl) throws VCloudException {
        SdkUtil.delete(client, adminOrgUrl, 204);
    }

    private static Task deleteAdminOrganization(VcloudClient client, String adminOrgUrl) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, adminOrgUrl, 202));
    }

    public void enable() throws VCloudException {
        String enableURL = this.getReference().getHref() + "/action/enable";
        AdminOrganization.executeOrgAction(this.getVcloudClient(), enableURL, null, null, 204);
    }

    public static void enable(VcloudClient client, ReferenceType orgRef) throws VCloudException {
        String enableURL = orgRef.getHref() + "/action/enable";
        AdminOrganization.executeOrgAction(client, enableURL, null, null, 204);
    }

    public void disable() throws VCloudException {
        String disableUrl = this.getReference().getHref() + "/action/disable";
        AdminOrganization.executeOrgAction(this.getVcloudClient(), disableUrl, null, null, 204);
    }

    public static void disable(VcloudClient client, ReferenceType adminOrgRef) throws VCloudException {
        String enableURL = adminOrgRef.getHref() + "/action/disable";
        AdminOrganization.executeOrgAction(client, enableURL, null, null, 204);
    }

    private static void executeOrgAction(VcloudClient client, String orgActionUrl, String content, String contentType, int statusCode) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + orgActionUrl);
        SdkUtil.post(client, orgActionUrl, content, contentType, statusCode);
    }

    public HashMap<String, ReferenceType> getUserRefsByName() {
        return this.userRefsByName;
    }

    public Collection<ReferenceType> getUserRefs() {
        return this.userRefsByName.values();
    }

    public ReferenceType getUserRefByName(String name) {
        return this.userRefsByName.get(name);
    }

    public HashMap<String, ReferenceType> getGroupRefsByName() {
        return this.groupRefsByName;
    }

    public Collection<ReferenceType> getGroupRefs() {
        return this.groupRefsByName.values();
    }

    public ReferenceType getGroupRefByName(String name) {
        return this.groupRefsByName.get(name);
    }

    public Collection<ReferenceType> getCatalogRefs() {
        return this.catalogRefs;
    }

    public HashMap<String, ReferenceType> getAdminVdcRefsByName() {
        return this.adminVdcRefsByName;
    }

    public Collection<ReferenceType> getAdminVdcRefs() {
        return this.adminVdcRefsByName.values();
    }

    public ReferenceType getAdminVdcRefByName(String name) {
        return this.adminVdcRefsByName.get(name);
    }

    public HashMap<String, ReferenceType> getAdminOrgNetworkRefsByName() {
        return this.orgNetworkRefsByName;
    }

    public Collection<ReferenceType> getAdminOrgNetworkRefs() {
        return this.orgNetworkRefsByName.values();
    }

    public ReferenceType getAdminOrgNetworkRefByName(String name) {
        return this.orgNetworkRefsByName.get(name);
    }

    public void createEvent(EventType eventType) throws VCloudException {
        String createEventUrl = this.getReference().getHref() + "/events";
        String adminOrgSettingsUpdateXml = JAXBUtil.marshal(new ObjectFactory().createEvent(eventType));
        SdkUtil.post(this.getVcloudClient(), createEventUrl, adminOrgSettingsUpdateXml, "application/vnd.vmware.admin.event+xml", 204);
    }

    public OrgGuestPersonalizationSettingsType getGuestPersonalizationSettings() throws VCloudException {
        String adminOrgSettingsUrl = this.getReference().getHref() + "/settings" + "/guestPersonalizationSettings";
        return (OrgGuestPersonalizationSettingsType)SdkUtil.get(this.getVcloudClient(), adminOrgSettingsUrl, 200);
    }

    public OrgOperationLimitsSettingsType getOperationLimitsSettings() throws VCloudException {
        String adminOrgSettingsUrl = this.getReference().getHref() + "/settings" + "/operationLimitsSettings";
        return (OrgOperationLimitsSettingsType)SdkUtil.get(this.getVcloudClient(), adminOrgSettingsUrl, 200);
    }

    public OrgGuestPersonalizationSettingsType updateGuestPersonalizationSettings(OrgGuestPersonalizationSettingsType orgGuestPersonalizationSettingsType) throws VCloudException {
        String adminOrgSettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/guestPersonalizationSettings";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createOrgGuestPersonalizationSettings(orgGuestPersonalizationSettingsType));
        return (OrgGuestPersonalizationSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgSettingsUpdateUrl, adminOrgSettingsUpdateXml, "application/vnd.vmware.admin.guestPersonalizationSettings+xml", 200);
    }

    public OrgOperationLimitsSettingsType updateOperationLimitsSettings(OrgOperationLimitsSettingsType operationLimitsSettingsType) throws VCloudException {
        String adminOrgSettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/operationLimitsSettings";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createOrgOperationLimitsSettings(operationLimitsSettingsType));
        return (OrgOperationLimitsSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgSettingsUpdateUrl, adminOrgSettingsUpdateXml, "application/vnd.vmware.admin.operationLimitsSettings+xml", 200);
    }

    public OrgLdapSettingsType getLdapSettings() throws VCloudException {
        return ((AdminOrgType)this.getResource()).getSettings().getOrgLdapSettings();
    }

    public static OrgLdapSettingsType getLdapSettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgLdapSettingsUrl = adminOrgReference.getHref() + "/settings" + "/ldap";
        return (OrgLdapSettingsType)SdkUtil.get(client, adminOrgLdapSettingsUrl, 200);
    }

    public OrgLdapSettingsType UpdateLdapSettings(OrgLdapSettingsType orgLdapSettingsType) throws VCloudException {
        String adminOrgLdapSettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/ldap";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgLdapSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createOrgLdapSettings(orgLdapSettingsType));
        return (OrgLdapSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgLdapSettingsUpdateUrl, adminOrgLdapSettingsUpdateXml, "application/vnd.vmware.admin.organizationLdapSettings+xml", 200);
    }

    public void resetLdapCertificate() throws VCloudException {
        String resetLdapCertificateUrl = this.getReference().getHref() + "/settings" + "/ldap" + "/action/resetLdapCertificate";
        SdkUtil.post(this.getVcloudClient(), resetLdapCertificateUrl, null, null, 204);
    }

    public void resetLdapKeyStore() throws VCloudException {
        String resetLdapKeyStore = this.getReference().getHref() + "/settings" + "/ldap" + "/action/resetLdapKeyStore";
        SdkUtil.post(this.getVcloudClient(), resetLdapKeyStore, null, null, 204);
    }

    public void resetLdapSspiKeytab() throws VCloudException {
        String resetLdapSspiKeytabUrl = this.getReference().getHref() + "/settings" + "/ldap" + "/action/resetLdapSspiKeytab";
        SdkUtil.post(this.getVcloudClient(), resetLdapSspiKeytabUrl, null, null, 204);
    }

    public CertificateUploadSocketType updateLdapCertificate(CertificateUpdateParamsType certificateUpdateParamsType) throws VCloudException {
        String adminOrgLdapCertificate = this.getReference().getHref() + "/settings" + "/ldap" + "/action/updateLdapCertificate";
        ObjectFactory objectFactory_v5_1 = new ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory_v5_1.createCertificateUpdateParams(certificateUpdateParamsType));
        return (CertificateUploadSocketType)SdkUtil.post(this.getVcloudClient(), adminOrgLdapCertificate, requestBodyXml, "application/vnd.vmware.admin.certificateUpdateParams+xml", 200);
    }

    public KeystoreUploadSocketType updateLdapKeyStore(KeystoreUpdateParamsType keystoreUpdateParamsType) throws VCloudException {
        String adminOrgLdapKeyStore = this.getReference().getHref() + "/settings" + "/ldap" + "/action/updateLdapKeyStore";
        ObjectFactory objectFactory_v5_1 = new ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory_v5_1.createKeystoreUpdateParams(keystoreUpdateParamsType));
        return (KeystoreUploadSocketType)SdkUtil.post(this.getVcloudClient(), adminOrgLdapKeyStore, requestBodyXml, "application/vnd.vmware.admin.keystoreUpdateParams+xml", 200);
    }

    public SspiKeytabUploadSocketType updateLdapSspiKeytab(SspiKeytabUpdateParamsType sspiKeytabUpdateParamsType) throws VCloudException {
        String adminOrgLdapSspiKeytab = this.getReference().getHref() + "/settings" + "/ldap" + "/action/updateLdapSspiKeytab";
        ObjectFactory objectFactory_v5_1 = new ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory_v5_1.createSspiKeytabUpdateParams(sspiKeytabUpdateParamsType));
        return (SspiKeytabUploadSocketType)SdkUtil.post(this.getVcloudClient(), adminOrgLdapSspiKeytab, requestBodyXml, "application/vnd.vmware.admin.sspiKeytabUpdateParams+xml", 200);
    }

    public static void regenerateFederationCertificate(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String regenerateFederationCertificateUrl = adminOrgReference.getHref() + "/settings" + "/federation" + "/action/regenerateFederationCertificate";
        SdkUtil.post(client, regenerateFederationCertificateUrl, null, null, 204);
    }

    public void regenerateFederationCertificate() throws VCloudException {
        String regenerateFederationCertificateUrl = ((AdminOrgType)this.getResource()).getHref() + "/settings" + "/federation" + "/action/regenerateFederationCertificate";
        SdkUtil.post(this.getVcloudClient(), regenerateFederationCertificateUrl, null, null, 204);
    }

    public Task createOrgAssociation(OrgAssociationType orgAssociation) throws VCloudException {
        String createAssociationUrl = this.getReference().getHref() + "/associations";
        ObjectFactory objectFactory = new ObjectFactory();
        String adminOrgAssociationXml = JAXBUtil.marshal(objectFactory.createOrgAssociationMember(orgAssociation));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), createAssociationUrl, adminOrgAssociationXml, "application/vnd.vmware.admin.organizationAssociation+xml", 200));
    }

    public OrgAssociationsType getOrgAssociations() {
        return ((AdminOrgType)this.getResource()).getOrgAssociations();
    }

    public static OrgAssociationsType getOrgAssociations(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgAssociationsUrl = adminOrgReference.getHref() + "/associations";
        return (OrgAssociationsType)SdkUtil.get(client, adminOrgAssociationsUrl, 200);
    }

    public Task updateOrgAssociations(OrgAssociationsType orgAssociations) throws VCloudException {
        String adminOrgAssociationsUpdateUrl = this.getReference().getHref() + "/associations";
        ObjectFactory objectFactory = new ObjectFactory();
        String adminOrgAssociationsUpdateXml = JAXBUtil.marshal(objectFactory.createOrgAssociations(orgAssociations));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), adminOrgAssociationsUpdateUrl, adminOrgAssociationsUpdateXml, "application/vnd.vmware.admin.organizationAssociations+xml", 200));
    }

    public OrgAssociationType getOrgAssociationByName(String memberName) throws VCloudException {
        OrgAssociationType orgAssociationFound = null;
        for (OrgAssociationType orgAssociation : ((AdminOrgType)this.getResource()).getOrgAssociations().getOrgAssociationMember()) {
            if (!memberName.equals(orgAssociation.getMemberName())) continue;
            orgAssociationFound = orgAssociation;
        }
        if (orgAssociationFound == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return orgAssociationFound;
    }

    public Task deleteOrgAssociationByName(String memberName) throws VCloudException {
        OrgAssociationType orgAssociationFound = null;
        for (OrgAssociationType orgAssociation : ((AdminOrgType)this.getResource()).getOrgAssociations().getOrgAssociationMember()) {
            if (!memberName.equals(orgAssociation.getMemberName())) continue;
            orgAssociationFound = orgAssociation;
        }
        String url = orgAssociationFound.getHref();
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.delete(this.getVcloudClient(), url, 200));
    }

    public static OrgOAuthSettingsType getOrgOAuthSettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgOauthSettingsUrl = adminOrgReference.getHref() + "/settings" + "/oauth";
        return (OrgOAuthSettingsType)SdkUtil.get(client, adminOrgOauthSettingsUrl, 200);
    }

    public OrgOAuthSettingsType updateOrgOauthSettings(OrgOAuthSettingsType orgOAuthSettings) throws VCloudException {
        String adminOrgSettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/oauth";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createOrgOAuthSettings(orgOAuthSettings));
        return (OrgOAuthSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgSettingsUpdateUrl, adminOrgSettingsUpdateXml, "application/vnd.vmware.admin.organizationOAuthSettings+xml", 200);
    }

    public SelectorExtensionType createOrgSelectorExtension(SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = ((AdminOrgType)this.getResource()).getHref() + "/extension";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.post(this.getVcloudClient(), url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 201);
    }

    public List<SelectorExtensionType> getOrgSelectorExtension() throws VCloudException {
        String url = ((AdminOrgType)this.getResource()).getHref() + "/extension";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        SelectorExtensionsType objectExtension = (SelectorExtensionsType)SdkUtil.get(this.getVcloudClient(), url, 200);
        return objectExtension.getSelectorExtension();
    }

    public SelectorExtensionType getOrgSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = ((AdminOrgType)this.getResource()).getHref() + "/extension" + "/" + selectorExtensionId;
        return (SelectorExtensionType)SdkUtil.get(this.getVcloudClient(), url, 200);
    }

    public SelectorExtensionType updateOrgSelectorExtensionById(String selectorExtensionId, SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = ((AdminOrgType)this.getResource()).getHref() + "/extension" + "/" + selectorExtensionId;
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.put(this.getVcloudClient(), url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 200);
    }

    public void deleteOrgSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = ((AdminOrgType)this.getResource()).getHref() + "/extension" + "/" + selectorExtensionId;
        SdkUtil.delete(this.getVcloudClient(), url, 204);
    }
}

