/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.VAppNetworkType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VappNetwork
extends VcloudEntity<VAppNetworkType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType vappReference;
    private ReferenceType vappNetworkRepairReference;

    VappNetwork(VcloudClient client, VAppNetworkType vappNetworkType) {
        super(client, vappNetworkType);
        this.sortReferences_v1_5();
    }

    public static VappNetwork getVappNetworkByReference(VcloudClient client, ReferenceType vappNetworkRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + vappNetworkRef.getHref());
        return new VappNetwork(client, (VAppNetworkType)VappNetwork.getResourceByReference(client, vappNetworkRef));
    }

    public static VappNetwork getVappNetworkById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new VappNetwork(client, (VAppNetworkType)VappNetwork.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.network+xml"));
    }

    private void sortReferences_v1_5() {
        for (LinkType vappNetworkLink : ((VAppNetworkType)this.getResource()).getLink()) {
            if (vappNetworkLink.getRel().equals("up") && vappNetworkLink.getType().equals("application/vnd.vmware.vcloud.vApp+xml")) {
                this.vappReference = vappNetworkLink;
                continue;
            }
            if (!vappNetworkLink.getRel().equals("repair")) continue;
            this.vappNetworkRepairReference = vappNetworkLink;
        }
    }

    public Task reset() throws VCloudException {
        if (this.vappNetworkRepairReference != null) {
            return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.vappNetworkRepairReference.getHref(), null, null, 202));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VAPP_NETWORK_NOT_DEPLOYED));
    }

    public ReferenceType getVappReference() throws VCloudException {
        if (this.vappReference != null) {
            return this.vappReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

