/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.AbstractVAppType;
import com.vmware.vcloud.api.rest.schema.ComplianceResultType;
import com.vmware.vcloud.api.rest.schema.CurrentUsageSpecType;
import com.vmware.vcloud.api.rest.schema.CurrentUsageType;
import com.vmware.vcloud.api.rest.schema.DiskAttachOrDetachParamsType;
import com.vmware.vcloud.api.rest.schema.GuestCustomizationSectionType;
import com.vmware.vcloud.api.rest.schema.HistoricUsageSpecType;
import com.vmware.vcloud.api.rest.schema.HistoricUsageType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.MediaInsertOrEjectParamsType;
import com.vmware.vcloud.api.rest.schema.MksTicketType;
import com.vmware.vcloud.api.rest.schema.NetworkConnectionSectionType;
import com.vmware.vcloud.api.rest.schema.NetworkConnectionType;
import com.vmware.vcloud.api.rest.schema.RasdItemsListType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.RelocateParamsType;
import com.vmware.vcloud.api.rest.schema.RuntimeInfoSectionType;
import com.vmware.vcloud.api.rest.schema.ScreenTicketType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.VCloudExtensionType;
import com.vmware.vcloud.api.rest.schema.VmCapabilitiesType;
import com.vmware.vcloud.api.rest.schema.VmPendingQuestionType;
import com.vmware.vcloud.api.rest.schema.VmQuestionAnswerType;
import com.vmware.vcloud.api.rest.schema.VmType;
import com.vmware.vcloud.api.rest.schema.extension.VimObjectRefType;
import com.vmware.vcloud.api.rest.schema.extension.VmVimInfoType;
import com.vmware.vcloud.api.rest.schema.ovf.CimString;
import com.vmware.vcloud.api.rest.schema.ovf.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ovf.OperatingSystemSectionType;
import com.vmware.vcloud.api.rest.schema.ovf.RASDType;
import com.vmware.vcloud.api.rest.schema.ovf.ResourceType;
import com.vmware.vcloud.api.rest.schema.ovf.SectionType;
import com.vmware.vcloud.api.rest.schema.ovf.VirtualHardwareSectionType;
import com.vmware.vcloud.api.rest.schema.ovf.environment.PlatformSectionType;
import com.vmware.vcloud.api.rest.schema.ovf.environment.PropertySectionType;
import com.vmware.vcloud.sdk.AbstractVapp;
import com.vmware.vcloud.sdk.HardwareItem;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.RestUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.SerialPort;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VirtualCpu;
import com.vmware.vcloud.sdk.VirtualDisk;
import com.vmware.vcloud.sdk.VirtualMedia;
import com.vmware.vcloud.sdk.VirtualMemory;
import com.vmware.vcloud.sdk.VirtualNetworkCard;
import com.vmware.vcloud.sdk.constants.IpAddressAllocationModeType;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.VMStatus;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VM
extends AbstractVapp<VmType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private VirtualHardwareSectionType virtualHardwareSection;
    private OperatingSystemSectionType operatingSystemSection;
    private NetworkConnectionSectionType networkConnectionSection;
    private GuestCustomizationSectionType guestCustomizationSection;
    private RuntimeInfoSectionType runtimeInfoSection;
    private VirtualCpu virtualCpu;
    private VirtualMemory virtualMemory;
    private List<VirtualDisk> virtualDisks;
    private List<VirtualNetworkCard> networkCards;
    private List<VirtualMedia> medias;
    private ReferenceType parentVappReference;
    private VmVimInfoType vmVimInfoType;

    VM(VcloudClient client, VmType vmType) {
        super(client, (AbstractVAppType)vmType);
        this.sortOvfSectionsAndReferences_v1_5();
    }

    public static VM getVMByReference(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + vmRef.getHref());
        VmType vmType = (VmType)VM.getResourceByReference(client, vmRef);
        return new VM(client, vmType);
    }

    public static VM getVMById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        VmType vmType = (VmType)VM.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.vm+xml");
        return new VM(client, vmType);
    }

    public VMStatus getVMStatus() {
        return VMStatus.fromValue(((VmType)this.getResource()).getStatus());
    }

    public Task updateVM(VmType vmType) throws VCloudException {
        com.vmware.vcloud.api.rest.schema.ObjectFactory of = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String vmUpdateUrl = this.getReference().getHref();
        String vmRequestXmlString = JAXBUtil.marshal(of.createVm(vmType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + vmUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), vmUpdateUrl, vmRequestXmlString, "application/vnd.vmware.vcloud.vm+xml", 202));
    }

    public GuestCustomizationSectionType getGuestCustomizationSection() throws VCloudException {
        if (this.guestCustomizationSection == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return this.guestCustomizationSection;
    }

    public static GuestCustomizationSectionType getGuestCustomizationSection(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return (GuestCustomizationSectionType)SdkUtil.get(client, vmRef.getHref() + "/guestCustomizationSection/", 200);
    }

    public VirtualHardwareSectionType getVirtualHardwareSection() throws VCloudException {
        if (this.virtualHardwareSection == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return this.virtualHardwareSection;
    }

    public static VirtualHardwareSectionType getVirtualHardwareSection(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return (VirtualHardwareSectionType)SdkUtil.get(client, vmRef.getHref() + "/virtualHardwareSection/", 200);
    }

    public OperatingSystemSectionType getOperatingSystemSection() throws VCloudException {
        if (this.operatingSystemSection == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return this.operatingSystemSection;
    }

    public static OperatingSystemSectionType getOperatingSystemSection(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return (OperatingSystemSectionType)SdkUtil.get(client, vmRef.getHref() + "/operatingSystemSection/", 200);
    }

    public RuntimeInfoSectionType getRuntimeInfoSection() throws VCloudException {
        if (this.runtimeInfoSection == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return this.runtimeInfoSection;
    }

    public static RuntimeInfoSectionType getRuntimeInfoSection(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return (RuntimeInfoSectionType)SdkUtil.get(client, vmRef.getHref() + "/runtimeInfoSection/", 200);
    }

    public Task updateSection(SectionType sectionType) throws VCloudException {
        ObjectFactory ovfObjectFactory = new ObjectFactory();
        com.vmware.vcloud.api.rest.schema.ObjectFactory vCloudObjectFactory_v1_5 = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String sectionUrl = this.getReference().getHref();
        String sectionContentType = null;
        String sectionRequestString = null;
        if (sectionType instanceof VirtualHardwareSectionType) {
            JAXBElement section = ovfObjectFactory.createVirtualHardwareSection((VirtualHardwareSectionType)sectionType);
            sectionRequestString = JAXBUtil.marshal(section);
            sectionUrl = sectionUrl + "/virtualHardwareSection/";
            sectionContentType = "application/vnd.vmware.vcloud.virtualHardwareSection+xml";
        } else if (sectionType instanceof OperatingSystemSectionType) {
            JAXBElement section = ovfObjectFactory.createOperatingSystemSection((OperatingSystemSectionType)sectionType);
            sectionRequestString = JAXBUtil.marshal(section);
            sectionUrl = sectionUrl + "/operatingSystemSection/";
            sectionContentType = "application/vnd.vmware.vcloud.operatingSystemSection+xml";
        } else if (sectionType instanceof GuestCustomizationSectionType) {
            JAXBElement section = vCloudObjectFactory_v1_5.createGuestCustomizationSection((GuestCustomizationSectionType)sectionType);
            sectionRequestString = JAXBUtil.marshal(section);
            sectionUrl = sectionUrl + "/guestCustomizationSection/";
            sectionContentType = "application/vnd.vmware.vcloud.guestCustomizationSection+xml";
        } else if (sectionType instanceof NetworkConnectionSectionType) {
            JAXBElement section = vCloudObjectFactory_v1_5.createNetworkConnectionSection((NetworkConnectionSectionType)sectionType);
            sectionRequestString = JAXBUtil.marshal(section);
            sectionUrl = sectionUrl + "/networkConnectionSection/";
            sectionContentType = "application/vnd.vmware.vcloud.networkConnectionSection+xml";
        } else {
            logger.info(sectionType.getClass().getName() + " - " + SdkUtil.getI18nString(SdkMessage.NOT_VALID_SECTION_MSG));
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NOT_VALID_SECTION_MSG));
        }
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), sectionUrl, sectionRequestString, sectionContentType, 202));
    }

    public Task insertMedia(MediaInsertOrEjectParamsType mediaInsertOrEjectParamsType) throws VCloudException {
        String url = this.getReference().getHref() + "/media/action/insertMedia";
        com.vmware.vcloud.api.rest.schema.ObjectFactory vcloudObjectFactory = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String requestString = JAXBUtil.marshal(vcloudObjectFactory.createMediaInsertOrEjectParams(mediaInsertOrEjectParamsType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), url, requestString, "application/vnd.vmware.vcloud.mediaInsertOrEjectParams+xml", 202));
    }

    public Task ejectMedia(MediaInsertOrEjectParamsType mediaInsertOrEjectParamsType) throws VCloudException {
        String url = this.getReference().getHref() + "/media/action/ejectMedia";
        com.vmware.vcloud.api.rest.schema.ObjectFactory vcloudObjectFactory = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String requestString = JAXBUtil.marshal(vcloudObjectFactory.createMediaInsertOrEjectParams(mediaInsertOrEjectParamsType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), url, requestString, "application/vnd.vmware.vcloud.mediaInsertOrEjectParams+xml", 202));
    }

    public BigInteger getVmSize() throws VCloudException {
        BigInteger size = BigInteger.ZERO;
        for (VirtualDisk disk : this.getDisks()) {
            BigInteger diskSize;
            String rasdItemType = disk.getItemResource().getResourceType().getValue();
            if (!"17".equals(rasdItemType) || (diskSize = disk.getHardDiskSize()) == null) continue;
            size = size.add(diskSize);
        }
        return size;
    }

    public VirtualCpu getCpu() throws VCloudException {
        List items;
        if (this.virtualCpu == null && this.virtualHardwareSection != null && (items = this.virtualHardwareSection.getItem()) != null) {
            for (RASDType item : items) {
                if (!item.getResourceType().getValue().equals("3")) continue;
                this.virtualCpu = new VirtualCpu(item);
            }
        }
        if (this.virtualCpu != null) {
            return this.virtualCpu;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_VIRTUAL_CPU_MSG));
    }

    public static VirtualCpu getCpu(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        String url = vmRef.getHref() + "/virtualHardwareSection/cpu";
        VirtualCpu virtualCpu = VM.getCpuByUrl(client, url);
        return virtualCpu;
    }

    private static VirtualCpu getCpuByUrl(VcloudClient client, String url) throws VCloudException {
        return new VirtualCpu((RASDType)SdkUtil.get(client, url, 200));
    }

    public Task updateCpu(VirtualCpu virtualCpuItem) throws VCloudException {
        String virtualCpuUpdateUrl = this.getReference().getHref() + "/virtualHardwareSection/cpu";
        String virtulCpuRequestXmlString = null;
        com.vmware.vcloud.api.rest.schema.ObjectFactory of = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        virtulCpuRequestXmlString = JAXBUtil.marshal(of.createItem(virtualCpuItem.getItemResource()));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + virtualCpuUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), virtualCpuUpdateUrl, virtulCpuRequestXmlString, "application/vnd.vmware.vcloud.rasdItem+xml", 202));
    }

    public VirtualMemory getMemory() throws VCloudException {
        List items;
        if (this.virtualMemory == null && this.virtualHardwareSection != null && (items = this.virtualHardwareSection.getItem()) != null) {
            for (RASDType item : items) {
                if (!item.getResourceType().getValue().equals("4")) continue;
                this.virtualMemory = new VirtualMemory(item);
            }
        }
        if (this.virtualMemory != null) {
            return this.virtualMemory;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_VIRTUAL_MEMORY_MSG));
    }

    public static VirtualMemory getMemory(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        String url = vmRef.getHref() + "/virtualHardwareSection/memory";
        VirtualMemory virtualMemory = VM.getMemoryByUrl(client, url);
        return virtualMemory;
    }

    private static VirtualMemory getMemoryByUrl(VcloudClient client, String url) throws VCloudException {
        return new VirtualMemory((RASDType)SdkUtil.get(client, url, 200));
    }

    public Task updateMemory(VirtualMemory virtualMemoryItem) throws VCloudException {
        String virtualMemoryUpdateUrl = this.getReference().getHref() + "/virtualHardwareSection/memory";
        String virtulMemoryRequestXmlString = null;
        com.vmware.vcloud.api.rest.schema.ObjectFactory of = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        virtulMemoryRequestXmlString = JAXBUtil.marshal(of.createItem(virtualMemoryItem.getItemResource()));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + virtualMemoryUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), virtualMemoryUpdateUrl, virtulMemoryRequestXmlString, "application/vnd.vmware.vcloud.rasdItem+xml", 202));
    }

    public List<SerialPort> getSerialPorts() throws VCloudException {
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NOT_SUPPORTED_API));
    }

    public static List<SerialPort> getSerialPorts(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NOT_SUPPORTED_API));
    }

    public Task updateSerialPorts(List<SerialPort> serialPorts) throws VCloudException {
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NOT_SUPPORTED_API));
    }

    public List<VirtualDisk> getDisks() throws VCloudException {
        if (this.virtualDisks == null) {
            List items;
            this.virtualDisks = new ArrayList<VirtualDisk>();
            if (this.virtualHardwareSection != null && (items = this.virtualHardwareSection.getItem()) != null) {
                for (RASDType item : items) {
                    if (!item.getResourceType().getValue().equals("17") && !item.getResourceType().getValue().equals("6") && !item.getResourceType().getValue().equals("5")) continue;
                    this.virtualDisks.add(new VirtualDisk(item));
                }
            }
        }
        return this.virtualDisks;
    }

    public static List<VirtualDisk> getDisks(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        String url = vmRef.getHref() + "/virtualHardwareSection/disks";
        return VM.getDisksByUrl(client, url);
    }

    private static List<VirtualDisk> getDisksByUrl(VcloudClient client, String url) throws VCloudException {
        ArrayList<VirtualDisk> hardwareItems = new ArrayList<VirtualDisk>();
        RasdItemsListType rasdItems = (RasdItemsListType)SdkUtil.get(client, url, 200);
        if (rasdItems != null) {
            for (RASDType item : rasdItems.getItem()) {
                hardwareItems.add(new VirtualDisk(item));
            }
        }
        return hardwareItems;
    }

    private CimString getBusAddress(VirtualDisk disk, List<VirtualDisk> disks) throws VCloudException {
        for (VirtualDisk bus : disks) {
            if (!(bus.getItemResource().getResourceType().getValue().equals("6") && disk.getHostResourceAttributeValue("busType").equals("6") ? bus.getItemResource().getResourceSubType().getValue().equals(disk.getHardDiskBusType()) && bus.getItemResource().getAddress().getValue().equals(disk.getItemResource().getAddress().getValue()) : bus.getItemResource().getResourceType().getValue().equals("5") && disk.getHostResourceAttributeValue("busType").equals("5") && bus.getItemResource().getAddress().getValue().equals(disk.getItemResource().getAddress().getValue()))) continue;
            return bus.getItemResource().getInstanceID();
        }
        return null;
    }

    private VirtualDisk createController(VirtualDisk disk) throws VCloudException {
        RASDType busType = new RASDType();
        CimString any = new CimString();
        any.setValue("");
        CimString resourceSubType = new CimString();
        ResourceType resourceType = new ResourceType();
        if (disk.getHostResourceAttributeValue("busType").equals("5")) {
            resourceType.setValue("5");
        } else {
            resourceSubType.setValue(disk.getHardDiskBusType());
            resourceType.setValue("6");
            busType.setResourceSubType(resourceSubType);
        }
        busType.setElementName(any);
        busType.setDescription(any);
        busType.setInstanceID(any);
        busType.setAddress(disk.getItemResource().getAddress());
        busType.setResourceType(resourceType);
        busType.setInstanceID(disk.getItemResource().getParent());
        VirtualDisk bus = new VirtualDisk(busType);
        return bus;
    }

    private void processDisks(List<VirtualDisk> disks) throws VCloudException {
        for (int i = 0; i < disks.size(); ++i) {
            if (!disks.get(i).isHardDisk().booleanValue() || disks.get(i).getItemResource().getAddressOnParent() == null || disks.get(i).getItemResource().getAddress() == null) continue;
            CimString busAddress = this.getBusAddress(disks.get(i), disks);
            if (busAddress != null) {
                disks.get(i).getItemResource().setParent(busAddress);
                continue;
            }
            disks.add(this.createController(disks.get(i)));
        }
    }

    public Task updateDisks(List<VirtualDisk> virtualDisks) throws VCloudException {
        this.processDisks(virtualDisks);
        String virtualDisksUpdateUrl = this.getReference().getHref() + "/virtualHardwareSection/disks";
        String virtulDisksRequestXmlString = null;
        com.vmware.vcloud.api.rest.schema.ObjectFactory of = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        virtulDisksRequestXmlString = JAXBUtil.marshal(of.createRasdItemsList(this.getRASDItemsList(virtualDisks)));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + virtualDisksUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), virtualDisksUpdateUrl, virtulDisksRequestXmlString, "application/vnd.vmware.vcloud.rasdItemsList+xml", 202));
    }

    public List<VirtualNetworkCard> getNetworkCards() throws VCloudException {
        if (this.networkCards == null) {
            List items;
            this.networkCards = new ArrayList<VirtualNetworkCard>();
            if (this.virtualHardwareSection != null && (items = this.virtualHardwareSection.getItem()) != null) {
                for (RASDType item : items) {
                    if (!item.getResourceType().getValue().equals("10")) continue;
                    this.networkCards.add(new VirtualNetworkCard(item));
                }
            }
        }
        return this.networkCards;
    }

    public static List<VirtualNetworkCard> getNetworkCards(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        String url = vmRef.getHref() + "/virtualHardwareSection/networkCards";
        return VM.getNetworkCardsByUrl(client, url);
    }

    private static List<VirtualNetworkCard> getNetworkCardsByUrl(VcloudClient client, String url) throws VCloudException {
        ArrayList<VirtualNetworkCard> hardwareItems = new ArrayList<VirtualNetworkCard>();
        RasdItemsListType rasdItems = (RasdItemsListType)SdkUtil.get(client, url, 200);
        if (rasdItems != null) {
            for (RASDType item : rasdItems.getItem()) {
                hardwareItems.add(new VirtualNetworkCard(item));
            }
        }
        return hardwareItems;
    }

    public Task updateNetworkCards(List<VirtualNetworkCard> virtualNetworkCards) throws VCloudException {
        String virtualNetworkCardsUpdateUrl = this.getReference().getHref() + "/virtualHardwareSection/networkCards";
        String virtulNetworkCardsRequestXmlString = null;
        com.vmware.vcloud.api.rest.schema.ObjectFactory of = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        virtulNetworkCardsRequestXmlString = JAXBUtil.marshal(of.createRasdItemsList(this.getRASDItemsList(virtualNetworkCards)));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + virtualNetworkCardsUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), virtualNetworkCardsUpdateUrl, virtulNetworkCardsRequestXmlString, "application/vnd.vmware.vcloud.rasdItemsList+xml", 202));
    }

    public List<VirtualMedia> getMedias() throws VCloudException {
        if (this.medias == null) {
            List items;
            this.medias = new ArrayList<VirtualMedia>();
            if (this.virtualHardwareSection != null && (items = this.virtualHardwareSection.getItem()) != null) {
                for (RASDType item : items) {
                    if (!item.getResourceType().getValue().equals("14") && !item.getResourceType().getValue().equals("15") && !item.getResourceType().getValue().equals("5")) continue;
                    this.medias.add(new VirtualMedia(item));
                }
            }
        }
        return this.medias;
    }

    public static List<VirtualMedia> getMedias(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        String url = vmRef.getHref() + "/virtualHardwareSection/media";
        return VM.getMediasByUrl(client, url);
    }

    private static List<VirtualMedia> getMediasByUrl(VcloudClient client, String url) throws VCloudException {
        ArrayList<VirtualMedia> hardwareItems = new ArrayList<VirtualMedia>();
        RasdItemsListType rasdItems = (RasdItemsListType)SdkUtil.get(client, url, 200);
        if (rasdItems != null) {
            for (RASDType item : rasdItems.getItem()) {
                hardwareItems.add(new VirtualMedia(item));
            }
        }
        return hardwareItems;
    }

    private RasdItemsListType getRASDItemsList(List<? extends HardwareItem> items) {
        RasdItemsListType rasdItemsListType = new RasdItemsListType();
        List rasdItems = rasdItemsListType.getItem();
        for (HardwareItem hardwareItem : items) {
            rasdItems.add(hardwareItem.getItemResource());
        }
        return rasdItemsListType;
    }

    private void sortOvfSectionsAndReferences_v1_5() {
        List sections = ((VmType)this.getResource()).getSection();
        for (JAXBElement sec : sections) {
            if (sec.getValue() instanceof VirtualHardwareSectionType) {
                this.virtualHardwareSection = (VirtualHardwareSectionType)sec.getValue();
            } else if (sec.getValue() instanceof OperatingSystemSectionType) {
                this.operatingSystemSection = (OperatingSystemSectionType)sec.getValue();
            } else if (sec.getValue() instanceof NetworkConnectionSectionType) {
                this.networkConnectionSection = (NetworkConnectionSectionType)sec.getValue();
            } else if (sec.getValue() instanceof GuestCustomizationSectionType) {
                this.guestCustomizationSection = (GuestCustomizationSectionType)sec.getValue();
            } else if (sec.getValue() instanceof RuntimeInfoSectionType) {
                this.runtimeInfoSection = (RuntimeInfoSectionType)sec.getValue();
            }
            logger.info(((SectionType)sec.getValue()).getClass().getName());
        }
        for (LinkType vmLink : ((VmType)this.getResource()).getLink()) {
            if (!vmLink.getRel().equals("up") || !vmLink.getType().equals("application/vnd.vmware.vcloud.vApp+xml")) continue;
            this.parentVappReference = vmLink;
        }
        for (VCloudExtensionType vcloudExtension : ((VmType)this.getResource()).getVCloudExtension()) {
            for (Object jaxbObject : vcloudExtension.getAny()) {
                if (!(((JAXBElement)jaxbObject).getValue() instanceof VmVimInfoType)) continue;
                this.vmVimInfoType = (VmVimInfoType)((JAXBElement)jaxbObject).getValue();
            }
        }
    }

    public ReferenceType getParentVappReference() throws VCloudException {
        if (this.parentVappReference != null) {
            return this.parentVappReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public VimObjectRefType getVMVimRef() throws VCloudException {
        if (this.vmVimInfoType != null && this.vmVimInfoType.getVmVimObjectRef() != null) {
            return this.vmVimInfoType.getVmVimObjectRef();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }

    public VimObjectRefType getVMDatastoreVimRef() throws VCloudException {
        if (this.vmVimInfoType != null && this.vmVimInfoType.getDatastoreVimObjectRef() != null) {
            return this.vmVimInfoType.getDatastoreVimObjectRef();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }

    public VimObjectRefType getVMHostVimRef() throws VCloudException {
        if (this.vmVimInfoType != null && this.vmVimInfoType.getHostVimObjectRef() != null) {
            return this.vmVimInfoType.getHostVimObjectRef();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }

    public Integer getVMDiskChainLength() throws VCloudException {
        if (this.vmVimInfoType != null) {
            return this.vmVimInfoType.getVirtualDisksMaxChainLength();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
    }

    public Boolean isVMwareToolsInstalled() throws VCloudException {
        return this.getRuntimeInfoSection().getVMWareTools() != null;
    }

    public PlatformSectionType getPlatformSection() throws VCloudException {
        if (((VmType)this.getResource()).getEnvironment() != null) {
            for (JAXBElement section : ((VmType)this.getResource()).getEnvironment().getSection()) {
                if (!(section.getValue() instanceof PlatformSectionType)) continue;
                return (PlatformSectionType)section.getValue();
            }
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
    }

    public PropertySectionType getPropertySection() throws VCloudException {
        if (((VmType)this.getResource()).getEnvironment() != null) {
            for (JAXBElement section : ((VmType)this.getResource()).getEnvironment().getSection()) {
                if (!(section.getValue() instanceof PropertySectionType)) continue;
                return (PropertySectionType)section.getValue();
            }
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
    }

    public NetworkConnectionSectionType getNetworkConnectionSection() throws VCloudException {
        if (this.networkConnectionSection == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return this.networkConnectionSection;
    }

    public static NetworkConnectionSectionType getNetworkConnectionSection(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return (NetworkConnectionSectionType)SdkUtil.get(client, vmRef.getHref() + "/networkConnectionSection/", 200);
    }

    public Collection<NetworkConnectionType> getNetworkConnections() throws VCloudException {
        if (this.networkConnectionSection == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return this.networkConnectionSection.getNetworkConnection();
    }

    public HashMap<Integer, String> getIpAddressesById() throws VCloudException {
        if (this.networkConnectionSection == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        HashMap<Integer, String> ipAddresses = new HashMap<Integer, String>();
        for (NetworkConnectionType networkConnection : this.networkConnectionSection.getNetworkConnection()) {
            if (networkConnection.getIpAddress() != null) {
                ipAddresses.put(networkConnection.getNetworkConnectionIndex(), networkConnection.getIpAddress());
                continue;
            }
            if (!networkConnection.getIpAddressAllocationMode().equals(IpAddressAllocationModeType.DHCP.value())) continue;
            ipAddresses.put(networkConnection.getNetworkConnectionIndex(), IpAddressAllocationModeType.DHCP.value());
        }
        return ipAddresses;
    }

    public VmPendingQuestionType getVmQuestion() throws VCloudException {
        String url = this.getReference().getHref() + "/question";
        return (VmPendingQuestionType)SdkUtil.get(this.getVcloudClient(), url, 200);
    }

    public static VmPendingQuestionType getVmQuestion(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        String url = vmRef.getHref() + "/question";
        return (VmPendingQuestionType)SdkUtil.get(client, url, 200);
    }

    private static String createVmQuestionAnswerBody(int choiceId, String questionId) {
        com.vmware.vcloud.api.rest.schema.ObjectFactory of = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        VmQuestionAnswerType vmQuestionAnswerType = new VmQuestionAnswerType();
        vmQuestionAnswerType.setChoiceId(choiceId);
        vmQuestionAnswerType.setQuestionId(questionId);
        JAXBElement vmQuestionAnswer = of.createVmQuestionAnswer(vmQuestionAnswerType);
        return JAXBUtil.marshal(vmQuestionAnswer);
    }

    public void answerVmQuestion(int choiceId, String questionId) throws VCloudException {
        String url = this.getReference().getHref() + "/question/action/answer";
        String requestString = VM.createVmQuestionAnswerBody(choiceId, questionId);
        SdkUtil.post(this.getVcloudClient(), url, requestString, "application/vnd.vmware.vcloud.vmPendingAnswer+xml", 204);
    }

    public InputStream getScreen() throws VCloudException {
        String url = this.getReference().getHref() + "/screen";
        return RestUtil.downloadFile(this.getVcloudClient(), url);
    }

    public ScreenTicketType acquireTicket() throws VCloudException {
        String vmUrl = this.getReference().getHref();
        String url = vmUrl + "/screen/action/acquireTicket";
        return (ScreenTicketType)SdkUtil.post(this.getVcloudClient(), url, null, null, 200);
    }

    public Task installVMwareTools() throws VCloudException {
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/installVMwareTools", null, null, 202));
    }

    public Task upgradeHardware() throws VCloudException {
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/upgradeHardwareVersion", null, null, 202));
    }

    public Task consolidate() throws VCloudException {
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/consolidate", null, null, 202));
    }

    public static Task installVMwareTools(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, vmRef.getHref() + "/action/installVMwareTools", null, null, 202));
    }

    public static Task upgradeHardware(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, vmRef.getHref() + "/action/upgradeHardwareVersion", null, null, 202));
    }

    public static Task consolidate(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, vmRef.getHref() + "/action/consolidate", null, null, 202));
    }

    public static Task relocate(VcloudClient client, ReferenceType vmRef, ReferenceType datastoreReference) throws VCloudException {
        RelocateParamsType paramsType = new RelocateParamsType();
        paramsType.setDatastore(datastoreReference);
        String request = JAXBUtil.marshal(new com.vmware.vcloud.api.rest.schema.ObjectFactory().createRelocateParams(paramsType));
        return new Task(client, (TaskType)SdkUtil.post(client, vmRef.getHref() + "/action/relocate", request, "application/vnd.vmware.vcloud.relocateVmParams+xml", 202));
    }

    public Task relocate(ReferenceType datastoreReference) throws VCloudException {
        RelocateParamsType paramsType = new RelocateParamsType();
        paramsType.setDatastore(datastoreReference);
        String request = JAXBUtil.marshal(new com.vmware.vcloud.api.rest.schema.ObjectFactory().createRelocateParams(paramsType));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/relocate", request, "application/vnd.vmware.vcloud.relocateVmParams+xml", 202));
    }

    public Task attachDisk(ReferenceType diskRef) throws VCloudException {
        DiskAttachOrDetachParamsType diskAttachOrDetachParamsType = new DiskAttachOrDetachParamsType();
        diskAttachOrDetachParamsType.setDisk(diskRef);
        String request = JAXBUtil.marshal(new com.vmware.vcloud.api.rest.schema.ObjectFactory().createDiskAttachOrDetachParams(diskAttachOrDetachParamsType));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/disk/action/attach", request, "application/vnd.vmware.vcloud.diskAttachOrDetachParams+xml", 202));
    }

    public Task attachDisk(ReferenceType diskRef, Integer busNumber, Integer unitNumber) throws VCloudException {
        DiskAttachOrDetachParamsType diskAttachOrDetachParamsType = new DiskAttachOrDetachParamsType();
        diskAttachOrDetachParamsType.setDisk(diskRef);
        diskAttachOrDetachParamsType.setBusNumber(busNumber);
        diskAttachOrDetachParamsType.setUnitNumber(unitNumber);
        String request = JAXBUtil.marshal(new com.vmware.vcloud.api.rest.schema.ObjectFactory().createDiskAttachOrDetachParams(diskAttachOrDetachParamsType));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/disk/action/attach", request, "application/vnd.vmware.vcloud.diskAttachOrDetachParams+xml", 202));
    }

    public Task detachDisk(ReferenceType diskRef) throws VCloudException {
        DiskAttachOrDetachParamsType detachDiskParams = new DiskAttachOrDetachParamsType();
        detachDiskParams.setDisk(diskRef);
        String request = JAXBUtil.marshal(new com.vmware.vcloud.api.rest.schema.ObjectFactory().createDiskAttachOrDetachParams(detachDiskParams));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/disk/action/detach", request, "application/vnd.vmware.vcloud.diskAttachOrDetachParams+xml", 202));
    }

    public Task detachDisk(ReferenceType diskRef, Integer busNumber, Integer unitNumber) throws VCloudException {
        DiskAttachOrDetachParamsType detachDiskParams = new DiskAttachOrDetachParamsType();
        detachDiskParams.setDisk(diskRef);
        detachDiskParams.setBusNumber(busNumber);
        detachDiskParams.setUnitNumber(unitNumber);
        String request = JAXBUtil.marshal(new com.vmware.vcloud.api.rest.schema.ObjectFactory().createDiskAttachOrDetachParams(detachDiskParams));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/disk/action/detach", request, "application/vnd.vmware.vcloud.diskAttachOrDetachParams+xml", 202));
    }

    public List<ReferenceType> getAttachedDisks() throws VCloudException {
        ArrayList<ReferenceType> attachedDisks = new ArrayList<ReferenceType>();
        List<VirtualDisk> vmDisks = this.getDisks();
        for (VirtualDisk vmDisk : vmDisks) {
            if (!vmDisk.isHardDisk().booleanValue()) continue;
            try {
                ReferenceType diskRef = new ReferenceType();
                diskRef.setHref(vmDisk.getHostResourceAttributeValue("disk"));
                diskRef.setType("application/vnd.vmware.vcloud.disk+xml");
                attachedDisks.add(diskRef);
            }
            catch (VCloudException e) {
                logger.info(vmDisk.getItemResource().getElementName().getValue() + " - not an independent disk attached to the vm");
            }
        }
        return attachedDisks;
    }

    public Task enableNestedHypervisor() throws VCloudException {
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/enableNestedHypervisor", null, null, 202));
    }

    public static Task enableNestedHypervisor(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, vmRef.getHref() + "/action/enableNestedHypervisor", null, null, 202));
    }

    public Task disableNestedHypervisor() throws VCloudException {
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/disableNestedHypervisor", null, null, 202));
    }

    public static Task disableNestedHypervisor(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, vmRef.getHref() + "/action/disableNestedHypervisor", null, null, 202));
    }

    public Task updateHotAdd(boolean memoryHotAdd, boolean cpuHotAdd) throws VCloudException {
        return VM.updateHotAdd(this.getVcloudClient(), this.getReference(), memoryHotAdd, cpuHotAdd);
    }

    public static Task updateHotAdd(VcloudClient client, ReferenceType vmRef, boolean memoryHotAdd, boolean cpuHotAdd) throws VCloudException {
        VmCapabilitiesType vmCapabilities = new VmCapabilitiesType();
        vmCapabilities.setCpuHotAddEnabled(Boolean.valueOf(cpuHotAdd));
        vmCapabilities.setMemoryHotAddEnabled(Boolean.valueOf(memoryHotAdd));
        String vmCapabilitiesString = JAXBUtil.marshal(new com.vmware.vcloud.api.rest.schema.ObjectFactory().createVmCapabilities(vmCapabilities));
        return new Task(client, (TaskType)SdkUtil.put(client, vmRef.getHref() + "/vmCapabilities", vmCapabilitiesString, "application/vnd.vmware.vcloud.vmCapabilitiesSection+xml", 202));
    }

    public Task checkCompliance() throws VCloudException {
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), ((VmType)this.getResource()).getHref() + "/action/checkCompliance", null, null, 202));
    }

    public static Task checkCompliance(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, vmRef.getHref() + "/action/checkCompliance", null, null, 202));
    }

    public ComplianceResultType complianceResult() throws VCloudException {
        return (ComplianceResultType)SdkUtil.get(this.getVcloudClient(), ((VmType)this.getResource()).getHref() + "/complianceResult", 200);
    }

    public static ComplianceResultType complianceResult(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return (ComplianceResultType)SdkUtil.get(client, vmRef.getHref() + "/complianceResult", 200);
    }

    public Task reconfigureVM(VmType vmType) throws VCloudException {
        String reconfigureVMUrl = this.getReference().getHref() + "/action/reconfigureVm";
        com.vmware.vcloud.api.rest.schema.ObjectFactory objectFactory_v5_1 = new com.vmware.vcloud.api.rest.schema.ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory_v5_1.createVm(vmType));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), reconfigureVMUrl, requestBodyXml, "application/vnd.vmware.vcloud.vm+xml", 202));
    }

    public MksTicketType acquireMksTicket() throws VCloudException {
        String url = this.getReference().getHref() + "/screen/action/acquireMksTicket";
        return (MksTicketType)SdkUtil.post(this.getVcloudClient(), url, null, null, 200);
    }

    public CurrentUsageType getCurrentMetrics(CurrentUsageSpecType currentUsageSpec) throws VCloudException {
        String url = this.getReference().getHref() + "/metrics/current";
        String currentUsageSpecString = JAXBUtil.marshal(new com.vmware.vcloud.api.rest.schema.ObjectFactory().createCurrentUsageSpec(currentUsageSpec));
        return (CurrentUsageType)SdkUtil.post(this.getVcloudClient(), url, currentUsageSpecString, "application/vnd.vmware.vcloud.metrics.currentUsageSpec+xml", 200);
    }

    public static CurrentUsageType getCurrentMetrics(VcloudClient client, ReferenceType vmRef, CurrentUsageSpecType currentUsageSpec) throws VCloudException {
        String url = vmRef.getHref() + "/metrics/current";
        String currentUsageSpecString = JAXBUtil.marshal(new com.vmware.vcloud.api.rest.schema.ObjectFactory().createCurrentUsageSpec(currentUsageSpec));
        return (CurrentUsageType)SdkUtil.post(client, url, currentUsageSpecString, "application/vnd.vmware.vcloud.metrics.currentUsageSpec+xml", 200);
    }

    public CurrentUsageType getCurrentMetrics() throws VCloudException {
        return (CurrentUsageType)SdkUtil.get(this.getVcloudClient(), this.getReference().getHref() + "/metrics/current", 200);
    }

    public static CurrentUsageType getCurrentMetrics(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return (CurrentUsageType)SdkUtil.get(client, vmRef.getHref() + "/metrics/current", 200);
    }

    public HistoricUsageType getHistoricMetrics(HistoricUsageSpecType historicUsageSpec) throws VCloudException {
        String url = this.getReference().getHref() + "/metrics/historic";
        String historicUsageSpecString = JAXBUtil.marshal(new com.vmware.vcloud.api.rest.schema.ObjectFactory().createHistoricUsageSpec(historicUsageSpec));
        return (HistoricUsageType)SdkUtil.post(this.getVcloudClient(), url, historicUsageSpecString, "application/vnd.vmware.vcloud.metrics.historicUsageSpec+xml", 200);
    }

    public static HistoricUsageType getHistoricMetrics(VcloudClient client, ReferenceType vmRef, HistoricUsageSpecType historicUsageSpec) throws VCloudException {
        String url = vmRef.getHref() + "/metrics/historic";
        String historicUsageSpecString = JAXBUtil.marshal(new com.vmware.vcloud.api.rest.schema.ObjectFactory().createHistoricUsageSpec(historicUsageSpec));
        return (HistoricUsageType)SdkUtil.post(client, url, historicUsageSpecString, "application/vnd.vmware.vcloud.metrics.historicUsageSpec+xml", 200);
    }

    public HistoricUsageType getHistoricMetrics() throws VCloudException {
        return (HistoricUsageType)SdkUtil.get(this.getVcloudClient(), this.getReference().getHref() + "/metrics/historic", 200);
    }

    public static HistoricUsageType getHistoricMetrics(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        return (HistoricUsageType)SdkUtil.get(client, vmRef.getHref() + "/metrics/historic", 200);
    }

    public void forceGuestCustomization() throws VCloudException {
        String url = this.getReference().getHref() + "/action/customizeAtNextPowerOn";
        SdkUtil.post(this.getVcloudClient(), url, null, null, 204);
    }

    public static void forceGuestCustomization(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        String url = vmRef.getHref() + "/action/customizeAtNextPowerOn";
        SdkUtil.post(client, url, null, null, 204);
    }

    public Task reloadFromVC() throws VCloudException {
        String url = this.getReference().getHref() + "/action/reloadFromVc";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), url, null, null, 202));
    }

    public static Task reloadFromVC(VcloudClient client, ReferenceType vmRef) throws VCloudException {
        String url = vmRef.getHref() + "/action/reloadFromVc";
        return new Task(client, (TaskType)SdkUtil.post(client, url, null, null, 202));
    }
}

