/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockConnection;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.activemq.filter.mockrunner.Filter;
import org.activemq.selector.mockrunner.SelectorParser;

public abstract class MockMessageConsumer
implements MessageConsumer {
    private MockConnection connection;
    private String messageSelector;
    private Filter messageSelectorFilter;
    private boolean closed;
    private MessageListener messageListener;

    public MockMessageConsumer(MockConnection mockConnection, String string) {
        this.connection = mockConnection;
        this.messageSelector = string;
        this.parseMessageSelector();
        this.closed = false;
        this.messageListener = null;
    }

    private void parseMessageSelector() {
        if (null == this.messageSelector || this.messageSelector.length() == 0) {
            this.messageSelectorFilter = null;
        } else {
            try {
                this.messageSelectorFilter = new SelectorParser().parse(this.messageSelector);
            }
            catch (InvalidSelectorException invalidSelectorException) {
                throw new RuntimeException("Error parsing message selector: " + invalidSelectorException.getMessage());
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean canConsume(Message message) {
        if (this.messageListener == null) {
            return false;
        }
        if (this.isClosed()) {
            return false;
        }
        return this.matchesMessageSelector(message);
    }

    public void receiveMessage(Message message) {
        if (null == this.messageListener) {
            return;
        }
        this.messageListener.onMessage(message);
    }

    public String getMessageSelector() throws JMSException {
        this.connection.throwJMSException();
        return this.messageSelector;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.connection.throwJMSException();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.connection.throwJMSException();
        this.messageListener = messageListener;
    }

    public Message receive(long l) throws JMSException {
        this.connection.throwJMSException();
        return this.receive();
    }

    public Message receiveNoWait() throws JMSException {
        this.connection.throwJMSException();
        return this.receive();
    }

    public void close() throws JMSException {
        this.connection.throwJMSException();
        this.closed = true;
    }

    private boolean matchesMessageSelector(Message message) {
        if (!this.connection.getConfigurationManager().getUseMessageSelectors()) {
            return true;
        }
        if (this.messageSelectorFilter == null) {
            return true;
        }
        try {
            return this.messageSelectorFilter.matches(message);
        }
        catch (JMSException jMSException) {
            throw new RuntimeException(jMSException.getMessage());
        }
    }

    protected Filter getMessageFilter() {
        return this.messageSelectorFilter;
    }

    protected MockConnection getConnection() {
        return this.connection;
    }

    public abstract Message receive() throws JMSException;
}

