/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.jms.MockSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.activemq.filter.mockrunner.Filter;

public abstract class MockDestination
implements Destination {
    private Set sessions = new HashSet();
    private List currentMessages = new ArrayList();
    private List receivedMessages = new ArrayList();

    public abstract void addMessage(Message var1) throws JMSException;

    public void loadMessage(Message message) {
        this.addCurrentMessage(message);
    }

    public boolean isEmpty() {
        return this.currentMessages.size() <= 0;
    }

    public void clear() {
        this.currentMessages.clear();
    }

    public void reset() {
        this.currentMessages.clear();
        this.receivedMessages.clear();
    }

    public Message getMessage() {
        if (this.currentMessages.size() <= 0) {
            return null;
        }
        return (Message)this.currentMessages.remove(0);
    }

    public Message getMatchingMessage(Filter filter) {
        int n = 0;
        while (n < this.currentMessages.size()) {
            Message message = (Message)this.currentMessages.get(n);
            try {
                if (filter.matches(message)) {
                    this.currentMessages.remove(n);
                    return message;
                }
            }
            catch (JMSException jMSException) {
                throw new NestedApplicationException(jMSException);
            }
            ++n;
        }
        return null;
    }

    public List getCurrentMessageList() {
        return Collections.unmodifiableList(this.currentMessages);
    }

    public List getReceivedMessageList() {
        return Collections.unmodifiableList(this.receivedMessages);
    }

    public void addSession(Session session) {
        this.sessions.add(session);
    }

    public void removeSession(Session session) {
        this.sessions.remove(session);
    }

    public Set sessionSet() {
        return Collections.unmodifiableSet(this.sessions);
    }

    protected void addReceivedMessage(Message message) {
        this.receivedMessages.add(message);
    }

    protected void addCurrentMessage(Message message) {
        this.currentMessages.add(message);
    }

    protected void acknowledgeMessage(Message message, MockSession mockSession) throws JMSException {
        if (mockSession.isAutoAcknowledge()) {
            message.acknowledge();
        }
    }
}

