/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTopic;
import com.mockrunner.mock.jms.MockTopicPublisher;
import com.mockrunner.mock.jms.MockTopicSubscriber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;

public class TopicTransmissionManager {
    private MockConnection connection;
    private MockSession session;
    private List topicPublisherList;
    private List topicSubscriberList;
    private Map topicDurableSubscriberMap;

    public TopicTransmissionManager(MockConnection mockConnection, MockSession mockSession) {
        this.connection = mockConnection;
        this.session = mockSession;
        this.topicPublisherList = new ArrayList();
        this.topicSubscriberList = new ArrayList();
        this.topicDurableSubscriberMap = new HashMap();
    }

    public void closeAll() {
        this.closeAllTopicPublishers();
        this.closeAllTopicSubscribers();
        this.closeAllTopicDurableSubscribers();
    }

    public void closeAllTopicPublishers() {
        int n = 0;
        while (n < this.topicPublisherList.size()) {
            TopicPublisher topicPublisher = (TopicPublisher)this.topicPublisherList.get(n);
            try {
                topicPublisher.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void closeAllTopicSubscribers() {
        int n = 0;
        while (n < this.topicSubscriberList.size()) {
            TopicSubscriber topicSubscriber = (TopicSubscriber)this.topicSubscriberList.get(n);
            try {
                topicSubscriber.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void closeAllTopicDurableSubscribers() {
        Iterator iterator = this.topicDurableSubscriberMap.keySet().iterator();
        while (iterator.hasNext()) {
            TopicSubscriber topicSubscriber = (TopicSubscriber)this.topicDurableSubscriberMap.get(iterator.next());
            try {
                topicSubscriber.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public MockTopicPublisher createTopicPublisher(MockTopic mockTopic) {
        MockTopicPublisher mockTopicPublisher = new MockTopicPublisher(this.connection, this.session, mockTopic);
        this.topicPublisherList.add(mockTopicPublisher);
        return mockTopicPublisher;
    }

    public MockTopicPublisher getTopicPublisher(int n) {
        if (this.topicPublisherList.size() <= n || n < 0) {
            return null;
        }
        return (MockTopicPublisher)this.topicPublisherList.get(n);
    }

    public MockTopicPublisher getTopicPublisher(String string) {
        List list = this.getTopicPublisherList(string);
        if (list.size() <= 0) {
            return null;
        }
        return (MockTopicPublisher)list.get(0);
    }

    public List getTopicPublisherList(String string) {
        ArrayList<TopicPublisher> arrayList = new ArrayList<TopicPublisher>();
        int n = 0;
        while (n < this.topicPublisherList.size()) {
            TopicPublisher topicPublisher = (TopicPublisher)this.topicPublisherList.get(n);
            try {
                if (topicPublisher.getTopic().getTopicName().equals(string)) {
                    arrayList.add(topicPublisher);
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            ++n;
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List getTopicPublisherList() {
        return Collections.unmodifiableList(this.topicPublisherList);
    }

    public MockTopicSubscriber createTopicSubscriber(MockTopic mockTopic, String string, boolean bl) {
        MockTopicSubscriber mockTopicSubscriber = new MockTopicSubscriber(this.connection, this.session, mockTopic, string, bl);
        mockTopicSubscriber.setDurable(false);
        this.topicSubscriberList.add(mockTopicSubscriber);
        return mockTopicSubscriber;
    }

    public MockTopicSubscriber getTopicSubscriber(int n) {
        if (this.topicSubscriberList.size() <= n || n < 0) {
            return null;
        }
        return (MockTopicSubscriber)this.topicSubscriberList.get(n);
    }

    public MockTopicSubscriber getTopicSubscriber(String string) {
        List list = this.getTopicSubscriberList(string);
        if (list.size() <= 0) {
            return null;
        }
        return (MockTopicSubscriber)list.get(0);
    }

    public List getTopicSubscriberList(String string) {
        ArrayList<TopicSubscriber> arrayList = new ArrayList<TopicSubscriber>();
        int n = 0;
        while (n < this.topicSubscriberList.size()) {
            TopicSubscriber topicSubscriber = (TopicSubscriber)this.topicSubscriberList.get(n);
            try {
                if (topicSubscriber.getTopic().getTopicName().equals(string)) {
                    arrayList.add(topicSubscriber);
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            ++n;
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List getTopicSubscriberList() {
        return Collections.unmodifiableList(this.topicSubscriberList);
    }

    public MockTopicSubscriber createDurableTopicSubscriber(MockTopic mockTopic, String string, String string2, boolean bl) {
        MockTopicSubscriber mockTopicSubscriber = new MockTopicSubscriber(this.connection, this.session, mockTopic, string2, bl);
        mockTopicSubscriber.setDurable(true);
        mockTopicSubscriber.setName(string);
        this.topicDurableSubscriberMap.put(string, mockTopicSubscriber);
        return mockTopicSubscriber;
    }

    public MockTopicSubscriber getDurableTopicSubscriber(String string) {
        return (MockTopicSubscriber)this.topicDurableSubscriberMap.get(string);
    }

    public void removeTopicDurableSubscriber(String string) {
        this.topicDurableSubscriberMap.remove(string);
    }

    public Map getDurableTopicSubscriberMap(String string) {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.topicDurableSubscriberMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            MockTopicSubscriber mockTopicSubscriber = (MockTopicSubscriber)this.topicDurableSubscriberMap.get(k);
            try {
                if (null == mockTopicSubscriber || !mockTopicSubscriber.getTopic().getTopicName().equals(string)) continue;
                hashMap.put(k, mockTopicSubscriber);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return hashMap;
    }

    public Map getDurableTopicSubscriberMap() {
        return Collections.unmodifiableMap(this.topicDurableSubscriberMap);
    }
}

