/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class StringValuesTable {
    private String name;
    private List columnNames = new ArrayList(0);
    private String[][] stringMatrix;

    public StringValuesTable(String string, String[][] stringArray) {
        this(string, null, stringArray);
    }

    public StringValuesTable(String string, String[] stringArray, String[][] stringArray2) {
        if (string != null) {
            if (string.trim().length() > 0) {
                this.name = string;
                this.stringMatrix = StringValuesTable.verifyStringMatrix(stringArray2);
                if (stringArray != null) {
                    this.columnNames = Arrays.asList(StringValuesTable.verifyColumnNames(stringArray, stringArray2));
                }
                return;
            }
            throw new IllegalArgumentException("invalid table name given");
        }
        throw new IllegalArgumentException("the table name cannot be null");
    }

    public String[] getColumn(String string) {
        if (string != null) {
            int n = this.columnNames.indexOf(string);
            if (n >= 0) {
                return this.doGetColumn(n);
            }
            throw new IllegalArgumentException(string + " is not a valid column name");
        }
        throw new IllegalArgumentException("the column name cannot be null");
    }

    public String[] getColumn(int n) {
        return this.doGetColumn(--n);
    }

    public String[] getColumnNames() {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    public String getItem(int n, String string) {
        if (string != null) {
            int n2 = this.columnNames.indexOf(string);
            if (n2 >= 0) {
                return this.doGetRow(n)[n2];
            }
            throw new IllegalArgumentException(string + " is not a valid column index");
        }
        throw new IllegalArgumentException("the column name cannot be null");
    }

    public String getItem(int n, int n2) {
        if (this.isColumnNumberValid(n2)) {
            return this.doGetRow(n)[--n2];
        }
        throw new IllegalArgumentException(n2 + " is not a valid column index");
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfColumns() {
        return this.stringMatrix[0].length;
    }

    public int getNumberOfRows() {
        return this.stringMatrix.length;
    }

    public String[] getRow(int n) {
        return this.doGetRow(n);
    }

    public boolean isValidColumnName(String string) {
        return string == null ? false : this.isColumnNumberValid(this.columnNames.indexOf(string) + 1);
    }

    public boolean isValidColumnNumber(int n) {
        return this.isColumnNumberValid(n);
    }

    public boolean isValidRowNumber(int n) {
        return --n >= 0 && n < this.stringMatrix.length;
    }

    public String[][] getStringMatrix() {
        return this.stringMatrix;
    }

    public static synchronized String[] verifyColumnNames(String[] stringArray, String[][] stringArray2) {
        if (stringArray != null) {
            if (stringArray.length == stringArray2[0].length) {
                String string = null;
                HashSet<String> hashSet = new HashSet<String>();
                int n = 0;
                while (n < stringArray.length) {
                    string = stringArray[n];
                    if (string == null) {
                        throw new IllegalArgumentException("the column names array must not contain null elements");
                    }
                    if (hashSet.contains(string)) {
                        throw new IllegalArgumentException("the column names array must not contain duplicate elements");
                    }
                    hashSet.add(string);
                    ++n;
                }
                return stringArray;
            }
            throw new IllegalArgumentException(stringArray.length + " columns were given where " + stringArray2[0].length + (stringArray2[0].length == 1 ? " is" : " are") + " required");
        }
        throw new IllegalArgumentException("the column names array cannot be null");
    }

    public static synchronized String[][] verifyStringMatrix(String[][] stringArray) {
        if (stringArray != null) {
            if (stringArray.length > 0) {
                if (stringArray[0] != null && stringArray[0].length > 0) {
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n] == null) {
                            throw new IllegalArgumentException("the string matrix cannot contain any null arrays");
                        }
                        if (stringArray[n].length != stringArray[0].length) {
                            throw new IllegalArgumentException("arrays in the string matrix must all contain " + stringArray[0].length + " elements");
                        }
                        int n2 = 0;
                        while (n2 < stringArray[n].length) {
                            if (stringArray[n][n2] == null) {
                                throw new IllegalArgumentException("arrays in the string matrix must not contain null elements");
                            }
                            ++n2;
                        }
                        ++n;
                    }
                    return stringArray;
                }
                throw new IllegalArgumentException("the string matrix must contain at least 1 column of items");
            }
            throw new IllegalArgumentException("the string matrix must contain at least 1 row of items");
        }
        throw new IllegalArgumentException("the string matrix cannot be null");
    }

    private String[] doGetColumn(int n) {
        if (n >= 0 && n < this.stringMatrix[0].length) {
            String[] stringArray = new String[this.stringMatrix.length];
            int n2 = 0;
            while (n2 < this.stringMatrix.length) {
                stringArray[n2] = this.stringMatrix[n2][n];
                ++n2;
            }
            return stringArray;
        }
        throw new IllegalArgumentException(++n + " is not a valid column index");
    }

    private String[] doGetRow(int n) {
        if (--n >= 0 && n < this.stringMatrix.length) {
            return this.stringMatrix[n];
        }
        throw new IllegalArgumentException(++n + " is not a valid row number");
    }

    private boolean isColumnNumberValid(int n) {
        return --n >= 0 && n < this.stringMatrix[0].length;
    }
}

