/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpEncodingException;
import com.ireasoning.protocol.snmp.h;

public class SnmpUInt
implements SnmpDataType {
    long a;
    public static final SnmpUInt MAX_VALUE = new SnmpUInt();

    public SnmpUInt() {
        this.a = 0L;
    }

    public SnmpUInt(String string) {
        this(Long.parseLong(string));
    }

    public SnmpUInt(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative number: " + l2);
        }
        if (l2 > SnmpUInt.MAX_VALUE.a) {
            throw new IllegalArgumentException("Too big: " + l2);
        }
        this.a = l2 & 0xFFFFFFFFL;
    }

    public SnmpUInt(SnmpUInt snmpUInt) {
        this.a = snmpUInt.a;
    }

    public long getValue() {
        return this.a & 0xFFFFFFFFL;
    }

    public void setValue(long l2) {
        this.a = l2 & 0xFFFFFFFFL;
    }

    public int getType() {
        return 66;
    }

    public String getTypeString() {
        return "UnsignedInteger";
    }

    public String toString() {
        return "" + this.getValue();
    }

    public SnmpDataType copy() {
        return new SnmpUInt(this);
    }

    public int encode(h h2) throws SnmpEncodingException {
        return h2.a(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof SnmpUInt)) {
            return false;
        }
        return ((SnmpUInt)object).a == this.a;
    }

    public int hashCode() {
        return (int)(this.a ^ this.a >> 32);
    }

    static {
        SnmpUInt.MAX_VALUE.a = 0xFFFFFFFFL;
    }
}

