/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class HTMLTokenizer {
    private final int BUF_LEN = 256;
    private Vector tokens = new Vector();
    private char separator;
    private int start;

    public HTMLTokenizer(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.parseInputStream(fileInputStream);
        }
        catch (IOException iOException) {
            return;
        }
    }

    public Enumeration getTokens() {
        return this.tokens.elements();
    }

    public Vector getTokenVector() {
        return this.tokens;
    }

    private void parseInputStream(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[256];
        char[] cArray = new char[256];
        StringBuffer stringBuffer = null;
        this.separator = (char)60;
        while ((n = inputStream.read(byArray)) >= 0) {
            int n2 = 0;
            while (n2 < n) {
                cArray[n2] = (char)byArray[n2];
                ++n2;
            }
            stringBuffer = this.processBuffer(cArray, stringBuffer, n);
        }
    }

    private StringBuffer processBuffer(char[] cArray, StringBuffer stringBuffer, int n) {
        StringBuffer stringBuffer2 = stringBuffer != null ? stringBuffer : new StringBuffer(80);
        this.start = 0;
        int n2 = -1;
        while (true) {
            Object object;
            this.start = n2 + 1;
            n2 = this.indexOf(this.separator, cArray, this.start, n);
            if (n2 < 0) {
                if (n - this.start > 0) {
                    stringBuffer2.append(cArray, this.start, n - this.start);
                }
                if (stringBuffer2.length() > 0) {
                    return stringBuffer2;
                }
                return null;
            }
            stringBuffer2.append(cArray, this.start, n2 - this.start);
            if (this.separator == '<') {
                if (stringBuffer2.length() > 0) {
                    object = new TextToken();
                    ((TextToken)object).setText(stringBuffer2);
                    this.tokens.addElement(object);
                }
            } else {
                object = stringBuffer2.toString();
                TagToken tagToken = new TagToken((String)object);
                this.tokens.addElement(tagToken);
            }
            stringBuffer2 = new StringBuffer(256);
            if (this.separator == '<') {
                this.separator = (char)62;
                continue;
            }
            this.separator = (char)60;
        }
    }

    private int indexOf(char c, char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (cArray[n3] == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }
}

