/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.JdbcDataObject;
import com.sybase.jdbc2.jdbc.TextPointer;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsParam;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.Debug;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;

public class TdsUpdateParam
extends TdsParam
implements JdbcDataObject {
    public TdsUpdateParam(TdsDataOutputStream tdos, CacheManager cm) {
        super(tdos);
    }

    private void checkStream(boolean throwOnNull) throws SQLException {
        if (this._inValue == null) {
            if (throwOnNull) {
                ErrorMessage.raiseError("JZ0TC");
            }
        } else if (this._inValue instanceof InputStream) {
            ErrorMessage.raiseError("JZ0IS");
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        Debug.println(this, "getAsciiStream()");
        this.checkStream(false);
        return Convert.objectToStream(this._inValue);
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        Debug.println(this, "getBigDecimal()");
        this.checkStream(false);
        BigDecimal bd = Convert.objectToBigDecimal(this._inValue);
        return Convert.setScale(bd, scale);
    }

    public InputStream getBinaryStream() throws SQLException {
        Debug.println(this, "getBinaryStream()");
        this.checkStream(false);
        return Convert.objectToStream(this._inValue);
    }

    public boolean getBoolean() throws SQLException {
        Debug.println(this, "getBoolean()");
        this.checkStream(true);
        return Convert.objectToBoolean(this._inValue);
    }

    public byte getByte() throws SQLException {
        Debug.println(this, "getByte()");
        this.checkStream(true);
        long retVal = Convert.objectToLongValue(this._inValue);
        Convert.checkByteOflo(retVal);
        return (byte)retVal;
    }

    public byte[] getBytes() throws SQLException {
        Debug.println(this, "getBytes()");
        this.checkStream(false);
        return Convert.objectToBytes(this._inValue);
    }

    public Reader getCharacterStream() throws SQLException {
        Debug.println(this, "getCharacterStream()");
        this.checkStream(false);
        return Convert.objectToReader(this._inValue);
    }

    public DateObject getDateObject(int targetType, Calendar cal) throws SQLException {
        Debug.println(this, "getDateObject()");
        this.checkStream(false);
        return Convert.objectToDateObject(this._inValue, cal);
    }

    public double getDouble() throws SQLException {
        Debug.println(this, "getDouble()");
        this.checkStream(true);
        return Convert.objectToDoubleValue(this._inValue);
    }

    public float getFloat() throws SQLException {
        Debug.println(this, "getFloat()");
        this.checkStream(true);
        return (float)Convert.objectToDoubleValue(this._inValue);
    }

    public int getInt() throws SQLException {
        Debug.println(this, "getInt()");
        this.checkStream(true);
        long retVal = Convert.objectToLongValue(this._inValue);
        Convert.checkIntOflo(retVal);
        return (int)retVal;
    }

    public long getLong() throws SQLException {
        Debug.println(this, "getLong()");
        this.checkStream(true);
        return Convert.objectToLongValue(this._inValue);
    }

    public Object getObject() throws SQLException {
        Debug.println(this, "getObject()");
        this.checkStream(false);
        return this._inValue;
    }

    public short getShort() throws SQLException {
        Debug.println(this, "getShort()");
        this.checkStream(true);
        long retVal = Convert.objectToLongValue(this._inValue);
        Convert.checkShortOflo(retVal);
        return (short)retVal;
    }

    public String getString() throws SQLException {
        Debug.println(this, "getString()");
        this.checkStream(false);
        return Convert.objectToString(this._inValue);
    }

    public TextPointer getTextPtr() throws SQLException {
        ErrorMessage.raiseError("JZ0R4");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        Debug.println(this, "getUnicodeStream()");
        this.checkStream(false);
        return Convert.objectToStream(this._inValue);
    }

    public boolean isNull() throws SQLException {
        if (this._sqlType == -999 || this._sqlType == -998) {
            ErrorMessage.raiseError("JZ0TC");
        }
        return this._sqlType == 0;
    }
}

