/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.RawInputStream;
import com.sybase.jdbc2.tds.BlobOutputStream;
import com.sybase.jdbc2.tds.PduOutputFormatter;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataObject;
import com.sybase.jdbc2.tds.TdsDateTime;
import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.tds.TdsNumeric;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.TdsParam;
import com.sybase.jdbc2.utils.Debug;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TdsDataOutputStream
extends TdsOutputStream {
    Tds _tds;
    protected static final int BUF_SIZE = 2048;
    protected static final int TDS_TYPE = 0;
    protected static final int LENGTH = 1;
    protected static final int PRECISION = 2;
    protected static final int SCALE = 3;
    protected static final int INFO_LENGTH = 4;

    public TdsDataOutputStream(Tds tds, PduOutputFormatter os) throws IOException {
        super(os);
        this._tds = tds;
    }

    protected void convertString(TdsParam p, int[] dataInfo) throws IOException {
        if (p._inValue != null) {
            if (p._inValue instanceof String) {
                if (p._cvtString == null) {
                    p._parameterAsAString = (String)p._inValue;
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(p);
                    } else {
                        p._cvtString = this.stringToByte((String)p._inValue);
                    }
                }
                dataInfo[1] = p._cvtString.length;
            } else if (p._inValue instanceof InputStream) {
                if (p._cvtString == null) {
                    Debug.println(this, "Parameter in-value is in InputStream");
                    String text = null;
                    p._parameterAsAString = text = p.getStringFromStream(0);
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(p);
                    } else {
                        p._cvtString = this.stringToByte(text);
                    }
                }
                dataInfo[1] = p._cvtString.length;
            } else if (p._inValue instanceof Reader) {
                Debug.println(this, "convert a Reader to String, length = " + p._scale);
                if (p._cvtString == null) {
                    char[] cb = new char[2048];
                    StringBuffer text = new StringBuffer(2048);
                    int amountRead = 0;
                    while (true) {
                        int len;
                        int toRead = 2048;
                        if (p._scale >= 0 && p._scale < 2048) {
                            toRead = p._scale - amountRead;
                        }
                        Debug.println(this, "Reading another " + toRead + " characters");
                        if (toRead <= 0 || (len = ((Reader)p._inValue).read(cb, 0, toRead)) <= 0) break;
                        text.append(cb, 0, len);
                        amountRead += len;
                    }
                    p._parameterAsAString = text.toString();
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(p);
                    } else {
                        p._cvtString = this.stringToByte(text.toString());
                    }
                }
                dataInfo[1] = p._cvtString.length;
            } else {
                if (p._cvtString == null) {
                    p._parameterAsAString = p._inValue.toString();
                    if (this._tds.isUnicharEnabled()) {
                        this.setUnicharParameter(p);
                    } else {
                        p._cvtString = this.stringToByte(p._inValue.toString());
                    }
                }
                dataInfo[1] = p._cvtString.length;
                Debug.assert(null, false);
            }
        }
    }

    protected void dataTypeInfo(TdsParam p, int[] dataInfo) throws IOException {
        Debug.assert(null, dataInfo.length >= 4);
        switch (p._sqlType) {
            case -7: {
                dataInfo[0] = 50;
                break;
            }
            case -6: {
                dataInfo[0] = 38;
                dataInfo[1] = 1;
                break;
            }
            case 5: {
                dataInfo[0] = 38;
                dataInfo[1] = 2;
                break;
            }
            case -998: {
                dataInfo[0] = 56;
                dataInfo[1] = 4;
                break;
            }
            case 4: {
                dataInfo[0] = 38;
                dataInfo[1] = 4;
                break;
            }
            case -5: {
                dataInfo[0] = 38;
                dataInfo[1] = 8;
                break;
            }
            case 7: {
                dataInfo[0] = 109;
                dataInfo[1] = 4;
                break;
            }
            case 6: 
            case 8: {
                dataInfo[0] = 109;
                dataInfo[1] = 8;
                break;
            }
            case 2: 
            case 3: {
                dataInfo[0] = 108;
                Debug.assert(null, p._inValue == null || p._inValue instanceof BigDecimal);
                if (p == null) break;
                TdsNumeric.tdsNumeric((BigDecimal)p._inValue, dataInfo);
                break;
            }
            case 9219: 
            case 9220: {
                dataInfo[0] = p._sqlType;
                dataInfo[1] = p._scale;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (this._tds.isUnicharEnabled()) {
                    dataInfo[0] = 225;
                    p._sqlType = -4;
                    p._parameterHoldsUnicharData = true;
                } else {
                    dataInfo[0] = p._sqlType == -1 ? 175 : 39;
                }
                this.convertString(p, dataInfo);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                dataInfo[0] = 111;
                dataInfo[1] = 8;
                break;
            }
            case -3: 
            case -2: {
                dataInfo[0] = 37;
                Debug.assert(null, p._inValue == null || p._inValue instanceof byte[]);
                if (p._inValue == null) break;
                dataInfo[1] = ((byte[])p._inValue).length;
                break;
            }
            case -4: {
                dataInfo[0] = 225;
                if (p._inValue == null) break;
                if (p._inValue instanceof byte[]) {
                    dataInfo[1] = ((byte[])p._inValue).length;
                    break;
                }
                if (p._inValue instanceof InputStream) {
                    if (p._scale == -1) {
                        InputStream is = (InputStream)p._inValue;
                        dataInfo[1] = is.available();
                        break;
                    }
                    dataInfo[1] = p._scale;
                    break;
                }
                Debug.assert(null, false);
                break;
            }
            case 2000: {
                dataInfo[0] = 9217;
                dataInfo[1] = -1;
                break;
            }
            default: {
                ErrorMessage.raiseIOException("JZ0SM", String.valueOf(p._sqlType));
            }
        }
        if (p._inValue == null) {
            dataInfo[1] = 0;
        }
        Debug.println(null, "dataTypeInfo Param: " + p._sqlType + ", converted to TDS type " + dataInfo[0] + ", length = " + dataInfo[1]);
    }

    public String getCharset() {
        return this._tds._charsetName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void send(TdsDataObject tdo) throws SQLException {
        block42: {
            block41: {
                block40: {
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        try {
                                            block43: {
                                                try {
                                                    tdo.beginRead();
                                                    if (!tdo._isNull) {
                                                        int bytes;
                                                        int length = tdo._dataLength;
                                                        switch (tdo._dataFmt._datatype) {
                                                            case 48: {
                                                                this.writeByte(tdo.getByte());
                                                                Object var3_4 = null;
                                                                break block35;
                                                            }
                                                            case 52: {
                                                                this.writeShort(tdo.getShort());
                                                                break block36;
                                                            }
                                                            case 56: {
                                                                this.writeInt(tdo.getInt());
                                                                break block37;
                                                            }
                                                            case 38: {
                                                                this.writeByte(length);
                                                                long value = tdo.getLong();
                                                                switch (length) {
                                                                    case 1: {
                                                                        this.writeByte((byte)value);
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        this.writeShort((short)value);
                                                                        break;
                                                                    }
                                                                    case 4: {
                                                                        this.writeInt((int)value);
                                                                        break;
                                                                    }
                                                                    case 8: {
                                                                        this.writeLong(value);
                                                                        break;
                                                                    }
                                                                }
                                                                break block38;
                                                            }
                                                            case 59: {
                                                                this.writeFloat(tdo.getFloat());
                                                                break block39;
                                                            }
                                                            case 62: {
                                                                this.writeDouble(tdo.getDouble());
                                                                break block40;
                                                            }
                                                            case 109: {
                                                                this.writeByte(length);
                                                                double dlb = tdo.getDouble();
                                                                switch (length) {
                                                                    case 4: {
                                                                        this.writeFloat((float)dlb);
                                                                        break;
                                                                    }
                                                                    case 8: {
                                                                        this.writeDouble(dlb);
                                                                        break;
                                                                    }
                                                                }
                                                                break block41;
                                                            }
                                                            case 37: 
                                                            case 39: 
                                                            case 45: 
                                                            case 47: 
                                                            case 103: 
                                                            case 104: 
                                                            case 106: 
                                                            case 108: 
                                                            case 110: 
                                                            case 111: {
                                                                this.writeByte(length);
                                                                break;
                                                            }
                                                            case 34: 
                                                            case 35: 
                                                            case 175: 
                                                            case 225: {
                                                                this.writeInt(length);
                                                                break;
                                                            }
                                                            case 36: {
                                                                int bytes2;
                                                                tdo.reset();
                                                                RawInputStream is = ((TdsJdbcInputStream)tdo).makeNewRIS(4);
                                                                byte[] buf = new byte[2048];
                                                                while ((bytes2 = is.read(buf)) >= 0) {
                                                                    this.write(buf, 0, bytes2);
                                                                }
                                                                break block42;
                                                            }
                                                            default: {
                                                                ErrorMessage.raiseError("JZ0TC");
                                                                break;
                                                            }
                                                            case 50: 
                                                            case 58: 
                                                            case 60: 
                                                            case 61: 
                                                            case 122: 
                                                        }
                                                        byte[] buf = new byte[length < 2048 ? length : 2048];
                                                        int total = 0;
                                                        while (total < length && (bytes = tdo.read(buf)) >= 0) {
                                                            this.write(buf, 0, bytes);
                                                            total += bytes;
                                                        }
                                                        break block43;
                                                    }
                                                    if ((tdo._dataFmt._status & 0x20) != 0) {
                                                        switch (tdo._dataFmt._datatype) {
                                                            case 37: 
                                                            case 38: 
                                                            case 39: 
                                                            case 45: 
                                                            case 47: 
                                                            case 103: 
                                                            case 104: 
                                                            case 106: 
                                                            case 108: 
                                                            case 109: 
                                                            case 110: 
                                                            case 111: {
                                                                this.writeByte(0);
                                                                break;
                                                            }
                                                            case 34: 
                                                            case 35: 
                                                            case 36: 
                                                            case 175: 
                                                            case 225: {
                                                                this.writeInt(0);
                                                                break;
                                                            }
                                                            default: {
                                                                ErrorMessage.raiseError("JZ0TC");
                                                                break;
                                                            }
                                                        }
                                                    }
                                                }
                                                catch (IOException ioe) {
                                                    ErrorMessage.raiseError("JZ006", ioe.toString());
                                                }
                                            }
                                            Object var3_12 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var3_13 = null;
                                            tdo.endRead();
                                            throw throwable;
                                        }
                                        tdo.endRead();
                                        return;
                                    }
                                    tdo.endRead();
                                    return;
                                }
                                Object var3_5 = null;
                                tdo.endRead();
                                return;
                            }
                            Object var3_6 = null;
                            tdo.endRead();
                            return;
                        }
                        Object var3_7 = null;
                        tdo.endRead();
                        return;
                    }
                    Object var3_8 = null;
                    tdo.endRead();
                    return;
                }
                Object var3_9 = null;
                tdo.endRead();
                return;
            }
            Object var3_10 = null;
            tdo.endRead();
            return;
        }
        Object var3_11 = null;
        tdo.endRead();
    }

    private void setUnicharParameter(TdsParam p) {
        p._cvtString = p.stringToUnicodeBytes(p._parameterAsAString);
        p._inValue = p._cvtString;
        p._sqlType = -4;
        p._parameterHoldsUnicharData = true;
    }

    protected byte[] toBytes(String s) throws CharConversionException {
        if (s == null) {
            return null;
        }
        return this._tds._charsetConverter.fromUnicode(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeParam(TdsParam p, int maxFieldSize) throws IOException {
        Debug.println(this, "writeParam, maxFieldSize =" + maxFieldSize);
        int[] dataInfo = new int[4];
        this.dataTypeInfo(p, dataInfo);
        if (p._inValue == null) {
            Debug.println(this, "writeParam java SqlType '" + p._sqlType + "' to TDS type '" + dataInfo[0] + "' as a null");
            switch (dataInfo[0]) {
                case 50: {
                    this.writeByte(0);
                    return;
                }
                case 37: 
                case 38: 
                case 39: 
                case 108: 
                case 109: 
                case 111: {
                    this.writeByte(0);
                    return;
                }
                case 175: 
                case 225: {
                    this.writeInt(0);
                    return;
                }
                case 36: 
                case 9217: {
                    this.writeByte(1);
                    this.writeShort(0);
                    this.writeInt(0);
                    return;
                }
                case 9219: 
                case 9220: {
                    this.writeByte(0);
                    this.writeShort(0);
                    this.writeInt(0);
                    return;
                }
                default: {
                    Debug.assert(null, false, "unsupported TDS Type " + dataInfo[0]);
                }
            }
            return;
        }
        Debug.println(this, "writeParam java SqlType '" + p._sqlType + "' to TDS type '" + dataInfo[0] + "' length " + dataInfo[1]);
        switch (dataInfo[0]) {
            case 50: {
                Debug.assert(this, p._inValue instanceof Boolean);
                this.writeByte((Boolean)p._inValue != false ? 1 : 0);
                return;
            }
            case 38: {
                if (dataInfo[1] > 0) {
                    if (dataInfo[1] < 5) {
                        Debug.assert(this, p._inValue instanceof Integer);
                    } else {
                        Debug.assert(this, p._inValue instanceof Long);
                    }
                }
                this.writeByte(dataInfo[1]);
                switch (dataInfo[1]) {
                    case 1: {
                        this.writeByte((Integer)p._inValue);
                        return;
                    }
                    case 2: {
                        this.writeShort((Integer)p._inValue);
                        return;
                    }
                    case 4: {
                        this.writeInt((Integer)p._inValue);
                        return;
                    }
                    case 8: {
                        this.writeLong((Long)p._inValue);
                        return;
                    }
                    default: {
                        Debug.assert(this, false);
                        return;
                    }
                    case 0: {
                        return;
                    }
                }
            }
            case 109: {
                this.writeByte(dataInfo[1]);
                if (dataInfo[1] > 0) {
                    Debug.assert(this, p._inValue instanceof Float || p._inValue instanceof Double);
                }
                switch (dataInfo[1]) {
                    case 4: {
                        this.writeFloat(((Float)p._inValue).floatValue());
                        return;
                    }
                    case 8: {
                        this.writeDouble((Double)p._inValue);
                        return;
                    }
                    default: {
                        Debug.assert(this, false);
                        return;
                    }
                    case 0: {
                        return;
                    }
                }
            }
            case 39: 
            case 175: {
                int len = dataInfo[1];
                if (dataInfo[0] == 39) {
                    Debug.assert(this, len < 256);
                    this.writeByte(len);
                } else {
                    this.writeInt(len);
                }
                if (dataInfo[1] > 0) {
                    Debug.assert(this, p._cvtString != null);
                }
                if (len <= 0) return;
                this.write(p._cvtString, 0, len);
                return;
            }
            case 37: {
                int len = dataInfo[1];
                this.writeByte(len);
                if (dataInfo[1] > 0) {
                    Debug.assert(this, p._inValue instanceof byte[]);
                }
                if (len <= 0) return;
                this.write((byte[])p._inValue, 0, len);
                return;
            }
            case 225: {
                int len = dataInfo[1];
                this.writeInt(len);
                if (len <= 0) return;
                if (p._inValue instanceof byte[]) {
                    this.write((byte[])p._inValue, 0, len);
                    return;
                }
                if (!(p._inValue instanceof InputStream)) return;
                InputStream is = (InputStream)p._inValue;
                int buflen = len < 2048 ? len : 2048;
                byte[] toSend = new byte[buflen];
                while (len > 0) {
                    int bytes = is.read(toSend, 0, len > buflen ? buflen : len);
                    if (bytes < 0) return;
                    this.write(toSend, 0, bytes);
                    len -= bytes;
                }
                return;
            }
            case 108: {
                if (dataInfo[1] > 0) {
                    Debug.assert(this, p._inValue instanceof BigDecimal);
                }
                byte[] numval = TdsNumeric.tdsNumeric((BigDecimal)p._inValue, dataInfo);
                this.writeByte(dataInfo[1]);
                if (dataInfo[1] <= 0) return;
                this.write(numval);
                return;
            }
            case 111: {
                if (p._sqlType != 92 && p._sqlType != 91 && p._sqlType != 93) {
                    Debug.assert(this, false);
                }
                this.writeByte(dataInfo[1]);
                if (dataInfo[1] <= 0) return;
                int[] datetime = TdsDateTime.tdsDateTime((DateObject)p._inValue);
                this.writeInt(datetime[0]);
                this.writeInt(datetime[1]);
                return;
            }
            case 9217: {
                this.writeByte(1);
                this.writeShort(0);
                BlobOutputStream bos = new BlobOutputStream(this);
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                Debug.assert(this, p._inValue != null);
                oos.writeObject(p._inValue);
                oos.close();
                return;
            }
            case 9219: {
                Debug.assert(this, p._inValue != null);
                this.writeByte(0);
                this.writeShort(0);
                BlobOutputStream bos = new BlobOutputStream(this);
                if (p._inValue instanceof InputStream) {
                    InputStream is = (InputStream)p._inValue;
                    byte[] toSend = new byte[2048];
                    int len = dataInfo[1];
                    if (len > 0) {
                        len *= 2;
                    }
                    char[] charBuf = new char[1024];
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, this._tds._charsetName);
                    while (len != 0) {
                        int bytes;
                        int toRead = 2048;
                        if (len > 0 && len < toRead) {
                            toRead = len;
                        }
                        if ((bytes = is.read(toSend, 0, toRead)) < 0) break;
                        if (bytes % 2 != 0) {
                            int oddChar = is.read();
                            Debug.assert(this, oddChar != -1);
                            if (oddChar == -1) break;
                            toSend[bytes++] = (byte)oddChar;
                        }
                        if (len > 0) {
                            Debug.assert(this, len >= bytes);
                            len -= bytes;
                        }
                        int chars = bytes / 2;
                        int i = 0;
                        while (i < chars) {
                            charBuf[i] = (char)(toSend[i * 2] << 8 | toSend[i * 2 + 1] & 0xFF);
                            ++i;
                        }
                        osw.write(charBuf, 0, chars);
                    }
                    osw.flush();
                } else if (p._inValue instanceof Reader) {
                    Reader rdr = (Reader)p._inValue;
                    int len = dataInfo[1];
                    char[] charBuf = new char[2048];
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, this._tds._charsetName);
                    while (len != 0) {
                        int chars;
                        int toRead = 2048;
                        if (len > 0 && len < toRead) {
                            toRead = len;
                        }
                        if ((chars = rdr.read(charBuf, 0, toRead)) < 0) break;
                        if (len > 0) {
                            Debug.assert(this, len >= chars);
                            len -= chars;
                        }
                        osw.write(charBuf, 0, chars);
                    }
                    osw.flush();
                } else {
                    Debug.assert(this, false);
                }
                bos.close();
                return;
            }
            case 9220: {
                Debug.assert(this, p._inValue != null);
                this.writeByte(0);
                this.writeShort(0);
                BlobOutputStream bos = new BlobOutputStream(this);
                InputStream is = (InputStream)p._inValue;
                byte[] toSend = new byte[2048];
                int len = dataInfo[1];
                while (len != 0) {
                    int bytes;
                    int toRead = 2048;
                    if (len > 0 && len < toRead) {
                        toRead = len;
                    }
                    if ((bytes = is.read(toSend, 0, toRead)) < 0) break;
                    if (len > 0) {
                        Debug.assert(this, len >= bytes);
                        len -= bytes;
                    }
                    bos.write(toSend, 0, bytes);
                }
                bos.close();
                return;
            }
            default: {
                Debug.assert(null, false, "unsupported TDS Type " + dataInfo[0]);
            }
        }
    }
}

