/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.utils.Debug;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class PduOutputFormatter
extends FilterOutputStream {
    private int _packetSize;
    private byte[] _netBuf;
    private int _nextOut;
    private int _pduType;
    private int _pduStatus;
    private SybConnection _conn;

    public PduOutputFormatter(OutputStream os, int netBufSize, SybConnection conn) throws SQLException {
        super(os);
        this.setNetBufSize(netBufSize);
        this._nextOut = 8;
        this._pduType = 15;
        this._pduStatus = 0;
        this._conn = conn;
    }

    protected void changeOutput(OutputStream newOut) {
        this.out = newOut;
    }

    private void doFlush(boolean more) throws IOException {
        try {
            try {
                this._netBuf[0] = (byte)this._pduType;
                int pktlen = this._packetSize;
                if (more) {
                    this._netBuf[1] = (byte)this._pduStatus;
                } else {
                    this._netBuf[1] = (byte)(this._pduStatus | 1);
                    pktlen = this._nextOut;
                }
                this._netBuf[2] = (byte)((pktlen & 0xFF00) >> 8);
                this._netBuf[3] = (byte)(pktlen & 0xFF);
                Debug.println(this, "flushing " + pktlen + "(" + this._netBuf[2] + "," + this._netBuf[3] + ") bytes, type = " + this._pduType + " status = " + this._netBuf[1]);
                this.out.write(this._netBuf, 0, pktlen);
                if (!more) {
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                this._conn.markDeadTryHA();
            }
            Object var3_3 = null;
            this._nextOut = 8;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this._nextOut = 8;
            throw throwable;
        }
    }

    public void flush() throws IOException {
        this.doFlush(false);
    }

    public void setNetBufSize(int netBufSize) {
        Debug.assert(this, this._nextOut < netBufSize);
        byte[] tmpBuf = new byte[netBufSize];
        int i = 0;
        while (i < this._nextOut) {
            tmpBuf[i] = this._netBuf[i];
            ++i;
        }
        int i2 = this._nextOut;
        while (i2 < netBufSize) {
            tmpBuf[i2] = 0;
            ++i2;
        }
        this._netBuf = tmpBuf;
        this._packetSize = netBufSize;
    }

    public void setPDUHeader(int pduType, int pduStatus) {
        this._pduType = pduType;
        this._pduStatus = pduStatus;
    }

    public void write(int b) throws IOException {
        if (this._nextOut >= this._packetSize) {
            this.doFlush(true);
        }
        this._netBuf[this._nextOut++] = (byte)b;
    }

    public void write(byte[] b, int len) throws IOException {
        this.write(b, 0, len);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        Debug.assert(this, len + off <= b.length, "Offset/Length values are incorrect");
        int bStart = off;
        while (len > 0) {
            int bLength;
            if (this._nextOut >= this._packetSize) {
                this.doFlush(true);
            }
            int lengthToCopy = (bLength = this._packetSize - this._nextOut) < len - off ? bLength : len - off;
            System.arraycopy(b, bStart, this._netBuf, this._nextOut, lengthToCopy);
            this._nextOut += lengthToCopy;
            len -= lengthToCopy;
            bStart += lengthToCopy;
        }
    }
}

