/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.ParamManager;
import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.RowFormatToken;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.sql.SQLException;

public class ParamFormatToken
extends RowFormatToken {
    public static final int MAX_PARAMFMT_LENGTH = 65535;
    protected DataFormat[] _param;
    protected ParamManager _paramMgr;
    protected int _numParams;

    public ParamFormatToken() {
    }

    public ParamFormatToken(ParamManager params) throws IOException, SQLException {
        this._numParams = params.makeFormats();
        this._paramMgr = params;
    }

    public ParamFormatToken(TdsInputStream in) throws IOException {
        this.readLength(in);
        this._numColumns = in.readShort();
        this.addDataFormats(in, this._numColumns);
    }

    public int getFormatCount() {
        return this._numParams;
    }

    protected long getLength() {
        int len = 2;
        Debug.println(this, "ParamFormatToken packet len = " + (len += this._paramMgr.getLength()) + ", # params = " + this._numParams);
        return len;
    }

    public void send(TdsOutputStream out) throws IOException {
        if (this.getLength() > 65535L) {
            ErrorMessage.raiseIOException("JZ0PC");
        } else {
            out.writeByte(236);
            out.writeShort((int)this.getLength());
            out.writeShort(this.getFormatCount());
            this.sendFormat(out);
        }
    }

    protected void sendFormat(TdsOutputStream out) throws IOException {
        this._paramMgr.sendFormats(out);
    }
}

